/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.gbs;

import com.ibm.ws.sib.msgstore.gbs.DeleteStack;
import com.ibm.ws.sib.msgstore.gbs.GBSNode;
import com.ibm.ws.sib.msgstore.gbs.GBSTree;
import com.ibm.ws.sib.msgstore.gbs.OptimisticDepthException;
import com.ibm.ws.sib.msgstore.gbs.SearchComparator;
import com.ibm.ws.sib.msgstore.gbs.SearchNode;
import java.util.NoSuchElementException;

public class GBSIterator
implements GBSTree.Iterator {
    private boolean _eof;
    private int _s;
    private GBSNode _p;
    private int _specialCount;
    private int _deleteCount;
    private GBSTree _index;
    private DeleteStack _dstack;
    private Locator _current1;
    private Locator _last1;
    private static final boolean pessimisticNeeded = false;
    private static final boolean optimisticWorked = true;
    private SearchComparator _localComparator;
    private SearchNode _localSearchNode;
    private volatile int _optimisticFindFirsts;
    private volatile int _optimisticGetNext1s;
    private volatile int _optimisticSearchNexts;
    private volatile int _nullPointerExceptions;
    private volatile int _optimisticDepthExceptions;
    private int _pessimisticFindFirsts;
    private int _pessimisticSearchNexts;
    private int _pessimisticGetNexts;

    private GBSIterator() {
    }

    GBSIterator(GBSTree index) {
        this._index = index;
        this._dstack = new DeleteStack(index);
        this._current1 = new Locator();
        this._last1 = new Locator();
    }

    @Override
    public void reset() {
        this._dstack.reset();
        this._current1.reset();
        this._last1.reset();
        this._eof = false;
        this._s = 0;
        this._p = null;
    }

    private void findFirst(DeleteStack stack) {
        boolean x = this.optimisticFindFirst(stack);
        if (!x) {
            this.pessimisticFindFirst(stack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean optimisticFindFirst(DeleteStack stack) {
        Object q = null;
        int v1 = this._index.vno();
        int x1 = this._index.xno();
        if ((v1 & 1) != 0) {
            return false;
        }
        GBSIterator gBSIterator = this;
        synchronized (gBSIterator) {
        }
        try {
            q = this.getFirst(stack);
        }
        catch (NullPointerException npe) {
            ++this._nullPointerExceptions;
            return GBSTree.checkForPossibleIndexChange(v1, this._index.vno(), npe, "optimisticFindFirst");
        }
        catch (OptimisticDepthException ode) {
            ++this._optimisticDepthExceptions;
            return GBSTree.checkForPossibleIndexChange(v1, this._index.vno(), ode, "optimisticFindFirst");
        }
        if (v1 != this._index.vno()) {
            return false;
        }
        this._current1.setLocation(q, v1, x1);
        ++this._optimisticFindFirsts;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pessimisticFindFirst(DeleteStack stack) {
        Object q = null;
        int v1 = 0;
        int x1 = 0;
        GBSTree gBSTree = this._index;
        synchronized (gBSTree) {
            q = this.getFirst(stack);
            v1 = this._index.vno();
            x1 = this._index.xno();
            ++this._pessimisticFindFirsts;
        }
        this._current1.setLocation(q, v1, x1);
    }

    private Object getFirst(DeleteStack stack) {
        Object q = null;
        GBSNode n = this.leftMostChild(stack);
        if (n != null) {
            q = n.leftMostKey();
            this._current1.setLocation(n, 0);
        }
        return q;
    }

    private GBSNode leftMostChild(DeleteStack stack) {
        GBSNode p = this._index.root();
        GBSNode lastl = null;
        if (p != null) {
            stack.start(this._index.dummyTopNode(), "GBSIterator.leftMostChild");
            lastl = this.leftMostChild(stack, p);
        }
        return lastl;
    }

    private GBSNode leftMostChild(DeleteStack stack, GBSNode p) {
        GBSNode q = p.leftChild();
        while (q != null) {
            if (stack.index() > 47) {
                throw new OptimisticDepthException("maxDepth (47) exceeded in GBSIterator.leftMostChild().");
            }
            stack.push(2, p, "GBSIterator.leftMostChild");
            p = q;
            q = p.leftChild();
        }
        this._p = p;
        this._s = 3;
        return this._p;
    }

    private void findNext(DeleteStack stack) {
        if (this._last1.key() == null) {
            throw new RuntimeException("Help!  In findNext(), _last1.key() == null");
        }
        if (!this._eof) {
            this.findNextBeforeEof(stack);
        } else {
            this.findNextAfterEof(stack);
        }
    }

    private void findNextBeforeEof(DeleteStack stack) {
        boolean state = false;
        if (this._last1._vno == this._index.vno()) {
            state = this.optimisticGetNext1(stack);
        }
        if (!state) {
            this.pessimisticGetNext(stack);
        }
    }

    private void findNextAfterEof(DeleteStack stack) {
        if (!this._eof) {
            throw new RuntimeException("findNextAfterEof called when _eof false.");
        }
        if (this._current1._vno != this._index.vno()) {
            boolean state = false;
            state = this.optimisticSearchNext(stack);
            if (!state) {
                this.pessimisticSearchNext(stack);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean optimisticSearchNext(DeleteStack stack) {
        int v1 = this._index.vno();
        int x1 = this._index.xno();
        if ((v1 & 1) != 0) {
            return false;
        }
        GBSIterator gBSIterator = this;
        synchronized (gBSIterator) {
        }
        try {
            this.internalSearchNext(stack, v1, x1);
        }
        catch (NullPointerException npe) {
            ++this._nullPointerExceptions;
            return GBSTree.checkForPossibleIndexChange(v1, this._index.vno(), npe, "optimisticSearchNext");
        }
        catch (OptimisticDepthException ode) {
            ++this._optimisticDepthExceptions;
            return GBSTree.checkForPossibleIndexChange(v1, this._index.vno(), ode, "optimisticSearchNext");
        }
        if (v1 != this._index.vno()) {
            this._current1.setVersion(1);
            return false;
        }
        ++this._optimisticSearchNexts;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pessimisticSearchNext(DeleteStack stack) {
        GBSTree gBSTree = this._index;
        synchronized (gBSTree) {
            this.internalSearchNext(stack, this._index.vno(), this._index.xno());
            ++this._pessimisticSearchNexts;
        }
    }

    private void internalSearchNext(DeleteStack stack, int v1, int x1) {
        SearchComparator comp = this.searchComparator(2);
        this._s = 0;
        this._p = null;
        this._eof = true;
        this._current1.setVersion(v1);
        SearchNode sn = this.searchNode();
        Object q = this._index.iteratorFind(this._dstack, comp, this._last1.key(), sn);
        if (q != null) {
            this._current1.setLocation(sn.foundNode(), sn.foundIndex());
            this._current1.setLocation(sn.key(), v1, x1);
            this._s = 3;
            this._p = sn.foundNode();
            this._eof = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean optimisticGetNext1(DeleteStack stack) {
        Object q = null;
        int v1 = this._index.vno();
        int x1 = this._index.xno();
        if ((v1 & 1) != 0) {
            return false;
        }
        GBSIterator gBSIterator = this;
        synchronized (gBSIterator) {
        }
        int idx = this._last1.index() + 1;
        GBSNode p = this._last1.node();
        if (idx >= p.population()) {
            return false;
        }
        this._current1.setLocation(p, idx);
        q = p.key(idx);
        if (v1 != this._index.vno()) {
            return false;
        }
        this._current1.setLocation(q, v1, x1);
        ++this._optimisticGetNext1s;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pessimisticGetNext(DeleteStack stack) {
        GBSTree gBSTree = this._index;
        synchronized (gBSTree) {
            this.internalGetNext(stack, this._index.vno(), this._index.xno());
            ++this._pessimisticGetNexts;
        }
    }

    private void internalGetNext(DeleteStack stack, int v1, int x1) {
        if (this._last1._xno == x1) {
            SearchComparator comp = this.searchComparator(1);
            GBSNode p = this._last1.node();
            int x = p.searchAll(comp, this._last1.key());
            if (x >= 0) {
                if (x + 1 < p.population()) {
                    this._current1.setLocation(p, x + 1);
                    this._current1.setLocation(p.key(x + 1), v1, x1);
                } else {
                    p = this.nextNode(stack);
                    this._current1.setLocation(p, 0);
                    if (p != null) {
                        Object q = p.leftMostKey();
                        this._current1.setLocation(q, v1, x1);
                    }
                }
            }
        }
        if (this._current1.key() == null) {
            this.internalSearchNext(stack, v1, x1);
        }
    }

    private GBSNode nextNode(DeleteStack stack) {
        if (this._eof) {
            throw new RuntimeException("_eof is set on entry to nextNode()");
        }
        boolean done = false;
        GBSNode q = null;
        GBSNode nextp = null;
        block6: while (!done) {
            if (stack.index() > 47) {
                throw new OptimisticDepthException("maxDepth (47) exceeded in GBSIterator.nextNode().");
            }
            switch (this._s) {
                case 1: {
                    this._s = 2;
                    q = this._p.leftChild();
                    while (q != null) {
                        stack.push(this._s, this._p, "GBSIterator.nextNode:VISIT_LEFT");
                        this._p = q;
                        q = this._p.leftChild();
                    }
                    continue block6;
                }
                case 2: {
                    this._s = 3;
                    done = true;
                    nextp = this._p;
                    continue block6;
                }
                case 3: {
                    this._s = 4;
                    q = this._p.rightChild();
                    if (q == null) continue block6;
                    stack.push(this._s, this._p, "GBSIterator.nextNode:VISIT_RIGHT");
                    this._s = 1;
                    this._p = this._p.rightChild();
                    continue block6;
                }
                case 4: {
                    if (stack.index() <= 0) {
                        done = true;
                        continue block6;
                    }
                    this._s = stack.state();
                    this._p = stack.node();
                    stack.pop();
                    continue block6;
                }
            }
            throw new RuntimeException("Help!, _s = " + this._s + ", _p = " + this._p + ".");
        }
        return nextp;
    }

    @Override
    public Object next() {
        this._current1.reset();
        if (this._last1.key() == null) {
            this.findFirst(this._dstack);
        } else {
            this.findNext(this._dstack);
            if (this._current1.key() == null) {
                this._eof = true;
            }
        }
        if (this._current1.key() != null) {
            this._last1.setLocation(this._current1);
        }
        return this._current1.key();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalRemove() {
        boolean result = false;
        boolean standardDelete = true;
        GBSNode p = this._last1.node();
        int lastx = this._last1.index();
        GBSTree gBSTree = this._index;
        synchronized (gBSTree) {
            SearchComparator comp;
            standardDelete = this._last1._xno != this._index.xno() ? true : (!(p = this._last1.node()).isLeafNode() ? true : (p.population() < 2 || p.isFull() ? true : (this._last1._vno == this._index.vno() ? false : (lastx = p.searchAll(comp = this.searchComparator(1), this._last1.key())) < 0)));
            if (!standardDelete) {
                this._index.iteratorSpecialDelete(this, p, lastx);
            }
        }
        ++this._deleteCount;
        if (standardDelete) {
            result = this._index.delete(this._last1.key());
        } else {
            ++this._specialCount;
            result = true;
        }
        return result;
    }

    @Override
    public boolean remove() {
        if (this._last1.key() == null) {
            throw new NoSuchElementException("remove() without calling next()");
        }
        boolean result = this.internalRemove();
        return result;
    }

    public String toString() {
        String x = "Delete Count = " + this._deleteCount + ", Special Count = " + this._specialCount;
        return x;
    }

    private SearchComparator searchComparator(int type) {
        return this.localComparator().getSingleton(type);
    }

    private SearchComparator localComparator() {
        if (this._localComparator == null) {
            this._localComparator = new SearchComparator(this._index.insertComparator());
        }
        return this._localComparator;
    }

    private SearchNode searchNode() {
        if (this._localSearchNode == null) {
            this._localSearchNode = new SearchNode();
        } else {
            this._localSearchNode.reset();
        }
        return this._localSearchNode;
    }

    private static class Locator {
        private GBSNode _node;
        private int _index;
        private Object _obj;
        private int _vno;
        private int _xno;

        private Locator() {
        }

        private void reset() {
            this._node = null;
            this._index = -6;
            this._obj = null;
            this._vno = 0;
            this._xno = 0;
        }

        private void setLocation(Object obj, int vno, int xno) {
            this._obj = obj;
            this._vno = vno;
            this._xno = xno;
        }

        private void setLocation(GBSNode node, int index) {
            this._node = node;
            this._index = index;
        }

        private void setLocation(Locator loc) {
            this._node = loc._node;
            this._index = loc._index;
            this._obj = loc._obj;
            this._vno = loc._vno;
            this._xno = loc._xno;
        }

        private void setVersion(int vno) {
            this._vno = vno;
        }

        private Object key() {
            return this._obj;
        }

        private GBSNode node() {
            return this._node;
        }

        private int index() {
            return this._index;
        }

        public String toString() {
            String x = "node = " + this._node + "\n  index = " + this._index + ", vno = " + this._vno + ", xno = " + this._xno;
            return x;
        }
    }
}

