/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.config.ConfigurationProvider;
import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.jta.impl.FailureScopeController;
import com.ibm.tx.jta.impl.HADBLogAvailabilityManager;
import com.ibm.tx.jta.impl.LeaseTimeoutManager;
import com.ibm.tx.jta.impl.RecoveryManager;
import com.ibm.tx.jta.util.TranLogConfiguration;
import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.recoverylog.spi.CustomLogProperties;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FileFailureScope;
import com.ibm.ws.recoverylog.spi.FileLogProperties;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.InvalidFailureScopeException;
import com.ibm.ws.recoverylog.spi.InvalidLogPropertiesException;
import com.ibm.ws.recoverylog.spi.LeaseInfo;
import com.ibm.ws.recoverylog.spi.LivingRecoveryLog;
import com.ibm.ws.recoverylog.spi.LogProperties;
import com.ibm.ws.recoverylog.spi.PeerLeaseTable;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import com.ibm.ws.recoverylog.spi.RecoveryFailedException;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import com.ibm.ws.recoverylog.spi.RecoveryLogManager;
import com.ibm.ws.recoverylog.spi.SharedServerLeaseLog;
import com.ibm.ws.recoverylog.spi.TerminationFailedException;
import com.ibm.wsspi.resource.ResourceFactory;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import javax.transaction.SystemException;

public class TxRecoveryAgentImpl
implements RecoveryAgent {
    private static final TraceComponent tc = Tr.register(TxRecoveryAgentImpl.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final int transactionLogRLI = 1;
    private static final int partnerLogRLI = 2;
    private static final int TRANSACTION_RECOVERYLOG_FORMAT_VERSION = 1;
    protected RecoveryDirector _recoveryDirector;
    protected final HashMap<String, FailureScopeController> failureScopeControllerTable = new HashMap();
    SharedServerLeaseLog _leaseLog;
    private String _recoveryGroup;
    private boolean _isPeerRecoverySupported;
    protected String localRecoveryIdentity;

    protected TxRecoveryAgentImpl() {
    }

    public TxRecoveryAgentImpl(RecoveryDirector rd) throws Exception {
        this._recoveryDirector = rd;
        RecoveryLogManager rlm = rd.registerService((RecoveryAgent)this, 2);
        Configuration.setLogManager(rlm);
        FailureScope currentFailureScope = rd.currentFailureScope();
        Configuration.setServerName(currentFailureScope.serverName());
        this.localRecoveryIdentity = currentFailureScope.serverName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"TxRecoveryAgentImpl constructor - localRecoveryIdentity set to ", (Object)this.localRecoveryIdentity);
        }
        FailureScopeController fsc = this.createFailureScopeController(currentFailureScope);
        this.failureScopeControllerTable.put(currentFailureScope.serverName(), fsc);
        Configuration.setFailureScopeController(fsc);
        byte[] newApplId = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        ConfigurationProvider cp = ConfigurationProviderManager.getConfigurationProvider();
        if (cp.getApplId() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("TXAGENT, cp applid null - " + cp + " set applid - " + Util.toHexString(newApplId)));
            }
            cp.setApplId(newApplId);
            Configuration.setApplId(newApplId);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("TXAGENT, do not reset cp - " + cp + " set applid - " + Util.toHexString(cp.getApplId())));
            }
            Configuration.setApplId(cp.getApplId());
        }
    }

    public void agentReportedFailure(int clientId, FailureScope failureScope) {
    }

    public int clientIdentifier() {
        return 1;
    }

    public String clientName() {
        return "transaction";
    }

    public int clientVersion() {
        return 1;
    }

    public boolean disableFileLocking() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initiateRecovery(FailureScope fs) throws RecoveryFailedException {
        block43: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"initiateRecovery", (Object)fs);
            }
            String recoveredServerIdentity = null;
            try {
                ConfigurationProvider cp;
                RecoveryFailedException rex;
                boolean localRecovery;
                FailureScopeController fsc;
                block44: {
                    TranLogConfiguration tlc;
                    block46: {
                        block45: {
                            recoveredServerIdentity = fs.serverName();
                            if (this._isPeerRecoverySupported) {
                                Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Recovery initiated for server " + recoveredServerIdentity));
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Recovery initiated for server -  ", (Object)recoveredServerIdentity);
                            }
                            boolean isCustom = false;
                            String logDir = ConfigurationProviderManager.getConfigurationProvider().getTransactionLogDirectory();
                            int logSize = ConfigurationProviderManager.getConfigurationProvider().getTransactionLogSize();
                            if (logDir.startsWith("custom")) {
                                isCustom = true;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Found a custom tran log directory");
                                }
                            }
                            tlc = null;
                            tlc = isCustom ? this.createCustomTranLogConfiguration(recoveredServerIdentity, logDir, this._isPeerRecoverySupported) : this.createFileTranLogConfiguration(recoveredServerIdentity, fs, logDir, logSize, this._isPeerRecoverySupported);
                            fsc = this.failureScopeControllerTable.get(recoveredServerIdentity);
                            if (fsc == null) break block45;
                            if (fsc.getRecoveryManager() == null) break block46;
                            if (this._isPeerRecoverySupported) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Where peer recovery is supported, a pre-existing RM is ok");
                                }
                                break block46;
                            } else {
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)("already recovering failure scope " + fs));
                                }
                                throw new RecoveryFailedException();
                            }
                        }
                        try {
                            fsc = new FailureScopeController(fs);
                        }
                        catch (SystemException exc) {
                            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.runtime.component.TxServiceImpl.initiateRecovery", (String)"1177", (Object)this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Exception caught whist creating FailureScopeController", (Object)((Object)exc));
                            }
                            throw new RecoveryFailedException((Throwable)exc);
                        }
                        this.failureScopeControllerTable.put(recoveredServerIdentity, fsc);
                    }
                    byte[] applId = ConfigurationProviderManager.getConfigurationProvider().getApplId();
                    int epoch = Configuration.getCurrentEpoch();
                    RecoveryLog transactionLog = null;
                    RecoveryLog partnerLog = null;
                    if (tlc != null && tlc.enabled()) {
                        CustomLogProperties partnerLogProps;
                        CustomLogProperties transactionLogProps;
                        if (tlc.type() == 3) {
                            transactionLogProps = new CustomLogProperties(1, "tranlog", tlc.customId(), tlc.customProperties());
                            partnerLogProps = new CustomLogProperties(2, "partnerlog", tlc.customId(), tlc.customProperties());
                            ResourceFactory nontranDSResourceFactory = ConfigurationProviderManager.getConfigurationProvider().getResourceFactory();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Retrieved non tran DS Resource Factory, ", (Object)nontranDSResourceFactory);
                            }
                            transactionLogProps.setResourceFactory(nontranDSResourceFactory);
                            partnerLogProps.setResourceFactory(nontranDSResourceFactory);
                        } else {
                            String tranLogDirStem = tlc.expandedLogDirectory();
                            tranLogDirStem = tranLogDirStem.trim();
                            String tranLogDirToUse = tranLogDirStem + File.separator + "tranlog";
                            transactionLogProps = new FileLogProperties(1, "tranlog", tranLogDirToUse, tlc.logFileSize(), tranLogDirStem);
                            String partnerLogDirToUse = tlc.expandedLogDirectory();
                            partnerLogDirToUse = partnerLogDirToUse.trim() + File.separator + "partnerlog";
                            partnerLogProps = new FileLogProperties(2, "partnerlog", partnerLogDirToUse, tlc.logFileSize());
                        }
                        RecoveryLogManager rlm = Configuration.getLogManager();
                        transactionLog = rlm.getRecoveryLog(fs, (LogProperties)transactionLogProps);
                        partnerLog = rlm.getRecoveryLog(fs, (LogProperties)partnerLogProps);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Test to see if peer recovery is supported -  ", (Object)this._isPeerRecoverySupported);
                        }
                        if (this._isPeerRecoverySupported) {
                            this._leaseLog = rlm.getLeaseLog(this.localRecoveryIdentity, this._recoveryGroup, (LogProperties)transactionLogProps);
                            this._leaseLog.setPeerRecoveryLeaseTimeout(this.getPeerRecoveryLeaseTimeout());
                        }
                    }
                    fsc.createRecoveryManager(this, transactionLog, partnerLog, null, applId, epoch);
                    final RecoveryManager rm = fsc.getRecoveryManager();
                    localRecovery = recoveredServerIdentity.equals(this.localRecoveryIdentity);
                    if (this._leaseLog != null) {
                        if (localRecovery && !this._leaseLog.lockLocalLease(this.localRecoveryIdentity)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Cannot lock server's own logs");
                            }
                            Object[] errorObject = new Object[]{this.localRecoveryIdentity};
                            rex = new RecoveryFailedException();
                            Tr.audit((TraceComponent)tc, (String)"CWRLS0008_RECOVERY_LOG_FAILED", (Object)errorObject);
                            Tr.info((TraceComponent)tc, (String)"CWRLS0009_RECOVERY_LOG_FAILED_DETAIL", (Object)((Object)rex));
                            rm.recoveryFailed(rex);
                            if (!this.doNotShutdownOnRecoveryFailure()) {
                                cp = ConfigurationProviderManager.getConfigurationProvider();
                                cp.shutDownFramework();
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)((Object)rex));
                            }
                            Tr.error((TraceComponent)tc, (String)"CWRLS0024_EXC_DURING_RECOVERY", (Object)((Object)rex));
                            throw rex;
                        }
                        rm.setLeaseLog(this._leaseLog);
                        rm.setRecoveryGroup(this._recoveryGroup);
                        rm.setLocalRecoveryIdentity(this.localRecoveryIdentity);
                    }
                    Thread t = (Thread)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            Thread temp = new Thread((Runnable)rm, "Recovery Thread");
                            return temp;
                        }
                    });
                    t.start();
                    this._recoveryDirector.serialRecoveryComplete((RecoveryAgent)this, fs);
                    fsc.getRecoveryManager().waitForReplayCompletion();
                    if (!localRecovery) {
                        fsc.getRecoveryManager().waitForRecoveryCompletion();
                    }
                    if (this._leaseLog == null) break block43;
                    try {
                        if (localRecovery) {
                            if (this._leaseLog.releaseLocalLease(recoveredServerIdentity) && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Have released locallease lock");
                            }
                            break block44;
                        }
                        if (this._leaseLog.releasePeerLease(recoveredServerIdentity) && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Have released peer lease lock");
                        }
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block44;
                        Tr.debug((TraceComponent)tc, (String)("Caught exception on lock release - " + e));
                    }
                }
                if (fsc.getRecoveryManager().recoveryFailed()) {
                    rex = new RecoveryFailedException();
                    if (localRecovery && !this.doNotShutdownOnRecoveryFailure()) {
                        cp = ConfigurationProviderManager.getConfigurationProvider();
                        cp.shutDownFramework();
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)((Object)rex));
                    }
                    Tr.error((TraceComponent)tc, (String)"CWRLS0024_EXC_DURING_RECOVERY", (Object)((Object)rex));
                    throw rex;
                }
                if (localRecovery) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Local server recovery identity so spawn lease timeout manager");
                    }
                    LeaseTimeoutManager.setTimeout(this._leaseLog, recoveredServerIdentity, this._recoveryGroup, this, this._recoveryDirector, this.getPeerLeaseCheckInterval());
                }
            }
            catch (InvalidFailureScopeException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.runtime.component.TxServiceImpl.initiateRecovery", (String)"1599", (Object)this);
                Tr.error((TraceComponent)tc, (String)"WTRN0016_EXC_DURING_RECOVERY", (Object)((Object)e));
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)((Object)e));
                }
                throw new RecoveryFailedException();
            }
            catch (InvalidLogPropertiesException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.runtime.component.TxServiceImpl.initiateRecovery", (String)"1599", (Object)this);
                Tr.error((TraceComponent)tc, (String)"WTRN0016_EXC_DURING_RECOVERY", (Object)((Object)e));
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)((Object)e));
                }
                throw new RecoveryFailedException();
            }
            catch (URISyntaxException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.runtime.component.TxServiceImpl.initiateRecovery", (String)"1599", (Object)this);
                Tr.error((TraceComponent)tc, (String)"WTRN0016_EXC_DURING_RECOVERY", (Object)e);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"initiateRecovery", (Object)e);
                }
                throw new RecoveryFailedException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initiateRecovery");
        }
    }

    public boolean isSnapshotSafe() {
        return false;
    }

    public String[] logDirectories(FailureScope failureScope) {
        return null;
    }

    public void prepareForRecovery(FailureScope failureScope) {
    }

    public void terminateRecovery(FailureScope fs) throws TerminationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"terminateRecovery", (Object)fs);
        }
        String terminateServerName = fs.serverName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The transaction service has received a request to terminate recovery processing for server " + terminateServerName));
        }
        RecoveryDirector recoveryDirector = null;
        try {
            recoveryDirector = RecoveryDirectorFactory.recoveryDirector();
        }
        catch (InternalLogException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.runtime.component.TxServiceImpl.terminateRecovery", (String)"1274", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"terminateRecovery");
            }
            throw new TerminationFailedException((Throwable)exc);
        }
        boolean terminatingThisServer = terminateServerName.equals(Configuration.getServerName());
        if (terminatingThisServer) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Received unexpected request to terminate recovery processing for local failure scope");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"terminateRecovery");
            }
            throw new TerminationFailedException();
        }
        FailureScopeController fsc = this.failureScopeControllerTable.remove(terminateServerName);
        if (fsc != null) {
            fsc.shutdown(false);
        }
        try {
            recoveryDirector.terminationComplete((RecoveryAgent)this, fs);
        }
        catch (InvalidFailureScopeException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.runtime.component.TxServiceImpl.terminateRecovery", (String)"1308", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to indicate termination completion to recovery director: " + (Object)((Object)exc)));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"terminateRecovery");
            }
            throw new TerminationFailedException((Throwable)exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"terminateRecovery");
        }
    }

    public void stop(boolean immediate) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop", (Object)new Object[]{immediate});
        }
        LeaseTimeoutManager.stopTimeout();
        HADBLogAvailabilityManager.stopTimeout();
        Collection<FailureScopeController> failureScopeControllerTableValues = this.failureScopeControllerTable.values();
        for (FailureScopeController fsc : failureScopeControllerTableValues) {
            fsc.shutdown(immediate);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void logFileWarning(String logname, int bytesInUse, int bytesTotal) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logFileWarning", (Object)new Object[]{logname, bytesInUse, bytesTotal});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logFileWarning");
        }
    }

    public void setRecoveryGroup(String recoveryGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setRecoveryGroup", (Object)new Object[]{recoveryGroup});
        }
        this._recoveryGroup = recoveryGroup;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setRecoveryGroup");
        }
    }

    public String getRecoveryGroup() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRecoveryGroup");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRecoveryGroup", (Object)this._recoveryGroup);
        }
        return this._recoveryGroup;
    }

    public void setPeerRecoverySupported(boolean isPeerRecoverySupported) {
        this._isPeerRecoverySupported = isPeerRecoverySupported;
    }

    public ArrayList<String> processLeasesForPeers(String recoveryIdentity, String recoveryGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processLeasesForPeers", (Object)new Object[]{recoveryIdentity, recoveryGroup});
        }
        ArrayList peersToRecover = null;
        if (this._leaseLog != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("work with leaseLog " + this._leaseLog));
            }
            try {
                PeerLeaseTable peerLeaseTable = new PeerLeaseTable();
                this._leaseLog.getLeasesForPeers(peerLeaseTable, recoveryGroup);
                peersToRecover = peerLeaseTable.getExpiredPeers();
                peersToRecover.remove(recoveryIdentity);
                int numPeers = peersToRecover.size();
                Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Have checked leases for peers in recovery group " + recoveryGroup + " - need to Recover " + numPeers + " peer servers"));
            }
            catch (Exception e) {
                System.out.println("Caught exception when trying to get leases for peers: " + e);
                e.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processLeasesForPeers", peersToRecover);
        }
        return peersToRecover;
    }

    public boolean claimPeerLeaseForRecovery(String recoveryIdentityToRecover, String myRecoveryIdentity, LeaseInfo leaseInfo) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"claimPeerLeaseForRecovery", (Object)new Object[]{recoveryIdentityToRecover, myRecoveryIdentity, leaseInfo, this});
        }
        boolean peerClaimed = this._leaseLog.claimPeerLeaseForRecovery(recoveryIdentityToRecover, myRecoveryIdentity, leaseInfo);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"claimPeerLeaseForRecovery", (Object)peerClaimed);
        }
        return peerClaimed;
    }

    private TranLogConfiguration createCustomTranLogConfiguration(String recoveredServerIdentity, String logDir, boolean isPeerRecoverySupported) throws URISyntaxException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createCustomTranLogConfiguration", (Object)new Object[]{recoveredServerIdentity, logDir, this});
        }
        TranLogConfiguration tlc = null;
        Properties props = new Properties();
        URI logSettingURI = new URI(logDir);
        String scheme = logSettingURI.getScheme();
        String logSetting = logSettingURI.getAuthority();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Scheme read from URI " + scheme + ", log setting" + logSetting));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Test to see if peer recovery is supported -  ", (Object)isPeerRecoverySupported);
        }
        if (isPeerRecoverySupported) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Work with server recovery identity -  " + recoveredServerIdentity + ", reset current logdir"));
            }
            if (recoveredServerIdentity != null) {
                logDir = "custom://com.ibm.rls.jdbc.SQLRecoveryLogFactory?datasource=Liberty,tablesuffix=" + recoveredServerIdentity;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"log dir is now -  ", (Object)logDir);
                }
            }
        }
        props.setProperty("LOG_DIRECTORY", logDir);
        tlc = new TranLogConfiguration(logSetting, props);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createCustomTranLogConfiguration", (Object)tlc);
        }
        return tlc;
    }

    private TranLogConfiguration createFileTranLogConfiguration(String recoveredServerIdentity, FailureScope fs, String logDir, int logSize, boolean isPeerRecoverySupported) throws URISyntaxException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createFileTranLogConfiguration", (Object)new Object[]{recoveredServerIdentity, fs, logDir, logSize, this});
        }
        TranLogConfiguration tlc = null;
        if (this._isPeerRecoverySupported) {
            LeaseInfo li;
            FileFailureScope ffs;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Work with server recovery identity -  ", (Object)recoveredServerIdentity);
            }
            if (recoveredServerIdentity.equals(this.localRecoveryIdentity)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Local server recovery identity so no need to reset the logDir");
                }
            } else if (fs != null && fs instanceof FileFailureScope && (ffs = (FileFailureScope)fs) != null && (li = ffs.getLeaseInfo()) != null) {
                logDir = li.getLeaseDetail();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Have reset the logDir to ", (Object)logDir);
                }
            }
        }
        tlc = new TranLogConfiguration(logDir, logDir, logSize);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createFileTranLogConfiguration", (Object)tlc);
        }
        return tlc;
    }

    private int getPeerLeaseCheckInterval() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPeerLeaseCheckInterval");
        }
        Integer peerLeaseCheckInterval = null;
        try {
            peerLeaseCheckInterval = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() {
                    return Integer.getInteger("com.ibm.tx.jta.impl.PeerLeaseCheckInterval", 20);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception setting Peer Lease-Check Interval", (Object)e);
            }
            peerLeaseCheckInterval = null;
        }
        if (peerLeaseCheckInterval == null) {
            peerLeaseCheckInterval = new Integer(20);
        }
        int intToReturn = peerLeaseCheckInterval;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPeerLeaseCheckInterval", (Object)intToReturn);
        }
        return intToReturn;
    }

    private int getPeerRecoveryLeaseTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPeerRecoveryLeaseTimeout");
        }
        Integer PeerRecoveryLeaseTimeout = null;
        try {
            PeerRecoveryLeaseTimeout = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() {
                    return Integer.getInteger("com.ibm.tx.jta.impl.PeerRecoveryLeaseTimeout", 30);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception setting Peer Recovery Lease-Timeout", (Object)e);
            }
            PeerRecoveryLeaseTimeout = null;
        }
        if (PeerRecoveryLeaseTimeout == null) {
            PeerRecoveryLeaseTimeout = new Integer(20);
        }
        int intToReturn = PeerRecoveryLeaseTimeout;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPeerRecoveryLeaseTimeout", (Object)intToReturn);
        }
        return intToReturn;
    }

    private boolean doNotShutdownOnRecoveryFailure() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doNotShutdownOnRecoveryFailure");
        }
        boolean doCheck = true;
        Boolean doNotShutdownOnRecoveryFailure = null;
        try {
            doNotShutdownOnRecoveryFailure = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() {
                    Boolean theResult = Boolean.getBoolean("com.ibm.ws.recoverylog.spi.DoNotShutdownOnRecoveryFailure");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Have retrieved jvm property with result, " + theResult));
                    }
                    return theResult;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting DoNotShutdownOnRecoveryFailure property", (Object)e);
            }
            doNotShutdownOnRecoveryFailure = null;
        }
        if (doNotShutdownOnRecoveryFailure == null) {
            doNotShutdownOnRecoveryFailure = Boolean.TRUE;
        }
        doCheck = doNotShutdownOnRecoveryFailure;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doNotShutdownOnRecoveryFailure", (Object)doCheck);
        }
        return doCheck;
    }

    protected FailureScopeController createFailureScopeController(FailureScope currentFailureScope) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createFailureScopeController", (Object)currentFailureScope);
        }
        FailureScopeController fsc = new FailureScopeController(currentFailureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createFailureScopeController", (Object)fsc);
        }
        return fsc;
    }

    public void startHADBLogAvailabilityHeartbeat(RecoveryLog customPartnerLog) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startHADBLogAvailabilityHeartbeat", (Object)customPartnerLog);
        }
        ConfigurationProvider cp = ConfigurationProviderManager.getConfigurationProvider();
        int peerLockTimeBetweenHeartbeats = cp.getTimeBetweenHeartbeats();
        HADBLogAvailabilityManager.setTimeout(this, customPartnerLog, peerLockTimeBetweenHeartbeats);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startHADBLogAvailabilityHeartbeat");
        }
    }

    public void updateHADBTimestamp(RecoveryLog customPartnerLog) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateHADBTimestamp", (Object)customPartnerLog);
        }
        if (customPartnerLog != null && customPartnerLog instanceof LivingRecoveryLog) {
            LivingRecoveryLog livingRecoveryLog = (LivingRecoveryLog)customPartnerLog;
            livingRecoveryLog.heartBeat();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateHADBTimestamp");
        }
    }

    public boolean claimLocalHADBLogs(RecoveryLog customPartnerLog) {
        boolean logIsStale = false;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"claimLocalHADBLogs", (Object)customPartnerLog);
        }
        if (customPartnerLog != null && customPartnerLog instanceof LivingRecoveryLog) {
            LivingRecoveryLog livingRecoveryLog = (LivingRecoveryLog)customPartnerLog;
            logIsStale = livingRecoveryLog.claimLocalRecoveryLogs();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"claimLocalHADBLogs", (Object)new Boolean(logIsStale));
        }
        return logIsStale;
    }

    public boolean claimPeerHADBLogs(RecoveryLog customPartnerLog) {
        boolean logIsStale = false;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"claimPeerHADBLogs", (Object)customPartnerLog);
        }
        if (customPartnerLog != null && customPartnerLog instanceof LivingRecoveryLog) {
            LivingRecoveryLog livingRecoveryLog = (LivingRecoveryLog)customPartnerLog;
            logIsStale = livingRecoveryLog.claimPeerRecoveryLogs();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"claimPeerHADBLogs", (Object)new Boolean(logIsStale));
        }
        return logIsStale;
    }

    public RecoveryLog getCustomPartnerLog(FailureScope fs) {
        RecoveryLog partnerLog;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getCustomPartnerLog", (Object)fs);
            }
            partnerLog = null;
            String recoveredServerIdentity = null;
            try {
                recoveredServerIdentity = fs.serverName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getCustomPartnerLog for server -  ", (Object)recoveredServerIdentity);
                }
                boolean isCustom = false;
                String logDir = ConfigurationProviderManager.getConfigurationProvider().getTransactionLogDirectory();
                if (logDir.startsWith("custom")) {
                    isCustom = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Found a custom tran log directory");
                    }
                }
                TranLogConfiguration tlc = null;
                if (isCustom && (tlc = this.createCustomTranLogConfiguration(recoveredServerIdentity, logDir, this._isPeerRecoverySupported)) != null && tlc.enabled() && tlc.type() == 3) {
                    CustomLogProperties partnerLogProps = new CustomLogProperties(2, "partnerlog", tlc.customId(), tlc.customProperties());
                    ResourceFactory nontranDSResourceFactory = ConfigurationProviderManager.getConfigurationProvider().getResourceFactory();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Retrieved non tran DS Resource Factory, ", (Object)nontranDSResourceFactory);
                    }
                    partnerLogProps.setResourceFactory(nontranDSResourceFactory);
                    RecoveryLogManager rlm = Configuration.getLogManager();
                    partnerLog = rlm.getRecoveryLog(fs, (LogProperties)partnerLogProps);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Custom PartnerLog is set - ", (Object)partnerLog);
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isEntryEnabled()) break block10;
                Tr.exit((TraceComponent)tc, (String)"getCustomPartnerLog", (Object)e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCustomPartnerLog", partnerLog);
        }
        return partnerLog;
    }

    public boolean enableHADBPeerLocking() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"enableHADBPeerLocking");
        }
        ConfigurationProvider cp = ConfigurationProviderManager.getConfigurationProvider();
        boolean enableLocking = cp.enableHADBPeerLocking();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"enableHADBPeerLocking", (Object)enableLocking);
        }
        return enableLocking;
    }

    public int getPeerTimeBeforeStale() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPeerTimeBeforeStale");
        }
        ConfigurationProvider cp = ConfigurationProviderManager.getConfigurationProvider();
        int peerLockTimeBeforeStale = cp.getPeerTimeBeforeStale();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPeerTimeBeforeStale", (Object)peerLockTimeBeforeStale);
        }
        return peerLockTimeBeforeStale;
    }

    public int getLocalTimeBeforeStale() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLocalTimeBeforeStale");
        }
        ConfigurationProvider cp = ConfigurationProviderManager.getConfigurationProvider();
        int localLockTimeBeforeStale = cp.getLocalTimeBeforeStale();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLocalTimeBeforeStale", (Object)localLockTimeBeforeStale);
        }
        return localLockTimeBeforeStale;
    }
}

