/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver;

import com.ibm.ws.kernel.feature.internal.FeatureResolverImpl;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import com.ibm.ws.product.utility.extension.ifix.xml.IFixInfo;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.connections.ProductDefinition;
import com.ibm.ws.repository.connections.RepositoryConnectionList;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.resolver.ProductRequirementInformation;
import com.ibm.ws.repository.resolver.RepositoryResolutionException;
import com.ibm.ws.repository.resolver.internal.ResolutionMode;
import com.ibm.ws.repository.resolver.internal.kernel.KernelResolverEsa;
import com.ibm.ws.repository.resolver.internal.kernel.KernelResolverRepository;
import com.ibm.ws.repository.resources.ApplicableToProduct;
import com.ibm.ws.repository.resources.EsaResource;
import com.ibm.ws.repository.resources.RepositoryResource;
import com.ibm.ws.repository.resources.SampleResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RepositoryResolver {
    KernelResolverRepository resolverRepository;
    Collection<ProvisioningFeatureDefinition> installedFeatures;
    Map<String, SampleResource> sampleIndex;
    Collection<EsaResource> repoFeatures;
    Collection<SampleResource> repoSamples;
    RepositoryConnectionList repoConnections;
    Collection<ProductDefinition> installDefinition;
    Map<String, Collection<FeatureResolver.Chain>> featureConflicts;
    Set<String> featureNamesToResolve;
    Set<String> requestedFeatureNames;
    List<SampleResource> samplesToInstall;
    Map<String, ProvisioningFeatureDefinition> resolvedFeatures;
    List<String> featuresMissing;
    List<ApplicableToProduct> resourcesWrongProduct;
    Set<String> requirementsFoundForOtherProducts;
    List<String> missingTopLevelRequirements;
    List<RepositoryResolutionException.MissingRequirement> missingRequirements;

    public RepositoryResolver(Collection<ProductDefinition> installDefinition, Collection<ProvisioningFeatureDefinition> installedFeatures, Collection<IFixInfo> installedIFixes, RepositoryConnectionList repoConnections) throws RepositoryException {
        this.repoConnections = repoConnections;
        this.installDefinition = installDefinition;
        this.fetchFromRepository(installDefinition);
        this.installedFeatures = installedFeatures;
        this.indexSamples();
    }

    RepositoryResolver(Collection<ProvisioningFeatureDefinition> installedFeatures, Collection<? extends EsaResource> repoFeatures, Collection<? extends SampleResource> repoSamples) {
        this.repoFeatures = new ArrayList<EsaResource>(repoFeatures);
        this.repoSamples = new ArrayList<SampleResource>(repoSamples);
        this.installedFeatures = installedFeatures;
        this.installDefinition = Collections.emptySet();
        this.indexSamples();
    }

    void fetchFromRepository(Collection<ProductDefinition> installDefinition) throws RepositoryException {
        Collection osiSamples;
        HashSet<ResourceType> interestingTypes = new HashSet<ResourceType>();
        interestingTypes.add(ResourceType.FEATURE);
        interestingTypes.add(ResourceType.OPENSOURCE);
        interestingTypes.add(ResourceType.PRODUCTSAMPLE);
        Map resources = this.repoConnections.getResources(installDefinition, interestingTypes, null);
        Collection<Object> features = (Collection<Object>)resources.get(ResourceType.FEATURE);
        this.repoFeatures = features != null ? features : Collections.emptySet();
        this.repoSamples = new ArrayList<SampleResource>();
        Collection samples = (Collection)resources.get(ResourceType.PRODUCTSAMPLE);
        if (samples != null) {
            this.repoSamples.addAll(samples);
        }
        if ((osiSamples = (Collection)resources.get(ResourceType.OPENSOURCE)) != null) {
            this.repoSamples.addAll(osiSamples);
        }
    }

    void initializeResolverRepository(Collection<ProductDefinition> installDefintion, ResolutionMode mode) {
        this.resolverRepository = new KernelResolverRepository(installDefintion, this.repoConnections, mode);
        this.resolverRepository.addInstalledFeatures(this.installedFeatures);
        this.resolverRepository.addFeatures(this.repoFeatures);
    }

    void indexSamples() {
        this.sampleIndex = new HashMap<String, SampleResource>();
        for (SampleResource sample : this.repoSamples) {
            if (sample.getShortName() == null) continue;
            this.sampleIndex.put(sample.getShortName().toLowerCase(), sample);
        }
    }

    public Collection<List<RepositoryResource>> resolve(Collection<String> toResolve) throws RepositoryResolutionException {
        return this.resolve(toResolve, ResolutionMode.IGNORE_CONFLICTS);
    }

    public Collection<List<RepositoryResource>> resolve(String toResolve) throws RepositoryResolutionException {
        return this.resolve(Collections.singleton(toResolve));
    }

    public Collection<List<RepositoryResource>> resolveAsSet(Collection<String> toResolve) throws RepositoryResolutionException {
        return this.resolve(toResolve, ResolutionMode.DETECT_CONFLICTS);
    }

    Collection<List<RepositoryResource>> resolve(Collection<String> toResolve, ResolutionMode resolutionMode) throws RepositoryResolutionException {
        this.initResolve();
        this.initializeResolverRepository(this.installDefinition, resolutionMode);
        this.processNames(toResolve);
        this.findAutofeatureDependencies();
        if (resolutionMode == ResolutionMode.IGNORE_CONFLICTS) {
            this.requireInstalledFeaturesWhenResolving();
        }
        this.resolveFeatures(resolutionMode);
        List<List<RepositoryResource>> installLists = this.createInstallLists();
        this.reportErrors();
        return installLists;
    }

    void initResolve() {
        this.featureNamesToResolve = new HashSet<String>();
        this.samplesToInstall = new ArrayList<SampleResource>();
        this.resolvedFeatures = new HashMap<String, ProvisioningFeatureDefinition>();
        this.requestedFeatureNames = new HashSet<String>();
        this.featuresMissing = new ArrayList<String>();
        this.resourcesWrongProduct = new ArrayList<ApplicableToProduct>();
        this.requirementsFoundForOtherProducts = new HashSet<String>();
        this.missingTopLevelRequirements = new ArrayList<String>();
        this.missingRequirements = new ArrayList<RepositoryResolutionException.MissingRequirement>();
        this.resolverRepository = null;
        this.featureConflicts = new HashMap<String, Collection<FeatureResolver.Chain>>();
    }

    void processNames(Collection<String> namesToResolve) {
        for (String name : namesToResolve) {
            SampleResource sample = this.sampleIndex.get(name.toLowerCase());
            if (sample != null) {
                this.samplesToInstall.add(sample);
                if (sample.getRequireFeature() == null) continue;
                this.featureNamesToResolve.addAll(sample.getRequireFeature());
                continue;
            }
            NameAndVersion nameAndVersion = this.splitRequestedNameAndVersion(name);
            if (nameAndVersion.version != null) {
                this.resolverRepository.setPreferredVersion(nameAndVersion.name, nameAndVersion.version);
            }
            this.featureNamesToResolve.add(nameAndVersion.name);
            this.requestedFeatureNames.add(nameAndVersion.name);
        }
    }

    private NameAndVersion splitRequestedNameAndVersion(String nameAndVersion) {
        String[] parts = nameAndVersion.split("/");
        if (parts.length > 2) {
            throw new IllegalArgumentException("Only one \"/\" symbol is allowed in the resourceString but it was " + nameAndVersion);
        }
        if (parts.length == 2) {
            return new NameAndVersion(parts[0], parts[1]);
        }
        return new NameAndVersion(nameAndVersion, null);
    }

    void findAutofeatureDependencies() {
        ArrayList<String> autofeatureDependencies = new ArrayList<String>();
        for (String featureName : this.featureNamesToResolve) {
            ProvisioningFeatureDefinition feature = this.resolverRepository.getFeature(featureName);
            if (feature == null || !feature.isAutoFeature() || !(feature instanceof KernelResolverEsa)) continue;
            List<ProvisioningFeatureDefinition> dependencies = ((KernelResolverEsa)feature).findFeaturesSatisfyingCapability(this.resolverRepository.getAllFeatures());
            for (ProvisioningFeatureDefinition dependency : dependencies) {
                autofeatureDependencies.add(dependency.getSymbolicName());
            }
        }
        this.featureNamesToResolve.addAll(autofeatureDependencies);
    }

    void resolveFeatures(ResolutionMode mode) {
        boolean allowMultipleVersions = mode == ResolutionMode.IGNORE_CONFLICTS;
        FeatureResolverImpl resolver = new FeatureResolverImpl();
        FeatureResolver.Result result = resolver.resolveFeatures((FeatureResolver.Repository)this.resolverRepository, this.featureNamesToResolve, Collections.emptySet(), allowMultipleVersions);
        this.featureConflicts.putAll(result.getConflicts());
        for (String name : result.getResolvedFeatures()) {
            ProvisioningFeatureDefinition feature = this.resolverRepository.getFeature(name);
            this.resolvedFeatures.put(feature.getSymbolicName(), feature);
        }
        for (String missingFeature : result.getMissing()) {
            Collection<ApplicableToProduct> featureOtherProducts = this.resolverRepository.getNonApplicableResourcesForName(missingFeature);
            if (featureOtherProducts.isEmpty()) {
                this.featuresMissing.add(missingFeature);
                continue;
            }
            this.requirementsFoundForOtherProducts.add(missingFeature);
            for (ApplicableToProduct feature : featureOtherProducts) {
                this.resourcesWrongProduct.add(feature);
            }
        }
    }

    void requireInstalledFeaturesWhenResolving() {
        for (ProvisioningFeatureDefinition installedFeature : this.installedFeatures) {
            this.featureNamesToResolve.add(installedFeature.getSymbolicName());
        }
    }

    List<List<RepositoryResource>> createInstallLists() {
        ArrayList<List<RepositoryResource>> installLists = new ArrayList<List<RepositoryResource>>();
        for (SampleResource sample : this.samplesToInstall) {
            installLists.add(this.createInstallList(sample));
        }
        for (String featureName : this.requestedFeatureNames) {
            List<RepositoryResource> installList = this.createInstallList(featureName);
            if (installList.isEmpty()) continue;
            installLists.add(installList);
        }
        for (ProvisioningFeatureDefinition feature : this.resolvedFeatures.values()) {
            if (!feature.isAutoFeature() || this.requestedFeatureNames.contains(feature.getSymbolicName()) || !(feature instanceof KernelResolverEsa)) continue;
            installLists.add(this.createInstallList(feature.getSymbolicName()));
        }
        return installLists;
    }

    List<RepositoryResource> createInstallList(SampleResource resource) {
        HashMap<String, Integer> maxDistanceMap = new HashMap<String, Integer>();
        ArrayList<RepositoryResolutionException.MissingRequirement> missingRequirements = new ArrayList<RepositoryResolutionException.MissingRequirement>();
        boolean allDependenciesResolved = true;
        if (resource.getRequireFeature() != null) {
            for (String featureName : resource.getRequireFeature()) {
                ProvisioningFeatureDefinition feature = this.resolverRepository.getFeature(featureName);
                if (feature == null) {
                    allDependenciesResolved = false;
                    if (!this.requirementsFoundForOtherProducts.contains(featureName)) {
                        missingRequirements.add(new RepositoryResolutionException.MissingRequirement(featureName, (RepositoryResource)resource));
                    }
                }
                allDependenciesResolved &= this.populateMaxDistanceMap(maxDistanceMap, featureName, 1, new HashSet<ProvisioningFeatureDefinition>(), missingRequirements);
            }
        }
        if (!allDependenciesResolved) {
            this.missingTopLevelRequirements.add(resource.getShortName());
            this.missingRequirements.addAll(missingRequirements);
        }
        ArrayList<RepositoryResource> installList = new ArrayList<RepositoryResource>();
        installList.addAll(this.convertFeatureNamesToResources(maxDistanceMap.keySet()));
        Collections.sort(installList, RepositoryResolver.byMaxDistance(maxDistanceMap));
        installList.add((RepositoryResource)resource);
        return installList;
    }

    List<RepositoryResource> createInstallList(String featureName) {
        ProvisioningFeatureDefinition feature = this.resolverRepository.getFeature(featureName);
        if (feature == null) {
            this.missingTopLevelRequirements.add(featureName);
            if (!this.requirementsFoundForOtherProducts.contains(featureName)) {
                this.missingRequirements.add(new RepositoryResolutionException.MissingRequirement(featureName, null));
            }
            return Collections.emptyList();
        }
        if (!(feature instanceof KernelResolverEsa)) {
            return Collections.emptyList();
        }
        EsaResource esa = ((KernelResolverEsa)feature).getResource();
        HashMap<String, Integer> maxDistanceMap = new HashMap<String, Integer>();
        ArrayList<RepositoryResolutionException.MissingRequirement> missingRequirements = new ArrayList<RepositoryResolutionException.MissingRequirement>();
        boolean foundAllDependencies = this.populateMaxDistanceMap(maxDistanceMap, esa.getProvideFeature(), 0, new HashSet<ProvisioningFeatureDefinition>(), missingRequirements);
        if (!foundAllDependencies) {
            this.missingTopLevelRequirements.add(featureName);
            this.missingRequirements.addAll(missingRequirements);
        }
        ArrayList<RepositoryResource> installList = new ArrayList<RepositoryResource>();
        installList.addAll(this.convertFeatureNamesToResources(maxDistanceMap.keySet()));
        Collections.sort(installList, RepositoryResolver.byMaxDistance(maxDistanceMap));
        return installList;
    }

    static Comparator<RepositoryResource> byMaxDistance(final Map<String, Integer> maxDistanceMap) {
        return new Comparator<RepositoryResource>(){

            @Override
            public int compare(RepositoryResource o1, RepositoryResource o2) {
                return Integer.compare(this.getDistance(o2), this.getDistance(o1));
            }

            private int getDistance(RepositoryResource res) {
                if (res.getType() == ResourceType.FEATURE) {
                    Integer distance = (Integer)maxDistanceMap.get(((EsaResource)res).getProvideFeature());
                    return distance == null ? 0 : distance;
                }
                return 0;
            }
        };
    }

    boolean populateMaxDistanceMap(Map<String, Integer> maxDistanceMap, String featureName, int currentDistance, Set<ProvisioningFeatureDefinition> currentStack, List<RepositoryResolutionException.MissingRequirement> missingRequirements) {
        ProvisioningFeatureDefinition feature = this.resolvedFeatures.get(featureName);
        if (!(feature instanceof KernelResolverEsa)) {
            return true;
        }
        if (currentStack.contains(feature)) {
            return true;
        }
        boolean result = true;
        currentStack.add(feature);
        KernelResolverEsa featureEsa = (KernelResolverEsa)feature;
        Integer oldDistance = maxDistanceMap.get(feature.getSymbolicName());
        if (oldDistance == null || oldDistance < currentDistance) {
            maxDistanceMap.put(feature.getSymbolicName(), currentDistance);
        }
        for (FeatureResource featureResource : feature.getConstituents(SubsystemContentType.FEATURE_TYPE)) {
            ResolvedFeatureSearchResult searchResult = this.findResolvedDependency(featureResource);
            if (searchResult.category == ResolvedFeatureSearchResult.ResultCategory.FOUND) {
                result &= this.populateMaxDistanceMap(maxDistanceMap, searchResult.symbolicName, currentDistance + 1, currentStack, missingRequirements);
                continue;
            }
            if (searchResult.category == ResolvedFeatureSearchResult.ResultCategory.MISSING) {
                missingRequirements.add(new RepositoryResolutionException.MissingRequirement(featureResource.getSymbolicName(), (RepositoryResource)featureEsa.getResource()));
                result = false;
                continue;
            }
            result = false;
        }
        for (ProvisioningFeatureDefinition provisioningFeatureDefinition : featureEsa.findFeaturesSatisfyingCapability(this.resolvedFeatures.values())) {
            result &= this.populateMaxDistanceMap(maxDistanceMap, provisioningFeatureDefinition.getSymbolicName(), currentDistance + 1, currentStack, missingRequirements);
        }
        currentStack.remove(feature);
        return result;
    }

    ResolvedFeatureSearchResult findResolvedDependency(FeatureResource featureResource) {
        ProvisioningFeatureDefinition feature = this.resolvedFeatures.get(featureResource.getSymbolicName());
        if (feature != null) {
            return new ResolvedFeatureSearchResult(ResolvedFeatureSearchResult.ResultCategory.FOUND, feature.getSymbolicName());
        }
        if (this.requirementsFoundForOtherProducts.contains(featureResource.getSymbolicName())) {
            return new ResolvedFeatureSearchResult(ResolvedFeatureSearchResult.ResultCategory.FOUND_WRONG_PRODUCT, featureResource.getSymbolicName());
        }
        String baseName = this.getFeatureBaseName(featureResource.getSymbolicName());
        for (String toleratedVersion : featureResource.getTolerates()) {
            String featureName = baseName + toleratedVersion;
            feature = this.resolvedFeatures.get(featureName);
            if (feature != null) {
                return new ResolvedFeatureSearchResult(ResolvedFeatureSearchResult.ResultCategory.FOUND, feature.getSymbolicName());
            }
            if (!this.requirementsFoundForOtherProducts.contains(featureName)) continue;
            return new ResolvedFeatureSearchResult(ResolvedFeatureSearchResult.ResultCategory.FOUND_WRONG_PRODUCT, featureName);
        }
        return new ResolvedFeatureSearchResult(ResolvedFeatureSearchResult.ResultCategory.MISSING, null);
    }

    String getFeatureBaseName(String nameAndVersion) {
        int dashPosition = nameAndVersion.lastIndexOf(45);
        if (dashPosition != -1) {
            return nameAndVersion.substring(0, dashPosition + 1);
        }
        return nameAndVersion;
    }

    List<EsaResource> convertFeatureNamesToResources(Collection<String> names) {
        ArrayList<EsaResource> results = new ArrayList<EsaResource>();
        for (String name : names) {
            ProvisioningFeatureDefinition feature = this.resolverRepository.getFeature(name);
            if (!(feature instanceof KernelResolverEsa)) continue;
            results.add(((KernelResolverEsa)feature).getResource());
        }
        return results;
    }

    private void reportErrors() throws RepositoryResolutionException {
        if (this.resourcesWrongProduct.isEmpty() && this.missingTopLevelRequirements.isEmpty() && this.missingRequirements.isEmpty() && this.featureConflicts.isEmpty()) {
            return;
        }
        HashSet<ProductRequirementInformation> missingProductInformation = new HashSet<ProductRequirementInformation>();
        for (ApplicableToProduct esa : this.resourcesWrongProduct) {
            this.missingRequirements.add(new RepositoryResolutionException.MissingRequirement(esa.getAppliesTo(), (RepositoryResource)esa));
            missingProductInformation.addAll(ProductRequirementInformation.createFromAppliesTo(esa.getAppliesTo()));
        }
        ArrayList<String> missingRequirementNames = new ArrayList<String>();
        for (RepositoryResolutionException.MissingRequirement req : this.missingRequirements) {
            missingRequirementNames.add(req.getRequirementName());
        }
        throw new RepositoryResolutionException(null, this.missingTopLevelRequirements, missingRequirementNames, missingProductInformation, this.missingRequirements, this.featureConflicts);
    }

    static class NameAndVersion {
        private final String name;
        private final String version;

        public NameAndVersion(String name, String version) {
            this.name = name;
            this.version = version;
        }
    }

    static class ResolvedFeatureSearchResult {
        ResultCategory category;
        String symbolicName;

        public ResolvedFeatureSearchResult(ResultCategory category, String symbolicName) {
            this.category = category;
            this.symbolicName = symbolicName;
        }

        static enum ResultCategory {
            FOUND,
            FOUND_WRONG_PRODUCT,
            MISSING;

        }
    }
}

