/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.proxy.ProxyBranchImpl;
import com.ibm.ws.sip.container.servlets.EmptyIterator;
import com.ibm.ws.sip.container.servlets.IncomingSipServletRequest;
import com.ibm.ws.sip.container.servlets.SipServletMessageImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.transaction.ClientTransaction;
import com.ibm.ws.sip.container.transaction.ClientTransactionListener;
import com.ibm.ws.sip.container.transaction.SipTransaction;
import com.ibm.ws.sip.container.was.ThreadLocalStorage;
import com.ibm.wsspi.webcontainer.servlet.IServletResponseWrapper;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.ProxyAuthenticateHeader;
import jain.protocol.ip.sip.header.RequireHeader;
import jain.protocol.ip.sip.header.SecurityHeader;
import jain.protocol.ip.sip.message.Response;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.ProxyBranch;
import javax.servlet.sip.Rel100Exception;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.TooManyHopsException;

public abstract class SipServletResponseImpl
extends SipServletMessageImpl
implements SipServletResponse,
IServletResponseWrapper {
    private static final LogMgr c_logger = Log.get(SipServletResponseImpl.class);
    private SipServletRequest m_sipServletRequest;
    private boolean _shouldBeSentWithoutST = false;
    private transient UnsupportedEncodingException m_unsupportedEncodingException = null;
    private transient boolean _isBranchResponse = false;

    public SipServletResponseImpl() {
    }

    public SipServletResponseImpl(Response response, long transactionId, SipProvider provider) {
        super(response, transactionId, provider);
    }

    @Override
    public String getReasonPhrase() {
        String rValue;
        block2: {
            rValue = null;
            try {
                rValue = this.getResponse().getReasonPhrase();
            }
            catch (SipParseException e2) {
                if (!c_logger.isErrorEnabled()) break block2;
                Object[] args = new Object[]{this};
                c_logger.error("error.get.reason.phrase", "Request", args, (Throwable)e2);
            }
        }
        return rValue;
    }

    @Override
    public SipServletRequest getRequest() {
        return this.m_sipServletRequest;
    }

    @Override
    public int getStatus() {
        int rValue;
        block2: {
            rValue = -1;
            try {
                rValue = this.getResponse().getStatusCode();
            }
            catch (SipParseException e2) {
                if (!c_logger.isErrorEnabled()) break block2;
                Object[] args = new Object[]{this};
                c_logger.error("error.get.status", "Request", args, (Throwable)e2);
            }
        }
        return rValue;
    }

    @Override
    public String getMethod() {
        return this.m_sipServletRequest == null ? null : this.m_sipServletRequest.getMethod();
    }

    @Override
    public void setStatus(int statusCode, String reasonPhrase) {
        this.setStatus(statusCode);
        Response response = this.getResponse();
        try {
            response.setReasonPhrase(reasonPhrase);
        }
        catch (SipParseException e2) {
            throw new IllegalArgumentException("bad reason phrase [" + reasonPhrase + ']', e2);
        }
    }

    @Override
    public void setStatus(int statusCode) {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        Response response = this.getResponse();
        try {
            response.setStatusCode(statusCode);
        }
        catch (SipParseException e2) {
            throw new IllegalArgumentException("bad status code [" + statusCode + ']', e2);
        }
    }

    @Override
    protected boolean checkIsSystemContactHeader() {
        boolean isSystemHeader = true;
        if (this.getStatus() == 485 || this.getStatus() >= 300 && this.getStatus() < 400 || this.getMethod().equals("REGISTER") || this.getMethod().equals("OPTIONS") && this.getStatus() == 200) {
            isSystemHeader = false;
        }
        return isSystemHeader;
    }

    @Override
    public abstract void sendReliably() throws Rel100Exception;

    @Override
    public abstract SipServletRequest createAck();

    public void flushBuffer() throws IOException {
    }

    public int getBufferSize() {
        return 0;
    }

    public Locale getLocale() {
        return null;
    }

    public void reset() {
    }

    public void resetBuffer() {
    }

    public void setBufferSize(int arg0) {
    }

    public void setLocale(Locale arg0) {
    }

    public Response getResponse() {
        return (Response)this.getMessage();
    }

    public void setRequest(SipServletRequestImpl request) {
        this.m_sipServletRequest = request;
    }

    @Override
    public Proxy getProxy() {
        Proxy proxy;
        block2: {
            proxy = null;
            try {
                proxy = this.m_sipServletRequest.getProxy(false);
            }
            catch (TooManyHopsException e2) {
                if (!c_logger.isTraceDebugEnabled()) break block2;
                c_logger.traceDebug(this, "getProxy", "TooManyHopsException!!!");
            }
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReliableResponse() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "isReliableResponse");
        }
        boolean result = false;
        try {
            HeaderIterator iter;
            if (this.getStatus() > 100 && this.getStatus() < 200 && (iter = this.getResponse().getHeaders("Require")) != null) {
                while (iter.hasNext()) {
                    try {
                        RequireHeader header = (RequireHeader)iter.next();
                        if (header.getValue().equals("100rel")) {
                            result = true;
                            boolean bl = true;
                            return bl;
                        }
                    }
                    catch (HeaderParseException e2) {
                        if (!c_logger.isErrorEnabled()) continue;
                        c_logger.error("error.exception", "Report", null);
                    }
                    catch (NoSuchElementException e3) {
                        if (!c_logger.isErrorEnabled()) continue;
                        c_logger.error("error.exception", "Report", null);
                    }
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceExit((Object)this, "isReliableResponse", new Boolean(result));
            }
        }
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        return null;
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        return null;
    }

    public ServletResponse getWrappedResponse() {
        return this.getHttpServletResponse();
    }

    public SecurityHeader getAuthHeader(String wantedRealm) {
        SecurityHeader authHeader;
        block6: {
            authHeader = null;
            try {
                Response response = this.getResponse();
                if (this.getStatus() == 407) {
                    authHeader = response.getProxyAuthenticateHeader();
                    String headerRealm = authHeader.getParameter("Digest");
                    if (wantedRealm != null && !wantedRealm.equals(headerRealm)) {
                        authHeader = null;
                    }
                } else if (this.getStatus() == 401) {
                    HeaderIterator headers = response.getWWWAuthenticateHeaders();
                    authHeader = this.getFirstDigestAuthHeader(headers, wantedRealm);
                }
            }
            catch (SipParseException e2) {
                if (!c_logger.isErrorEnabled()) break block6;
                c_logger.error("error.parse.auth.challange", "Request", null, (Throwable)e2);
            }
        }
        return authHeader;
    }

    private SecurityHeader getFirstDigestAuthHeader(HeaderIterator headers, String wantedRealm) throws HeaderParseException {
        SecurityHeader digestHeader = null;
        while (headers.hasNext()) {
            SecurityHeader currHeader = (SecurityHeader)headers.next();
            String scheme = currHeader.getScheme();
            if (!scheme.equals("Digest")) continue;
            String headerRealm = currHeader.getParameter("realm");
            if (wantedRealm != null && !wantedRealm.equals(headerRealm)) continue;
            digestHeader = currHeader;
            break;
        }
        return digestHeader;
    }

    @Override
    public void setCharacterEncoding(String enc) {
        try {
            super.setCharacterEncoding(enc);
            this.m_unsupportedEncodingException = null;
        }
        catch (UnsupportedEncodingException e2) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setCharacterEncoding", "invalid encoding", e2);
            }
            this.m_unsupportedEncodingException = e2;
        }
    }

    @Override
    public void setContent(Object content, String contentType) throws UnsupportedEncodingException {
        if (this.m_unsupportedEncodingException != null) {
            UnsupportedEncodingException e2 = new UnsupportedEncodingException();
            e2.initCause(this.m_unsupportedEncodingException);
            throw e2;
        }
        super.setContent(content, contentType);
    }

    @Override
    public Object getContent() throws IOException, UnsupportedEncodingException {
        if (this.m_unsupportedEncodingException != null) {
            UnsupportedEncodingException e2 = new UnsupportedEncodingException();
            e2.initCause(this.m_unsupportedEncodingException);
            throw e2;
        }
        return super.getContent();
    }

    @Override
    public Object getContent(Class[] classes) throws IOException, UnsupportedEncodingException {
        throw new UnsupportedOperationException("getContent: Not Done Yet");
    }

    @Override
    public void removeAttribute(String key) {
        if (this.isCommitted() && this.isJSR289Application()) {
            throw new IllegalStateException("Can not modify committed message");
        }
        if (this.m_attributes != null) {
            this.m_attributes.remove(key);
        }
    }

    @Override
    public Iterator<String> getChallengeRealms() {
        ArrayList<String> realms;
        block8: {
            realms = null;
            ProxyAuthenticateHeader authHeader = null;
            try {
                Response response = this.getResponse();
                if (this.getStatus() == 407) {
                    authHeader = response.getProxyAuthenticateHeader();
                    if (authHeader != null) {
                        String headerRealm = authHeader.getParameter("Digest");
                        realms = new ArrayList<String>(1);
                        realms.add(headerRealm);
                    }
                } else if (this.getStatus() == 401) {
                    HeaderIterator headers = response.getWWWAuthenticateHeaders();
                    while (headers.hasNext()) {
                        SecurityHeader currHeader = (SecurityHeader)headers.next();
                        String scheme = currHeader.getScheme();
                        if (!scheme.equals("Digest")) continue;
                        if (realms == null) {
                            realms = new ArrayList();
                        }
                        String headerRealm = currHeader.getParameter("realm");
                        realms.add(headerRealm);
                    }
                }
            }
            catch (SipParseException e2) {
                if (!c_logger.isErrorEnabled()) break block8;
                c_logger.error("error.parse.auth.challange", "Request", null, (Throwable)e2);
            }
        }
        Iterator<Object> iterator = realms != null ? realms.iterator() : EmptyIterator.getInstance();
        return iterator;
    }

    protected boolean canBeSentReliably() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "canBeSentReliably");
        }
        IncomingSipServletRequest req = (IncomingSipServletRequest)this.getRequest();
        String method = this.getMethod();
        int status = this.getStatus();
        if (req.getTransactionUser() != null && req.getTransactionUser().isProxying() && req.getRequest().getToHeader().hasTag()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "canBeSentReliably", "Trying to answer with reliable response in proxy mode for requests with to tag");
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit((Object)this, "canBeSentReliably", false);
            }
            return false;
        }
        if (status > 100 && status < 200 && method.equals("INVITE") && (req.getShouldBeAnsweredReliable() || req.getMayBeAnsweredReliable())) {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit((Object)this, "canBeSentReliably", true);
            }
            return true;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "canBeSentReliably", false);
        }
        return false;
    }

    public boolean shouldBeSentWithoutST() {
        return this._shouldBeSentWithoutST;
    }

    public void setShouldBeSentWithoutST(boolean beSentWithoutST) {
        this._shouldBeSentWithoutST = beSentWithoutST;
    }

    @Override
    public ProxyBranch getProxyBranch() {
        SipTransaction transaction = this.getTransaction();
        if (!(transaction instanceof ClientTransaction)) {
            return null;
        }
        ClientTransaction clientTransaction = (ClientTransaction)transaction;
        ClientTransactionListener listener = clientTransaction.getListener();
        if (!(listener instanceof ProxyBranch)) {
            return null;
        }
        ProxyBranch branch = (ProxyBranch)((Object)listener);
        return branch;
    }

    @Override
    public boolean isBranchResponse() {
        return ThreadLocalStorage.getCurrentBranch() != null;
    }

    public void setIsBranchResponse(ProxyBranchImpl branch) {
        ThreadLocalStorage.setCurrentBranch(branch);
    }
}

