/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.internal.literals;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

enum StringParser {
    UNSTARTED,
    UNESCAPED,
    ESCAPED,
    OCTAL2LEFT,
    OCTAL1LEFT,
    HEX4LEFT,
    HEX3LEFT,
    HEX2LEFT,
    HEX1LEFT,
    COMPLETE;

    private static final TraceComponent tc;

    @FFDCIgnore(value={UnterminatedEscapeSequence.class, StringNotStarted.class, EarlyTermination.class})
    static String parse(String s) {
        block9: {
            StringBuilder sb = new StringBuilder(s.length());
            StringParser state = UNSTARTED;
            int i = 0;
            try {
                for (i = 0; i < s.length(); ++i) {
                    state = state.accept(sb, s.charAt(i), '\"');
                }
                if (state == COMPLETE) {
                    return sb.toString();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"String not terminated with double quote.", (Object[])new Object[]{s});
                }
            }
            catch (UnterminatedEscapeSequence e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unexpected character in escape sequence.", (Object[])new Object[]{s, StringParser.createPointerString(s, i), state});
                }
            }
            catch (StringNotStarted e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"String does not start with double quote.", (Object[])new Object[]{state});
                }
            }
            catch (EarlyTermination e) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug((TraceComponent)tc, (String)"Unexpected double quote before end of string.", (Object[])new Object[]{s, StringParser.createPointerString(s, i), state});
            }
        }
        return s;
    }

    @FFDCIgnore(value={UnterminatedEscapeSequence.class, StringNotStarted.class, EarlyTermination.class})
    static Object parseChar(String s) {
        block12: {
            StringBuilder sb = new StringBuilder(s.length());
            StringParser state = UNSTARTED;
            int i = 0;
            try {
                for (i = 0; i < s.length(); ++i) {
                    state = state.accept(sb, s.charAt(i), '\'');
                }
                if (state == COMPLETE) {
                    if (sb.length() == 1) {
                        return Character.valueOf(sb.charAt(0));
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"char expression contains too many characters", (Object[])new Object[]{s, sb});
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"char not terminated with single quote.", (Object[])new Object[]{s});
                }
            }
            catch (UnterminatedEscapeSequence e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unexpected character in escape sequence.", (Object[])new Object[]{s, StringParser.createPointerString(s, i), state});
                }
            }
            catch (StringNotStarted e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"char does not start with single quote.", (Object[])new Object[]{state});
                }
            }
            catch (EarlyTermination e) {
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug((TraceComponent)tc, (String)"Unexpected single quote before end of input string.", (Object[])new Object[]{s, StringParser.createPointerString(s, i), state});
            }
        }
        return s;
    }

    private static String createPointerString(String s, int i) {
        String pointer = s.replaceAll(".", " ");
        pointer = pointer.substring(0, i) + '^' + pointer.substring(i + 1, pointer.length());
        return pointer;
    }

    private StringParser accept(StringBuilder sb, char ch, char delim) throws UnterminatedEscapeSequence, StringNotStarted, EarlyTermination {
        if (ch == delim && this != ESCAPED) {
            return this.parseDelimiter();
        }
        switch (this) {
            default: {
                throw new IllegalStateException(this.toString());
            }
            case UNSTARTED: {
                throw new StringNotStarted();
            }
            case UNESCAPED: {
                if (ch == '\\') {
                    return ESCAPED;
                }
                sb.append(ch);
                return UNESCAPED;
            }
            case ESCAPED: {
                return this.parseEscape(sb, ch);
            }
            case OCTAL2LEFT: {
                return this.parseOctal(sb, ch, OCTAL1LEFT, delim);
            }
            case OCTAL1LEFT: {
                return this.parseOctal(sb, ch, UNESCAPED, delim);
            }
            case HEX4LEFT: {
                return this.parseHex(sb, ch, HEX3LEFT);
            }
            case HEX3LEFT: {
                return this.parseHex(sb, ch, HEX2LEFT);
            }
            case HEX2LEFT: {
                return this.parseHex(sb, ch, HEX1LEFT);
            }
            case HEX1LEFT: {
                return this.parseHex(sb, ch, UNESCAPED);
            }
            case COMPLETE: 
        }
        throw new EarlyTermination();
    }

    private StringParser parseDelimiter() throws UnterminatedEscapeSequence {
        switch (this) {
            case UNSTARTED: {
                return UNESCAPED;
            }
            case HEX4LEFT: 
            case HEX3LEFT: 
            case HEX2LEFT: 
            case HEX1LEFT: {
                throw new UnterminatedEscapeSequence();
            }
        }
        return COMPLETE;
    }

    private StringParser parseOctal(StringBuilder sb, char ch, StringParser nextState, char delim) throws UnterminatedEscapeSequence, EarlyTermination, StringNotStarted {
        int val = Character.digit(ch, 8);
        if (val == -1) {
            return UNESCAPED.accept(sb, ch, delim);
        }
        int lastIndex = sb.length() - 1;
        char partial = sb.charAt(lastIndex);
        partial = (char)(partial << 3);
        partial = (char)(partial | val);
        sb.setCharAt(lastIndex, partial);
        return nextState;
    }

    private StringParser parseHex(StringBuilder sb, char ch, StringParser nextState) throws UnterminatedEscapeSequence {
        int val = Character.digit(ch, 16);
        if (val == -1) {
            throw new UnterminatedEscapeSequence();
        }
        int lastIndex = sb.length() - 1;
        char partial = sb.charAt(lastIndex);
        partial = (char)(partial << 4);
        partial = (char)(partial | val);
        sb.setCharAt(lastIndex, partial);
        return nextState;
    }

    private StringParser parseEscape(StringBuilder sb, char ch) throws UnterminatedEscapeSequence {
        switch (ch) {
            case 't': {
                sb.append('\t');
                return UNESCAPED;
            }
            case 'n': {
                sb.append('\n');
                return UNESCAPED;
            }
            case 'b': {
                sb.append('\b');
                return UNESCAPED;
            }
            case 'r': {
                sb.append('\r');
                return UNESCAPED;
            }
            case 'f': {
                sb.append('\f');
                return UNESCAPED;
            }
            case '\"': {
                sb.append('\"');
                return UNESCAPED;
            }
            case '\'': {
                sb.append('\'');
                return UNESCAPED;
            }
            case '\\': {
                sb.append('\\');
                return UNESCAPED;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': {
                sb.append((char)(ch - 48));
                return OCTAL2LEFT;
            }
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                sb.append((char)(ch - 48));
                return OCTAL1LEFT;
            }
            case 'u': {
                sb.append('u');
                return HEX4LEFT;
            }
        }
        throw new UnterminatedEscapeSequence();
    }

    static {
        tc = Tr.register(StringParser.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class UnterminatedEscapeSequence
    extends Exception {
        private static final long serialVersionUID = 1L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private UnterminatedEscapeSequence() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jndi.internal.literals.StringParser$UnterminatedEscapeSequence", UnterminatedEscapeSequence.class, (String)"Naming", (String)"com.ibm.ws.jndi.internal.resources.JNDIMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class EarlyTermination
    extends Exception {
        private static final long serialVersionUID = 1L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private EarlyTermination() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jndi.internal.literals.StringParser$EarlyTermination", EarlyTermination.class, (String)"Naming", (String)"com.ibm.ws.jndi.internal.resources.JNDIMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class StringNotStarted
    extends Exception {
        private static final long serialVersionUID = 1L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private StringNotStarted() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jndi.internal.literals.StringParser$StringNotStarted", StringNotStarted.class, (String)"Naming", (String)"com.ibm.ws.jndi.internal.resources.JNDIMessages");
        }
    }
}

