/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.timer.osgi.internal;

import com.ibm.ejs.container.TimerNpImpl;
import com.ibm.ejs.container.TimerNpRunnable;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TimerNpSERunnable
extends TimerNpRunnable {
    private static final TraceComponent tc = Tr.register(TimerNpSERunnable.class, (String)"EJBContainer", null);
    private final ScheduledExecutorService ivExecutorService;
    private ScheduledFuture<?> ivTaskFuture;
    static final long serialVersionUID = 3100814940237068300L;

    TimerNpSERunnable(ScheduledExecutorService executorService, TimerNpImpl timerNpImpl, int retryLimit, long retryInterval) {
        super(timerNpImpl, retryLimit, retryInterval);
        this.ivExecutorService = executorService;
    }

    protected void schedule(long expiration) {
        long delay = Math.max(0L, expiration - System.currentTimeMillis());
        this.ivTaskFuture = this.ivExecutorService.schedule((Runnable)((Object)this), delay, TimeUnit.MILLISECONDS);
    }

    protected void scheduleNext(long nextExpiration) {
        long delay = Math.max(0L, nextExpiration - System.currentTimeMillis());
        this.ivTaskFuture = this.ivExecutorService.schedule((Runnable)((Object)this), delay, TimeUnit.MILLISECONDS);
    }

    protected void scheduleRetry(long retryInterval) {
        this.ivTaskFuture = this.ivExecutorService.schedule((Runnable)((Object)this), retryInterval, TimeUnit.MILLISECONDS);
    }

    protected void cancel() {
        if (this.ivTaskFuture != null) {
            boolean cancelled = this.ivTaskFuture.cancel(false);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Timer was cancelled : " + cancelled), (Object[])new Object[0]);
            }
        }
    }
}

