/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument.serialfilter.agent;

import com.ibm.ws.kernel.instrument.serialfilter.agenthelper.ObjectInputStreamClassInjector;
import com.ibm.ws.kernel.instrument.serialfilter.agenthelper.ObjectInputStreamTransformer;
import com.ibm.ws.kernel.instrument.serialfilter.agenthelper.PreMainUtil;
import com.ibm.ws.kernel.instrument.serialfilter.config.Config;
import com.ibm.ws.kernel.instrument.serialfilter.config.ConfigFacade;
import com.ibm.ws.kernel.instrument.serialfilter.config.ConfigurableFunctor;
import com.ibm.ws.kernel.instrument.serialfilter.validators.ValidatorsFacade;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class PreMain {
    public static void premain(String args, Instrumentation instrumentation) {
        if (!PreMainUtil.isBeta() && !PreMainUtil.isEnableAgentPropertySet()) {
            return;
        }
        ObjectInputStreamTransformer transform = null;
        if (ObjectInputStreamClassInjector.injectionNeeded()) {
            if (PreMainUtil.isDebugEnabled()) {
                System.out.println("Using class file transformer to modify ObjectInputStream.");
            }
            transform = new ObjectInputStreamTransformer();
            instrumentation.addTransformer((ClassFileTransformer)transform);
        }
        try {
            PreMain.initialiseObjectInputStream();
        }
        finally {
            if (transform != null) {
                if (PreMainUtil.isDebugEnabled()) {
                    System.out.println("Removing class file transformer.");
                }
                instrumentation.removeTransformer((ClassFileTransformer)transform);
            }
        }
        AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.setProperty("com.ibm.websphere.serialfilter.active", "true");
            }
        });
    }

    public static void agentmain(String args, Instrumentation instrumentation) throws Exception {
        if (PreMainUtil.isDebugEnabled()) {
            System.out.println("agentmain was called");
        }
        PreMain.premain(args, instrumentation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialiseObjectInputStream() {
        Config config = ConfigFacade.createConfig();
        ConfigurableFunctor validatorFactory = ValidatorsFacade.createFactory((Config)config);
        boolean debugEnabled = PreMainUtil.isDebugEnabled();
        if (debugEnabled) {
            System.out.println("Inserting validator factory instance into system property: com.ibm.serialization.validators.factory.instance");
        }
        Object oldVal = System.getProperties().put("com.ibm.serialization.validators.factory.instance", validatorFactory);
        if (debugEnabled) {
            System.out.println("Saving old value stored in system property: com.ibm.serialization.validators.factory.instance=" + oldVal);
        }
        try {
            Class<ObjectInputStream> oisc = ObjectInputStream.class;
            Field factory = ObjectInputStream.class.getDeclaredField("serializationValidatorFactory");
            factory.setAccessible(true);
            int modifiers = factory.getModifiers();
            if (Modifier.isFinal(modifiers)) {
                try {
                    Field modifierField = factory.getClass().getDeclaredField("modifiers");
                    modifierField.setAccessible(true);
                    modifierField.setInt(factory, modifiers & 0xFFFFFFEF);
                }
                catch (NoSuchFieldException expectedForNonIbmJava) {
                    if (debugEnabled) {
                        System.out.println("Caught NoSuchFieldException while accessing ObjectInputStream modifiers fields from agent which is expected for non IBM JVM");
                    }
                }
            } else if (debugEnabled) {
                System.out.println("Modifiers does not set as final.");
            }
            factory.set(null, validatorFactory);
            if (debugEnabled) {
                System.out.println("Forcing ObjectInputStream initialisation.");
            }
            try {
                new ObjectInputStream(null);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (IllegalAccessException unexpected) {
            if (debugEnabled) {
                System.out.println("Caught unexpected IllegalAccessException while accessing ObjectInputStream fields from agent" + unexpected);
            }
        }
        catch (Exception unexpected) {
            if (debugEnabled) {
                System.out.println("Caught unexpected exception while accessing ObjectInputStream fields from agent" + unexpected);
            }
        }
        finally {
            if (oldVal == null) {
                if (debugEnabled) {
                    System.out.println("Removing validator factory from system property: com.ibm.serialization.validators.factory.instance");
                }
                System.getProperties().remove("com.ibm.serialization.validators.factory.instance");
            } else {
                if (debugEnabled) {
                    System.out.println("Restoring previous value of system property: com.ibm.serialization.validators.factory.instance=" + oldVal);
                }
                System.getProperties().put("com.ibm.serialization.validators.factory.instance", oldVal);
            }
        }
        assert (ObjectInputStreamClassInjector.hasModified(ObjectInputStream.class));
    }
}

