/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc.v43;

import com.ibm.ws.rsadapter.impl.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.impl.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource;
import com.ibm.ws.rsadapter.jdbc.v43.WSJdbc43ConnectionBuilder;
import java.sql.Connection;
import java.sql.ConnectionBuilder;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.ShardingKeyBuilder;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;

public class WSJdbc43DataSource
extends WSJdbcDataSource
implements DataSource {
    public WSJdbc43DataSource(WSManagedConnectionFactoryImpl mcf, ConnectionManager connMgr) {
        super(mcf, connMgr);
    }

    @Override
    public ConnectionBuilder createConnectionBuilder() throws SQLException {
        return new WSJdbc43ConnectionBuilder(this);
    }

    @Override
    public ShardingKeyBuilder createShardingKeyBuilder() throws SQLException {
        CommonDataSource ds = this.mcf.getUnderlyingDataSource();
        if (ds == null) {
            throw new SQLFeatureNotSupportedException("java.sql.Driver.createShardingKeyBuilder");
        }
        return ds.createShardingKeyBuilder();
    }

    Connection getConnection(WSJdbc43ConnectionBuilder builder) throws SQLException {
        WSConnectionRequestInfoImpl conRequest = new WSConnectionRequestInfoImpl(this.mcf, this.cm, builder.user, builder.password, builder.shardingKey, builder.superShardingKey);
        return super.getConnection((ConnectionRequestInfo)conRequest);
    }

    final boolean isBackedByDriver() {
        return this.mcf.getUnderlyingDataSource() == null;
    }
}

