/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.impl;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.config.impl.AbstractConfigBuilder;
import com.ibm.ws.microprofile.config.impl.ConfigWrapper;
import com.ibm.ws.microprofile.config.interfaces.ConfigException;
import com.ibm.ws.microprofile.config.interfaces.WebSphereConfig;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AbstractProviderResolver
extends ConfigProviderResolver
implements ApplicationStateListener {
    private static final TraceComponent tc = Tr.register(AbstractProviderResolver.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config.resources.Config");
    private final AtomicServiceReference<ScheduledExecutorService> scheduledExecutorServiceRef = new AtomicServiceReference("scheduledExecutorService");
    private final Map<ClassLoader, ConfigWrapper> configCache = new HashMap<ClassLoader, ConfigWrapper>();
    private final Map<String, Set<ClassLoader>> appClassLoaderMap = new HashMap<String, Set<ClassLoader>>();
    static final long serialVersionUID = -8878410307057980795L;

    @Reference(name="scheduledExecutorService", service=ScheduledExecutorService.class, target="(deferrable=false)")
    protected void setScheduledExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.scheduledExecutorServiceRef.setReference(ref);
    }

    protected void unsetScheduledExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.scheduledExecutorServiceRef.unsetReference(ref);
    }

    public void activate(ComponentContext cc) {
        this.scheduledExecutorServiceRef.activate(cc);
        ConfigProviderResolver.setInstance((ConfigProviderResolver)this);
    }

    public void deactivate(ComponentContext cc) throws IOException {
        ConfigProviderResolver.setInstance(null);
        this.shutdown();
        this.scheduledExecutorServiceRef.deactivate(cc);
    }

    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStopped(ApplicationInfo appInfo) {
    }

    public void applicationStopping(ApplicationInfo appInfo) {
        ExtendedApplicationInfo extendedAppInfo = (ExtendedApplicationInfo)appInfo;
        String applicationName = extendedAppInfo.getMetaData().getJ2EEName().getApplication();
        this.shutdown(applicationName);
    }

    public String getApplicationName() {
        ComponentMetaDataAccessorImpl cmdai = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
        ComponentMetaData cmd = cmdai.getComponentMetaData();
        String applicationName = null;
        if (cmd != null) {
            J2EEName applicationJEEName = cmd.getModuleMetaData().getApplicationMetaData().getJ2EEName();
            applicationName = applicationJEEName.getApplication();
        }
        if (applicationName == null) {
            applicationName = "!GLOBAL_CONFIG_APPLICATION_NAME!";
        }
        return applicationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Map<ClassLoader, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            HashSet<ClassLoader> allClassLoaders = new HashSet<ClassLoader>();
            allClassLoaders.addAll(this.configCache.keySet());
            for (ClassLoader classLoader : allClassLoaders) {
                this.close(classLoader);
            }
            this.configCache.clear();
            this.appClassLoaderMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(String applicationName) {
        Map<ClassLoader, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            Set<ClassLoader> appClassLoaders = this.appClassLoaderMap.remove(applicationName);
            if (appClassLoaders != null) {
                for (ClassLoader classLoader : appClassLoaders) {
                    this.shutdown(applicationName, classLoader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(String applicationName, ClassLoader classLoader) {
        Map<ClassLoader, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            ConfigWrapper configWrapper = this.configCache.get(classLoader);
            boolean close = configWrapper.removeApplication(applicationName);
            if (close) {
                this.close(classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(ClassLoader classLoader) {
        Map<ClassLoader, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            ConfigWrapper config = this.configCache.remove(classLoader);
            if (config != null) {
                Set<String> applicationNames = config.getApplications();
                for (String app : applicationNames) {
                    this.appClassLoaderMap.remove(app);
                }
                config.close();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void closeConfig(Config config) {
        if (config instanceof WebSphereConfig) {
            try {
                ((WebSphereConfig)config).close();
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.microprofile.config.impl.AbstractProviderResolver", (String)"208", (Object)((Object)this), (Object[])new Object[]{config});
                throw new ConfigException(Tr.formatMessage((TraceComponent)tc, (String)"could.not.close.CWMCG0004E", (Object[])new Object[]{e}));
            }
        }
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return (ScheduledExecutorService)this.scheduledExecutorServiceRef.getService();
    }

    public Config getConfig() {
        ClassLoader classloader = this.getThreadContextClassLoader();
        Config config = this.getConfig(classloader);
        return config;
    }

    private ClassLoader getThreadContextClassLoader() {
        ClassLoader classloader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = -1358665995610986238L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.config.impl.AbstractProviderResolver$1", 1.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config.resources.Config");
            }
        });
        return classloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config getConfig(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"null.classloader.CWMCG0002E", (Object[])new Object[0]));
        }
        Config config = null;
        Map<ClassLoader, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            ConfigWrapper configWrapper = this.configCache.get(classLoader);
            if (configWrapper == null) {
                AbstractConfigBuilder builder = this.newBuilder(classLoader);
                builder.addDefaultSources();
                builder.addDiscoveredSources();
                builder.addDefaultConverters();
                builder.addDiscoveredConverters();
                config = builder.build();
                configWrapper = this.newConfigWrapper(config, classLoader);
            } else {
                config = configWrapper.getConfig();
            }
            this.registerApplication(configWrapper, classLoader);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConfig(Config config, ClassLoader classLoader) {
        Map<ClassLoader, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            ConfigWrapper configWrapper = this.newConfigWrapper(config, classLoader);
            this.registerApplication(configWrapper, classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigWrapper newConfigWrapper(Config config, ClassLoader classLoader) {
        ConfigWrapper configWrapper = null;
        Map<ClassLoader, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            configWrapper = null;
            ConfigWrapper previous = this.configCache.get(classLoader);
            if (previous != null) {
                throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"config.already.exists.CWMCG0003E", (Object[])new Object[0]));
            }
            configWrapper = new ConfigWrapper((WebSphereConfig)config);
            this.configCache.put(classLoader, configWrapper);
        }
        return configWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerApplication(ConfigWrapper configWrapper, ClassLoader classLoader) {
        String applicationName = this.getApplicationName();
        Map<ClassLoader, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            Set<ClassLoader> appClassLoaders = this.appClassLoaderMap.get(applicationName);
            if (appClassLoaders == null) {
                appClassLoaders = new HashSet<ClassLoader>();
                this.appClassLoaderMap.put(applicationName, appClassLoaders);
                appClassLoaders.add(classLoader);
                configWrapper.addApplication(applicationName);
            } else if (!appClassLoaders.contains(classLoader)) {
                appClassLoaders.add(classLoader);
                configWrapper.addApplication(applicationName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConfig(Config config) {
        Map<ClassLoader, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            ClassLoader classloader = this.findClassloaderForRegisteredConfig(config);
            if (classloader != null) {
                this.close(classloader);
            } else {
                this.closeConfig(config);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader findClassloaderForRegisteredConfig(Config config) {
        Map<ClassLoader, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            for (Map.Entry<ClassLoader, ConfigWrapper> entry : this.configCache.entrySet()) {
                Config cachedConfig;
                ClassLoader classLoader = entry.getKey();
                ConfigWrapper configWrapper = entry.getValue();
                if (configWrapper == null || (cachedConfig = configWrapper.getConfig()) == null || config != cachedConfig) continue;
                return classLoader;
            }
            return null;
        }
    }

    public ConfigBuilder getBuilder() {
        ClassLoader classLoader = this.getThreadContextClassLoader();
        AbstractConfigBuilder builder = this.newBuilder(classLoader);
        builder.addDefaultConverters();
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    public String getConfigCacheDetails() {
        StringBuilder builder = new StringBuilder("[");
        boolean first1 = true;
        Map<ClassLoader, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            for (Map.Entry<ClassLoader, ConfigWrapper> entry : this.configCache.entrySet()) {
                if (!first1) {
                    builder.append(", ");
                } else {
                    first1 = false;
                }
                ClassLoader cl = entry.getKey();
                ConfigWrapper wrapper = entry.getValue();
                builder.append(cl.toString());
                builder.append(":{");
                boolean first2 = true;
                for (String app : wrapper.getApplications()) {
                    if (!first2) {
                        builder.append(",");
                    } else {
                        first2 = false;
                    }
                    builder.append(app);
                }
                builder.append("}");
            }
        }
        builder.append("]");
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    public int getConfigCacheSize() {
        int size = 0;
        Map<ClassLoader, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            size = this.configCache.size();
        }
        return size;
    }

    @Trivial
    public String toString() {
        StringBuilder builder = new StringBuilder(((Object)((Object)this)).getClass().getName());
        builder.append(": cache=");
        builder.append(this.getConfigCacheDetails());
        return builder.toString();
    }

    protected abstract AbstractConfigBuilder newBuilder(ClassLoader var1);
}

