/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.oauth.core.internal.oauth20.OAuth20Constants;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.util.OIDCConstants;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import com.ibm.ws.security.oauth20.web.AbstractOidcEndpointServices;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcBaseClientValidator {
    protected static final String MESSAGE_BUNDLE = "com.ibm.ws.security.oauth20.internal.resources.OAuthMessages";
    private static final String[] illegalChars;
    private final OidcBaseClient client;
    static final long serialVersionUID = 740822539673214098L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private OidcBaseClientValidator(OidcBaseClient client) {
        this.client = client.getDeepCopy();
    }

    public static OidcBaseClientValidator getInstance(OidcBaseClient client) {
        try {
            if (client.getClientName() != null) {
                client.setClientName(URLDecoder.decode(client.getClientName(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.oauth20.plugins.OidcBaseClientValidator", (String)"52", null, (Object[])new Object[]{client});
        }
        return new OidcBaseClientValidator(client);
    }

    public OidcBaseClient validateCreateUpdate() throws OidcServerException {
        this.detectIllegalChars();
        this.validateAppType();
        this.validateResponseTypes();
        Set<String> grantTypes = this.validateGrantTypes();
        this.validateResponseAndGrantMatch(grantTypes);
        this.validateRedirectUris();
        this.validateScopes();
        this.validateSujectType();
        this.validateTokenEndpointAuthMethod();
        this.validatePostLogoutRedirectUris();
        this.validatePreAuthorizedScopes();
        this.validateTrustedUriPrefixes();
        this.validateFunctionalUserGroupIds();
        this.validateOutputParameters();
        return this.client;
    }

    private void detectIllegalChars() throws OidcServerException {
        this.detectIllegalCharacters(this.client.getClientId());
        this.detectIllegalCharacters(this.client.getClientSecret());
        this.detectIllegalCharacters(this.client.getRedirectUris());
        this.detectIllegalCharacters(this.client.getClientName());
        this.detectIllegalCharacters(this.client.getPostLogoutRedirectUris());
        this.detectIllegalCharacters(this.client.getPreAuthorizedScope());
        this.detectIllegalCharacters(this.client.getFunctionalUserId());
        this.detectIllegalCharacters(this.client.getFunctionalUserGroupIds());
    }

    private void detectIllegalCharacters(@Sensitive String s) throws OidcServerException {
        if (s == null || s.length() == 0) {
            return;
        }
        for (int i = 0; i < illegalChars.length; ++i) {
            if (!s.contains(illegalChars[i])) continue;
            String description = TraceNLS.getFormattedMessage(OidcBaseClientValidator.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_ILLEGAL_CHAR", (Object[])new Object[]{illegalChars[i]}, (String)"");
            throw new OidcServerException(description, "invalid_client_metadata", 400);
        }
    }

    private void detectIllegalCharacters(@Sensitive JsonArray a) throws OidcServerException {
        this.detectIllegalCharacters(a.toString());
    }

    public OidcBaseClient setDefaultsForOmitted() {
        this.setDefaultAppType();
        this.setDefaultResponseType();
        this.setDefaultGrantType();
        this.setDefaultTokenEndpointAuthMethod();
        this.setDefaultJsonArrayForNullUris();
        return this.client;
    }

    protected void setDefaultAppType() {
        String appType = this.client.getApplicationType();
        if (OidcOAuth20Util.isNullEmpty(appType)) {
            this.client.setApplicationType("web");
        }
    }

    protected void setDefaultResponseType() {
        JsonArray responseTypes = this.client.getResponseTypes();
        if (OidcOAuth20Util.isNullEmpty(responseTypes)) {
            this.client.setResponseTypes(OidcOAuth20Util.initJsonArray("code"));
        }
    }

    protected void setDefaultGrantType() {
        JsonArray grantTypes = this.client.getGrantTypes();
        if (OidcOAuth20Util.isNullEmpty(grantTypes)) {
            this.client.setGrantTypes(OidcOAuth20Util.initJsonArray("authorization_code"));
        }
    }

    protected void setDefaultTokenEndpointAuthMethod() {
        String tokenEndpointAuthMethod = this.client.getTokenEndpointAuthMethod();
        if (OidcOAuth20Util.isNullEmpty(tokenEndpointAuthMethod)) {
            this.client.setTokenEndpointAuthMethod("client_secret_basic");
        }
    }

    protected void setDefaultJsonArrayForNullUris() {
        if (this.client.getRedirectUris() == null) {
            this.client.setRedirectUris(new JsonArray());
        }
        if (this.client.getPostLogoutRedirectUris() == null) {
            this.client.setPostLogoutRedirectUris(new JsonArray());
        }
        if (this.client.getTrustedUriPrefixes() == null) {
            this.client.setTrustedUriPrefixes(new JsonArray());
        }
    }

    protected void validateAppType() throws OidcServerException {
        String appType = this.client.getApplicationType();
        if (!(OidcOAuth20Util.isNullEmpty(appType) || appType.equals("native") || appType.equals("web"))) {
            String description = TraceNLS.getFormattedMessage(OidcBaseClientValidator.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_VALUE_NOT_SUPPORTED", (Object[])new Object[]{appType, "application_type"}, (String)"CWWKS1442E: The value {0} is not a supported value for the {1} client registration metadata field.");
            throw new OidcServerException(description, "invalid_client_metadata", 400);
        }
    }

    protected void validateResponseTypes() throws OidcServerException {
        JsonArray responseTypes = this.client.getResponseTypes();
        if (!OidcOAuth20Util.isNullEmpty(responseTypes)) {
            HashSet<String> dupeCheckerSet = new HashSet<String>();
            for (JsonElement response : responseTypes) {
                if (!OIDCConstants.OIDC_SUPP_RESP_TYPES_SET.contains(response.getAsString())) {
                    String description = TraceNLS.getFormattedMessage(OidcBaseClientValidator.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_VALUE_NOT_SUPPORTED", (Object[])new Object[]{response.getAsString(), "response_type"}, (String)"CWWKS1442E: The value {0} is not a supported value for the {1} client registration metadata field.");
                    throw new OidcServerException(description, "invalid_client_metadata", 400);
                }
                if (dupeCheckerSet.add(response.getAsString())) continue;
                String description = TraceNLS.getFormattedMessage(OidcBaseClientValidator.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_VALUE_DUPE", (Object[])new Object[]{response.getAsString(), "response_type"}, (String)"CWWKS1443E: The value {0} is a duplicate for the {1} client registration metadata field.");
                throw new OidcServerException(description, "invalid_client_metadata", 400);
            }
        }
    }

    protected Set<String> validateGrantTypes() throws OidcServerException {
        HashSet<String> grantTypeSet = new HashSet<String>();
        JsonArray grantTypes = this.client.getGrantTypes();
        if (!OidcOAuth20Util.isNullEmpty(grantTypes)) {
            for (JsonElement grant : grantTypes) {
                if (!OAuth20Constants.ALL_GRANT_TYPES_SET.contains(grant.getAsString())) {
                    String description = TraceNLS.getFormattedMessage(OidcBaseClientValidator.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_VALUE_NOT_SUPPORTED", (Object[])new Object[]{grant.getAsString(), "grant_type"}, (String)"CWWKS1442E: The value {0} is not a supported value for the {1} client registration metadata field.");
                    throw new OidcServerException(description, "invalid_client_metadata", 400);
                }
                if (grantTypeSet.add(grant.getAsString())) continue;
                String description = TraceNLS.getFormattedMessage(OidcBaseClientValidator.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_VALUE_DUPE", (Object[])new Object[]{grant.getAsString(), "grant_type"}, (String)"CWWKS1443E: The value {0} is a duplicate for the {1} client registration metadata field.");
                throw new OidcServerException(description, "invalid_client_metadata", 400);
            }
        }
        return grantTypeSet;
    }

    protected void validateResponseAndGrantMatch(Set<String> grantTypeSet) throws OidcServerException {
        JsonArray responseTypes = this.client.getResponseTypes();
        if (!OidcOAuth20Util.isNullEmpty(responseTypes)) {
            for (JsonElement responseType : responseTypes) {
                if (responseType.getAsString().equals("code") && !grantTypeSet.contains("authorization_code")) {
                    String description = TraceNLS.getFormattedMessage(OidcBaseClientValidator.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_GRANT_RESPONSE_VALIDATION", (Object[])new Object[]{responseType.getAsString(), "authorization_code"}, (String)"CWWKS1444E: The client registration metadata field response_type contains value {0}, which requires at least a matching grant_type value {1}.");
                    throw new OidcServerException(description, "invalid_client_metadata", 400);
                }
                if (!responseType.getAsString().equals("id_token token") && !responseType.getAsString().equals("token id_token") || grantTypeSet.contains("implicit")) continue;
                String description = TraceNLS.getFormattedMessage(OidcBaseClientValidator.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_GRANT_RESPONSE_VALIDATION", (Object[])new Object[]{responseType.getAsString(), "implicit"}, (String)"CWWKS1444E: The client registration metadata field response_type contains value {0}, which requires at least a matching grant_type value {1}.");
                throw new OidcServerException(description, "invalid_client_metadata", 400);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void validateRedirectUris() throws OidcServerException {
        JsonArray redirectUris = this.client.getRedirectUris();
        if (redirectUris == null) {
            this.client.setRedirectUris(new JsonArray());
            return;
        }
        if (!OidcOAuth20Util.isNullEmpty(redirectUris)) {
            HashSet<String> dupeCheckerSet = new HashSet<String>();
            for (JsonElement redirectUriEle : redirectUris) {
                URI uri;
                String redirectUriString = redirectUriEle.getAsString();
                try {
                    uri = new URI(redirectUriEle.getAsString());
                }
                catch (URISyntaxException uRISyntaxException) {
                    void e;
                    FFDCFilter.processException((Throwable)uRISyntaxException, (String)"com.ibm.ws.security.oauth20.plugins.OidcBaseClientValidator", (String)"491", (Object)this, (Object[])new Object[0]);
                    String description = TraceNLS.getFormattedMessage(OidcBaseClientValidator.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_VALUE_MALFORMED_URI", (Object[])new Object[]{redirectUriString, "redirect_uris"}, (String)"CWWKS1445E: The value {0} for the client registration metadata field {1} contains a malformed URI syntax.");
                    throw new OidcServerException(description, "invalid_redirect_uri", 400, (Throwable)e);
                }
                if ((this.client.getApplicationType() == null || this.client.getApplicationType().equals("web")) && !uri.isAbsolute()) {
                    String description = TraceNLS.getFormattedMessage(OidcBaseClientValidator.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_VALUE_NOT_ABSOLUTE_URI", (Object[])new Object[]{redirectUriString, "redirect_uris"}, (String)"CWWKS1446E: The value {0} for the client registration metadata field {1} is not an absolute URI.");
                    throw new OidcServerException(description, "invalid_redirect_uri", 400);
                }
                if (dupeCheckerSet.add(redirectUriEle.getAsString())) continue;
                String description = TraceNLS.getFormattedMessage(OidcBaseClientValidator.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_VALUE_DUPE", (Object[])new Object[]{redirectUriEle.getAsString(), "redirect_uris"}, (String)"CWWKS1443E: The value {0} is a duplicate for the {1} client registration metadata field.");
                throw new OidcServerException(description, "invalid_client_metadata", 400);
            }
        }
    }

    protected void validateScopes() throws OidcServerException {
        if (!OidcOAuth20Util.isNullEmpty(this.client.getScope())) {
            // empty if block
        }
    }

    protected void validateSujectType() throws OidcServerException {
        String subjectType = this.client.getSubjectType();
        if (!OidcOAuth20Util.isNullEmpty(subjectType) && !subjectType.equals("public")) {
            String description = TraceNLS.getFormattedMessage(OidcBaseClientValidator.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_VALUE_NOT_SUPPORTED", (Object[])new Object[]{subjectType, "subject_type"}, (String)"CWWKS1442E: The value {0} is not a supported value for the {1} client registration metadata field.");
            throw new OidcServerException(description, "invalid_client_metadata", 400);
        }
    }

    protected void validateTokenEndpointAuthMethod() throws OidcServerException {
        String tokenEndpointAuthMethod = this.client.getTokenEndpointAuthMethod();
        if (!(OidcOAuth20Util.isNullEmpty(tokenEndpointAuthMethod) || tokenEndpointAuthMethod.equals("client_secret_post") || tokenEndpointAuthMethod.equals("client_secret_basic") || tokenEndpointAuthMethod.equals("none"))) {
            String description = TraceNLS.getFormattedMessage(OidcBaseClientValidator.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_VALUE_NOT_SUPPORTED", (Object[])new Object[]{tokenEndpointAuthMethod, "token_endpoint_auth_method"}, (String)"CWWKS1442E: The value {0} is not a supported value for the {1} client registration metadata field.");
            throw new OidcServerException(description, "invalid_client_metadata", 400);
        }
    }

    protected void validatePostLogoutRedirectUris() throws OidcServerException {
        JsonArray postLogoutRedirectUris = this.client.getPostLogoutRedirectUris();
        if (postLogoutRedirectUris == null) {
            this.client.setPostLogoutRedirectUris(new JsonArray());
            return;
        }
        this.validateUris(postLogoutRedirectUris, "post_logout_redirect_uris");
    }

    protected void validatePreAuthorizedScopes() throws OidcServerException {
    }

    protected void validateTrustedUriPrefixes() throws OidcServerException {
        JsonArray trustedUriPrefixes = this.client.getTrustedUriPrefixes();
        if (trustedUriPrefixes == null) {
            this.client.setTrustedUriPrefixes(new JsonArray());
            return;
        }
        this.validateUris(trustedUriPrefixes, "trusted_uri_prefixes");
        this.client.setTrustedUriPrefixes(AbstractOidcEndpointServices.getSlashTerminated(trustedUriPrefixes));
    }

    protected void validateFunctionalUserGroupIds() throws OidcServerException {
        JsonArray functionalUserGroupIds = this.client.getFunctionalUserGroupIds();
        if (functionalUserGroupIds == null) {
            this.client.setFunctionalUserGroupIds(new JsonArray());
            return;
        }
        HashSet<String> dupeCheckerSet = new HashSet<String>();
        for (JsonElement groupIdEle : functionalUserGroupIds) {
            String groupIdString = groupIdEle.getAsString();
            if (dupeCheckerSet.add(groupIdString)) continue;
            String description = TraceNLS.getFormattedMessage(OidcBaseClientValidator.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_VALUE_DUPE", (Object[])new Object[]{groupIdString, "functional_user_groupIds"}, (String)"CWWKS1443E: The value {0} is a duplicate for the {1} client registration metadata field.");
            throw new OidcServerException(description, "invalid_client_metadata", 400);
        }
    }

    protected void validateOutputParameters() throws OidcServerException {
        if (this.client.getClientIdIssuedAt() != 0L) {
            String description = TraceNLS.getFormattedMessage(OidcBaseClientValidator.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_VALUE_OUT_NOT_ALLOWED", (Object[])new Object[]{"client_id_issued_at"}, (String)"CWWKS1447E: The client registration metadata field {0} cannot be specified for a create or update action because it is an output parameter.");
            throw new OidcServerException(description, "invalid_client_metadata", 400);
        }
        if (this.client.getClientSecretExpiresAt() != 0L) {
            String description = TraceNLS.getFormattedMessage(OidcBaseClientValidator.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_VALUE_OUT_NOT_ALLOWED", (Object[])new Object[]{"client_secret_expires_at"}, (String)"CWWKS1447E: The client registration metadata field {0} cannot be specified for a create or update action because it is an output parameter.");
            throw new OidcServerException(description, "invalid_client_metadata", 400);
        }
        if (this.client.getRegistrationClientUri() != null && !this.client.getRegistrationClientUri().isEmpty()) {
            String description = TraceNLS.getFormattedMessage(OidcBaseClientValidator.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_VALUE_OUT_NOT_ALLOWED", (Object[])new Object[]{"registration_client_uri"}, (String)"CWWKS1447E: The client registration metadata field {0} cannot be specified for a create or update action because it is an output parameter.");
            throw new OidcServerException(description, "invalid_client_metadata", 400);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateUris(JsonArray uris, String clientMetadataField) throws OidcServerException {
        if (!OidcOAuth20Util.isNullEmpty(uris)) {
            HashSet<String> dupeCheckerSet = new HashSet<String>();
            for (JsonElement uriEle : uris) {
                URI uri;
                String uriString = uriEle.getAsString();
                try {
                    uri = new URI(uriString);
                }
                catch (URISyntaxException uRISyntaxException) {
                    void e;
                    FFDCFilter.processException((Throwable)uRISyntaxException, (String)"com.ibm.ws.security.oauth20.plugins.OidcBaseClientValidator", (String)"696", (Object)this, (Object[])new Object[]{uris, clientMetadataField});
                    String description = TraceNLS.getFormattedMessage(OidcBaseClientValidator.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_VALUE_MALFORMED_URI", (Object[])new Object[]{uriString, clientMetadataField}, (String)"CWWKS1445E: The value {0} for the client registration metadata field {1} contains a malformed URI syntax.");
                    throw new OidcServerException(description, "invalid_client_metadata", 400, (Throwable)e);
                }
                if (!uri.isAbsolute()) {
                    String description = TraceNLS.getFormattedMessage(OidcBaseClientValidator.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_VALUE_NOT_ABSOLUTE_URI", (Object[])new Object[]{uriString, clientMetadataField}, (String)"CWWKS1446E: The value {0} for the client registration metadata field {1} is not an absolute URI.");
                    throw new OidcServerException(description, "invalid_client_metadata", 400);
                }
                if (dupeCheckerSet.add(uriString)) continue;
                String description = TraceNLS.getFormattedMessage(OidcBaseClientValidator.class, (String)MESSAGE_BUNDLE, (String)"OAUTH_CLIENT_REGISTRATION_VALUE_DUPE", (Object[])new Object[]{uriString, clientMetadataField}, (String)"CWWKS1443E: The value {0} is a duplicate for the {1} client registration metadata field.");
                throw new OidcServerException(description, "invalid_client_metadata", 400);
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.oauth20.plugins.OidcBaseClientValidator", OidcBaseClientValidator.class, null, null);
        illegalChars = new String[]{"<", ">"};
    }
}

