/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.web;

import com.ibm.oauth.core.api.OAuthResult;
import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.oauth20.OAuth20Util;
import com.ibm.oauth.core.util.RateLimiter;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.audit.context.AuditManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.Audit;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.api.OidcOAuth20ClientProvider;
import com.ibm.ws.security.oauth20.error.impl.BrowserAndServerLogMessage;
import com.ibm.ws.security.oauth20.error.impl.OAuth20TokenRequestExceptionHandler;
import com.ibm.ws.security.oauth20.exception.OAuth20BadParameterException;
import com.ibm.ws.security.oauth20.plugins.OAuth20TokenImpl;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.util.HashUtils;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import com.ibm.ws.security.oauth20.web.ClientAuthnData;
import com.ibm.ws.security.oauth20.web.EndpointUtils;
import com.ibm.ws.security.oauth20.web.WebUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TokenExchange {
    public static final String CT_APPLICATION_JSON_UTF8 = "application/json;charset=UTF-8";
    public static final String HDR_AUTHORIZATION = "Authorization";
    public static final String CT_APPLICATION_URLENC = "application/x-www-form-urlencoded";
    public static final int PARAM_MAX_LENGTH = 255;
    public static final String HTTP_METHOD_DELETE = "DELETE";
    public static final String HTTP_METHOD_POST = "POST";
    public static final String HTTP_METHOD_GET = "GET";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String NO_STORE = "no-store";
    public static final String NO_CACHE = "no-cache";
    public static final String PRAGMA = "Pragma";
    public static final String APP_ID_LOOKUP_KEY = "com.ibm.wsspi.security.oidc.external.claims:app_id";
    public static final String APP_TOKEN_LOOKUP_KEY = "com.ibm.wsspi.security.oidc.external.claims:app_id";
    public static final String ROLE_REQUIRED = "tokenManager";
    public static final String[] ALLOWED_AT_GT = new String[]{"authorization_code", "implicit", "implicit_internal", "refresh_token", "urn:ietf:params:oauth:grant-type:jwt-bearer"};
    public static final HashSet<String> ALLOWED_AT_GT_SET = new HashSet<String>(Arrays.asList(ALLOWED_AT_GT));
    public static final String[] ALLOWED_RT_GT = new String[]{"authorization_code", "implicit"};
    public static final HashSet<String> ALLOWED_RT_GT_SET = new HashSet<String>(Arrays.asList(ALLOWED_RT_GT));
    private static TraceComponent tc = Tr.register(TokenExchange.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    private static final ThreadLocal<Map<String, Object>> auditMap = new ThreadLocal<Map<String, Object>>(){
        static final long serialVersionUID = -4689953052342383386L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>(32);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.oauth20.web.TokenExchange$1", 1.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
        }
    };
    public int numberRevoked = 0;
    private final AuditManager auditManager = new AuditManager();
    private Enumeration<Locale> requestLocales = null;
    static final long serialVersionUID = -6251441693335381936L;

    protected void processAppPassword(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.processCommon(true, provider, request, response);
    }

    protected void processAppToken(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.processCommon(false, provider, request, response);
    }

    private void processCommonAudit(boolean isAppPasswordRequest, OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) throws IOException {
        auditMap.get().clear();
        auditMap.get().put("isAppPasswordRequest", isAppPasswordRequest);
        auditMap.get().put("provider", provider.getID());
        auditMap.get().put("request", request);
        auditMap.get().put("response", response);
        String endpoint = isAppPasswordRequest ? "app-passwords" : "app-tokens";
        auditMap.get().put("endpoint", endpoint);
        if (OidcOAuth20Util.isJwtToken(request.getHeader("access_token"))) {
            auditMap.get().put("credentialType", "JWT");
        }
    }

    private void processCommon(boolean isAppPasswordRequest, OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.requestLocales = request.getLocales();
        this.processCommonAudit(isAppPasswordRequest, provider, request, response);
        if (request.getMethod().equalsIgnoreCase(HTTP_METHOD_GET)) {
            this.processCommonGet(isAppPasswordRequest, provider, request, response);
        } else if (request.getMethod().equalsIgnoreCase(HTTP_METHOD_POST)) {
            this.processCommonPost(isAppPasswordRequest, provider, request, response);
        } else if (request.getMethod().equalsIgnoreCase(HTTP_METHOD_DELETE)) {
            this.processCommonDelete(isAppPasswordRequest, provider, request, response);
        } else {
            String endpoint = isAppPasswordRequest ? "app-passwords" : "app-tokens";
            BrowserAndServerLogMessage errorMsg = new BrowserAndServerLogMessage(tc, this.requestLocales, "OAUTH_UNSUPPORTED_METHOD", request.getMethod(), endpoint);
            Tr.error((TraceComponent)tc, (String)errorMsg.getServerErrorMessage(), (Object[])new Object[0]);
            response.sendError(400, errorMsg.getBrowserErrorMessage());
            auditMap.get().put("auditOutcome", "failure");
            auditMap.get().put("detaileError", "bad request: unsupported HTTP method for endpoint");
            Audit.audit((Audit.EventID)Audit.EventID.APPLICATION_PASSWORD_TOKEN_01, (Object[])new Object[]{auditMap.get()});
        }
    }

    private String processAuditRole(HttpServletRequest request) {
        String role = "";
        if (request.isUserInRole(ROLE_REQUIRED)) {
            role = role + ROLE_REQUIRED.concat(", ");
        }
        if (request.isUserInRole("clientManager")) {
            role = role + "clientManager".concat(", ");
        }
        if (request.isUserInRole("authenticated")) {
            role = role + "authenticated".concat(", ");
        }
        return role;
    }

    private void processCommonDelete(boolean appPasswordRequest, OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) {
        AuthResult authRes;
        String role;
        String[] clientIdAndSecret = this.extractClientIdAndSecretFromAuthHeader(request, response);
        if (clientIdAndSecret != null && clientIdAndSecret[0] != null) {
            auditMap.get().put("clientId", clientIdAndSecret[0]);
        }
        if ((role = this.processAuditRole(request)).length() > 0) {
            auditMap.get().put("initiatorRole", role.substring(0, role.length() - 2));
        }
        if ((authRes = this.validateClientAndAuthenticate(appPasswordRequest, provider, request, response)) == null) {
            auditMap.get().put("auditOutcome", "failure");
            Audit.audit((Audit.EventID)Audit.EventID.APPLICATION_PASSWORD_TOKEN_01, (Object[])new Object[]{auditMap.get()});
            return;
        }
        boolean result = this.deleteAppPasswordOrToken(appPasswordRequest, authRes, provider);
        if (!result) {
            this.sendHttp500(response);
            Audit.audit((Audit.EventID)Audit.EventID.APPLICATION_PASSWORD_TOKEN_01, (Object[])new Object[]{auditMap.get()});
            return;
        }
        response.setStatus(200);
        auditMap.get().put("auditOutcome", "success");
        auditMap.get().put("numberRevoked", this.numberRevoked);
        Audit.audit((Audit.EventID)Audit.EventID.APPLICATION_PASSWORD_TOKEN_01, (Object[])new Object[]{auditMap.get()});
        try {
            response.flushBuffer();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.oauth20.web.TokenExchange", (String)"236", (Object)this, (Object[])new Object[]{appPasswordRequest, provider, request, response});
        }
    }

    private void processCommonPost(boolean appPasswordRequest, OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) {
        boolean paramsOk;
        String role;
        String[] clientIdAndSecret = this.extractClientIdAndSecretFromAuthHeader(request, response);
        if (clientIdAndSecret != null && clientIdAndSecret[0] != null) {
            auditMap.get().put("clientId", clientIdAndSecret[0]);
        }
        if ((role = this.processAuditRole(request)).length() > 0) {
            auditMap.get().put("initiatorRole", role.substring(0, role.length() - 2));
        }
        if (!(paramsOk = this.checkContentType(CT_APPLICATION_URLENC, request))) {
            this.sendInvalidRequestError(null, response);
            Audit.audit((Audit.EventID)Audit.EventID.APPLICATION_PASSWORD_TOKEN_01, (Object[])new Object[]{auditMap.get()});
            return;
        }
        AuthResult authRes = this.validateClientAndAuthenticate(appPasswordRequest, provider, request, response);
        if (authRes == null) {
            auditMap.get().put("auditOutcome", "failure");
            Audit.audit((Audit.EventID)Audit.EventID.APPLICATION_PASSWORD_TOKEN_01, (Object[])new Object[]{auditMap.get()});
            return;
        }
        String appName = request.getParameter("app_name");
        appName = appName == null ? null : WebUtils.htmlEncode(request.getParameter("app_name"));
        auditMap.get().put("appName", appName);
        Collection<OAuth20Token> tokenCollection = this.getTokensForUser(appPasswordRequest, authRes, provider);
        BrowserAndServerLogMessage errorMsg = this.checkAppNameValidAndNotInUse(appPasswordRequest, authRes, appName, provider, tokenCollection);
        if (errorMsg != null) {
            Tr.error((TraceComponent)tc, (String)errorMsg.getServerErrorMessage(), (Object[])new Object[0]);
            this.sendInvalidRequestError(errorMsg.getBrowserErrorMessage(), response);
            Audit.audit((Audit.EventID)Audit.EventID.APPLICATION_PASSWORD_TOKEN_01, (Object[])new Object[]{auditMap.get()});
            return;
        }
        errorMsg = this.checkTokenQuantityLimit(appPasswordRequest, authRes, provider, tokenCollection);
        if (errorMsg != null) {
            Tr.error((TraceComponent)tc, (String)errorMsg.getServerErrorMessage(), (Object[])new Object[0]);
            this.sendInvalidRequestError(errorMsg.getBrowserErrorMessage(), response);
            Audit.audit((Audit.EventID)Audit.EventID.APPLICATION_PASSWORD_TOKEN_01, (Object[])new Object[]{auditMap.get()});
            return;
        }
        OAuthResult result = null;
        result = this.requestAppPasswordOrTokenJson(appPasswordRequest, authRes, appName, provider, request, response);
        if (result.getStatus() != 0) {
            OAuth20TokenRequestExceptionHandler handler = new OAuth20TokenRequestExceptionHandler();
            handler.handleResultException(request, response, result);
            auditMap.get().put("auditOutcome", "failure");
            auditMap.get().put("detaileError", "failure to return request");
        } else {
            if (this.auditManager != null) {
                auditMap.get().put("respBody", this.auditManager.getAgent());
            }
            auditMap.get().put("auditOutcome", "success");
        }
        Audit.audit((Audit.EventID)Audit.EventID.APPLICATION_PASSWORD_TOKEN_01, (Object[])new Object[]{auditMap.get()});
    }

    private BrowserAndServerLogMessage checkTokenQuantityLimit(boolean isAppPasswordRequest, AuthResult authRes, OAuth20Provider provider, Collection<OAuth20Token> tokenCollection) {
        boolean okToCreate = false;
        long maxQuantity = provider.getAppTokenOrPasswordLimit();
        boolean bl = okToCreate = (long)tokenCollection.size() < maxQuantity;
        if (!okToCreate) {
            return new BrowserAndServerLogMessage(tc, this.requestLocales, "OAUTH_INVALID_REQUEST_TOO_MANY_TOKENS", authRes.user);
        }
        return null;
    }

    private void processCommonGet(boolean appPasswordRequest, OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) {
        String[] clientIdAndSecret = this.extractClientIdAndSecretFromAuthHeader(request, response);
        if (clientIdAndSecret != null && clientIdAndSecret[0] != null) {
            auditMap.get().put("clientId", clientIdAndSecret[0]);
        }
        String role = "";
        if (request.isUserInRole(ROLE_REQUIRED)) {
            role = role + ROLE_REQUIRED.concat(", ");
        }
        if (request.isUserInRole("clientManager")) {
            role = role + "clientManager".concat(", ");
        }
        if (request.isUserInRole("authenticated")) {
            role = role + "authenticated".concat(", ");
        }
        if (role.length() > 0) {
            auditMap.get().put("initiatorRole", role.substring(0, role.length() - 2));
        }
        AuthResult authRes = this.validateClientAndAuthenticate(appPasswordRequest, provider, request, response);
        auditMap.get().put("authResult", authRes);
        if (authRes == null) {
            auditMap.get().put("auditOutcome", "failure");
            if (response.getStatus() == 400) {
                auditMap.get().put("detaileError", "bad request");
            } else if (response.getStatus() == 401) {
                auditMap.get().put("detaileError", "invalid client");
            }
            Audit.audit((Audit.EventID)Audit.EventID.APPLICATION_PASSWORD_TOKEN_01, (Object[])new Object[]{auditMap.get()});
            return;
        }
        String responseJson = this.listTokensJson(appPasswordRequest, authRes, provider);
        if (responseJson == null) {
            this.sendHttp500(response);
            auditMap.get().put("auditOutcome", "failure");
            auditMap.get().put("detaileError", "internal error");
            Audit.audit((Audit.EventID)Audit.EventID.APPLICATION_PASSWORD_TOKEN_01, (Object[])new Object[]{auditMap.get()});
            return;
        }
        this.sendGoodResponse(responseJson, response);
        auditMap.get().put("auditOutcome", "success");
        Audit.audit((Audit.EventID)Audit.EventID.APPLICATION_PASSWORD_TOKEN_01, (Object[])new Object[]{auditMap.get()});
    }

    private AuthResult validateClientAndAuthenticate(boolean appPasswordRequest, OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) {
        String appOrTokenId;
        AuthResult result = null;
        String[] clientIdAndSecret = this.extractClientIdAndSecretFromAuthHeader(request, response);
        if (clientIdAndSecret == null) {
            return result;
        }
        if (!this.isAccessTokenPresent(request)) {
            BrowserAndServerLogMessage errorMsg = new BrowserAndServerLogMessage(tc, this.requestLocales, "OAUTH_INVALID_REQUEST_NO_TOKEN", request.getMethod(), request.getRequestURI());
            Tr.error((TraceComponent)tc, (String)errorMsg.getServerErrorMessage(), (Object[])new Object[0]);
            RateLimiter.limit();
            this.sendInvalidRequestError(errorMsg.getBrowserErrorMessage(), response);
            return result;
        }
        String user = null;
        if (!this.clientIdAndSecretValid(provider, clientIdAndSecret)) {
            BrowserAndServerLogMessage errorMsg = new BrowserAndServerLogMessage(tc, this.requestLocales, "OAUTH_INVALID_REQUEST_AUTHN_FAIL", request.getMethod(), request.getRequestURI());
            Tr.error((TraceComponent)tc, (String)errorMsg.getServerErrorMessage(), (Object[])new Object[0]);
            RateLimiter.limit();
            this.sendInvalidClientError(errorMsg.getBrowserErrorMessage(), response);
            return result;
        }
        user = this.authenticate(provider, request.getHeader("access_token"), request, response, clientIdAndSecret);
        if (user == null) {
            RateLimiter.limit();
            return result;
        }
        String clientId = clientIdAndSecret[0];
        if (!this.checkClientAuthorization(appPasswordRequest, provider, clientId, request.getMethod())) {
            BrowserAndServerLogMessage errorMsg = new BrowserAndServerLogMessage(tc, this.requestLocales, "OAUTH_UNAUTHORIZED_CLIENT", clientId);
            Tr.error((TraceComponent)tc, (String)errorMsg.getServerErrorMessage(), (Object[])new Object[0]);
            this.sendUnauthorizedClientError(errorMsg.getBrowserErrorMessage(), response);
            return result;
        }
        boolean isAdmin = false;
        String targetUser = null;
        if (!request.getMethod().equalsIgnoreCase(HTTP_METHOD_POST)) {
            targetUser = request.getParameter("user_id");
        }
        if (targetUser != null) {
            if (!this.checkParamLength("user_id", targetUser, request.getRequestURI(), response)) {
                return result;
            }
            targetUser = this.escapeIllegalCharacters(targetUser);
            isAdmin = this.isAdminUser(user, request);
            if (!isAdmin && !targetUser.equals(user)) {
                BrowserAndServerLogMessage errorMsg = new BrowserAndServerLogMessage(tc, this.requestLocales, "OAUTH_SERVER_USERNAME_PARAM_NOT_SUPPORTED", request.getMethod(), request.getRequestURI());
                Tr.error((TraceComponent)tc, (String)errorMsg.getServerErrorMessage(), (Object[])new Object[0]);
                this.sendInvalidRequestError(errorMsg.getBrowserErrorMessage(), response);
                return result;
            }
        }
        appOrTokenId = (appOrTokenId = this.getAppIdOrTokenId(request)) != null ? WebUtils.htmlEncode(appOrTokenId) : null;
        return new AuthResult(isAdmin, user, targetUser, clientId, appOrTokenId);
    }

    private String getAppIdOrTokenId(HttpServletRequest request) {
        if (!request.getMethod().equalsIgnoreCase(HTTP_METHOD_DELETE)) {
            return null;
        }
        String appid = null;
        String path = request.getPathInfo();
        String apppws = "/app-passwords/";
        String apptoks = "/app-tokens/";
        int apppw = path.indexOf(apppws);
        int apptok = path.indexOf(apptoks);
        if (apppw > 0) {
            appid = path.substring(apppw + apppws.length());
        } else if (apptok > 0) {
            appid = path.substring(apptok + apptoks.length());
        }
        if (appid == null || appid.length() == 0) {
            return null;
        }
        return appid;
    }

    private boolean isAccessTokenPresent(HttpServletRequest request) {
        String at = request.getHeader("access_token");
        return at != null && !at.isEmpty();
    }

    @FFDCIgnore(value={OAuth20BadParameterException.class, OAuthException.class})
    private String authenticate(OAuth20Provider provider, String accessTokenStr, HttpServletRequest request, HttpServletResponse response, String[] clientIdAndSecret) {
        OAuth20Token accessToken;
        String result = null;
        String tokenLookupStr = accessTokenStr;
        if (OidcOAuth20Util.isJwtToken(accessTokenStr)) {
            tokenLookupStr = HashUtils.digest(accessTokenStr);
        }
        if ((accessToken = provider.getTokenCache().get(tokenLookupStr)) != null) {
            block15: {
                String tokenType = accessToken.getType();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("token type: " + tokenType), (Object[])new Object[0]);
                }
                if (!tokenType.equals("access_token")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"token type not an access token, return null", (Object[])new Object[0]);
                    }
                    this.handleInvalidAccessTokenError(request, response, "OAUTH_INVALID_ATINREQUEST_AUTHN_FAIL");
                    return null;
                }
                String grantType = accessToken.getGrantType();
                String refreshTokenId = ((OAuth20TokenImpl)accessToken).getRefreshTokenKey();
                OAuth20Token refreshToken = null;
                if (refreshTokenId != null) {
                    refreshToken = provider.getTokenCache().get(refreshTokenId);
                }
                if (!this.validateGrantType(grantType, accessToken, refreshToken, request, response)) {
                    return null;
                }
                if (!this.clientInAccessTokenMatchesClientInAuthHeader(accessToken, clientIdAndSecret)) {
                    this.handleInvalidAccessTokenError(request, response, "OAUTH_CLIENTINREQ_DONOT_MATCH_AT");
                    return null;
                }
                result = accessToken.getUsername();
                if (result != null && HTTP_METHOD_POST.equalsIgnoreCase(request.getMethod())) {
                    try {
                        this.buildAndSaveAttributeList(accessToken, request, response);
                    }
                    catch (OAuth20BadParameterException e) {
                        result = null;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("token user name reset to null due to an exception: " + e), (Object[])new Object[0]);
                        }
                    }
                    catch (OAuthException e) {
                        result = null;
                        if (!tc.isDebugEnabled()) break block15;
                        Tr.debug((TraceComponent)tc, (String)("token user name reset to null due to an exception: " + e), (Object[])new Object[0]);
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("token user name : " + result), (Object[])new Object[0]);
            }
        } else {
            this.handleInvalidAccessTokenError(request, response, "OAUTH_INVALID_ATINREQUEST_AUTHN_FAIL");
            return null;
        }
        return result;
    }

    private boolean validateGrantType(String grantType, OAuth20Token accessToken, OAuth20Token refreshToken, HttpServletRequest request, HttpServletResponse response) {
        if (grantType == null || !this.isGrantTypeInAllowedGrantTypes(grantType)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("grantType is not one we accept: " + grantType + ",  return false"), (Object[])new Object[0]);
            }
            this.handleInvalidAccessTokenError(request, response, "OAUTH_INVALID_ATINREQUEST_AUTHN_FAIL");
            return false;
        }
        if ("refresh_token".equals(grantType) && (refreshToken == null || !this.validateRefreshTokenGrantType(refreshToken))) {
            this.handleInvalidAccessTokenError(request, response, "OAUTH_INVALID_ATINREQUEST_AUTHN_FAIL");
            return false;
        }
        return true;
    }

    private boolean validateRefreshTokenGrantType(OAuth20Token refreshToken) {
        String originalGT = this.getRefreshTokenOriginalGrantType(refreshToken);
        return ALLOWED_RT_GT_SET.contains(originalGT);
    }

    private String getRefreshTokenOriginalGrantType(OAuth20Token refreshToken) {
        String[] buf = refreshToken.getExtensionProperty("com.ibm.wsspi.security.oidc.external.claims:originalGrantType");
        return buf == null ? null : buf[0];
    }

    private boolean isGrantTypeInAllowedGrantTypes(String grantType) {
        return ALLOWED_AT_GT_SET.contains(grantType);
    }

    private boolean clientInAccessTokenMatchesClientInAuthHeader(OAuth20Token accessToken, String[] clientIdAndSecret) {
        return accessToken.getClientId() != null && accessToken.getClientId().equals(clientIdAndSecret[0]);
    }

    private void handleInvalidAccessTokenError(HttpServletRequest request, HttpServletResponse response, String msgKey) {
        BrowserAndServerLogMessage errorMsg = new BrowserAndServerLogMessage(tc, this.requestLocales, msgKey, request.getMethod(), request.getRequestURI());
        Tr.error((TraceComponent)tc, (String)errorMsg.getServerErrorMessage(), (Object[])new Object[0]);
        this.sendInvalidRequestError(errorMsg.getBrowserErrorMessage(), response);
    }

    private void buildAndSaveAttributeList(OAuth20Token accessToken, HttpServletRequest request, HttpServletResponse response) throws OAuthException {
        if (accessToken != null) {
            String redirectUri;
            AttributeList attributeList = (AttributeList)request.getAttribute("urn:ibm:names:oauth:param:request");
            boolean reqHasAttributes = true;
            if (attributeList == null) {
                attributeList = new AttributeList();
                reqHasAttributes = false;
            }
            this.addUserToAttributeList(accessToken.getUsername(), attributeList);
            this.addTokenExtensionAttributes(request, attributeList, response);
            String[] scope = accessToken.getScope();
            if (scope != null) {
                attributeList.setAttribute("scope", "urn:ibm:names:oauth:param:request", scope);
            }
            if ((redirectUri = accessToken.getRedirectUri()) != null) {
                attributeList.setAttribute("redirect_uri", "urn:ibm:names:oauth:param", new String[]{redirectUri});
            }
            if (!reqHasAttributes) {
                request.setAttribute("urn:ibm:names:oauth:param:request", (Object)attributeList);
            }
        }
    }

    private void addTokenExtensionAttributes(HttpServletRequest request, AttributeList attributeList, HttpServletResponse response) throws OAuthException {
        this.addUsedByExtensionAttribute(request, attributeList, response);
        String app_name = request.getParameter("app_name");
        if (app_name != null) {
            String key = "com.ibm.wsspi.security.oidc.external.claims:app_name";
            attributeList.setAttribute(key, "com.ibm.wsspi.security.oidc.external.claims", new String[]{this.escapeIllegalCharacters(app_name)});
        }
    }

    private String escapeIllegalCharacters(String in) {
        return in.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replace("'", "&#39;").replaceAll("\"", "&quot;");
    }

    private boolean checkParamLength(String paramName, String param, String URI2, HttpServletResponse resp) {
        if (param.length() > 255) {
            BrowserAndServerLogMessage errorMsg = new BrowserAndServerLogMessage(tc, this.requestLocales, "OAUTH_PARAMETER_VALUE_LENGTH_TOO_LONG", paramName, URI2, 255);
            Tr.error((TraceComponent)tc, (String)errorMsg.getServerErrorMessage(), (Object[])new Object[0]);
            this.sendInvalidRequestError(errorMsg.getBrowserErrorMessage(), resp);
            return false;
        }
        return true;
    }

    private void addUsedByExtensionAttribute(HttpServletRequest request, AttributeList attributeList, HttpServletResponse response) throws OAuth20BadParameterException {
        String usedBy = request.getParameter("used_by");
        if (usedBy == null) {
            return;
        }
        if (!this.checkParamLength("used_by", usedBy, request.getRequestURI(), response)) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"OAUTH_PARAMETER_VALUE_LENGTH_TOO_LONG", (Object[])new Object[]{"used_by", request.getRequestURI(), 255});
            throw new OAuth20BadParameterException(errorMsg, new Object[]{"used_by", usedBy});
        }
        usedBy = WebUtils.htmlEncode(usedBy);
        String[] usedByArray = usedBy.split(",");
        String key = "com.ibm.wsspi.security.oidc.external.claims:used_by";
        attributeList.setAttribute(key, "com.ibm.wsspi.security.oidc.external.claims", usedByArray);
    }

    private void addUserToAttributeList(String username, AttributeList attributeList) throws OAuthException {
        OAuth20Util.validateRequiredAttribute("username", username);
        attributeList.setAttribute("username", "urn:ibm:names:oauth:param:request", new String[]{username});
    }

    private boolean isAdminUser(String user, HttpServletRequest request) {
        return request.isUserInRole(ROLE_REQUIRED);
    }

    private void sendInvalidRequestError(String errorDescription, HttpServletResponse response) {
        WebUtils.sendErrorJSON(response, 400, "invalid_request", errorDescription);
        auditMap.get().put("auditOutcome", "failure");
        auditMap.get().put("detaileError", "invalid_request");
    }

    private void sendInvalidClientError(String errorDescription, HttpServletResponse response) {
        WebUtils.sendErrorJSON(response, 401, "invalid_client", errorDescription);
        auditMap.get().put("auditOutcome", "failure");
        auditMap.get().put("detaileError", "invalid_client");
    }

    private void sendUnauthorizedClientError(String errorDescription, HttpServletResponse response) {
        WebUtils.sendErrorJSON(response, 400, "unauthorized_client", errorDescription);
        auditMap.get().put("auditOutcome", "failure");
        auditMap.get().put("detaileError", "unauthorized_client");
    }

    private boolean checkClientAuthorization(boolean appPasswordRequest, OAuth20Provider provider, String clientId, String requestMethod) {
        boolean result = false;
        OidcOAuth20ClientProvider cp = provider.getClientProvider();
        try {
            OidcBaseClient bc = cp.get(clientId);
            if (bc == null) {
                return false;
            }
            if (HTTP_METHOD_POST.equalsIgnoreCase(requestMethod)) {
                result = appPasswordRequest ? bc.isAppPasswordAllowed() : bc.isAppTokenAllowed();
                result = bc.isEnabled() && result;
            } else {
                result = bc.isEnabled();
            }
        }
        catch (OidcServerException oidcServerException) {
            FFDCFilter.processException((Throwable)oidcServerException, (String)"com.ibm.ws.security.oauth20.web.TokenExchange", (String)"842", (Object)this, (Object[])new Object[]{appPasswordRequest, provider, clientId, requestMethod});
        }
        return result;
    }

    boolean clientIdAndSecretValid(OAuth20Provider provider, @Sensitive String[] clientIdAndSecret) {
        OidcBaseClient bc;
        try {
            OidcOAuth20ClientProvider clientProvider = provider.getClientProvider();
            if (clientProvider == null) {
                return false;
            }
            bc = clientProvider.get(clientIdAndSecret[0]);
        }
        catch (OidcServerException clientProvider) {
            Object[] objectArray = new Object[2];
            objectArray[0] = provider;
            objectArray[1] = "<sensitive java.lang.String[]>";
            FFDCFilter.processException((Throwable)clientProvider, (String)"com.ibm.ws.security.oauth20.web.TokenExchange", (String)"861", (Object)this, (Object[])objectArray);
            return false;
        }
        String storedSecret = null;
        if (bc != null) {
            storedSecret = bc.getClientSecret();
        }
        if (storedSecret == null) {
            return false;
        }
        return storedSecret.equals(clientIdAndSecret[1]);
    }

    @Sensitive
    private String[] extractClientIdAndSecretFromAuthHeader(HttpServletRequest req, HttpServletResponse response) {
        String[] stringArray;
        boolean valid;
        String clientId = null;
        String clientSecret = null;
        String authHeader = req.getHeader(HDR_AUTHORIZATION);
        if (authHeader == null) {
            BrowserAndServerLogMessage errorMsg = new BrowserAndServerLogMessage(tc, req.getLocales(), "OAUTH_INVALID_REQUEST_NO_AUTHHEADER", req.getMethod(), req.getRequestURI());
            Tr.error((TraceComponent)tc, (String)errorMsg.getServerErrorMessage(), (Object[])new Object[0]);
            this.sendInvalidClientError(errorMsg.getBrowserErrorMessage(), response);
            return null;
        }
        if (!authHeader.startsWith("Basic ")) {
            BrowserAndServerLogMessage errorMsg = new BrowserAndServerLogMessage(tc, req.getLocales(), "OAUTH_AUTH_HEADER_NOT_BASIC_AUTH", req.getMethod(), req.getRequestURI());
            Tr.error((TraceComponent)tc, (String)errorMsg.getServerErrorMessage(), (Object[])new Object[0]);
            this.sendInvalidClientError(errorMsg.getBrowserErrorMessage(), response);
            return null;
        }
        String hdrValue = ClientAuthnData.decodeAuthorizationHeader(authHeader, req.getHeader("Authorization-Encoding"));
        int idx = hdrValue.indexOf(58);
        if (idx < 0) {
            clientId = hdrValue;
        } else {
            clientId = hdrValue.substring(0, idx);
            clientSecret = hdrValue.substring(idx + 1);
        }
        boolean bl = valid = clientId != null && clientId.length() > 0 && clientSecret != null && clientSecret.length() > 0;
        if (!valid) {
            BrowserAndServerLogMessage errorMsg = new BrowserAndServerLogMessage(tc, this.requestLocales, "OAUTH_INVALID_REQUEST_NO_ID_SECRET", req.getMethod(), req.getRequestURI());
            Tr.error((TraceComponent)tc, (String)errorMsg.getServerErrorMessage(), (Object[])new Object[0]);
            this.sendInvalidClientError(errorMsg.getBrowserErrorMessage(), response);
        }
        if (valid) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = clientId;
            stringArray = stringArray2;
            stringArray2[1] = clientSecret;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    private void sendGoodResponse(String responseJson, HttpServletResponse response) {
        response.setHeader(CACHE_CONTROL, NO_STORE);
        response.setHeader(PRAGMA, NO_CACHE);
        response.setContentType(CT_APPLICATION_JSON_UTF8);
        response.setStatus(200);
        try {
            byte[] b = responseJson.getBytes("UTF-8");
            response.getOutputStream().write(b);
            response.flushBuffer();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.oauth20.web.TokenExchange", (String)"924", (Object)this, (Object[])new Object[]{responseJson, response});
        }
    }

    private void sendHttp500(HttpServletResponse response) {
        response.setStatus(500);
        auditMap.get().put("auditOutcome", "failure");
        auditMap.get().put("detaileError", "internal error");
        try {
            response.getOutputStream().print("INTERNAL SERVER ERROR");
            response.flushBuffer();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.oauth20.web.TokenExchange", (String)"937", (Object)this, (Object[])new Object[]{response});
        }
    }

    private boolean deleteAppPasswordOrToken(boolean isAppPasswordRequest, AuthResult authRes, OAuth20Provider provider) {
        Collection<OAuth20Token> tokens = this.getTokensForUser(isAppPasswordRequest, authRes, provider);
        String tokenId = authRes.appOrTokenId;
        this.numberRevoked = 0;
        for (OAuth20Token token : tokens) {
            boolean removeByTokenId;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("considering removing token: " + token.getId()), (Object[])new Object[0]);
            }
            boolean removeByAppId = isAppPasswordRequest && tokenId != null && tokenId.equals(this.getAppIdFromToken(token));
            boolean bl = removeByTokenId = !isAppPasswordRequest && tokenId != null && tokenId.equals(this.getTokenIdFromToken(token));
            if (tokenId != null && !removeByAppId && !removeByTokenId) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("removing token: " + token.getId()), (Object[])new Object[0]);
            }
            String tokenLookupKey = token.getId();
            if (provider.isLocalStoreUsed()) {
                String encode = provider.getAccessTokenEncoding();
                tokenLookupKey = "plain".equals(encode) ? EndpointUtils.computeTokenHash(tokenLookupKey) : EndpointUtils.computeTokenHash(tokenLookupKey, encode);
            }
            provider.getTokenCache().removeByHash(tokenLookupKey);
            ++this.numberRevoked;
        }
        return true;
    }

    private boolean checkContentType(String ctApplicationUrlenc, HttpServletRequest request) {
        return true;
    }

    private BrowserAndServerLogMessage checkAppNameValidAndNotInUse(boolean isAppPasswordRequest, AuthResult authRes, String appName, OAuth20Provider provider, Collection<OAuth20Token> tokenCollection) {
        boolean badLength;
        boolean missing;
        boolean inuse = false;
        boolean bl = missing = appName == null || appName.length() == 0;
        if (missing) {
            return new BrowserAndServerLogMessage(tc, this.requestLocales, "OAUTH_COVERAGE_MAP_MISSING_TOKEN_PARAM", "app_name");
        }
        boolean bl2 = badLength = appName.length() > 255;
        if (!badLength) {
            inuse = this.isAppNameInUse(tokenCollection, appName);
        }
        if (badLength || inuse) {
            return new BrowserAndServerLogMessage(tc, this.requestLocales, "OAUTH_SERVER_APPNAME_IN_USE_OR_TOO_LONG", appName, provider.getID());
        }
        return null;
    }

    private OAuthResult requestAppPasswordOrTokenJson(boolean isAppPasswordRequest, AuthResult authRes, String appName, OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("user", (Object)authRes.user);
        return provider.getComponent().processAppTokenRequest(isAppPasswordRequest, authRes.clientId, request, response);
    }

    private String listTokensJson(boolean isAppPasswordRequest, AuthResult authRes, OAuth20Provider provider) {
        return this.tokensToJson(isAppPasswordRequest, this.getTokensForUser(isAppPasswordRequest, authRes, provider));
    }

    private Collection<OAuth20Token> getTokensForUser(boolean isAppPasswordRequest, AuthResult authRes, OAuth20Provider provider) {
        String userName = authRes.targetUser != null ? authRes.targetUser : authRes.user;
        return EndpointUtils.getTokensForUser(isAppPasswordRequest, false, userName, authRes.clientId, provider);
    }

    private boolean isAppNameInUse(Collection<OAuth20Token> tokens, String appName) {
        for (OAuth20Token token : tokens) {
            if (!token.getAppName().equals(appName)) continue;
            return true;
        }
        return false;
    }

    private String tokensToJson(boolean appPasswordRequest, Collection<OAuth20Token> tokens) {
        StringBuffer sb = new StringBuffer();
        boolean haveTokens = false;
        String arrayType = appPasswordRequest ? "\"app-passwords\"" : "\"app-tokens\"";
        sb.append("{");
        sb.append(arrayType);
        sb.append(":[");
        for (OAuth20Token token : tokens) {
            haveTokens = true;
            sb.append(this.tokenToJson(token));
            sb.append(",");
        }
        if (haveTokens) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]}");
        return sb.toString();
    }

    private String tokenToJson(OAuth20Token token) {
        StringBuffer sb = new StringBuffer();
        if (token == null) {
            return null;
        }
        String appId = this.getAppIdFromToken(token);
        sb.append("{");
        sb.append("\"user\":\"");
        sb.append(EndpointUtils.escapeQuotesForJson(token.getUsername()));
        sb.append("\",\"name\":\"");
        sb.append(EndpointUtils.escapeQuotesForJson(token.getAppName()));
        sb.append("\"");
        if (appId != null) {
            sb.append(",\"app_id\":\"");
            sb.append(appId);
            sb.append("\"");
        }
        sb.append(",\"created_at\":");
        sb.append(token.getCreatedAt());
        sb.append(",\"expires_at\":");
        sb.append((long)token.getLifetimeSeconds() * 1000L + token.getCreatedAt());
        if (token.getUsedBy() != null) {
            sb.append(",\"used_by\":\"");
            sb.append(token.getUsedBy()[0]);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private String getAppIdFromToken(OAuth20Token token) {
        String appId = null;
        String[] appIds = token.getExtensionProperties().get("com.ibm.wsspi.security.oidc.external.claims:app_id");
        if (appIds != null) {
            appId = appIds[0];
        }
        return appId;
    }

    private String getTokenIdFromToken(OAuth20Token token) {
        String tokenId = null;
        String[] tokenIds = token.getExtensionProperties().get("com.ibm.wsspi.security.oidc.external.claims:app_id");
        if (tokenIds != null) {
            tokenId = tokenIds[0];
        }
        return tokenId;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private final class AuthResult {
        final boolean isAdmin;
        final String user;
        final String targetUser;
        final String clientId;
        final String appOrTokenId;
        static final long serialVersionUID = -1679603630094096518L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        AuthResult(boolean isAdmin, String user, String targetUser, String clientId, String appId) {
            this.isAdmin = isAdmin;
            this.user = this.setToNullIfEmpty(user);
            this.targetUser = this.setToNullIfEmpty(targetUser);
            this.clientId = this.setToNullIfEmpty(clientId);
            this.appOrTokenId = this.setToNullIfEmpty(appId);
            ((Map)auditMap.get()).put("isAdmin", isAdmin);
            ((Map)auditMap.get()).put("user", user);
            ((Map)auditMap.get()).put("targetUser", targetUser);
            ((Map)auditMap.get()).put("clientId", clientId);
            ((Map)auditMap.get()).put("appOrTokenId", this.appOrTokenId);
            ((Map)auditMap.get()).put("applicationId", appId);
        }

        private String setToNullIfEmpty(String in) {
            if (in != null && in.length() == 0) {
                return null;
            }
            return in;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.oauth20.web.TokenExchange$AuthResult", AuthResult.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
        }
    }
}

