/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jfap.inbound.channel.CommsServerServiceFacade;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.CommsByteBufferPool;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationSession;

public class StaticCATHelper {
    private static String CLASS_NAME = StaticCATHelper.class.getName();
    private static CommsByteBufferPool poolManager = CommsByteBufferPool.getInstance();
    private static final TraceComponent tc = SibTr.register(StaticCATHelper.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");

    public static void sendExceptionToClient(Throwable throwable, String probeId, Conversation conversation, int requestNumber) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendExceptionToClient", (Object)new Object[]{throwable, probeId, conversation, requestNumber});
        }
        CommsByteBuffer buffer = poolManager.allocate();
        buffer.putException(throwable, probeId, conversation);
        if (CommsServerServiceFacade.getJsAdminService() != null) {
            try {
                conversation.send((JFapByteBuffer)buffer, 11, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            }
            catch (SIException c) {
                FFDCFilter.processException((Throwable)c, (String)(CLASS_NAME + ".sendExceptionToClient"), (String)"3-012-0001");
                SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2023", (Object)((Object)c));
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"conversation send is not being called as jmsadminService is null");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendExceptionToClient");
        }
    }

    public static void sendAsyncExceptionToClient(Throwable throwable, String probeId, short clientSessionId, Conversation conversation, int requestNumber) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAsyncExceptionToClient", (Object)new Object[]{throwable, probeId, "" + clientSessionId, conversation, "" + requestNumber});
        }
        CommsByteBuffer buffer = poolManager.allocate();
        buffer.putShort(0);
        buffer.putShort((short)4);
        buffer.putShort(clientSessionId);
        buffer.putException(throwable, probeId, conversation);
        try {
            conversation.send((JFapByteBuffer)buffer, 225, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
        }
        catch (SIException c) {
            FFDCFilter.processException((Throwable)c, (String)(CLASS_NAME + ".sendAsyncExceptionToClient"), (String)"3-012-0002");
            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2023", (Object)((Object)c));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAsyncExceptionToClient");
        }
    }

    public static void sendSessionCreateResponse(int segmentType, int requestNumber, Conversation conversation, short sessionId, DestinationSession session, SIDestinationAddress originalDestinationAddr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendSessionCreateResponse");
        }
        CommsByteBuffer buffer = poolManager.allocate();
        if (segmentType == 231 || segmentType == 205) {
            long id;
            block12: {
                id = 0L;
                try {
                    id = ((ConsumerSession)session).getId();
                }
                catch (SIException e) {
                    if (!((ConversationState)conversation.getAttachment()).hasMETerminated()) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendSessionCreateResponse"), (String)"3-012-0004");
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block12;
                    SibTr.debug((TraceComponent)tc, (String)"Unable to get session id", (Object)((Object)e));
                }
            }
            buffer.putLong(id);
        }
        if (segmentType == 205) {
            buffer.putShort((short)8);
        }
        buffer.putShort(sessionId);
        JsDestinationAddress destAddress = (JsDestinationAddress)session.getDestinationAddress();
        if (originalDestinationAddr == null || !originalDestinationAddr.toString().equals(destAddress.toString())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Destination address is different: Orig, New", (Object)new Object[]{originalDestinationAddr, destAddress});
            }
            buffer.putSIDestinationAddress((SIDestinationAddress)destAddress, conversation.getHandshakeProperties().getFapLevel());
        }
        try {
            conversation.send((JFapByteBuffer)buffer, segmentType, requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendSessionCreateResponse"), (String)"3-012-0003");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2023", (Object)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendSessionCreateResponse");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/StaticCATHelper.java, SIB.comms, WASX.SIB, aa1225.01 1.62");
        }
    }
}

