/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.registry.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.SearchResult;
import com.ibm.ws.security.wim.registry.dataobject.IDAndRealm;
import com.ibm.ws.security.wim.registry.util.BridgeUtils;
import com.ibm.ws.security.wim.registry.util.TypeMappings;
import com.ibm.wsspi.security.wim.exception.EntityNotFoundException;
import com.ibm.wsspi.security.wim.exception.InvalidIdentifierException;
import com.ibm.wsspi.security.wim.exception.InvalidUniqueNameException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Context;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.ExternalNameControl;
import com.ibm.wsspi.security.wim.model.Group;
import com.ibm.wsspi.security.wim.model.GroupMemberControl;
import com.ibm.wsspi.security.wim.model.GroupMembershipControl;
import com.ibm.wsspi.security.wim.model.IdentifierType;
import com.ibm.wsspi.security.wim.model.LoginAccount;
import com.ibm.wsspi.security.wim.model.Root;
import com.ibm.wsspi.security.wim.model.SearchControl;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MembershipBridge {
    private static final TraceComponent tc = Tr.register(MembershipBridge.class, (String)"registyUtil", (String)"com.ibm.ws.security.wim.registry.util.resources.RegistryUtilMessages");
    private TypeMappings propertyMap = null;
    private BridgeUtils mappingUtils = null;
    static final long serialVersionUID = -6409220961095031717L;

    public MembershipBridge(BridgeUtils mappingUtil) {
        this.mappingUtils = mappingUtil;
        this.propertyMap = new TypeMappings(mappingUtil);
    }

    @FFDCIgnore(value={WIMException.class})
    public List<String> getGroupsForUser(String inputUserSecurityName) throws EntryNotFoundException, RegistryException {
        String methodName = "getGroupsForUser";
        ArrayList<String> returnValue = new ArrayList<String>();
        try {
            Root resultRoot;
            boolean allowDNAsPrincipalName;
            String outputAttrName;
            String inputAttrName;
            String id;
            String quote;
            Root root;
            IDAndRealm idAndRealm;
            block24: {
                List contexts;
                this.mappingUtils.validateId(inputUserSecurityName);
                idAndRealm = this.mappingUtils.separateIDAndRealm(inputUserSecurityName);
                root = this.mappingUtils.getWimService().createRootObject();
                if (idAndRealm.isRealmDefined()) {
                    this.mappingUtils.createRealmDataObject(root, idAndRealm.getRealm());
                }
                quote = "'";
                id = idAndRealm.getId();
                if (id.indexOf("'") != -1) {
                    quote = "\"";
                }
                inputAttrName = this.propertyMap.getInputUserSecurityName(idAndRealm.getRealm());
                inputAttrName = this.mappingUtils.getRealInputAttrName(inputAttrName, id, true);
                outputAttrName = this.propertyMap.getOutputGroupSecurityName(idAndRealm.getRealm());
                allowDNAsPrincipalName = this.mappingUtils.allowDNAsPrincipalName;
                if (allowDNAsPrincipalName && (contexts = root.getContexts()) != null) {
                    Context ctx = new Context();
                    ctx.setKey("allowDNPrincipalNameAsLiteral");
                    ctx.setValue((Object)allowDNAsPrincipalName);
                    contexts.add(ctx);
                }
                resultRoot = null;
                try {
                    resultRoot = this.mappingUtils.getEntityByIdentifier(root, inputAttrName, id, outputAttrName, this.mappingUtils);
                }
                catch (WIMException e) {
                    if (allowDNAsPrincipalName) break block24;
                    throw e;
                }
            }
            if (resultRoot != null) {
                root = resultRoot;
            } else {
                if (allowDNAsPrincipalName) {
                    inputAttrName = "principalName";
                }
                List controls = root.getControls();
                SearchControl srchCtrl = new SearchControl();
                if (controls != null) {
                    controls.add(srchCtrl);
                }
                srchCtrl.setExpression("//entities[@xsi:type='LoginAccount' and " + inputAttrName + "=" + quote + id + quote + "]");
                Context context = new Context();
                context.set("key", (Object)"useUserFilterForSearch");
                context.set("value", (Object)id);
                root.getContexts().add(context);
                root = this.mappingUtils.getWimService().search(root);
            }
            List returnList = root.getEntities();
            if (returnList.isEmpty()) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputUserSecurityName)));
            }
            if (returnList.size() != 1) {
                throw new EntityNotFoundException("MULTIPLE_PRINCIPALS_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"MULTIPLE_PRINCIPALS_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputUserSecurityName)));
            }
            Entity user = (Entity)returnList.get(0);
            idAndRealm.setId(user.getIdentifier().getUniqueName());
            root = this.mappingUtils.getWimService().createRootObject();
            if (idAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(root, idAndRealm.getRealm());
            }
            List controls = root.getControls();
            GroupMembershipControl grpMbrShipCtrl = new GroupMembershipControl();
            if (controls != null) {
                controls.add(grpMbrShipCtrl);
            }
            if (!this.mappingUtils.isIdentifierTypeProperty(outputAttrName)) {
                grpMbrShipCtrl.getProperties().add(outputAttrName);
            }
            grpMbrShipCtrl.setLevel((int)this.mappingUtils.getGroupDepth());
            grpMbrShipCtrl.setExpression("@xsi:type='Group'");
            List entities = root.getEntities();
            LoginAccount loginAccount = new LoginAccount();
            if (entities != null) {
                entities.add(loginAccount);
            }
            IdentifierType idfType = new IdentifierType();
            idfType.setUniqueName(idAndRealm.getId());
            loginAccount.setIdentifier(idfType);
            root = this.mappingUtils.getWimService().get(root);
            List entityList = root.getEntities();
            if (entityList.isEmpty()) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputUserSecurityName)));
            }
            Entity entity = (Entity)entityList.get(0);
            List groupList = entity.getGroups();
            if (!groupList.isEmpty()) {
                String grpAttrName = outputAttrName;
                boolean isIdentifier = this.mappingUtils.isIdentifierTypeProperty(grpAttrName);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " grpAttrName=" + grpAttrName + ", isIdentifier=" + isIdentifier), (Object[])new Object[]{methodName});
                }
                for (int i = 0; i < groupList.size(); ++i) {
                    Group member = (Group)groupList.get(i);
                    Object groups = !isIdentifier ? member.get(grpAttrName) : member.getIdentifier().get(grpAttrName);
                    if (groups instanceof String) {
                        returnValue.add((String)groups);
                        continue;
                    }
                    if (!(groups instanceof List)) continue;
                    returnValue.addAll((List)groups);
                }
            }
        }
        catch (WIMException toCatch) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)toCatch.getMessage(), (Object[])new Object[]{toCatch});
            }
            if (toCatch instanceof EntityNotFoundException || toCatch instanceof InvalidIdentifierException) {
                throw new EntryNotFoundException(toCatch.getMessage(), (Throwable)toCatch);
            }
            throw new RegistryException(toCatch.getMessage(), (Throwable)toCatch);
        }
        return returnValue;
    }

    @FFDCIgnore(value={WIMException.class})
    public SearchResult getUsersForGroup(String inputGroupSecurityName, int inputLimit) throws EntryNotFoundException, RegistryException {
        String methodName = "getUsersForGroup";
        SearchResult returnValue = null;
        try {
            String outputAttrName;
            this.mappingUtils.validateId(inputGroupSecurityName);
            this.mappingUtils.validateLimit(inputLimit);
            IDAndRealm idAndRealm = this.mappingUtils.separateIDAndRealm(inputGroupSecurityName);
            Root root = this.mappingUtils.getWimService().createRootObject();
            if (idAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(root, idAndRealm.getRealm());
            }
            String quote = "'";
            String id = idAndRealm.getId();
            if (id.indexOf("'") != -1) {
                quote = "\"";
            }
            String inputAttrName = this.propertyMap.getInputGroupSecurityName(idAndRealm.getRealm());
            Root resultRoot = this.mappingUtils.getEntityByIdentifier(root, inputAttrName = this.mappingUtils.getRealInputAttrName(inputAttrName, id, false), id, outputAttrName = "uniqueName", this.mappingUtils);
            if (resultRoot != null) {
                root = resultRoot;
            } else {
                List controls = root.getControls();
                SearchControl srchCtrl = new SearchControl();
                if (controls != null) {
                    controls.add(srchCtrl);
                }
                srchCtrl.setExpression("//entities[@xsi:type='Group' and " + inputAttrName + "=" + quote + id + quote + "]");
                Context context = new Context();
                context.set("key", (Object)"useGroupFilterForSearch");
                context.set("value", (Object)id);
                root.getContexts().add(context);
                root = this.mappingUtils.getWimService().search(root);
            }
            List returnList = root.getEntities();
            if (returnList.isEmpty()) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputGroupSecurityName)));
            }
            if (returnList.size() != 1) {
                throw new EntityNotFoundException("MULTIPLE_PRINCIPALS_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"MULTIPLE_PRINCIPALS_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputGroupSecurityName)));
            }
            Entity group = (Entity)returnList.get(0);
            idAndRealm.setId(group.getIdentifier().getUniqueName());
            root = this.mappingUtils.getWimService().createRootObject();
            if (idAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(root, idAndRealm.getRealm());
            }
            List controls = root.getControls();
            GroupMemberControl groupMemberControl = new GroupMemberControl();
            if (controls != null) {
                controls.add(groupMemberControl);
            }
            groupMemberControl.setLevel((int)this.mappingUtils.getGroupDepth());
            String outputUserSecurityNameAttr = this.propertyMap.getOutputUserSecurityName(idAndRealm.getRealm());
            if (!this.mappingUtils.isIdentifierTypeProperty(outputUserSecurityNameAttr)) {
                groupMemberControl.getProperties().add(outputUserSecurityNameAttr);
            }
            if (inputLimit != 0) {
                groupMemberControl.setCountLimit(inputLimit + 1);
            } else {
                groupMemberControl.setCountLimit(inputLimit);
            }
            groupMemberControl.setExpression("@xsi:type='LoginAccount'");
            List entities = root.getEntities();
            Group group2 = new Group();
            if (entities != null) {
                entities.add(group2);
            }
            IdentifierType idfType = new IdentifierType();
            idfType.setUniqueName(idAndRealm.getId());
            group2.setIdentifier(idfType);
            root = this.mappingUtils.getWimService().get(root);
            List entityList = root.getEntities();
            if (entityList.isEmpty()) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputGroupSecurityName)));
            }
            if (entityList.get(0) instanceof Group) {
                Group entity = (Group)entityList.get(0);
                List memberList = entity.getMembers();
                if (!memberList.isEmpty()) {
                    String userAttrName = outputUserSecurityNameAttr;
                    boolean isIdentifier = this.mappingUtils.isIdentifierTypeProperty(userAttrName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " userAttrName=" + userAttrName + ", isIdentifier=" + isIdentifier), (Object[])new Object[]{methodName});
                    }
                    ArrayList<String> users = new ArrayList<String>();
                    for (int count = 0; count < memberList.size() && (inputLimit == 0 || count != inputLimit); ++count) {
                        Entity member = (Entity)memberList.get(count);
                        if (!isIdentifier) {
                            users.add((String)member.get(userAttrName));
                            continue;
                        }
                        users.add((String)member.getIdentifier().get(userAttrName));
                    }
                    returnValue = new SearchResult(users, true);
                } else {
                    returnValue = new SearchResult(new ArrayList(), false);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No users will be returned because the entity was not of type \"Group\".", (Object[])new Object[]{entityList.get(0)});
            }
        }
        catch (WIMException toCatch) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)toCatch.getMessage(), (Object[])new Object[]{toCatch});
            }
            if (toCatch instanceof EntityNotFoundException || toCatch instanceof InvalidIdentifierException) {
                throw new EntryNotFoundException(toCatch.getMessage(), (Throwable)toCatch);
            }
            throw new RegistryException(toCatch.getMessage(), (Throwable)toCatch);
        }
        return returnValue;
    }

    @FFDCIgnore(value={WIMException.class, InvalidNameException.class})
    public List<String> getUniqueGroupIds(String inputUniqueUserId) throws EntryNotFoundException, RegistryException {
        ArrayList<String> returnValue;
        block34: {
            String methodName = "getUniqueGroupIds";
            returnValue = new ArrayList<String>();
            try {
                List controls;
                Root resultRoot;
                boolean allowDNAsPrincipalName;
                String outputAttrName;
                String inputAttrName;
                String id;
                String quote;
                Root root;
                IDAndRealm idAndRealm;
                block33: {
                    List contexts;
                    this.mappingUtils.validateId(inputUniqueUserId);
                    idAndRealm = this.mappingUtils.separateIDAndRealm(inputUniqueUserId);
                    root = this.mappingUtils.getWimService().createRootObject();
                    if (idAndRealm.isRealmDefined()) {
                        this.mappingUtils.createRealmDataObject(root, idAndRealm.getRealm());
                        List contexts2 = root.getContexts();
                        if (contexts2 != null) {
                            Context ctx = new Context();
                            ctx.setKey("allowOperationIfReposDown");
                            ctx.setValue((Object)this.mappingUtils.getCoreConfiguration().isAllowOpIfRepoDown(idAndRealm.getRealm()));
                            contexts2.add(ctx);
                        }
                    }
                    quote = "'";
                    id = idAndRealm.getId();
                    if (id.indexOf("'") != -1) {
                        quote = "\"";
                    }
                    inputAttrName = this.propertyMap.getInputUniqueUserId(idAndRealm.getRealm());
                    inputAttrName = this.mappingUtils.getRealInputAttrName(inputAttrName, id, true);
                    outputAttrName = this.propertyMap.getOutputUniqueGroupId(idAndRealm.getRealm());
                    allowDNAsPrincipalName = this.mappingUtils.allowDNAsPrincipalName;
                    if (allowDNAsPrincipalName && (contexts = root.getContexts()) != null) {
                        Context ctx = new Context();
                        ctx.setKey("allowDNPrincipalNameAsLiteral");
                        ctx.setValue((Object)allowDNAsPrincipalName);
                        contexts.add(ctx);
                    }
                    resultRoot = null;
                    try {
                        resultRoot = this.mappingUtils.getEntityByIdentifier(root, inputAttrName, id, outputAttrName, this.mappingUtils);
                    }
                    catch (WIMException e) {
                        if (allowDNAsPrincipalName) break block33;
                        throw e;
                    }
                }
                if (resultRoot != null) {
                    root = resultRoot;
                } else {
                    List contexts;
                    controls = root.getControls();
                    SearchControl searchControl = new SearchControl();
                    if (controls != null) {
                        controls.add(searchControl);
                    }
                    if ((contexts = root.getContexts()) != null) {
                        Context ctx = new Context();
                        ctx.setKey("allowOperationIfReposDown");
                        ctx.setValue((Object)this.mappingUtils.getCoreConfiguration().isAllowOpIfRepoDown(idAndRealm.getRealm()));
                        contexts.add(ctx);
                    }
                    String inputAttrNameMod = inputAttrName;
                    if (allowDNAsPrincipalName) {
                        inputAttrNameMod = "principalName";
                    }
                    searchControl.setExpression("//entities[@xsi:type='LoginAccount' and " + inputAttrNameMod + "=" + quote + id + quote + "]");
                    Context context = new Context();
                    context.set("key", (Object)"useUserFilterForSearch");
                    context.set("value", (Object)id);
                    root.getContexts().add(context);
                    root = this.mappingUtils.getWimService().search(root);
                    List returnList = root.getEntities();
                    if (returnList.isEmpty()) {
                        throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputUniqueUserId)));
                    }
                    if (returnList.size() != 1) {
                        throw new EntityNotFoundException("MULTIPLE_PRINCIPALS_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"MULTIPLE_PRINCIPALS_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputUniqueUserId)));
                    }
                    Entity user = (Entity)returnList.get(0);
                    idAndRealm.setId(user.getIdentifier().getUniqueName());
                }
                root = this.mappingUtils.getWimService().createRootObject();
                if (idAndRealm.isRealmDefined()) {
                    this.mappingUtils.createRealmDataObject(root, idAndRealm.getRealm());
                    List contexts = root.getContexts();
                    if (contexts != null) {
                        Context ctx = new Context();
                        ctx.setKey("allowOperationIfReposDown");
                        ctx.setValue((Object)this.mappingUtils.getCoreConfiguration().isAllowOpIfRepoDown(idAndRealm.getRealm()));
                        contexts.add(ctx);
                    }
                }
                controls = root.getControls();
                GroupMembershipControl groupMembershipControl = new GroupMembershipControl();
                if (controls != null) {
                    controls.add(groupMembershipControl);
                }
                if (!this.mappingUtils.isIdentifierTypeProperty(outputAttrName)) {
                    groupMembershipControl.getProperties().add(outputAttrName);
                }
                groupMembershipControl.setLevel((int)this.mappingUtils.getGroupDepth());
                groupMembershipControl.setExpression("@xsi:type='Group'");
                List entities = root.getEntities();
                LoginAccount loginAccount = new LoginAccount();
                if (entities != null) {
                    entities.add(loginAccount);
                }
                IdentifierType actIdfType = new IdentifierType();
                inputAttrName = this.propertyMap.getInputUniqueUserId(idAndRealm.getRealm());
                if (!this.mappingUtils.isIdentifierTypeProperty(inputAttrName)) {
                    actIdfType.setUniqueName(idAndRealm.getId());
                    loginAccount.setIdentifier(actIdfType);
                } else {
                    List extCtrls;
                    actIdfType.set(inputAttrName, (Object)idAndRealm.getId());
                    loginAccount.setIdentifier(actIdfType);
                    if (inputAttrName.equals("externalName") && (extCtrls = root.getControls()) != null) {
                        extCtrls.add(new ExternalNameControl());
                    }
                }
                root = this.mappingUtils.getWimService().get(root);
                List entityList = root.getEntities();
                if (entityList.isEmpty()) {
                    throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputUniqueUserId)));
                }
                Entity entity = (Entity)entityList.get(0);
                List groupList = entity.getGroups();
                if (groupList.isEmpty()) break block34;
                String grpAttrName = outputAttrName;
                boolean isIdentifier = this.mappingUtils.isIdentifierTypeProperty(grpAttrName);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " grpAttrName=" + grpAttrName + ", isIdentifier=" + isIdentifier), (Object[])new Object[]{methodName});
                }
                for (int i = 0; i < groupList.size(); ++i) {
                    String value;
                    block35: {
                        Group member = (Group)groupList.get(i);
                        value = null;
                        value = !isIdentifier ? (String)member.get(grpAttrName) : (String)member.getIdentifier().get(grpAttrName);
                        if ("uniqueName".equalsIgnoreCase(grpAttrName)) {
                            try {
                                new LdapName(String.valueOf(value));
                            }
                            catch (InvalidNameException e) {
                                String uid = member.getIdentifier().getUniqueId();
                                if (uid == null) break block35;
                                value = uid;
                            }
                        }
                    }
                    returnValue.add(value);
                }
            }
            catch (WIMException toCatch) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " " + toCatch.getMessage()), (Object[])new Object[]{toCatch});
                }
                if (toCatch instanceof EntityNotFoundException) {
                    throw new EntryNotFoundException(toCatch.getMessage(), (Throwable)toCatch);
                }
                if (toCatch instanceof InvalidUniqueNameException) {
                    throw new EntryNotFoundException(toCatch.getMessage(), (Throwable)toCatch);
                }
                if (toCatch instanceof InvalidIdentifierException) {
                    throw new EntryNotFoundException(toCatch.getMessage(), (Throwable)toCatch);
                }
                throw new RegistryException(toCatch.getMessage(), (Throwable)toCatch);
            }
        }
        return returnValue;
    }
}

