/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.extended;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwtsso.token.proxy.JwtSSOTokenHelper;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.ws.webcontainer.security.SSOCookieHelperImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.internal.StringUtil;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServer;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.util.ArrayList;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SSOCookieHelperImplExtended
extends SSOCookieHelperImpl {
    private static final TraceComponent tc = Tr.register(SSOCookieHelperImplExtended.class, null, null);
    private static final String OIDC_BROWSER_STATE_COOKIE = "oidc_bsc";
    private final AtomicServiceReference<OidcServer> oidcServerRef;
    static final long serialVersionUID = 8632033790336810115L;

    public SSOCookieHelperImplExtended(WebAppSecurityConfig config, String ssoCookieName) {
        this(config, ssoCookieName, (AtomicServiceReference<OidcServer>)((AtomicServiceReference)null));
    }

    public SSOCookieHelperImplExtended(WebAppSecurityConfig config) {
        this(config, null, (AtomicServiceReference<OidcServer>)((AtomicServiceReference)null));
    }

    public SSOCookieHelperImplExtended(WebAppSecurityConfig config, AtomicServiceReference<OidcServer> oidcServerRef) {
        this(config, null, oidcServerRef);
    }

    private SSOCookieHelperImplExtended(WebAppSecurityConfig config, String ssoCookieName, AtomicServiceReference<OidcServer> oidcServerRef) {
        super(config, ssoCookieName);
        this.oidcServerRef = oidcServerRef;
    }

    public void addSSOCookiesToResponse(Subject subject, HttpServletRequest req, HttpServletResponse resp) {
        if (!this.allowToAddCookieToResponse(req)) {
            return;
        }
        this.addJwtSsoCookiesToResponse(subject, req, resp);
        if (!JwtSSOTokenHelper.shouldAlsoIncludeLtpaCookie()) {
            return;
        }
        SingleSignonToken ssoToken = this.getDefaultSSOTokenFromSubject(subject);
        if (ssoToken == null) {
            return;
        }
        byte[] ssoTokenBytes = ssoToken.getBytes();
        if (ssoTokenBytes == null) {
            return;
        }
        ByteArray cookieBytes = new ByteArray(ssoTokenBytes);
        String cookieByteString = (String)cookieByteStringCache.get(cookieBytes);
        if (cookieByteString == null) {
            cookieByteString = StringUtil.toString((byte[])Base64Coder.base64Encode((byte[])ssoTokenBytes));
            this.updateCookieCache(cookieBytes, cookieByteString);
        }
        Cookie ssoCookie = this.createCookie(req, cookieByteString);
        resp.addCookie(ssoCookie);
        if (this.oidcServerRef != null && this.oidcServerRef.getService() != null && this.isBrowserStateEnabled(req)) {
            this.removeBrowserStateCookie(req, resp);
        }
    }

    public void createLogoutCookies(HttpServletRequest req, HttpServletResponse res) {
        Cookie[] cookies = req.getCookies();
        ArrayList logoutCookieList = new ArrayList();
        if (cookies != null) {
            String ssoCookieName = this.resolveCookieName(cookies);
            for (int i = 0; i < cookies.length; ++i) {
                if (cookies[i].getName().equalsIgnoreCase(ssoCookieName)) {
                    cookies[i].setValue(null);
                    this.addLogoutCookieToList(req, ssoCookieName, logoutCookieList);
                    continue;
                }
                if (!cookies[i].getName().equalsIgnoreCase(OIDC_BROWSER_STATE_COOKIE) || this.oidcServerRef == null || this.oidcServerRef.getService() == null) continue;
                this.removeBrowserStateCookie(req, res);
            }
            this.logoutJwtCookies(req, cookies, logoutCookieList);
            for (Cookie cookie : logoutCookieList) {
                res.addCookie(cookie);
            }
        }
    }

    protected boolean isBrowserStateEnabled(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equalsIgnoreCase(OIDC_BROWSER_STATE_COOKIE)) continue;
                return true;
            }
        }
        return false;
    }

    protected void removeBrowserStateCookie(HttpServletRequest req, HttpServletResponse res) {
        Cookie c = new Cookie(OIDC_BROWSER_STATE_COOKIE, "");
        c.setMaxAge(0);
        c.setPath("/");
        c.setSecure(req.isSecure());
        res.addCookie(c);
    }
}

