/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.internal.extended;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.UnauthenticatedSubjectService;
import com.ibm.ws.security.authentication.tai.TAIService;
import com.ibm.ws.security.collaborator.CollaboratorUtils;
import com.ibm.ws.webcontainer.security.AuthenticateApi;
import com.ibm.ws.webcontainer.security.PostParameterHelper;
import com.ibm.ws.webcontainer.security.SSOCookieHelper;
import com.ibm.ws.webcontainer.security.UnprotectedResourceService;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.WebAuthenticator;
import com.ibm.ws.webcontainer.security.WebAuthenticatorFactory;
import com.ibm.ws.webcontainer.security.WebAuthenticatorProxy;
import com.ibm.ws.webcontainer.security.WebProviderAuthenticatorProxy;
import com.ibm.ws.webcontainer.security.WebRequest;
import com.ibm.ws.webcontainer.security.extended.AuthenticateApiExtended;
import com.ibm.ws.webcontainer.security.extended.WebAppSecurityConfigExtended;
import com.ibm.ws.webcontainer.security.extended.WebAuthenticatorFactoryExtended;
import com.ibm.ws.webcontainer.security.extended.WebAuthenticatorProxyExtended;
import com.ibm.ws.webcontainer.security.extended.WebProviderAuthenticatorProxyExtended;
import com.ibm.ws.webcontainer.security.internal.WebSecurityHelperImpl;
import com.ibm.ws.webcontainer.security.internal.extended.WebAppSecurityConfigImplExtended;
import com.ibm.ws.webcontainer.security.oauth20.OAuth20Service;
import com.ibm.ws.webcontainer.security.openid20.OpenidClientService;
import com.ibm.ws.webcontainer.security.openidconnect.OidcClient;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServer;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={WebAuthenticatorFactory.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "service.ranking:Integer=100"})
public class WebAuthenticatorFactoryImplExtended
implements WebAuthenticatorFactoryExtended {
    static final String KEY_OAUTH_SERVICE = "oauthService";
    static final String KEY_OIDC_SERVER = "oidcServer";
    static final String KEY_OIDC_CLIENT = "oidcClient";
    static final String KEY_OPENID_CLIENT_SERVICE = "openidClientService";
    protected final AtomicServiceReference<OAuth20Service> oauthServiceRef = new AtomicServiceReference("oauthService");
    protected final AtomicServiceReference<OidcServer> oidcServerRef = new AtomicServiceReference("oidcServer");
    protected final AtomicServiceReference<OidcClient> oidcClientRef = new AtomicServiceReference("oidcClient");
    protected final AtomicServiceReference<OpenidClientService> openidClientRef = new AtomicServiceReference("openidClientService");
    protected WebAppSecurityConfig globalConfig = null;
    protected WebProviderAuthenticatorProxy providerAuthenticatorProxy = null;
    protected WebAuthenticatorProxy authenticatorProxy = null;
    static final long serialVersionUID = -1020248561288509913L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public WebAppSecurityConfig createWebAppSecurityConfigImpl(Map<String, Object> props, AtomicServiceReference<WsLocationAdmin> locationAdminRef, AtomicServiceReference<SecurityService> securityServiceRef) {
        this.globalConfig = new WebAppSecurityConfigImplExtended(props, locationAdminRef, securityServiceRef, this.oidcServerRef, this.oidcClientRef);
        return this.globalConfig;
    }

    public AuthenticateApi createAuthenticateApi(SSOCookieHelper ssoCookieHelper, AtomicServiceReference<SecurityService> securityServiceRef, CollaboratorUtils collabUtils, ConcurrentServiceReferenceMap<String, WebAuthenticator> webAuthenticatorRef, ConcurrentServiceReferenceMap<String, UnprotectedResourceService> unprotectedResourceServiceRef, UnauthenticatedSubjectService unauthSubjectService) {
        return new AuthenticateApiExtended(ssoCookieHelper, securityServiceRef, collabUtils, webAuthenticatorRef, unprotectedResourceServiceRef, unauthSubjectService);
    }

    public WebProviderAuthenticatorProxy createWebProviderAuthenticatorProxy(AtomicServiceReference<SecurityService> securityServiceRef, AtomicServiceReference<TAIService> taiServiceRef, ConcurrentServiceReferenceMap<String, TrustAssociationInterceptor> interceptorServiceRef, WebAppSecurityConfig webAppSecConfig, ConcurrentServiceReferenceMap<String, WebAuthenticator> webAuthenticatorRef) {
        this.providerAuthenticatorProxy = new WebProviderAuthenticatorProxyExtended(securityServiceRef, taiServiceRef, interceptorServiceRef, webAppSecConfig, this.oauthServiceRef, this.openidClientRef, this.oidcServerRef, this.oidcClientRef, webAuthenticatorRef);
        return this.providerAuthenticatorProxy;
    }

    public WebAuthenticatorProxy createWebAuthenticatorProxy(WebAppSecurityConfig webAppSecConfig, PostParameterHelper postParameterHelper, AtomicServiceReference<SecurityService> securityServiceRef, WebProviderAuthenticatorProxy providerAuthenticatorProxy) {
        this.authenticatorProxy = new WebAuthenticatorProxyExtended(webAppSecConfig, postParameterHelper, securityServiceRef, providerAuthenticatorProxy, this.oidcServerRef);
        return this.authenticatorProxy;
    }

    public Boolean needToAuthenticateSubject(WebRequest webRequest) {
        OidcServer oidcServer;
        OAuth20Service oauthService;
        HttpServletRequest req = webRequest.getHttpServletRequest();
        if (this.isProviderSpecialProtectedURI(req, oauthService = (OAuth20Service)this.oauthServiceRef.getService(), oidcServer = (OidcServer)this.oidcServerRef.getService(), false)) {
            if (this.isProviderSpecialProtectedURI(req, oauthService, oidcServer, true)) {
                webRequest.setProviderSpecialUnprotectedURI(true);
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public WebProviderAuthenticatorProxy getWebProviderAuthenticatorProxy() {
        return this.providerAuthenticatorProxy;
    }

    @Override
    public WebAuthenticatorProxy getWebAuthenticatorProxy() {
        return this.authenticatorProxy;
    }

    private boolean isProviderSpecialProtectedURI(HttpServletRequest req, OAuth20Service oauthService, OidcServer oidcServer, boolean protectedUri) {
        if (oidcServer != null && oidcServer.isOIDCSpecificURI(req, protectedUri)) {
            return true;
        }
        return oauthService != null && oauthService.isOauthSpecificURI(req, protectedUri);
    }

    @Reference(name="oauthService", service=OAuth20Service.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setOauthService(ServiceReference<OAuth20Service> reference) {
        this.oauthServiceRef.setReference(reference);
    }

    protected void unsetOauthService(ServiceReference<OAuth20Service> reference) {
        this.oauthServiceRef.unsetReference(reference);
    }

    @Reference(name="oidcServer", service=OidcServer.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setOidcServer(ServiceReference<OidcServer> reference) {
        this.oidcServerRef.setReference(reference);
        WebAppSecurityConfig webAppSecConfig = WebSecurityHelperImpl.getWebAppSecurityConfig();
        if (webAppSecConfig != null && webAppSecConfig instanceof WebAppSecurityConfigExtended) {
            ((WebAppSecurityConfigExtended)webAppSecConfig).setSsoCookieName(this.oidcServerRef, this.oidcClientRef);
        }
    }

    protected void unsetOidcServer(ServiceReference<OidcServer> reference) {
        this.oidcServerRef.unsetReference(reference);
    }

    @Reference(name="oidcClient", service=OidcClient.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setOidcClient(ServiceReference<OidcClient> reference) {
        this.oidcClientRef.setReference(reference);
        WebAppSecurityConfig webAppSecConfig = WebSecurityHelperImpl.getWebAppSecurityConfig();
        if (webAppSecConfig != null && webAppSecConfig instanceof WebAppSecurityConfigExtended) {
            ((WebAppSecurityConfigExtended)webAppSecConfig).setSsoCookieName(this.oidcServerRef, this.oidcClientRef);
        }
    }

    protected void unsetOidcClient(ServiceReference<OidcClient> reference) {
        this.oidcClientRef.unsetReference(reference);
    }

    @Reference(name="openidClientService", service=OpenidClientService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setOpenidClientService(ServiceReference<OpenidClientService> reference) {
        this.openidClientRef.setReference(reference);
    }

    protected void unsetOpenidClientService(ServiceReference<OpenidClientService> reference) {
        this.openidClientRef.unsetReference(reference);
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> props) {
        this.oauthServiceRef.activate(cc);
        this.oidcServerRef.activate(cc);
        this.oidcClientRef.activate(cc);
        this.openidClientRef.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.oauthServiceRef.deactivate(cc);
        this.oidcServerRef.deactivate(cc);
        this.oidcClientRef.deactivate(cc);
        this.openidClientRef.deactivate(cc);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.webcontainer.security.internal.extended.WebAuthenticatorFactoryImplExtended", WebAuthenticatorFactoryImplExtended.class, null, null);
    }
}

