/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.tools;

import com.ibm.ws.jaxws.tools.internal.JaxWsToolsUtil;
import com.sun.tools.ws.wscompile.WsimportTool;
import java.io.File;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;

public class WsImport {
    private static final PrintStream err = System.err;

    public static void main(String[] args) {
        if (WsImport.isTargetRequired(args)) {
            String errMsg = JaxWsToolsUtil.formatMessage("error.parameter.target.missed");
            err.println(errMsg);
            System.exit(1);
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.setProperty("javax.xml.accessExternalSchema", "all");
                return null;
            }
        });
        if (WsImport.getMajorJavaVersion() > 8) {
            String classpathValue = null;
            Class<?> JAXB2 = null;
            Class<?> WebService = null;
            Class<?> Service2 = null;
            try {
                JAXB2 = Thread.currentThread().getContextClassLoader().loadClass("javax.xml.bind.JAXB");
                WebService = Thread.currentThread().getContextClassLoader().loadClass("javax.jws.WebService");
                Service2 = Thread.currentThread().getContextClassLoader().loadClass("javax.xml.ws.Service");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                System.exit(2);
            }
            classpathValue = WsImport.getJarFileOfClass(JAXB2);
            classpathValue = classpathValue + File.pathSeparator + WsImport.getJarFileOfClass(WebService);
            classpathValue = classpathValue + File.pathSeparator + WsImport.getJarFileOfClass(Service2);
            if (classpathValue != null) {
                boolean classpathSet = false;
                for (int i = 0; i < args.length; ++i) {
                    if (!args[i].equals("-cp") && !args[i].equals("-classpath")) continue;
                    args[i + 1] = args[i + 1] + File.pathSeparator + classpathValue;
                    classpathSet = true;
                }
                if (!classpathSet && args.length > 0) {
                    args = Arrays.copyOf(args, args.length + 2);
                    args[args.length - 1] = args[args.length - 3];
                    args[args.length - 2] = classpathValue;
                    args[args.length - 3] = "-classpath";
                }
            }
        }
        System.exit(new WsimportTool(System.out).run(args) ? 0 : 1);
    }

    private static boolean isTargetRequired(String[] args) {
        boolean helpExisted = false;
        boolean versionExisted = false;
        boolean targetExisted = false;
        for (String arg : args) {
            if (arg.equals("-help")) {
                helpExisted = true;
                continue;
            }
            if (arg.equals("-version")) {
                versionExisted = true;
                continue;
            }
            if (!arg.equals("-target")) continue;
            targetExisted = true;
        }
        return args.length > 0 && !helpExisted && !versionExisted && !targetExisted;
    }

    private static String getJarFileOfClass(final Class<?> javaClass) {
        ProtectionDomain protectionDomain = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return javaClass.getProtectionDomain();
            }
        });
        return protectionDomain.getCodeSource().getLocation().getPath();
    }

    private static int getMajorJavaVersion() {
        String version = System.getProperty("java.version");
        String[] versionElements = version.split("\\D");
        int i = Integer.valueOf(versionElements[0]) == 1 ? 1 : 0;
        return Integer.valueOf(versionElements[i]);
    }
}

