/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.internal.archive.liberty;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.internal.archive.AbstractCDIArchive;
import com.ibm.ws.cdi.internal.archive.liberty.ApplicationImpl;
import com.ibm.ws.cdi.internal.archive.liberty.ContainerInfoTypeUtils;
import com.ibm.ws.cdi.internal.archive.liberty.ResourceImpl;
import com.ibm.ws.cdi.internal.archive.liberty.RuntimeFactory;
import com.ibm.ws.cdi.internal.interfaces.Application;
import com.ibm.ws.cdi.internal.interfaces.ArchiveType;
import com.ibm.ws.cdi.internal.interfaces.CDIArchive;
import com.ibm.ws.cdi.internal.interfaces.CDIUtils;
import com.ibm.ws.cdi.internal.interfaces.Resource;
import com.ibm.ws.cdi.internal.interfaces.ResourceInjectionBag;
import com.ibm.ws.container.service.annotations.ContainerAnnotations;
import com.ibm.ws.container.service.app.deploy.ClientModuleInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.InjectionClassList;
import com.ibm.ws.container.service.app.deploy.ModuleClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ModuleContainerInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.injectionengine.osgi.util.OSGiJNDIEnvironmentRefBindingHelper;
import com.ibm.ws.javaee.dd.client.ApplicationClient;
import com.ibm.ws.javaee.dd.commonbnd.RefBindingsGroup;
import com.ibm.ws.javaee.dd.managedbean.ManagedBean;
import com.ibm.ws.javaee.dd.managedbean.ManagedBeanBnd;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.resource.ResourceRefConfigFactory;
import com.ibm.ws.resource.ResourceRefConfigList;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CDIArchiveImpl
extends AbstractCDIArchive
implements CDIArchive {
    private final ContainerInfo containerInfo;
    private final RuntimeFactory factory;
    private final ArchiveType type;
    private final ClassLoader classLoader;
    private final ApplicationImpl application;
    private Set<String> classNames;
    private List<String> jeeComponentClassNames;
    private ExtendedModuleInfo moduleInfo;
    private String appCallbackHandlerName;
    private ResourceInjectionBag allBindings;
    private String path;
    private final Collection<CDIArchive> moduleLibraryArchives;
    static final long serialVersionUID = -6816745985351954756L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public CDIArchiveImpl(ApplicationImpl application, ContainerInfo containerInfo, ArchiveType archiveType, ClassLoader classLoader, RuntimeFactory factory) {
        super(containerInfo.getName(), factory.getServices());
        this.application = application;
        this.containerInfo = containerInfo;
        this.factory = factory;
        this.type = archiveType;
        this.classLoader = classLoader;
        this.moduleLibraryArchives = this.initModuleLibraryArchives();
    }

    @Override
    public J2EEName getJ2EEName() throws CDIException {
        J2EEName j2eeName = null;
        ModuleMetaData moduleMetaData = this.getModuleMetaData();
        if (moduleMetaData != null) {
            j2eeName = moduleMetaData.getJ2EEName();
        }
        return j2eeName;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Set<String> getClassNames() {
        if (this.classNames == null) {
            Container container = this.containerInfo.getContainer();
            if (this.type == ArchiveType.WEB_MODULE) {
                container = this.getSubContainer(container, "WEB-INF/classes/");
            }
            this.classNames = this.scanForAllClassNames(container, null);
        }
        return this.classNames;
    }

    @Trivial
    private Set<String> scanForAllClassNames(Container container, String packageName) {
        TreeSet<String> classNames = new TreeSet<String>();
        String entryPath = null;
        if (container != null) {
            for (Entry entry : container) {
                String entryName = entry.getName();
                entryPath = packageName == null ? entryName : packageName + "." + entryName;
                if (entryPath.endsWith(".class")) {
                    int classNameLength = entryPath.length() - CDIUtils.CLASS_EXT_LENGTH;
                    String className = entryPath.substring(0, classNameLength);
                    classNames.add(className);
                    continue;
                }
                Container entryContainer = this.getContainer(entry);
                if (entryContainer == null) continue;
                classNames.addAll(this.scanForAllClassNames(entryContainer, entryPath));
            }
        }
        return classNames;
    }

    private Container getSubContainer(Container container, String path) {
        Container subContainer = null;
        Entry startEntry = container.getEntry(path);
        if (startEntry != null) {
            subContainer = this.getContainer(startEntry);
        }
        return subContainer;
    }

    @Trivial
    private Container getContainer(Entry entry) {
        Container container = null;
        try {
            container = (Container)entry.adapt(Container.class);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.cdi.internal.archive.liberty.CDIArchiveImpl", (String)"166", (Object)this, (Object[])new Object[]{entry});
        }
        return container;
    }

    @Override
    public Resource getResource(String path) {
        Entry entry = this.getContainer().getEntry(path);
        ResourceImpl resource = entry == null ? null : new ResourceImpl(entry);
        return resource;
    }

    @Override
    public ArchiveType getType() {
        return this.type;
    }

    public ContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public RuntimeFactory getFactory() {
        return this.factory;
    }

    public Container getContainer() {
        return this.containerInfo.getContainer();
    }

    public ModuleMetaData getModuleMetaData() throws CDIException {
        ExtendedModuleInfo moduleInfo;
        ModuleMetaData moduleMetaData = null;
        if (this.isModule() && (moduleInfo = this.getModuleInfo()) != null) {
            moduleMetaData = moduleInfo.getMetaData();
        }
        return moduleMetaData;
    }

    /*
     * WARNING - void declaration
     */
    public ExtendedModuleInfo getModuleInfo() throws CDIException {
        if (this.moduleInfo == null && this.containerInfo instanceof ModuleContainerInfo) {
            try {
                ModuleContainerInfo ci = (ModuleContainerInfo)this.containerInfo;
                NonPersistentCache cache = (NonPersistentCache)ci.getContainer().adapt(NonPersistentCache.class);
                this.moduleInfo = (ExtendedModuleInfo)cache.getFromCache(ModuleInfo.class);
            }
            catch (UnableToAdaptException ci) {
                void e;
                FFDCFilter.processException((Throwable)ci, (String)"com.ibm.ws.cdi.internal.archive.liberty.CDIArchiveImpl", (String)"236", (Object)this, (Object[])new Object[0]);
                throw new CDIException((Throwable)e);
            }
        }
        return this.moduleInfo;
    }

    @Override
    public boolean isModule() {
        return this.containerInfo instanceof ModuleContainerInfo;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public String getClientModuleMainClass() throws CDIException {
        String mainClassName = null;
        ExtendedModuleInfo moduleInfo = this.getModuleInfo();
        if (moduleInfo != null && moduleInfo instanceof ClientModuleInfo) {
            ClientModuleInfo clientModuleInfo = (ClientModuleInfo)moduleInfo;
            mainClassName = clientModuleInfo.getMainClassName();
        }
        return mainClassName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getClientAppCallbackHandlerName() throws CDIException {
        ExtendedModuleInfo moduleInfo;
        if (this.appCallbackHandlerName == null && (moduleInfo = this.getModuleInfo()) != null && moduleInfo instanceof ClientModuleInfo) {
            try {
                ApplicationClient appClientXml = (ApplicationClient)this.getContainer().adapt(ApplicationClient.class);
                if (appClientXml != null) {
                    this.appCallbackHandlerName = appClientXml.getCallbackHandler();
                }
            }
            catch (UnableToAdaptException appClientXml) {
                void e;
                FFDCFilter.processException((Throwable)appClientXml, (String)"com.ibm.ws.cdi.internal.archive.liberty.CDIArchiveImpl", (String)"279", (Object)this, (Object[])new Object[0]);
                throw new CDIException((Throwable)e);
            }
        }
        return this.appCallbackHandlerName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> getInjectionClassList() throws CDIException {
        if (this.jeeComponentClassNames == null) {
            try {
                InjectionClassList injectionClassList = (InjectionClassList)this.getContainer().adapt(InjectionClassList.class);
                this.jeeComponentClassNames = injectionClassList.getClassNames();
            }
            catch (UnableToAdaptException injectionClassList) {
                void e;
                FFDCFilter.processException((Throwable)injectionClassList, (String)"com.ibm.ws.cdi.internal.archive.liberty.CDIArchiveImpl", (String)"296", (Object)this, (Object[])new Object[0]);
                throw new CDIException((Throwable)e);
            }
        }
        return this.jeeComponentClassNames;
    }

    @Override
    public MetaData getMetaData() throws CDIException {
        Object metaData = null;
        metaData = this.isModule() ? this.getModuleMetaData() : this.application.getApplicationMetaData();
        return metaData;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ResourceInjectionBag getAllBindings() throws CDIException {
        if (this.allBindings == null) {
            try {
                ManagedBeanBnd managedBeanBnd = (ManagedBeanBnd)this.getContainer().adapt(ManagedBeanBnd.class);
                if (managedBeanBnd != null) {
                    ResourceRefConfigFactory resourceRefConfigFactory = this.factory.getServices().getResourceRefConfigFactory();
                    this.allBindings = new ResourceInjectionBag(resourceRefConfigFactory.createResourceRefConfigList());
                    List mbs = managedBeanBnd.getManagedBeans();
                    if (mbs != null) {
                        for (ManagedBean mb : mbs) {
                            OSGiJNDIEnvironmentRefBindingHelper.processBndAndExt(this.allBindings.allBindings, this.allBindings.envEntryValues, (ResourceRefConfigList)this.allBindings.resourceRefConfigList, (RefBindingsGroup)mb, null);
                        }
                    }
                }
            }
            catch (UnableToAdaptException managedBeanBnd) {
                void e;
                FFDCFilter.processException((Throwable)managedBeanBnd, (String)"com.ibm.ws.cdi.internal.archive.liberty.CDIArchiveImpl", (String)"339", (Object)this, (Object[])new Object[0]);
                throw new CDIException((Throwable)e);
            }
        }
        return this.allBindings;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getPath() throws CDIException {
        if (this.path == null) {
            try {
                Entry entry = (Entry)this.getContainer().adapt(Entry.class);
                this.path = "";
                while (entry != null) {
                    this.path = entry.getPath() + this.path;
                    entry = (Entry)entry.getRoot().adapt(Entry.class);
                }
            }
            catch (UnableToAdaptException entry) {
                void e;
                FFDCFilter.processException((Throwable)entry, (String)"com.ibm.ws.cdi.internal.archive.liberty.CDIArchiveImpl", (String)"362", (Object)this, (Object[])new Object[0]);
                throw new CDIException((Throwable)e);
            }
        }
        return this.path;
    }

    @Override
    public Collection<CDIArchive> getModuleLibraryArchives() {
        return this.moduleLibraryArchives;
    }

    private Collection<CDIArchive> initModuleLibraryArchives() {
        HashMap<ContainerInfo, CDIArchive> moduleLibraryArchives = new HashMap<ContainerInfo, CDIArchive>();
        if (this.containerInfo instanceof ModuleClassesContainerInfo) {
            ModuleClassesContainerInfo moduleClassesContainerInfo = (ModuleClassesContainerInfo)this.containerInfo;
            List containerInfos = moduleClassesContainerInfo.getClassesContainerInfo();
            for (ContainerInfo child : containerInfos) {
                ContainerInfo.Type childType = child.getType();
                if (childType != ContainerInfo.Type.WEB_INF_LIB && childType != ContainerInfo.Type.MANIFEST_CLASSPATH && childType != ContainerInfo.Type.JAR_MODULE) continue;
                ArchiveType archiveType = ContainerInfoTypeUtils.getType(childType);
                CDIArchive childArchive = this.factory.newArchive(this.application, child, archiveType, this.classLoader);
                moduleLibraryArchives.put(child, childArchive);
            }
        }
        return moduleLibraryArchives.values();
    }

    @Override
    public Set<String> getAnnotatedClasses(Set<String> annotations) throws CDIException {
        HashSet<String> classNames = new HashSet<String>();
        Container container = this.getContainer();
        if (this.type == ArchiveType.WEB_MODULE) {
            container = this.getSubContainer(container, "WEB-INF/classes/");
        }
        if (container != null) {
            Set<String> annotatedClasses = this.getClassesWithSpecifiedInheritedAnnotations(container, annotations);
            classNames.addAll(annotatedClasses);
        }
        return classNames;
    }

    /*
     * WARNING - void declaration
     */
    private Set<String> getClassesWithSpecifiedInheritedAnnotations(Container container, Set<String> annotations) throws CDIException {
        ContainerAnnotations containerAnnotations;
        try {
            containerAnnotations = (ContainerAnnotations)container.adapt(ContainerAnnotations.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.cdi.internal.archive.liberty.CDIArchiveImpl", (String)"424", (Object)this, (Object[])new Object[]{container, annotations});
            throw new CDIException((Throwable)e);
        }
        boolean useJandex = false;
        if (this.application != null) {
            useJandex = this.application.getUseJandex();
        }
        Set annotatedClasses = containerAnnotations.getClassesWithSpecifiedInheritedAnnotations(new ArrayList<String>(annotations), useJandex);
        return annotatedClasses;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.cdi.internal.archive.liberty.CDIArchiveImpl", CDIArchiveImpl.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    }
}

