/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.jsontoken;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.security.SignatureException;
import net.oauth.jsontoken.Clock;
import net.oauth.jsontoken.JsonTokenUtil;
import net.oauth.jsontoken.SystemClock;
import net.oauth.jsontoken.crypto.AsciiStringSigner;
import net.oauth.jsontoken.crypto.SignatureAlgorithm;
import net.oauth.jsontoken.crypto.Signer;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.Instant;

public class JsonToken {
    public static final String ALGORITHM_HEADER = "alg";
    public static final String KEY_ID_HEADER = "kid";
    public static final String TYPE_HEADER = "typ";
    public static final String ISSUER = "iss";
    public static final String ISSUED_AT = "iat";
    public static final String EXPIRATION = "exp";
    public static final String AUDIENCE = "aud";
    public static final String BASE64URL_ENCODING = "base64url";
    public static final int DEFAULT_LIFETIME_IN_MINS = 2;
    private JsonObject header;
    private SignatureAlgorithm sigAlg;
    protected final Clock clock;
    private final JsonObject payload;
    private final String tokenString;
    private final Signer signer;
    private String signature;
    private String baseString;

    public JsonToken(Signer signer) {
        this(signer, (Clock)new SystemClock());
    }

    public JsonToken(Signer signer, Clock clock) {
        Preconditions.checkNotNull((Object)signer);
        Preconditions.checkNotNull((Object)clock);
        this.payload = new JsonObject();
        this.signer = signer;
        this.clock = clock;
        this.sigAlg = signer.getSignatureAlgorithm();
        this.signature = null;
        this.baseString = null;
        this.tokenString = null;
        String issuer = signer.getIssuer();
        if (issuer != null) {
            this.setParam(ISSUER, issuer);
        }
    }

    public JsonToken(JsonObject header, JsonObject payload, Clock clock, String tokenString) {
        this.payload = payload;
        this.clock = clock;
        this.baseString = null;
        this.signature = null;
        this.sigAlg = null;
        this.signer = null;
        this.header = header;
        this.tokenString = tokenString;
    }

    public JsonToken(JsonObject payload) {
        this.payload = payload;
        this.baseString = null;
        this.tokenString = null;
        this.signature = null;
        this.sigAlg = null;
        this.signer = null;
        this.clock = null;
    }

    public JsonToken(JsonObject payload, Clock clock) {
        this.payload = payload;
        this.clock = clock;
        this.baseString = null;
        this.tokenString = null;
        this.signature = null;
        this.sigAlg = null;
        this.signer = null;
    }

    public String serializeAndSign() throws SignatureException {
        String baseString = this.computeSignatureBaseString();
        String sig = this.getSignature();
        return JsonTokenUtil.toDotFormat(baseString, sig);
    }

    public String toString() {
        return JsonTokenUtil.toJson(this.payload);
    }

    public String getIssuer() {
        return this.getParamAsString(ISSUER);
    }

    public Instant getIssuedAt() {
        Long issuedAt = this.getParamAsLong(ISSUED_AT);
        if (issuedAt == null) {
            return null;
        }
        return new Instant(issuedAt * 1000L);
    }

    public void setIssuedAt(Instant instant) {
        this.setParam(ISSUED_AT, instant.getMillis() / 1000L);
    }

    public Instant getExpiration() {
        Long expiration = this.getParamAsLong(EXPIRATION);
        if (expiration == null) {
            return null;
        }
        return new Instant(expiration * 1000L);
    }

    public void setExpiration(Instant instant) {
        this.setParam(EXPIRATION, instant.getMillis() / 1000L);
    }

    public String getAudience() {
        return this.getParamAsString(AUDIENCE);
    }

    public void setAudience(String audience) {
        this.setParam(AUDIENCE, audience);
    }

    public void setParam(String name, String value) {
        this.payload.addProperty(name, value);
    }

    public void setParam(String name, Number value) {
        this.payload.addProperty(name, value);
    }

    public JsonPrimitive getParamAsPrimitive(String param) {
        JsonElement element = this.payload.get(param);
        if (element != null && element.isJsonPrimitive()) {
            return (JsonPrimitive)element;
        }
        return null;
    }

    public JsonObject getPayloadAsJsonObject() {
        return this.payload;
    }

    public String getKeyId() {
        return this.signer.getKeyId();
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        if (this.sigAlg == null) {
            if (this.header == null) {
                throw new IllegalStateException("JWT has no algorithm or header");
            }
            JsonElement algorithmName = this.header.get(ALGORITHM_HEADER);
            if (algorithmName == null) {
                throw new IllegalStateException("JWT header is missing the required 'alg' parameter");
            }
            this.sigAlg = SignatureAlgorithm.getFromJsonName(algorithmName.getAsString());
        }
        return this.sigAlg;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public JsonObject getHeader() {
        if (this.header == null) {
            this.createHeader();
        }
        return this.header;
    }

    private String getParamAsString(String param) {
        JsonPrimitive primitive = this.getParamAsPrimitive(param);
        return primitive == null ? null : primitive.getAsString();
    }

    private Long getParamAsLong(String param) {
        JsonPrimitive primitive = this.getParamAsPrimitive(param);
        if (primitive != null && (primitive.isNumber() || primitive.isString())) {
            try {
                return primitive.getAsLong();
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    protected String computeSignatureBaseString() {
        if (this.baseString != null && !this.baseString.isEmpty()) {
            return this.baseString;
        }
        this.baseString = JsonTokenUtil.toDotFormat(JsonTokenUtil.toBase64(this.getHeader()), JsonTokenUtil.toBase64(this.payload));
        return this.baseString;
    }

    private JsonObject createHeader() {
        this.header = new JsonObject();
        this.header.addProperty(ALGORITHM_HEADER, this.getSignatureAlgorithm().getNameForJson());
        String keyId = this.getKeyId();
        if (keyId != null) {
            this.header.addProperty(KEY_ID_HEADER, keyId);
        }
        return this.header;
    }

    private String getSignature() throws SignatureException {
        if (this.signature != null && !this.signature.isEmpty()) {
            return this.signature;
        }
        if (this.signer == null) {
            throw new SignatureException("can't sign JsonToken with signer.");
        }
        AsciiStringSigner asciiSigner = new AsciiStringSigner(this.signer);
        String signature = Base64.encodeBase64URLSafeString((byte[])asciiSigner.sign(this.baseString));
        return signature;
    }
}

