/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance20.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.Executor;
import com.ibm.ws.microprofile.faulttolerance.spi.FTExecutionContext;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorder;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.TimeoutPolicy;
import com.ibm.ws.microprofile.faulttolerance.utils.FTDebug;
import com.ibm.ws.microprofile.faulttolerance20.impl.AsyncAttemptContextImpl;
import com.ibm.ws.microprofile.faulttolerance20.impl.AsyncExecutionContextImpl;
import com.ibm.ws.microprofile.faulttolerance20.impl.MethodResult;
import com.ibm.ws.microprofile.faulttolerance20.state.AsyncBulkheadState;
import com.ibm.ws.microprofile.faulttolerance20.state.CircuitBreakerState;
import com.ibm.ws.microprofile.faulttolerance20.state.FaultToleranceStateFactory;
import com.ibm.ws.microprofile.faulttolerance20.state.RetryState;
import com.ibm.ws.microprofile.faulttolerance20.state.TimeoutState;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AsyncExecutor<W>
implements Executor<W> {
    private static final TraceComponent tc = Tr.register(AsyncExecutor.class, (String)"FAULTTOLERANCE", (String)"com.ibm.ws.microprofile.faulttolerance.resources.FaultTolerance");
    private static final Map<String, ?>[] THREAD_CONTEXT_PROVIDERS = new Map[]{Collections.singletonMap("threadContextProvider", "com.ibm.ws.classloader.context.provider"), Collections.singletonMap("threadContextProvider", "com.ibm.ws.javaee.metadata.context.provider"), Collections.singletonMap("threadContextProvider", "com.ibm.ws.security.context.provider")};
    private final RetryPolicy retryPolicy;
    private final CircuitBreakerState circuitBreaker;
    private final ScheduledExecutorService executorService;
    private final TimeoutPolicy timeoutPolicy;
    private final FallbackPolicy fallbackPolicy;
    private final AsyncBulkheadState bulkhead;
    private final WSContextService contextService;
    private final MetricRecorder metricRecorder;
    static final long serialVersionUID = -6167409905171074774L;

    public AsyncExecutor(RetryPolicy retry, CircuitBreakerPolicy cbPolicy, TimeoutPolicy timeoutPolicy, FallbackPolicy fallbackPolicy, BulkheadPolicy bulkheadPolicy, ScheduledExecutorService executorService, WSContextService contextService, MetricRecorder metricRecorder) {
        this.retryPolicy = retry;
        this.circuitBreaker = FaultToleranceStateFactory.INSTANCE.createCircuitBreakerState(cbPolicy, metricRecorder);
        this.timeoutPolicy = timeoutPolicy;
        this.executorService = executorService;
        this.fallbackPolicy = fallbackPolicy;
        this.bulkhead = FaultToleranceStateFactory.INSTANCE.createAsyncBulkheadState(executorService, bulkheadPolicy, metricRecorder);
        this.metricRecorder = metricRecorder;
        this.contextService = contextService;
    }

    public W execute(Callable<W> callable, ExecutionContext context) {
        AsyncExecutionContextImpl executionContext = (AsyncExecutionContextImpl)context;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Execution {0} Fault tolerance asynchronous execution started for {1}", (Object[])new Object[]{executionContext.getId(), context.getMethod()});
        }
        executionContext.setCallable(callable);
        W resultWrapper = this.createEmptyResultWrapper(executionContext);
        executionContext.setResultWrapper(resultWrapper);
        executionContext.setThreadContextDescriptor(this.contextService.captureThreadContext(null, (Map[])THREAD_CONTEXT_PROVIDERS));
        RetryState retryState = FaultToleranceStateFactory.INSTANCE.createRetryState(this.retryPolicy, this.metricRecorder);
        executionContext.setRetryState(retryState);
        retryState.start();
        this.prepareExecutionAttempt(executionContext);
        return resultWrapper;
    }

    protected abstract W createEmptyResultWrapper(AsyncExecutionContextImpl<W> var1);

    protected abstract void setResult(AsyncExecutionContextImpl<W> var1, MethodResult<W> var2);

    private void prepareExecutionAttempt(AsyncExecutionContextImpl<W> executionContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Execution {0} enqueuing new execution attempt", (Object[])new Object[]{executionContext.getId()});
        }
        AsyncAttemptContextImpl<W> attemptContext = new AsyncAttemptContextImpl<W>(executionContext);
        TimeoutState timeout = FaultToleranceStateFactory.INSTANCE.createTimeoutState(this.executorService, this.timeoutPolicy, this.metricRecorder);
        attemptContext.setTimeoutState(timeout);
        if (!this.circuitBreaker.requestPermissionToExecute()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Execution {0} Circuit Breaker open, not executing", (Object[])new Object[]{executionContext.getId()});
            }
            MethodResult result = MethodResult.failure(new CircuitBreakerOpenException());
            this.processEndOfAttempt(attemptContext, result);
            return;
        }
        attemptContext.setCircuitBreakerPermittedExecution(true);
        timeout.start();
        AsyncBulkheadState.ExecutionReference ref = this.bulkhead.submit(reservation -> this.runExecutionAttempt(attemptContext, reservation), this.getExceptionHandler(attemptContext));
        if (!ref.wasAccepted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Execution {0} bulkhead rejected execution", (Object[])new Object[]{executionContext.getId()});
            }
            this.processEndOfAttempt(attemptContext, MethodResult.failure((Throwable)new BulkheadException()));
            return;
        }
        timeout.setTimeoutCallback(this.handleExceptions(() -> this.timeout(attemptContext, ref), attemptContext, executionContext));
        executionContext.setCancelCallback(mayInterrupt -> {
            ref.abort((boolean)mayInterrupt);
            this.processEndOfAttempt(attemptContext, MethodResult.failure(new CancellationException()));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={Throwable.class, IllegalStateException.class})
    private void runExecutionAttempt(AsyncAttemptContextImpl<W> attemptContext, AsyncBulkheadState.BulkheadReservation reservation) {
        AsyncExecutionContextImpl<W> executionContext = attemptContext.getExecutionContext();
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Execution {0} running execution attempt", (Object[])new Object[]{executionContext.getId()});
            }
            MethodResult<Object> methodResult = null;
            ThreadContextDescriptor contextDescriptor = executionContext.getThreadContextDescriptor();
            ArrayList context = null;
            try {
                context = contextDescriptor.taskStarting();
            }
            catch (IllegalStateException e) {
                methodResult = MethodResult.internalFailure((Throwable)this.createAppStoppedException(e, attemptContext.getExecutionContext()));
            }
            if (methodResult == null) {
                try {
                    W result = executionContext.getCallable().call();
                    methodResult = MethodResult.success(result);
                }
                catch (Throwable e) {
                    methodResult = MethodResult.failure(e);
                }
                finally {
                    contextDescriptor.taskStopping(context);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Execution {0} attempt result: {1}", (Object[])new Object[]{executionContext.getId(), methodResult});
            }
            this.processMethodResult(attemptContext, methodResult, reservation);
            if (attemptContext.getTimeoutState().isTimedOut()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Execution {0} timed out, clearing interrupted flag", (Object[])new Object[]{executionContext.getId()});
                }
                Thread.interrupted();
            }
        }
        catch (Throwable t) {
            String sourceId = AsyncExecutor.class.getName();
            FFDCFilter.processException((Throwable)t, (String)sourceId, (String)"runExecutionAttempt.errorBarrier", (Object)this);
            reservation.release();
            this.handleException(t, attemptContext, executionContext);
        }
    }

    protected void processMethodResult(AsyncAttemptContextImpl<W> attemptContext, MethodResult<W> methodResult, AsyncBulkheadState.BulkheadReservation reservation) {
        reservation.release();
        TimeoutState timeoutState = attemptContext.getTimeoutState();
        timeoutState.stop();
        if (!timeoutState.isTimedOut()) {
            this.processEndOfAttempt(attemptContext, methodResult);
        }
    }

    private void timeout(AsyncAttemptContextImpl<W> attemptContext, AsyncBulkheadState.ExecutionReference ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Execution {0} timed out, attempting to cancel execution attempt", (Object[])new Object[]{attemptContext.getExecutionContext().getId()});
        }
        ref.abort(true);
        MethodResult result = MethodResult.failure((Throwable)new TimeoutException());
        this.processEndOfAttempt(attemptContext, result);
    }

    /*
     * WARNING - void declaration
     */
    protected void processEndOfAttempt(AsyncAttemptContextImpl<W> attemptContext, MethodResult<W> result) {
        AsyncExecutionContextImpl<W> executionContext = attemptContext.getExecutionContext();
        try {
            if (!attemptContext.end()) {
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Execution {0} processing end of attempt execution. Result: {1}", (Object[])new Object[]{executionContext.getId(), result});
            }
            if (attemptContext.getCircuitBreakerPermittedExecution()) {
                this.circuitBreaker.recordResult(result);
            }
            if (!result.isInternalFailure() && !executionContext.isCancelled()) {
                RetryState.RetryResult retryResult = executionContext.getRetryState().recordResult(result);
                if (retryResult.shouldRetry()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Execution {0} retrying with delay: {1} {2}", (Object[])new Object[]{executionContext.getId(), retryResult.getDelay(), retryResult.getDelayUnit()});
                    }
                    if (retryResult.getDelay() > 0L) {
                        this.executorService.schedule(this.handleExceptions(() -> this.prepareExecutionAttempt(executionContext), null, executionContext), retryResult.getDelay(), retryResult.getDelayUnit());
                    } else {
                        this.prepareExecutionAttempt(executionContext);
                    }
                    return;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Execution {0} not retrying: {1}", (Object[])new Object[]{executionContext.getId(), retryResult});
                }
                if (result.isFailure() && this.fallbackPolicy != null) {
                    this.prepareFallback(result, executionContext);
                    return;
                }
            }
            this.processEndOfExecution(executionContext, result);
        }
        catch (Throwable retryResult) {
            void t;
            FFDCFilter.processException((Throwable)retryResult, (String)"com.ibm.ws.microprofile.faulttolerance20.impl.AsyncExecutor", (String)"382", (Object)this, (Object[])new Object[]{attemptContext, result});
            MethodResult errorResult = MethodResult.internalFailure((Throwable)new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT4998E", (Object[])new Object[]{t}), (Throwable)t));
            this.setResult(attemptContext.getExecutionContext(), errorResult);
            throw t;
        }
    }

    private void processEndOfExecution(AsyncExecutionContextImpl<W> executionContext, MethodResult<W> result) {
        this.metricRecorder.incrementInvocationCount();
        if (result.isFailure()) {
            this.metricRecorder.incrementInvocationFailedCount();
        }
        this.setResult(executionContext, result);
    }

    private void prepareFallback(MethodResult<W> result, AsyncExecutionContextImpl<W> executionContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Execution {0} fallback is required", (Object[])new Object[]{executionContext.getId()});
        }
        this.executorService.submit(() -> this.runFallback(result, executionContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={Throwable.class, IllegalStateException.class})
    private void runFallback(MethodResult<W> failedResult, AsyncExecutionContextImpl<W> executionContext) {
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Execution {0} calling fallback", (Object[])new Object[]{executionContext.getId()});
            }
            executionContext.setFailure(failedResult.getFailure());
            MethodResult<Object> fallbackResult = null;
            ThreadContextDescriptor contextDescriptor = executionContext.getThreadContextDescriptor();
            ArrayList context = null;
            try {
                context = contextDescriptor.taskStarting();
            }
            catch (IllegalStateException e) {
                fallbackResult = MethodResult.internalFailure((Throwable)this.createAppStoppedException(e, executionContext));
            }
            if (fallbackResult == null) {
                this.metricRecorder.incrementFallbackCalls();
                try {
                    fallbackResult = MethodResult.success(this.fallbackPolicy.getFallbackFunction().execute(executionContext));
                }
                catch (Throwable ex) {
                    fallbackResult = MethodResult.failure(ex);
                }
                finally {
                    contextDescriptor.taskStopping(context);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Execution {0} fallback result: {1}", (Object[])new Object[]{executionContext.getId(), fallbackResult});
            }
            this.processEndOfExecution(executionContext, fallbackResult);
        }
        catch (Throwable t) {
            String sourceId = AsyncExecutor.class.getName();
            FFDCFilter.processException((Throwable)t, (String)sourceId, (String)"runFallback.errorBarrier", (Object)this);
            this.handleException(t, null, executionContext);
        }
    }

    public FTExecutionContext newExecutionContext(String id, Method method, Object ... parameters) {
        return new AsyncExecutionContextImpl(id, method, parameters);
    }

    public void close() {
        this.bulkhead.shutdown();
    }

    private Runnable handleExceptions(Runnable runnable, AsyncAttemptContextImpl<W> attemptContext, AsyncExecutionContextImpl<W> executionContext) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                this.handleException(t, attemptContext, executionContext);
            }
        };
    }

    private AsyncBulkheadState.ExceptionHandler getExceptionHandler(AsyncAttemptContextImpl<W> attemptContext) {
        return e -> this.handleException(e, attemptContext, attemptContext.getExecutionContext());
    }

    private void handleException(Throwable t, AsyncAttemptContextImpl<W> attemptContext, AsyncExecutionContextImpl<W> executionContext) {
        Tr.error((TraceComponent)tc, (String)"internal.error.CWMFT4998E", (Object[])new Object[]{t});
        MethodResult result = MethodResult.internalFailure((Throwable)new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT4998E", (Object[])new Object[]{t}), t));
        if (attemptContext != null) {
            this.processEndOfAttempt(attemptContext, result);
        } else {
            this.setResult(executionContext, result);
        }
    }

    protected FaultToleranceException createAppStoppedException(IllegalStateException e, AsyncExecutionContextImpl<W> context) {
        String methodString = FTDebug.formatMethod((Method)context.getMethod());
        Tr.warning((TraceComponent)tc, (String)"application.shutdown.CWMFT0002W", (Object[])new Object[]{methodString});
        return new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"application.shutdown.CWMFT0002W", (Object[])new Object[]{methodString}), (Throwable)e);
    }
}

