/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance20.state.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorder;
import com.ibm.ws.microprofile.faulttolerance20.state.AsyncBulkheadState;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AsyncBulkheadStateImpl
implements AsyncBulkheadState {
    private final ExecutorService executorService;
    private final MetricRecorder metrics;
    private final BlockingQueue<ExecutionTask> queue;
    private final Semaphore runningSemaphore;
    static final long serialVersionUID = 8195255783147076710L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AsyncBulkheadStateImpl(ExecutorService executorService, BulkheadPolicy policy, MetricRecorder metricRecorder) {
        this.executorService = executorService;
        int queueSize = policy.getQueueSize();
        this.queue = new LinkedBlockingQueue<ExecutionTask>(queueSize);
        int maxThreads = policy.getMaxThreads();
        this.runningSemaphore = new Semaphore(maxThreads);
        this.metrics = metricRecorder;
        this.metrics.setBulkheadConcurentExecutionCountSupplier(() -> maxThreads - this.runningSemaphore.availablePermits());
        this.metrics.setBulkheadQueuePopulationSupplier(this.queue::size);
    }

    @Override
    public AsyncBulkheadState.ExecutionReference submit(AsyncBulkheadState.AsyncBulkheadTask task, AsyncBulkheadState.ExceptionHandler exceptionHandler) {
        ExecutionTask execution = new ExecutionTask(task, exceptionHandler);
        execution.enqueue();
        if (execution.wasAccepted()) {
            this.metrics.incrementBulkeadAcceptedCount();
            execution.startTime = System.nanoTime();
            this.tryRunNext();
        } else {
            this.metrics.incrementBulkheadRejectedCount();
        }
        return execution;
    }

    /*
     * WARNING - void declaration
     */
    private void tryRunNext() {
        while (this.runningSemaphore.tryAcquire()) {
            ExecutionTask execution = (ExecutionTask)this.queue.poll();
            if (execution != null) {
                try {
                    execution.submit();
                }
                catch (Throwable throwable) {
                    void e;
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.faulttolerance20.state.impl.AsyncBulkheadStateImpl", (String)"81", (Object)this, (Object[])new Object[0]);
                    this.runningSemaphore.release();
                    execution.exceptionHandler.handle((Throwable)e);
                }
                continue;
            }
            this.runningSemaphore.release();
            break;
        }
    }

    @Override
    public void shutdown() {
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.faulttolerance20.state.impl.AsyncBulkheadStateImpl", AsyncBulkheadStateImpl.class, (String)"FAULTTOLERANCE", null);
    }

    private static enum Status {
        NEW,
        QUEUED,
        SUBMITTED,
        RUNNING,
        COMPLETE,
        REJECTED,
        CANCELLED;

    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class ExecutionTask
    implements AsyncBulkheadState.ExecutionReference,
    Runnable,
    AsyncBulkheadState.BulkheadReservation {
        private final AtomicReference<Status> status;
        private final AsyncBulkheadState.AsyncBulkheadTask task;
        private Future<?> future;
        private final AsyncBulkheadState.ExceptionHandler exceptionHandler;
        private long startTime;
        static final long serialVersionUID = 4042226153786117840L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ExecutionTask(AsyncBulkheadState.AsyncBulkheadTask task, AsyncBulkheadState.ExceptionHandler exceptionHandler) {
            this.task = task;
            this.exceptionHandler = exceptionHandler;
            this.status = new AtomicReference<Status>(Status.NEW);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enqueue() {
            ExecutionTask executionTask = this;
            synchronized (executionTask) {
                if (AsyncBulkheadStateImpl.this.queue.offer(this)) {
                    this.status.set(Status.QUEUED);
                } else {
                    this.status.set(Status.REJECTED);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void submit() {
            ExecutionTask executionTask = this;
            synchronized (executionTask) {
                if (this.status.compareAndSet(Status.QUEUED, Status.SUBMITTED)) {
                    this.future = AsyncBulkheadStateImpl.this.executorService.submit(this);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            if (this.status.compareAndSet(Status.SUBMITTED, Status.RUNNING)) {
                try {
                    long now;
                    try {
                        now = System.nanoTime();
                        AsyncBulkheadStateImpl.this.metrics.reportQueueWaitTime(now - this.startTime);
                        this.startTime = now;
                        this.task.run(this);
                    }
                    finally {
                        now = System.nanoTime();
                        AsyncBulkheadStateImpl.this.metrics.recordBulkheadExecutionTime(now - this.startTime);
                    }
                }
                catch (Throwable now) {
                    void t;
                    FFDCFilter.processException((Throwable)now, (String)"com.ibm.ws.microprofile.faulttolerance20.state.impl.AsyncBulkheadStateImpl$ExecutionTask", (String)"181", (Object)this, (Object[])new Object[0]);
                    this.exceptionHandler.handle((Throwable)t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abort(boolean mayInterrupt) {
            ExecutionTask executionTask = this;
            synchronized (executionTask) {
                if (this.status.compareAndSet(Status.QUEUED, Status.CANCELLED)) {
                    AsyncBulkheadStateImpl.this.queue.remove(this);
                } else if (this.status.compareAndSet(Status.SUBMITTED, Status.CANCELLED)) {
                    this.future.cancel(mayInterrupt);
                    AsyncBulkheadStateImpl.this.runningSemaphore.release();
                    AsyncBulkheadStateImpl.this.tryRunNext();
                } else if (this.status.get().equals((Object)Status.RUNNING)) {
                    this.future.cancel(mayInterrupt);
                }
            }
        }

        @Override
        public boolean wasAccepted() {
            return this.status.get() != Status.REJECTED;
        }

        @Override
        public void release() {
            if (this.status.compareAndSet(Status.RUNNING, Status.COMPLETE)) {
                AsyncBulkheadStateImpl.this.runningSemaphore.release();
                AsyncBulkheadStateImpl.this.tryRunNext();
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.faulttolerance20.state.impl.AsyncBulkheadStateImpl$ExecutionTask", ExecutionTask.class, (String)"FAULTTOLERANCE", null);
        }
    }
}

