/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument.serialfilter.digest;

import com.ibm.ws.kernel.instrument.serialfilter.digest.Digester;
import com.ibm.ws.kernel.instrument.serialfilter.digest.DigesterSortedMap;
import com.ibm.ws.kernel.instrument.serialfilter.digest.Processor;
import java.util.Map;
import java.util.TreeMap;
import org.objectweb.asm.AnnotationVisitor;

class AnnotationDigester
extends AnnotationVisitor
implements Digester {
    private final Processor processor = new Processor();
    private Map<String, Object> values = new TreeMap<String, Object>();
    private DigesterSortedMap<AnnotationDigester> annotations = new DigesterSortedMap();

    public AnnotationDigester() {
        super(458752);
    }

    public void visit(String name, Object value) {
        this.values.put(name, value);
    }

    public void visitEnum(String name, String desc, String value) {
        this.values.put(name, desc + "#" + value);
    }

    public AnnotationDigester visitAnnotation(String name, String desc) {
        AnnotationDigester result = new AnnotationDigester();
        this.annotations.put(name, result);
        return result;
    }

    public AnnotationArrayDigester visitArray(String name) {
        AnnotationArrayDigester result = new AnnotationArrayDigester();
        this.annotations.put(name, result);
        return result;
    }

    public final void visitEnd() {
        this.processor.consider(this.values).consider(this.annotations);
        this.values = null;
        this.annotations = null;
    }

    @Override
    public byte[] getDigest() {
        return this.processor.getDigest();
    }

    static class AnnotationArrayDigester
    extends AnnotationDigester {
        int index = 0;

        AnnotationArrayDigester() {
        }

        private String getIndex() {
            return String.format("%08x", this.index++);
        }

        @Override
        public void visit(String name, Object value) {
            super.visit(this.getIndex(), value);
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            super.visitEnum(this.getIndex(), desc, value);
        }

        @Override
        public AnnotationDigester visitAnnotation(String name, String desc) {
            return super.visitAnnotation(this.getIndex(), desc);
        }

        @Override
        public AnnotationArrayDigester visitArray(String name) {
            return super.visitArray(this.getIndex());
        }
    }
}

