/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument.serialfilter.validators;

import com.ibm.ws.kernel.instrument.serialfilter.util.MessageUtil;
import com.ibm.ws.kernel.instrument.serialfilter.validators.ClassValidator;
import java.io.InvalidClassException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

class RejectingClassValidator
extends ClassValidator {
    private final Logger log = Logger.getLogger(RejectingClassValidator.class.getName());

    RejectingClassValidator() {
    }

    @Override
    protected Class<?> apply(Class<?> cls) throws InvalidClassException {
        if (cls == null) {
            return null;
        }
        String message = MessageUtil.format("SF_ERROR_REJECT", cls.getName());
        if (this.log.isLoggable(Level.SEVERE)) {
            this.log.severe(String.format(message, new Object[0]));
        }
        throw new InvalidClassException(message);
    }

    private static ClassLoader getLoader(final Class<?> cls) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return cls.getClassLoader();
            }
        });
    }
}

