/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public final class SystemPropertyAction
implements PrivilegedAction<String> {
    private static final Logger LOG = LogUtils.getL7dLogger(SystemPropertyAction.class);
    private final String property;
    private final String def;
    static final long serialVersionUID = -267675399322677634L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private SystemPropertyAction(String name) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.SystemPropertyAction", "<init>", new Object[]{name});
        }
        this.property = name;
        this.def = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.common.util.SystemPropertyAction", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private SystemPropertyAction(String name, String d) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.SystemPropertyAction", "<init>", new Object[]{name, d});
        }
        this.property = name;
        this.def = d;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.common.util.SystemPropertyAction", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String run() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.SystemPropertyAction", "run", new Object[0]);
        }
        if (this.def != null) {
            String string = System.getProperty(this.property, this.def);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.common.util.SystemPropertyAction", "run", string);
            }
            return string;
        }
        String string = System.getProperty(this.property);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.common.util.SystemPropertyAction", "run", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getProperty(String name) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.SystemPropertyAction", "getProperty", new Object[]{name});
        }
        String string = AccessController.doPrivileged(new SystemPropertyAction(name));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.common.util.SystemPropertyAction", "getProperty", string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getProperty(String name, String def) {
        String string;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.SystemPropertyAction", "getProperty", new Object[]{name, def});
        }
        try {
            string = AccessController.doPrivileged(new SystemPropertyAction(name, def));
        }
        catch (SecurityException securityException) {
            void ex;
            FFDCFilter.processException((Throwable)securityException, (String)"org.apache.cxf.common.util.SystemPropertyAction", (String)"62", null, (Object[])new Object[]{name, def});
            LOG.log(Level.FINE, "SecurityException raised getting property " + name, (Throwable)ex);
            String string2 = def;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string2 = string2;
                LOG.exiting("org.apache.cxf.common.util.SystemPropertyAction", "getProperty", string2);
            }
            return string2;
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.common.util.SystemPropertyAction", "getProperty", string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getPropertyOrNull(String name) {
        String string;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.SystemPropertyAction", "getPropertyOrNull", new Object[]{name});
        }
        try {
            string = AccessController.doPrivileged(new SystemPropertyAction(name));
        }
        catch (SecurityException securityException) {
            void ex;
            FFDCFilter.processException((Throwable)securityException, (String)"org.apache.cxf.common.util.SystemPropertyAction", (String)"76", null, (Object[])new Object[]{name});
            LOG.log(Level.FINE, "SecurityException raised getting property " + name, (Throwable)ex);
            String string2 = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string2 = string2;
                LOG.exiting("org.apache.cxf.common.util.SystemPropertyAction", "getPropertyOrNull", string2);
            }
            return string2;
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.common.util.SystemPropertyAction", "getPropertyOrNull", string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static int getInteger(final String name, final int def) {
        int n;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.SystemPropertyAction", "getInteger", new Object[]{name, def});
        }
        try {
            n = AccessController.doPrivileged(new PrivilegedAction<Integer>(){
                static final long serialVersionUID = 3171440448736125758L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Integer run() {
                    return Integer.getInteger(name, def);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.apache.cxf.common.util.SystemPropertyAction$1", 1.class, null, null);
                }
            });
        }
        catch (SecurityException securityException) {
            void ex;
            FFDCFilter.processException((Throwable)securityException, (String)"org.apache.cxf.common.util.SystemPropertyAction", (String)"89", null, (Object[])new Object[]{name, def});
            LOG.log(Level.FINE, "SecurityException raised getting property " + name, (Throwable)ex);
            int n2 = def;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                n2 = n2;
                LOG.exiting("org.apache.cxf.common.util.SystemPropertyAction", "getInteger", n2);
            }
            return n2;
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            n = n;
            LOG.exiting("org.apache.cxf.common.util.SystemPropertyAction", "getInteger", n);
        }
        return n;
    }
}

