/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.http.internal.HostAlias;
import com.ibm.ws.http.internal.HttpEndpointImpl;
import com.ibm.ws.http.internal.HttpEndpointList;
import com.ibm.ws.http.internal.VirtualHostConfig;
import com.ibm.ws.http.internal.VirtualHostImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.staticvalue.StaticValue;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class VirtualHostMap {
    static final TraceComponent tc = Tr.register(VirtualHostMap.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static volatile StaticValue<VirtualHostConfig> defaultHost = StaticValue.createStaticValue(null);
    private static volatile StaticValue<AlternateHostSelector> alternateHostSelector = StaticValue.createStaticValue(null);
    static final long serialVersionUID = -8993019103864933334L;

    public static synchronized void addVirtualHost(VirtualHostConfig oldConfig, final VirtualHostConfig newConfig) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Add virtual host: " + newConfig.getVirtualHost()), (Object[])new Object[]{oldConfig, newConfig, defaultHost.get(), alternateHostSelector.get()});
        }
        if (newConfig.isDefaultHost()) {
            defaultHost = StaticValue.mutateStaticValue(defaultHost, (Callable)new Callable<VirtualHostConfig>(){
                static final long serialVersionUID = -7979366948028151692L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public VirtualHostConfig call() {
                    return newConfig;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.VirtualHostMap$1", 1.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
                }
            });
            if (alternateHostSelector.get() != null) {
                ((AlternateHostSelector)alternateHostSelector.get()).alternateAddDefaultHost(newConfig);
            } else {
                for (HttpEndpointImpl e : HttpEndpointList.getInstance()) {
                    int ePort = e.getListeningHttpPort();
                    if (ePort > 0) {
                        ((VirtualHostConfig)defaultHost.get()).listenerStarted(e, e.getResolvedHostName(), ePort, false);
                    }
                    if ((ePort = e.getListeningSecureHttpPort()) <= 0) continue;
                    ((VirtualHostConfig)defaultHost.get()).listenerStarted(e, e.getResolvedHostName(), ePort, true);
                }
            }
        } else {
            if (alternateHostSelector.get() == null) {
                alternateHostSelector = StaticValue.mutateStaticValue(alternateHostSelector, (Callable)new Callable<AlternateHostSelector>(){
                    static final long serialVersionUID = 885890076605310712L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public AlternateHostSelector call() throws Exception {
                        return new AlternateHostSelector();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.VirtualHostMap$2", 2.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
                    }
                });
            }
            AlternateHostSelector current = (AlternateHostSelector)alternateHostSelector.get();
            ArrayList<HostAlias> toRemove = new ArrayList<HostAlias>(oldConfig.getHostAliases());
            toRemove.removeAll(newConfig.getHostAliases());
            if (!toRemove.isEmpty()) {
                current.alternateRemoveVirtualHost(oldConfig, toRemove);
            }
            current.alternateAddVirtualHost(newConfig);
        }
    }

    public static synchronized void removeVirtualHost(VirtualHostConfig config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Remove virtual host: " + config.getVirtualHost()), (Object[])new Object[]{config, defaultHost.get(), alternateHostSelector});
        }
        if (config.isDefaultHost()) {
            defaultHost = StaticValue.mutateStaticValue(defaultHost, (Callable)new Callable<VirtualHostConfig>(){
                static final long serialVersionUID = -3960470696830722292L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public VirtualHostConfig call() {
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.VirtualHostMap$3", 3.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
                }
            });
            if (alternateHostSelector.get() != null) {
                ((AlternateHostSelector)alternateHostSelector.get()).alternateRemoveDefaultHost(config);
            } else {
                for (HttpEndpointImpl e : HttpEndpointList.getInstance()) {
                    int ePort = e.getListeningHttpPort();
                    if (ePort > 0) {
                        config.listenerStopped(e, e.getResolvedHostName(), ePort, false);
                    }
                    if ((ePort = e.getListeningSecureHttpPort()) <= 0) continue;
                    config.listenerStopped(e, e.getResolvedHostName(), ePort, true);
                }
            }
        } else if (alternateHostSelector.get() != null) {
            ((AlternateHostSelector)alternateHostSelector.get()).alternateRemoveVirtualHost(config, config.getHostAliases());
        }
    }

    public static synchronized void notifyStarted(HttpEndpointImpl endpoint, String resolvedHostName, int port, boolean isHttps) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Notify endpoint started: " + endpoint), (Object[])new Object[]{resolvedHostName, port, isHttps, defaultHost.get(), alternateHostSelector});
        }
        if (alternateHostSelector.get() == null) {
            if (defaultHost.get() != null) {
                ((VirtualHostConfig)defaultHost.get()).listenerStarted(endpoint, resolvedHostName, port, isHttps);
            }
        } else {
            ((AlternateHostSelector)alternateHostSelector.get()).alternateNotifyStarted(endpoint, resolvedHostName, port, isHttps);
        }
    }

    public static synchronized void notifyStopped(HttpEndpointImpl endpoint, String resolvedHostName, int port, boolean isHttps) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Notify endpoint stopped: " + endpoint), (Object[])new Object[]{resolvedHostName, port, isHttps, defaultHost.get(), alternateHostSelector});
        }
        if (alternateHostSelector.get() == null) {
            if (defaultHost.get() != null) {
                ((VirtualHostConfig)defaultHost.get()).listenerStopped(endpoint, resolvedHostName, port, isHttps);
            }
        } else {
            ((AlternateHostSelector)alternateHostSelector.get()).alternateNotifyStopped(endpoint, resolvedHostName, port, isHttps);
        }
    }

    public static VirtualHostImpl findVirtualHost(String endpointPid, RequestHelper helper) {
        AlternateHostSelector selector = (AlternateHostSelector)alternateHostSelector.get();
        if (selector == null) {
            VirtualHostConfig defHostCfg = (VirtualHostConfig)defaultHost.get();
            if (defHostCfg != null) {
                return defHostCfg.getVirtualHost();
            }
            return null;
        }
        return selector.findVirtualHost(endpointPid, helper.getRequestedHost(), helper.getRequestedPort());
    }

    protected static synchronized void dump(PrintStream ps) {
        ps.println("Default host: " + defaultHost.get());
        ps.println("Alternate hosts: " + (alternateHostSelector.get() != null));
        if (alternateHostSelector.get() != null) {
            ps.println(alternateHostSelector.get());
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class VirtualHostDiscriminator {
        final int port;
        final String portString;
        final HashSet<HttpEndpointImpl> endpoints = new HashSet(1);
        volatile HostTuple currentHosts = new HostTuple(null, (VirtualHostConfig)VirtualHostMap.access$000().get());
        static final long serialVersionUID = -5969203835018628246L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        VirtualHostDiscriminator(int port) {
            this.port = port;
            this.portString = String.valueOf(port);
        }

        void addVirtualHost(String hostName, VirtualHostConfig config) {
            HostTuple snapshot = this.currentHosts;
            if ("*".equals(hostName)) {
                if (snapshot.wildcardHost != null && !snapshot.wildcardHost.isSameVirtualHost(config)) {
                    if (snapshot.wildcardHost.isDefaultHost()) {
                        this.removeVirtualHost(hostName, snapshot.wildcardHost);
                    } else {
                        if (!config.isDefaultHost()) {
                            Tr.warning((TraceComponent)tc, (String)"duplicateAlias", (Object[])new Object[]{hostName + ":" + this.port, config.getName()});
                        }
                        return;
                    }
                }
                this.currentHosts = new HostTuple(snapshot.otherHosts, config);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Added/Updated {0} as wildcard virtual host on port {1}: {2}", (Object[])new Object[]{config.getName(), this.portString, this});
                }
            } else {
                VirtualHostConfig prev;
                Map<String, VirtualHostConfig> others = snapshot.otherHosts;
                if (others == null) {
                    others = new HashMap<String, VirtualHostConfig>(3);
                }
                if ((prev = others.get(hostName)) != null && !prev.isSameVirtualHost(config)) {
                    Tr.warning((TraceComponent)tc, (String)"duplicateAlias", (Object[])new Object[]{hostName + ":" + this.port, config.getName()});
                    return;
                }
                others.put(hostName, config);
                this.currentHosts = new HostTuple(others, snapshot.wildcardHost);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Added/updated {0} to list of virtual hosts on port {1}: {2}", (Object[])new Object[]{config.getName(), this.portString, this});
                }
            }
            this.notifyVHostExistingEndpoints(config, hostName, true);
        }

        void removeVirtualHost(String hostName, VirtualHostConfig config) {
            HostTuple vhosts = this.currentHosts;
            if ("*".equals(hostName)) {
                if (vhosts.wildcardHost.isSameVirtualHost(config)) {
                    this.currentHosts = new HostTuple(vhosts.otherHosts, null);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Removed {0} as wildcard virtual host on port {1}: {2}", (Object[])new Object[]{config.getName(), this.portString, this});
                    }
                    if (!config.isDefaultHost() && defaultHost.get() != null) {
                        this.addVirtualHost(hostName, (VirtualHostConfig)defaultHost.get());
                    }
                }
            } else {
                Map<String, VirtualHostConfig> others = vhosts.otherHosts;
                if (others != null) {
                    others.remove(hostName);
                    if (others.isEmpty()) {
                        this.currentHosts = new HostTuple(null, vhosts.wildcardHost);
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Removed {0} from list of virtual hosts on port {1}: {2}", (Object[])new Object[]{config.getName(), this.portString, this});
                }
            }
            this.notifyVHostExistingEndpoints(config, hostName, false);
        }

        void notifyVHostExistingEndpoints(VirtualHostConfig config, String aliasHost, boolean added) {
            if (config != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Notify {0} of endpoint {3} on port {1} for {4}: {2}", (Object[])new Object[]{config.getName(), this.portString, this, added ? "added" : "removed", aliasHost});
                }
                for (HttpEndpointImpl e : this.endpoints) {
                    boolean isHttps;
                    if (!config.acceptFromEndpoint(e.getPid())) continue;
                    String msgHostName = aliasHost;
                    if ("*".equals(aliasHost)) {
                        msgHostName = e.getResolvedHostName();
                    }
                    boolean bl = isHttps = this.port == e.getListeningSecureHttpPort();
                    if (added) {
                        config.listenerStarted(e, msgHostName, this.port, isHttps);
                        continue;
                    }
                    config.listenerStopped(e, msgHostName, this.port, isHttps);
                }
            }
        }

        private void findActiveEndpoints() {
            for (HttpEndpointImpl e : HttpEndpointList.getInstance()) {
                int ePort = e.getListeningHttpPort();
                if (ePort == this.port) {
                    this.addEndpoint(e, e.getResolvedHostName(), false);
                }
                if ((ePort = e.getListeningSecureHttpPort()) != this.port) continue;
                this.addEndpoint(e, e.getResolvedHostName(), true);
            }
        }

        void addEndpoint(HttpEndpointImpl endpoint, String resolvedHostName, boolean isHttps) {
            if (this.endpoints.add(endpoint)) {
                VirtualHostConfig wildcard;
                HashSet<VirtualHostConfig> hosts = new HashSet<VirtualHostConfig>();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("addEndpoint: " + this), (Object[])new Object[0]);
                }
                if (this.currentHosts.otherHosts != null) {
                    for (Map.Entry<String, VirtualHostConfig> entry : this.currentHosts.otherHosts.entrySet()) {
                        String host = entry.getKey();
                        VirtualHostConfig config = entry.getValue();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"addEndpoint: update existing host", (Object[])new Object[]{host, config});
                        }
                        if (!hosts.add(config) || !config.acceptFromEndpoint(endpoint.getPid())) continue;
                        config.listenerStarted(endpoint, host, this.port, isHttps);
                    }
                }
                if ((wildcard = this.currentHosts.wildcardHost) != null) {
                    wildcard.listenerStarted(endpoint, resolvedHostName, this.port, isHttps);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Endpoint {0} added for port {1}: {2}", (Object[])new Object[]{endpoint.getName(), this.portString, this});
                }
            }
        }

        void removeEndpoint(HttpEndpointImpl endpoint, String resolvedHostName, boolean isHttps) {
            if (this.endpoints.remove(endpoint)) {
                VirtualHostConfig wildcard;
                HashSet<VirtualHostConfig> hosts = new HashSet<VirtualHostConfig>();
                if (this.currentHosts.otherHosts != null) {
                    for (Map.Entry<String, VirtualHostConfig> entry : this.currentHosts.otherHosts.entrySet()) {
                        String host = entry.getKey();
                        VirtualHostConfig config = entry.getValue();
                        if (!hosts.add(config) || !config.acceptFromEndpoint(endpoint.getPid())) continue;
                        config.listenerStopped(endpoint, host, this.port, isHttps);
                    }
                }
                if ((wildcard = this.currentHosts.wildcardHost) != null) {
                    wildcard.listenerStopped(endpoint, resolvedHostName, this.port, isHttps);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Endpoint {0} removed for port {1}: {2}", (Object[])new Object[]{endpoint.getName(), this.portString, this});
                }
            }
        }

        boolean cleanup() {
            return (this.currentHosts.wildcardHost == null || this.currentHosts.wildcardHost == defaultHost.get()) && this.currentHosts.otherHosts == null && this.endpoints.isEmpty();
        }

        VirtualHostConfig selectVirtualHost(String hostName) {
            HostTuple tuple = this.currentHosts;
            if (tuple.hasMoreHosts) {
                VirtualHostConfig config;
                if (tuple.otherHosts != null && (config = tuple.otherHosts.get(hostName)) != null) {
                    return config;
                }
                if (tuple.wildcardHost != null) {
                    return tuple.wildcardHost;
                }
            }
            return (VirtualHostConfig)defaultHost.get();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("VirtualHostDiscriminator[");
            sb.append("port=").append(this.port);
            sb.append(",hosts=").append(this.currentHosts);
            sb.append(",endpoints=").append(this.endpoints);
            sb.append(']');
            return sb.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.VirtualHostMap$VirtualHostDiscriminator", VirtualHostDiscriminator.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
        }
    }

    @Trivial
    private static class HostTuple {
        final boolean hasMoreHosts;
        final Map<String, VirtualHostConfig> otherHosts;
        final VirtualHostConfig wildcardHost;

        @Trivial
        HostTuple(Map<String, VirtualHostConfig> otherHosts, VirtualHostConfig wildcardHost) {
            this.otherHosts = otherHosts;
            this.wildcardHost = wildcardHost;
            this.hasMoreHosts = otherHosts != null || wildcardHost != null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            sb.append(this.otherHosts);
            sb.append(',');
            sb.append(this.wildcardHost);
            sb.append('}');
            return sb.toString();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class AlternateHostSelector {
        private static final Map<Integer, VirtualHostDiscriminator> discriminators;
        static final long serialVersionUID = 643187307778327015L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        AlternateHostSelector() {
            for (HttpEndpointImpl e : HttpEndpointList.getInstance()) {
                VirtualHostDiscriminator d;
                int ePort = e.getListeningHttpPort();
                if (ePort > 0) {
                    d = this.findOrCreateDiscriminator(ePort);
                    d.addEndpoint(e, e.getResolvedHostName(), false);
                }
                if ((ePort = e.getListeningSecureHttpPort()) <= 0) continue;
                d = this.findOrCreateDiscriminator(ePort);
                d.addEndpoint(e, e.getResolvedHostName(), true);
            }
        }

        private VirtualHostDiscriminator findOrCreateDiscriminator(int port) {
            VirtualHostDiscriminator d = discriminators.get(port);
            if (d == null) {
                d = new VirtualHostDiscriminator(port);
                discriminators.put(port, d);
            }
            return d;
        }

        VirtualHostImpl findVirtualHost(String endpointPid, String hostName, int port) {
            VirtualHostConfig target = null;
            VirtualHostDiscriminator d = discriminators.get(port);
            target = d != null ? d.selectVirtualHost(hostName.toLowerCase(Locale.ENGLISH)) : (VirtualHostConfig)defaultHost.get();
            if (target != null && target.acceptFromEndpoint(endpointPid)) {
                return target.getVirtualHost();
            }
            return null;
        }

        void alternateNotifyStarted(HttpEndpointImpl endpoint, String hostName, int port, boolean isHttps) {
            VirtualHostDiscriminator d = this.findOrCreateDiscriminator(port);
            d.addEndpoint(endpoint, hostName, isHttps);
        }

        void alternateNotifyStopped(HttpEndpointImpl endpoint, String hostName, int port, boolean isHttps) {
            VirtualHostDiscriminator d = discriminators.get(port);
            if (d != null) {
                d.removeEndpoint(endpoint, hostName, isHttps);
                if (d.cleanup()) {
                    discriminators.remove(port);
                }
            }
        }

        void alternateAddDefaultHost(VirtualHostConfig config) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Add default host: " + config.getVirtualHost()), (Object[])new Object[0]);
            }
            for (VirtualHostDiscriminator d : discriminators.values()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("try adding default host as wildcard host for " + d), (Object[])new Object[0]);
                }
                d.addVirtualHost("*", config);
            }
        }

        void alternateRemoveDefaultHost(VirtualHostConfig config) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Remove default host: " + config.getVirtualHost()), (Object[])new Object[0]);
            }
            Iterator<VirtualHostDiscriminator> i = discriminators.values().iterator();
            while (i.hasNext()) {
                VirtualHostDiscriminator d = i.next();
                d.removeVirtualHost("*", config);
                if (!d.cleanup()) continue;
                i.remove();
            }
        }

        void alternateAddVirtualHost(VirtualHostConfig config) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Add virtual host: " + config), (Object[])new Object[0]);
            }
            for (HostAlias ha : config.getHostAliases()) {
                VirtualHostDiscriminator d = this.findOrCreateDiscriminator(ha.port);
                d.addVirtualHost(ha.hostName, config);
                d.findActiveEndpoints();
            }
        }

        void alternateRemoveVirtualHost(VirtualHostConfig config, Collection<HostAlias> toRemove) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Remove virtual host: " + config.getVirtualHost()), (Object[])new Object[]{config});
            }
            for (HostAlias ha : toRemove) {
                VirtualHostDiscriminator d = discriminators.get(ha.port);
                if (d == null) continue;
                d.removeVirtualHost(ha.hostName, config);
                if (!d.cleanup()) continue;
                discriminators.remove(d.port);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName()).append('[');
            sb.append("discriminators(").append(discriminators.size()).append(")=[");
            for (Map.Entry<Integer, VirtualHostDiscriminator> entry : discriminators.entrySet()) {
                sb.append(entry.getKey()).append('=').append(entry.getValue()).append(",");
            }
            sb.append("]]");
            return sb.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.VirtualHostMap$AlternateHostSelector", AlternateHostSelector.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
            discriminators = new HashMap<Integer, VirtualHostDiscriminator>();
        }
    }

    public static interface RequestHelper {
        public String getRequestedHost();

        public int getRequestedPort();
    }
}

