/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token.ltpa.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.ws.crypto.ltpakeyutil.LTPAPrivateKey;
import com.ibm.ws.crypto.ltpakeyutil.LTPAPublicKey;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.token.ltpa.internal.LTPAToken2;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.ltpa.TokenFactory;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LTPAToken2Factory
implements TokenFactory {
    private static final TraceComponent tc = Tr.register(LTPAToken2Factory.class, (String)"Token", (String)"com.ibm.ws.security.token.ltpa.internal.resources.LTPAMessages");
    private long expirationInMinutes;
    private byte[] sharedKey;
    private LTPAPublicKey publicKey;
    private LTPAPrivateKey privateKey;
    static final long serialVersionUID = 5086515898936896975L;

    public void initialize(@Sensitive Map tokenFactoryMap) {
        this.expirationInMinutes = (Long)tokenFactoryMap.get("expiration");
        this.sharedKey = (byte[])tokenFactoryMap.get("ltpa_shared_key");
        this.publicKey = (LTPAPublicKey)tokenFactoryMap.get("ltpa_public_key");
        this.privateKey = (LTPAPrivateKey)tokenFactoryMap.get("ltpa_private_key");
    }

    public Token createToken(Map tokenData) throws TokenCreationFailedException {
        String userUniqueId = this.getUniqueId(tokenData);
        return new LTPAToken2(userUniqueId, this.expirationInMinutes, this.sharedKey, this.privateKey, this.publicKey);
    }

    private String getUniqueId(Map tokenData) throws TokenCreationFailedException {
        String userUniqueId = (String)tokenData.get("unique_id");
        if (userUniqueId == null || userUniqueId.length() == 0) {
            Tr.error((TraceComponent)tc, (String)"LTPA_TOKEN_SERVICE_INVALID_UNIQUE_ID", (Object[])new Object[0]);
            String formattedMessage = Tr.formatMessage((TraceComponent)tc, (String)"LTPA_TOKEN_SERVICE_INVALID_UNIQUE_ID", (Object[])new Object[0]);
            throw new TokenCreationFailedException(formattedMessage);
        }
        return userUniqueId;
    }

    public Token validateTokenBytes(byte[] tokenBytes) throws InvalidTokenException, TokenExpiredException {
        return new LTPAToken2(tokenBytes, this.sharedKey, this.privateKey, this.publicKey);
    }
}

