/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.osgi.internal.naming;

import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.EJSWrapperCommon;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.MetaDataSlotService;
import com.ibm.ws.container.service.metadata.MetaDataUtils;
import com.ibm.ws.container.service.metadata.ModuleMetaDataListener;
import com.ibm.ws.container.service.naming.JavaColonNamespaceBindings;
import com.ibm.ws.container.service.naming.JavaColonNamingHelper;
import com.ibm.ws.container.service.naming.NamingConstants;
import com.ibm.ws.container.service.naming.RemoteJavaColonNamingHelper;
import com.ibm.ws.container.service.naming.RemoteObjectInstance;
import com.ibm.ws.container.service.naming.RemoteObjectInstanceFactory;
import com.ibm.ws.ejbcontainer.osgi.EJBHomeRuntime;
import com.ibm.ws.ejbcontainer.osgi.EJBRemoteRuntime;
import com.ibm.ws.ejbcontainer.osgi.internal.naming.EJBBinding;
import com.ibm.ws.jndi.url.contexts.javacolon.JavaJNDIComponentMetaDataAccessor;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import java.rmi.Remote;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
@Component(service={JavaColonNamingHelper.class, ModuleMetaDataListener.class, EJBJavaColonNamingHelper.class, RemoteJavaColonNamingHelper.class})
public class EJBJavaColonNamingHelper
implements JavaColonNamingHelper,
JavaColonNamespaceBindings.ClassNameProvider<EJBBinding>,
ModuleMetaDataListener,
RemoteJavaColonNamingHelper {
    private static final TraceComponent tc = Tr.register(EJBJavaColonNamingHelper.class, (String)"EJBContainer", (String)"com.ibm.ws.ejbcontainer.osgi.internal.resources.EJBContainerMessages");
    private final JavaColonNamespaceBindings<EJBBinding> javaColonGlobalBindings = new JavaColonNamespaceBindings(NamingConstants.JavaColonNamespace.GLOBAL, (JavaColonNamespaceBindings.ClassNameProvider)this);
    private final ReentrantReadWriteLock javaColonLock = new ReentrantReadWriteLock();
    protected MetaDataSlotService metaDataSlotService;
    protected volatile boolean homeRuntime;
    protected volatile boolean remoteRuntime;
    private RemoteObjectInstanceFactory roiFactory;
    protected MetaDataSlot mmdSlot;
    protected MetaDataSlot amdSlot;
    static final long serialVersionUID = -6498849435100771628L;

    @Activate
    protected void activate(ComponentContext context) {
        this.mmdSlot = this.metaDataSlotService.reserveMetaDataSlot(ModuleMetaData.class);
        this.amdSlot = this.metaDataSlotService.reserveMetaDataSlot(ApplicationMetaData.class);
    }

    @Reference
    protected void setMetaDataSlotService(MetaDataSlotService service) {
        this.metaDataSlotService = service;
    }

    protected void unsetMetaDataSlotService(MetaDataSlotService service) {
        this.metaDataSlotService = null;
    }

    @Reference(service=EJBHomeRuntime.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEJBHomeRuntime(ServiceReference<EJBHomeRuntime> ref) {
        this.homeRuntime = true;
    }

    protected void unsetEJBHomeRuntime(ServiceReference<EJBHomeRuntime> ref) {
        this.homeRuntime = false;
    }

    @Reference(service=EJBRemoteRuntime.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEJBRemoteRuntime(ServiceReference<EJBRemoteRuntime> ref) {
        this.remoteRuntime = true;
    }

    protected void unsetEJBRemoteRuntime(ServiceReference<EJBRemoteRuntime> ref) {
        this.remoteRuntime = false;
    }

    @Reference(policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setRemoteObjectInstanceFactory(RemoteObjectInstanceFactory roiFactory) {
        this.roiFactory = roiFactory;
    }

    protected void unsetRemoteObjectInstanceFactory(RemoteObjectInstanceFactory roiFactory) {
        this.roiFactory = null;
    }

    public String getBindingClassName(EJBBinding binding) {
        return binding.interfaceName;
    }

    public Object getObjectInstance(NamingConstants.JavaColonNamespace namespace, String name) throws NamingException {
        Object instance = namespace == NamingConstants.JavaColonNamespace.GLOBAL ? this.processJavaColonGlobal(name) : (namespace == NamingConstants.JavaColonNamespace.APP ? this.processJavaColonApp(name) : (namespace == NamingConstants.JavaColonNamespace.MODULE ? this.processJavaColonModule(name) : null));
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processJavaColonGlobal(String name) throws NamingException {
        EJBBinding binding;
        this.getComponentMetaData(NamingConstants.JavaColonNamespace.GLOBAL, name);
        ReentrantReadWriteLock.ReadLock readLock = this.javaColonLock.readLock();
        readLock.lock();
        try {
            binding = (EJBBinding)this.javaColonGlobalBindings.lookup(name);
        }
        finally {
            readLock.unlock();
        }
        return this.processJavaColon(binding, NamingConstants.JavaColonNamespace.GLOBAL, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processJavaColonApp(String lookupName) throws NamingException {
        ComponentMetaData cmd = this.getComponentMetaData(NamingConstants.JavaColonNamespace.APP, lookupName);
        ModuleMetaData mmd = cmd.getModuleMetaData();
        ApplicationMetaData amd = mmd.getApplicationMetaData();
        ReentrantReadWriteLock.ReadLock readLock = this.javaColonLock.readLock();
        readLock.lock();
        EJBBinding binding = null;
        try {
            JavaColonNamespaceBindings<EJBBinding> appMap = this.getAppBindingMap(amd);
            if (appMap != null) {
                binding = (EJBBinding)appMap.lookup(lookupName);
            }
        }
        finally {
            readLock.unlock();
        }
        return this.processJavaColon(binding, NamingConstants.JavaColonNamespace.APP, lookupName);
    }

    private Object processJavaColonModule(String lookupName) throws NamingException {
        ComponentMetaData cmd = this.getComponentMetaData(NamingConstants.JavaColonNamespace.MODULE, lookupName);
        ModuleMetaData mmd = cmd.getModuleMetaData();
        JavaColonNamespaceBindings<EJBBinding> modMap = this.getModuleBindingMap(mmd);
        EJBBinding binding = (EJBBinding)modMap.lookup(lookupName);
        return this.processJavaColon(binding, NamingConstants.JavaColonNamespace.MODULE, lookupName);
    }

    protected Object processJavaColon(EJBBinding binding, NamingConstants.JavaColonNamespace jndiType, String lookupName) throws NamingException {
        Object instance = null;
        if (binding == null) {
            return null;
        }
        if (binding.isHome() && !this.homeRuntime) {
            this.throwCannotInstanciateUnsupported(binding, jndiType, lookupName, "JNDI_CANNOT_INSTANTIATE_HOME_CNTR4008E");
        }
        if (!binding.isLocal && !this.remoteRuntime) {
            this.throwCannotInstanciateUnsupported(binding, jndiType, lookupName, "JNDI_CANNOT_INSTANTIATE_REMOTE_CNTR4009E");
        }
        try {
            EJSHome home = binding.homeRecord.getHomeAndInitialize();
            if (binding.isHome()) {
                EJSWrapperCommon wc = home.getWrapper();
                instance = binding.isLocal ? wc.getLocalObject() : home.getContainer().getEJBRuntime().getRemoteReference(wc.getRemoteWrapper());
            } else {
                instance = binding.isLocal ? home.createLocalBusinessObject(binding.interfaceIndex, null) : home.createRemoteBusinessObject(binding.interfaceIndex, null);
            }
        }
        catch (Throwable t) {
            this.throwCannotInstanciateObjectException(binding, jndiType, lookupName, t);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasObjectWithPrefix(NamingConstants.JavaColonNamespace namespace, String name) throws NamingException {
        boolean result = false;
        Lock readLock = null;
        ComponentMetaData cmd = null;
        try {
            JavaColonNamespaceBindings<EJBBinding> bindings;
            if (namespace == NamingConstants.JavaColonNamespace.GLOBAL) {
                cmd = this.getComponentMetaData(namespace, name);
                bindings = this.javaColonGlobalBindings;
                readLock = this.javaColonLock.readLock();
                readLock.lock();
            } else if (namespace == NamingConstants.JavaColonNamespace.APP) {
                cmd = this.getComponentMetaData(namespace, name);
                bindings = this.getAppBindingMap(cmd.getModuleMetaData().getApplicationMetaData());
                readLock = this.javaColonLock.readLock();
                readLock.lock();
            } else if (namespace == NamingConstants.JavaColonNamespace.MODULE) {
                cmd = this.getComponentMetaData(namespace, name);
                bindings = this.getModuleBindingMap(cmd.getModuleMetaData());
            } else {
                bindings = null;
            }
            result = bindings != null && bindings.hasObjectWithPrefix(name);
        }
        finally {
            if (readLock != null) {
                readLock.unlock();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addGlobalBinding(String name, EJBBinding bindingObject) {
        ReentrantReadWriteLock.WriteLock writeLock = this.javaColonLock.writeLock();
        writeLock.lock();
        try {
            this.javaColonGlobalBindings.bind(name, (Object)bindingObject);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGlobalBindings(List<String> names) {
        ReentrantReadWriteLock.WriteLock writeLock = this.javaColonLock.writeLock();
        writeLock.lock();
        try {
            for (String name : names) {
                this.javaColonGlobalBindings.unbind(name);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addAppBinding(ModuleMetaData mmd, String name, EJBBinding bindingObject) {
        ReentrantReadWriteLock.WriteLock writeLock = this.javaColonLock.writeLock();
        writeLock.lock();
        try {
            JavaColonNamespaceBindings<EJBBinding> bindings = this.getAppBindingMap(mmd.getApplicationMetaData());
            bindings.bind(name, (Object)bindingObject);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void addModuleBinding(ModuleMetaData mmd, String name, EJBBinding bindingObject) {
        JavaColonNamespaceBindings<EJBBinding> bindingMap = this.getModuleBindingMap(mmd);
        bindingMap.bind(name, (Object)bindingObject);
    }

    private JavaColonNamespaceBindings<EJBBinding> getAppBindingMap(ApplicationMetaData amd) {
        JavaColonNamespaceBindings bindingMap = (JavaColonNamespaceBindings)amd.getMetaData(this.amdSlot);
        if (bindingMap == null) {
            bindingMap = new JavaColonNamespaceBindings(NamingConstants.JavaColonNamespace.APP, (JavaColonNamespaceBindings.ClassNameProvider)this);
            amd.setMetaData(this.amdSlot, (Object)bindingMap);
        }
        return bindingMap;
    }

    private JavaColonNamespaceBindings<EJBBinding> getModuleBindingMap(ModuleMetaData mmd) {
        JavaColonNamespaceBindings bindingMap = (JavaColonNamespaceBindings)mmd.getMetaData(this.mmdSlot);
        if (bindingMap == null) {
            bindingMap = new JavaColonNamespaceBindings(NamingConstants.JavaColonNamespace.MODULE, (JavaColonNamespaceBindings.ClassNameProvider)this);
            mmd.setMetaData(this.mmdSlot, (Object)bindingMap);
        }
        return bindingMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppBindings(ModuleMetaData mmd, List<String> names) {
        ApplicationMetaData amd = mmd.getApplicationMetaData();
        ReentrantReadWriteLock.WriteLock writeLock = this.javaColonLock.writeLock();
        writeLock.lock();
        try {
            JavaColonNamespaceBindings<EJBBinding> bindings = this.getAppBindingMap(amd);
            for (String name : names) {
                bindings.unbind(name);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends NameClassPair> listInstances(NamingConstants.JavaColonNamespace namespace, String nameInContext) throws NamingException {
        JavaColonNamespaceBindings<EJBBinding> bindingsMap;
        if (namespace != NamingConstants.JavaColonNamespace.GLOBAL && namespace != NamingConstants.JavaColonNamespace.APP && namespace != NamingConstants.JavaColonNamespace.MODULE) {
            return Collections.emptyList();
        }
        ComponentMetaData cmd = this.getComponentMetaData(namespace, nameInContext);
        boolean lockingRequired = true;
        if (namespace == NamingConstants.JavaColonNamespace.GLOBAL) {
            bindingsMap = this.javaColonGlobalBindings;
        } else if (namespace == NamingConstants.JavaColonNamespace.MODULE) {
            bindingsMap = this.getModuleBindingMap(cmd.getModuleMetaData());
            lockingRequired = false;
        } else {
            bindingsMap = this.getAppBindingMap(cmd.getModuleMetaData().getApplicationMetaData());
        }
        Collection retVal = null;
        ReentrantReadWriteLock.ReadLock readLock = null;
        if (lockingRequired) {
            readLock = this.javaColonLock.readLock();
            readLock.lock();
        }
        try {
            retVal = bindingsMap.listInstances(nameInContext);
        }
        finally {
            if (readLock != null) {
                readLock.unlock();
            }
        }
        return retVal;
    }

    protected ComponentMetaData getComponentMetaData(NamingConstants.JavaColonNamespace namespace, String name) throws NamingException {
        return JavaJNDIComponentMetaDataAccessor.getComponentMetaData((NamingConstants.JavaColonNamespace)namespace, (String)name);
    }

    protected J2EEName getJ2EEName(EJBBinding binding) {
        return binding.homeRecord.getJ2EEName();
    }

    private NamingException throwCannotInstanciateObjectException(EJBBinding binding, NamingConstants.JavaColonNamespace jndiType, String lookupName, Throwable cause) throws NamingException {
        String jndiName = jndiType.toString() + "/" + lookupName;
        J2EEName j2eeName = this.getJ2EEName(binding);
        String causeMsg = cause.getLocalizedMessage();
        if (causeMsg == null) {
            causeMsg = cause.toString();
        }
        String msgTxt = Tr.formatMessage((TraceComponent)tc, (String)"JNDI_CANNOT_INSTANTIATE_OBJECT_CNTR4007E", (Object[])new Object[]{binding.interfaceName, j2eeName.getComponent(), j2eeName.getModule(), j2eeName.getApplication(), jndiName, causeMsg});
        NamingException nex = new NamingException(msgTxt);
        nex.initCause(cause);
        throw nex;
    }

    private void throwCannotInstanciateUnsupported(EJBBinding binding, NamingConstants.JavaColonNamespace jndiType, String lookupName, String messageId) throws NameNotFoundException {
        J2EEName j2eeName = this.getJ2EEName(binding);
        String jndiName = jndiType.toString() + "/" + lookupName;
        String msgTxt = Tr.formatMessage((TraceComponent)tc, (String)messageId, (Object[])new Object[]{binding.interfaceName, j2eeName.getComponent(), j2eeName.getModule(), j2eeName.getApplication(), jndiName});
        throw new NameNotFoundException(msgTxt);
    }

    public void moduleMetaDataCreated(MetaDataEvent<ModuleMetaData> event) throws MetaDataException {
        if (!MetaDataUtils.copyModuleMetaDataSlot(event, (MetaDataSlot)this.mmdSlot)) {
            this.getModuleBindingMap((ModuleMetaData)event.getMetaData());
        }
    }

    public void moduleMetaDataDestroyed(MetaDataEvent<ModuleMetaData> event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EJBBinding getEJBBinding(NamingConstants.JavaColonNamespace namespace, String name) throws NamingException {
        ComponentMetaData cmd = this.getComponentMetaData(namespace, name);
        ModuleMetaData mmd = cmd.getModuleMetaData();
        ApplicationMetaData amd = mmd == null ? null : mmd.getApplicationMetaData();
        ReentrantReadWriteLock.ReadLock readLock = this.javaColonLock.readLock();
        readLock.lock();
        EJBBinding binding = null;
        try {
            if (NamingConstants.JavaColonNamespace.GLOBAL.equals((Object)namespace)) {
                binding = (EJBBinding)this.javaColonGlobalBindings.lookup(name);
            } else if (amd != null && NamingConstants.JavaColonNamespace.APP.equals((Object)namespace)) {
                JavaColonNamespaceBindings<EJBBinding> appMap = this.getAppBindingMap(amd);
                if (appMap != null) {
                    binding = (EJBBinding)appMap.lookup(name);
                }
            } else if (mmd != null && NamingConstants.JavaColonNamespace.MODULE.equals((Object)namespace)) {
                JavaColonNamespaceBindings<EJBBinding> modMap = this.getModuleBindingMap(mmd);
                binding = (EJBBinding)modMap.lookup(name);
            }
        }
        finally {
            readLock.unlock();
        }
        return binding;
    }

    public RemoteObjectInstance getRemoteObjectInstance(NamingConstants.JavaColonNamespace namespace, String name) throws NamingException {
        RemoteObjectInstance roi = null;
        Object o = this.getObjectInstance(namespace, name);
        if (o != null && o instanceof Remote) {
            EJBBinding ejbBinding = this.getEJBBinding(namespace, name);
            if (ejbBinding == null || ejbBinding.interfaceName == null) {
                throw new NamingException("Unable to determine bound EJB's remote interface");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getObjectInstance() ==> " + o + "  interfaceName = " + ejbBinding.interfaceName), (Object[])new Object[0]);
            }
            roi = this.roiFactory.create((Remote)o, ejbBinding.interfaceName);
        }
        return roi;
    }

    public boolean hasRemoteObjectWithPrefix(NamingConstants.JavaColonNamespace namespace, String name) throws NamingException {
        return this.hasObjectWithPrefix(namespace, name);
    }

    public Collection<? extends NameClassPair> listRemoteInstances(NamingConstants.JavaColonNamespace namespace, String nameInContext) throws NamingException {
        return this.listInstances(namespace, nameInContext);
    }
}

