/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FileFailureScope;
import com.ibm.ws.recoverylog.spi.LeaseInfo;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl;
import com.ibm.ws.recoverylog.spi.RecoveryFailedException;
import com.ibm.ws.recoverylog.spi.RecoveryLogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyRecoveryDirectorImpl
extends RecoveryDirectorImpl {
    private static final TraceComponent tc;
    private static LibertyRecoveryDirectorImpl _instance;
    private static RecoveryLogFactory theRecoveryLogFactory;
    static final long serialVersionUID = 3080835831812469606L;
    private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

    public LibertyRecoveryDirectorImpl() {
        if (theRecoveryLogFactory != null) {
            String className = theRecoveryLogFactory.getClass().getName();
            this._customLogFactories.put(className, theRecoveryLogFactory);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("LibertyRecoveryDirectorImpl: setting RecoveryLogFactory, " + theRecoveryLogFactory + "for classname, " + className));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"LibertyRecoveryDirectorImpl: the RecoveryLogFactory is null");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"LibertyRecoveryDirectorImpl", (Object)this);
        }
    }

    public static synchronized RecoveryDirector instance() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"instance");
        }
        if (_instance == null) {
            _instance = new LibertyRecoveryDirectorImpl();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"instance", (Object)_instance);
        }
        return _instance;
    }

    public static void reset() {
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reset");
        }
        _instance = null;
    }

    public void drivePeerRecovery() throws RecoveryFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"drivePeerRecovery", (Object)this);
        }
        RecoveryAgent libertyRecoveryAgent = null;
        FailureScope localFailureScope = Configuration.localFailureScope();
        Tr.audit((TraceComponent)tc, (String)("WTRN0108I: " + localFailureScope.serverName() + " checking to see if any peers need recovering"));
        ArrayList<String> peersToRecover = null;
        Collection registeredRecoveryAgentsValues = this._registeredRecoveryAgents.values();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("work with RA values: " + registeredRecoveryAgentsValues + ", collection size: " + registeredRecoveryAgentsValues.size()), (Object)this);
        }
        for (ArrayList registeredRecoveryAgentsArray : registeredRecoveryAgentsValues) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("work with Agents array: " + registeredRecoveryAgentsArray + ", of size: " + registeredRecoveryAgentsArray.size()), (Object)this);
            }
            Iterator registeredRecoveryAgentsArrayIterator = registeredRecoveryAgentsArray.iterator();
            while (registeredRecoveryAgentsArrayIterator.hasNext()) {
                RecoveryAgent recoveryAgent;
                libertyRecoveryAgent = recoveryAgent = (RecoveryAgent)registeredRecoveryAgentsArrayIterator.next();
                String recoveryGroup = libertyRecoveryAgent.getRecoveryGroup();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("work with Agent: " + recoveryAgent + " and recoveryGroup " + recoveryGroup), (Object)this);
                }
                peersToRecover = recoveryAgent.processLeasesForPeers(localFailureScope.serverName(), recoveryGroup);
            }
        }
        if (peersToRecover != null && !peersToRecover.isEmpty() && libertyRecoveryAgent != null) {
            this.peerRecoverServers(libertyRecoveryAgent, localFailureScope.serverName(), peersToRecover);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"drivePeerRecovery");
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={RecoveryFailedException.class})
    public synchronized void peerRecoverServers(RecoveryAgent recoveryAgent, String myRecoveryIdentity, ArrayList<String> peersToRecover) throws RecoveryFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"peerRecoverServers", (Object)new Object[]{recoveryAgent, myRecoveryIdentity, peersToRecover});
        }
        for (String peerRecoveryIdentity : peersToRecover) {
            try {
                LeaseInfo leaseInfo = new LeaseInfo();
                if (recoveryAgent.claimPeerLeaseForRecovery(peerRecoveryIdentity, myRecoveryIdentity, leaseInfo)) {
                    Tr.audit((TraceComponent)tc, (String)("WTRN0108I: PEER RECOVER server with recovery identity " + peerRecoveryIdentity));
                    FileFailureScope peerFFS = new FileFailureScope(peerRecoveryIdentity, leaseInfo);
                    this.directInitialization(peerFFS);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Failed to claim lease for peer", (Object)this);
            }
            catch (RecoveryFailedException rfexc) {
                Tr.audit((TraceComponent)tc, (String)("WTRN0108I: HADB Peer locking failed for server with recovery identity " + peerRecoveryIdentity));
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"peerRecoverServers", (Object)rfexc);
                }
                throw rfexc;
            }
            catch (Exception rfexc) {
                void exc;
                FFDCFilter.processException((Throwable)rfexc, (String)"com.ibm.ws.recoverylog.spi.LibertyRecoveryDirectorImpl", (String)"166", (Object)this, (Object[])new Object[]{recoveryAgent, myRecoveryIdentity, peersToRecover});
                Tr.audit((TraceComponent)tc, (String)("WTRN0108I: HADB Peer locking failed for server with recovery identity " + peerRecoveryIdentity + " with exception " + exc));
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"peerRecoverServers", (Object)exc);
                }
                throw new RecoveryFailedException((Throwable)exc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"peerRecoverServers");
        }
    }

    @Override
    public void setRecoveryLogFactory(RecoveryLogFactory fac) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setRecoveryLogFactory, factory: " + fac), (Object)this);
        }
        if ((theRecoveryLogFactory = fac) != null) {
            String className = theRecoveryLogFactory.getClass().getName();
            this._customLogFactories.put(className, theRecoveryLogFactory);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("LibertyRecoveryDirectorImpl: setting RecoveryLogFactory, " + theRecoveryLogFactory + "for classname, " + className));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"LibertyRecoveryDirectorImpl: the RecoveryLogFactory is null");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"LibertyRecoveryDirectorImpl", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.LibertyRecoveryDirectorImpl", LibertyRecoveryDirectorImpl.class, null, null);
        tc = Tr.register(LibertyRecoveryDirectorImpl.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
        theRecoveryLogFactory = null;
    }
}

