/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.targets.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.anno.service.internal.AnnotationServiceImpl_Logging;
import com.ibm.ws.anno.targets.internal.AnnotationTargetsImpl_Targets;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import java.text.MessageFormat;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AnnotationTargetsVisitor
extends ClassVisitor {
    private static final TraceComponent tc = Tr.register(AnnotationTargetsVisitor.class, (String)"com.ibm.ws.anno", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
    public static final String CLASS_NAME = AnnotationTargetsVisitor.class.getName();
    public static final String PACKAGE_INFO_CLASS_NAME = "package-info";
    protected final String hashText;
    protected final AnnotationTargetsImpl_Targets annotationTargets;
    protected final boolean isDetailEnabled;
    protected String i_classSourceName;
    protected ClassSource_Aggregate.ScanPolicy scanPolicy;
    protected boolean scanPolicyIsExternal;
    protected String externalName;
    protected boolean isClass;
    protected String i_className;
    public static final VisitEnded VISIT_ENDED_DETAIL = new VisitEnded(VisitEndCase.VISIT_END_DETAIL);
    public static final VisitEnded VISIT_ENDED_DUPLICATE_CLASS = new VisitEnded(VisitEndCase.VISIT_END_DUPLICATE_CLASS);
    public static final VisitEnded VISIT_ENDED_CLASS_MISMATCH = new VisitEnded(VisitEndCase.VISIT_END_CLASS_MISMATCH);
    public static final VisitEnded VISIT_ENDED_DUPLICATE_PACKAGE = new VisitEnded(VisitEndCase.VISIT_END_DUPLICATE_PACKAGE);
    public static final VisitEnded VISIT_ENDED_PACKAGE_MISMATCH = new VisitEnded(VisitEndCase.VISIT_END_PACKAGE_MISMATCH);
    protected final FieldVisitor fieldVisitor = new AnnoFieldVisitor();
    protected final MethodVisitor methodVisitor = new AnnoMethodVisitor();
    static final long serialVersionUID = -3785108644137834388L;

    protected void reportFFDC(String eMsg, String eLine) {
        FFDCFilter.processException((Throwable)new Exception(eMsg), (String)CLASS_NAME, (String)eLine);
    }

    public static boolean isPackageName(String className) {
        return className.endsWith(PACKAGE_INFO_CLASS_NAME);
    }

    public static String stripPackageNameFromClassName(String className) {
        return className.substring(0, className.length() - (PACKAGE_INFO_CLASS_NAME.length() + 1));
    }

    protected static String getResourceNameFromDescription(String desc) {
        Type type = Type.getType((String)desc);
        String className = type.getClassName();
        String resourceName = className.replace(".", "/");
        return resourceName;
    }

    protected static String getClassResourceNameFromAnnotationDescription(String desc) {
        return desc.substring(1, desc.length() - 1);
    }

    protected static String getClassNameFromPartialResourceName(String partialResourceName) {
        return partialResourceName.replace("/", ".");
    }

    public AnnotationTargetsVisitor(AnnotationTargetsImpl_Targets annotationTargets) {
        super(458752);
        this.hashText = AnnotationServiceImpl_Logging.getBaseHash((Object)this);
        this.annotationTargets = annotationTargets;
        this.isDetailEnabled = annotationTargets.getIsDetailEnabled();
        if (tc.isDebugEnabled()) {
            String trMsg = MessageFormat.format("[ {0} ] Created on [ {1} ]", this.getHashText(), this.getAnnotationTargets().getHashText());
            Tr.debug((TraceComponent)tc, (String)trMsg, (Object[])new Object[0]);
        }
    }

    public String getHashText() {
        return this.hashText;
    }

    public AnnotationTargetsImpl_Targets getAnnotationTargets() {
        return this.annotationTargets;
    }

    protected boolean isDetailEnabled() {
        return this.isDetailEnabled;
    }

    protected String internClassName(String name) {
        return this.getAnnotationTargets().internClassName(name);
    }

    protected String internClassName(String name, boolean doForce) {
        return this.getAnnotationTargets().internClassName(name, doForce);
    }

    protected void i_setClassSourceName(String i_classSourceName) {
        this.i_classSourceName = i_classSourceName;
    }

    protected String i_getClassSourceName() {
        return this.i_classSourceName;
    }

    protected void setScanPolicy(ClassSource_Aggregate.ScanPolicy scanPolicy) {
        this.scanPolicy = scanPolicy;
        this.scanPolicyIsExternal = this.scanPolicy == ClassSource_Aggregate.ScanPolicy.EXTERNAL;
    }

    protected ClassSource_Aggregate.ScanPolicy getScanPolicy() {
        return this.scanPolicy;
    }

    protected boolean scanPolicyIsExternal() {
        return this.scanPolicyIsExternal;
    }

    public void setExternalName(String externalName) {
        this.externalName = externalName;
    }

    private String getExternalName() {
        return this.externalName;
    }

    protected boolean i_recordScannedClassName(String i_className) {
        boolean didPlaceClass = this.annotationTargets.i_placeClass(this.i_getClassSourceName(), i_className);
        if (!didPlaceClass) {
            return false;
        }
        boolean didAddClass = this.annotationTargets.i_addScannedClassName(i_className, this.getScanPolicy());
        return didAddClass;
    }

    protected void i_recordSuperclassName(String i_className, String i_superclassName) {
        this.annotationTargets.i_setSuperclassName(i_className, i_superclassName);
    }

    protected void i_recordInterfaceNames(String i_className, String[] i_interfaceNames) {
        this.annotationTargets.i_setInterfaceNames(i_className, i_interfaceNames);
    }

    protected void i_recordReferencedClassName(String i_className) {
        this.annotationTargets.i_addReferencedClassName(i_className);
    }

    protected void i_removeReferencedClassName(String i_className) {
        this.annotationTargets.i_removeReferencedClassName(i_className);
    }

    protected void recordAnnotation(AnnotationTargets_Targets.AnnotationCategory annotationCategory, String desc) {
        String annotationResourceName = AnnotationTargetsVisitor.getClassResourceNameFromAnnotationDescription(desc);
        String annotationClassName = AnnotationTargetsVisitor.getClassNameFromPartialResourceName(annotationResourceName);
        String i_annotationClassName = this.internClassName(annotationClassName);
        this.annotationTargets.i_recordAnnotation(this.getScanPolicy(), annotationCategory, this.i_className, i_annotationClassName);
    }

    public void visit(int version, int access, String classResourceName, String signature, String superClassResourceName, String[] interfaceResourceNames) {
        Object[] logParms;
        if (tc.isDebugEnabled()) {
            logParms = new Object[]{this.getHashText(), classResourceName};
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] [ {1} ]", logParms), (Object[])new Object[0]);
        } else {
            logParms = null;
        }
        String className = AnnotationTargetsVisitor.getClassNameFromPartialResourceName(classResourceName);
        if (logParms != null) {
            logParms[1] = className + ".class";
        }
        if (AnnotationTargetsVisitor.isPackageName(className)) {
            String externalClassName;
            if (logParms != null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] [ {1} ] Package load", logParms), (Object[])new Object[0]);
            }
            this.isClass = false;
            if (!(className = AnnotationTargetsVisitor.stripPackageNameFromClassName(className)).equals(externalClassName = AnnotationTargetsVisitor.stripPackageNameFromClassName(this.getExternalName()))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Class name mismatch", (Object[])new Object[]{this.getHashText(), externalClassName});
                }
                throw VISIT_ENDED_PACKAGE_MISMATCH;
            }
            this.i_className = this.internClassName(className, true);
        } else {
            if (logParms != null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] [ {1} ] Class load", logParms), (Object[])new Object[0]);
            }
            this.isClass = true;
            if (!className.equals(this.getExternalName())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Class name mismatch", (Object[])new Object[]{this.getHashText(), className});
                }
                throw VISIT_ENDED_CLASS_MISMATCH;
            }
            this.i_className = this.internClassName(className);
            if (!this.i_recordScannedClassName(this.i_className)) {
                Tr.warning((TraceComponent)tc, (String)"ANNO_TARGETS_DUPLICATE_CLASS", (Object[])new Object[]{this.getHashText(), this.i_className});
                throw VISIT_ENDED_DUPLICATE_CLASS;
            }
            this.i_removeReferencedClassName(this.i_className);
            if (superClassResourceName != null) {
                superClassResourceName = AnnotationTargetsVisitor.getClassNameFromPartialResourceName(superClassResourceName);
                String i_superclassName = this.internClassName(superClassResourceName);
                this.i_recordSuperclassName(this.i_className, i_superclassName);
                this.i_recordReferencedClassName(i_superclassName);
            }
            if (interfaceResourceNames != null && interfaceResourceNames.length > 0) {
                String[] i_interfaceNames = new String[interfaceResourceNames.length];
                for (int nameNo = 0; nameNo < interfaceResourceNames.length; ++nameNo) {
                    String i_nextInterfaceName;
                    String nextInterfaceResourceName = interfaceResourceNames[nameNo];
                    String nextInterfaceName = AnnotationTargetsVisitor.getClassNameFromPartialResourceName(nextInterfaceResourceName);
                    i_interfaceNames[nameNo] = i_nextInterfaceName = this.internClassName(nextInterfaceName);
                }
                this.i_recordInterfaceNames(this.i_className, i_interfaceNames);
                for (String i_interfaceName : i_interfaceNames) {
                    this.i_recordReferencedClassName(i_interfaceName);
                }
            }
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationTargets_Targets.AnnotationCategory category = this.isClass ? AnnotationTargets_Targets.AnnotationCategory.CLASS : AnnotationTargets_Targets.AnnotationCategory.PACKAGE;
        this.recordAnnotation(category, desc);
        return null;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object defaultValue) {
        if (this.scanPolicyIsExternal() || !this.isDetailEnabled()) {
            this.visitEnd();
            throw VISIT_ENDED_DETAIL;
        }
        return this.fieldVisitor;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.scanPolicyIsExternal() || !this.isDetailEnabled()) {
            this.visitEnd();
            throw VISIT_ENDED_DETAIL;
        }
        return this.methodVisitor;
    }

    public void visitEnd() {
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected class AnnoMethodVisitor
    extends MethodVisitor {
        static final long serialVersionUID = 2334231598451759950L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public AnnoMethodVisitor() {
            super(458752);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationTargetsVisitor.this.recordAnnotation(AnnotationTargets_Targets.AnnotationCategory.METHOD, desc);
            return null;
        }

        public AnnotationVisitor visitParameterAnnotation(int param, String desc, boolean visible) {
            return null;
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return null;
        }

        public void visitEnd() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.anno.targets.internal.AnnotationTargetsVisitor$AnnoMethodVisitor", AnnoMethodVisitor.class, (String)"com.ibm.ws.anno", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected class AnnoFieldVisitor
    extends FieldVisitor {
        static final long serialVersionUID = 6818029444933258753L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public AnnoFieldVisitor() {
            super(458752);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationTargetsVisitor.this.recordAnnotation(AnnotationTargets_Targets.AnnotationCategory.FIELD, desc);
            return null;
        }

        public void visitEnd() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.anno.targets.internal.AnnotationTargetsVisitor$AnnoFieldVisitor", AnnoFieldVisitor.class, (String)"com.ibm.ws.anno", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class VisitEnded
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        protected final VisitEndCase endCase;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public VisitEnded(VisitEndCase endCase) {
            this.endCase = endCase;
        }

        @Override
        public Throwable fillInStackTrace() {
            return null;
        }

        public VisitEndCase getEndCase() {
            return this.endCase;
        }

        public boolean isDetailCase() {
            return this.getEndCase() == VisitEndCase.VISIT_END_DETAIL;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.anno.targets.internal.AnnotationTargetsVisitor$VisitEnded", VisitEnded.class, (String)"com.ibm.ws.anno", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }

    public static enum VisitEndCase {
        VISIT_END_DETAIL,
        VISIT_END_DUPLICATE_CLASS,
        VISIT_END_CLASS_MISMATCH,
        VISIT_END_DUPLICATE_PACKAGE,
        VISIT_END_PACKAGE_MISMATCH;

    }
}

