/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.adaptable.module.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.adaptable.module.internal.AdaptableEntryImpl;
import com.ibm.ws.adaptable.module.internal.FactoryHolder;
import com.ibm.ws.adaptable.module.internal.InterpretedContainerImpl;
import com.ibm.ws.adaptable.module.internal.NotifierImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.InterpretedContainer;
import com.ibm.wsspi.adaptable.module.Notifier;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AdaptableContainerImpl
implements Container {
    protected Container root;
    protected final OverlayContainer rootOverlay;
    protected final FactoryHolder factoryHolder;
    protected final ArtifactContainer delegate;
    protected Notifier notifier;
    static final long serialVersionUID = -5950528200509051684L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AdaptableContainerImpl(OverlayContainer rootOverlay, FactoryHolder factoryHolder) {
        this.delegate = rootOverlay;
        this.root = this;
        this.rootOverlay = rootOverlay;
        this.factoryHolder = factoryHolder;
    }

    public AdaptableContainerImpl(ArtifactContainer delegate, OverlayContainer rootOverlay, FactoryHolder factoryHolder) {
        this.delegate = delegate;
        this.root = this;
        this.rootOverlay = rootOverlay;
        this.factoryHolder = factoryHolder;
    }

    public AdaptableContainerImpl(ArtifactContainer delegate, Container root, OverlayContainer rootOverlay, FactoryHolder factoryHolder) {
        this.delegate = delegate;
        this.root = root;
        this.rootOverlay = rootOverlay;
        this.factoryHolder = factoryHolder;
    }

    @Override
    public Container getEnclosingContainer() {
        ArtifactContainer parent = this.delegate.getEnclosingContainer();
        if (parent != null) {
            if (this.delegate.isRoot()) {
                OverlayContainer newOverlay = this.rootOverlay.getParentOverlay();
                ArtifactContainer newDelegateContainer = this.delegate.getEnclosingContainer();
                AdaptableContainerImpl newRoot = new AdaptableContainerImpl(newDelegateContainer.getRoot(), newOverlay, this.factoryHolder);
                return new AdaptableContainerImpl(newDelegateContainer, newRoot, newOverlay, this.factoryHolder);
            }
            return new AdaptableContainerImpl(this.delegate.getEnclosingContainer(), this.root, this.rootOverlay, this.factoryHolder);
        }
        return null;
    }

    @Override
    public Container getRoot() {
        return this.root;
    }

    public Entry getEntryInEnclosingContainer() {
        ArtifactContainer parent = this.delegate.getEnclosingContainer();
        if (parent != null) {
            if (this.delegate.isRoot()) {
                OverlayContainer newOverlay = this.rootOverlay.getParentOverlay();
                ArtifactEntry newDelegateEntry = this.delegate.getEntryInEnclosingContainer();
                AdaptableContainerImpl newRoot = new AdaptableContainerImpl(newDelegateEntry.getRoot(), newOverlay, this.factoryHolder);
                return new AdaptableEntryImpl(newDelegateEntry, newRoot, newOverlay, this.factoryHolder);
            }
            return new AdaptableEntryImpl(this.delegate.getEntryInEnclosingContainer(), this.root, this.rootOverlay, this.factoryHolder);
        }
        return null;
    }

    @Override
    public Entry getEntry(String pathAndName) {
        ArtifactEntry entry = this.delegate.getEntry(pathAndName);
        if (entry != null) {
            return new AdaptableEntryImpl(entry, this.root, this.rootOverlay, this.factoryHolder);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public String getPath() {
        return this.delegate.getPath();
    }

    @Override
    public Collection<URL> getURLs() {
        return this.delegate.getURLs();
    }

    @Override
    @Deprecated
    public String getPhysicalPath() {
        return this.delegate.getPhysicalPath();
    }

    @Override
    public <T> T adapt(Class<T> adaptTarget) throws UnableToAdaptException {
        if (adaptTarget.equals(InterpretedContainer.class) && this.isRoot() && this.getEnclosingContainer() == null) {
            return (T)new InterpretedContainerImpl(this.delegate, this.rootOverlay, this.factoryHolder);
        }
        if (adaptTarget.equals(Entry.class)) {
            return (T)this.getEntryInEnclosingContainer();
        }
        if (adaptTarget.equals(Notifier.class)) {
            if (this.isRoot()) {
                if (this.notifier == null) {
                    this.notifier = new NotifierImpl(this.delegate, this);
                }
                return (T)this.notifier;
            }
            return (T)this.getRoot().adapt(Notifier.class);
        }
        T adapted = this.factoryHolder.getAdapterFactoryService().adapt(this.root, this.rootOverlay, this.delegate, this, adaptTarget);
        return adapted;
    }

    @Override
    public Iterator<Entry> iterator() {
        return new WrapperedIterator(this.delegate.iterator(), this.root, this.rootOverlay, this.factoryHolder);
    }

    @Override
    public boolean isRoot() {
        return this.delegate.isRoot();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" ( ");
        for (URL url : this.getURLs()) {
            sb.append(url).append(" ");
        }
        sb.append(")");
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.adaptable.module.internal.AdaptableContainerImpl", AdaptableContainerImpl.class, (String)"archive.adaptable", null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class WrapperedIterator
    implements Iterator<Entry> {
        private final Iterator<ArtifactEntry> delegateIter;
        private final Container root;
        private final OverlayContainer rootOverlay;
        private final FactoryHolder factoryHolder;
        static final long serialVersionUID = -9006075813972253708L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public WrapperedIterator(Iterator<ArtifactEntry> delegate, Container root, OverlayContainer rootOverlay, FactoryHolder factoryHolder) {
            this.delegateIter = delegate;
            this.root = root;
            this.rootOverlay = rootOverlay;
            this.factoryHolder = factoryHolder;
        }

        @Override
        public boolean hasNext() {
            return this.delegateIter.hasNext();
        }

        @Override
        public Entry next() {
            ArtifactEntry entry = this.delegateIter.next();
            if (entry != null) {
                return new AdaptableEntryImpl(entry, this.root, this.rootOverlay, this.factoryHolder);
            }
            return null;
        }

        @Override
        public void remove() {
            this.delegateIter.remove();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.adaptable.module.internal.AdaptableContainerImpl$WrapperedIterator", WrapperedIterator.class, (String)"archive.adaptable", null);
        }
    }
}

