/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.event;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.audit.AuditEvent;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SAFAuthorizationEvent
extends AuditEvent {
    private static final TraceComponent tc = Tr.register(SAFAuthorizationEvent.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    static final long serialVersionUID = 1244666217939083494L;

    public SAFAuthorizationEvent() {
        this.set("eventName", "SECURITY_SAF_AUTHZ");
        this.setInitiator((Map)AuditEvent.STD_INITIATOR.clone());
        this.setObserver((Map)AuditEvent.STD_OBSERVER.clone());
        this.setTarget((Map)AuditEvent.STD_TARGET.clone());
    }

    public SAFAuthorizationEvent(int safReturnCode, int racfReturnCode, int racfReasonCode, String userSecurityName, String applID, String safProfile, String safClass, Boolean authDecision, String principalName, String accessLevel, String errorMessage, String methodName) {
        this();
        AuditEvent.STD_TARGET.remove("target.typeURI");
        if (safReturnCode != -1) {
            this.set("target.saf.return.code", safReturnCode);
        }
        if (racfReturnCode != -1) {
            this.set("target.racf.return.code", racfReturnCode);
        }
        if (racfReasonCode != -1) {
            this.set("target.racf.reason.code", racfReasonCode);
        }
        if (userSecurityName != null) {
            this.set("target.user.security.name", userSecurityName);
        }
        if (applID != null) {
            this.set("target.applid", applID);
        }
        if (safProfile != null) {
            this.set("target.saf.profile", safProfile);
        }
        if (safClass != null) {
            this.set("target.saf.class", safClass);
        }
        if (authDecision != null) {
            if (authDecision.booleanValue()) {
                this.set("outcome", "success");
                this.set("target.authorization.decision", true);
            } else {
                this.set("outcome", "failure");
                this.set("target.authorization.decision", false);
            }
        }
        if (principalName != null) {
            this.set("target.credential.token", principalName);
        }
        if (accessLevel != null) {
            this.set("target.access.level", accessLevel);
        }
        if (errorMessage != null) {
            this.set("target.saf.error.message", errorMessage);
        }
        if (methodName != null) {
            this.set("target.method", methodName);
        }
    }
}

