/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.xpath.ldap.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.adapter.ldap.LdapConfigManager;
import com.ibm.ws.security.wim.adapter.ldap.LdapEntity;
import com.ibm.ws.security.wim.xpath.ParenthesisNode;
import com.ibm.ws.security.wim.xpath.mapping.datatype.LogicalNode;
import com.ibm.ws.security.wim.xpath.mapping.datatype.PropertyNode;
import com.ibm.ws.security.wim.xpath.mapping.datatype.XPathNode;
import com.ibm.ws.security.wim.xpath.util.XPathTranslateHelper;
import com.ibm.wsspi.security.wim.exception.PropertyNotDefinedException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.Group;
import com.ibm.wsspi.security.wim.model.Person;
import com.ibm.wsspi.security.wim.model.PersonAccount;
import java.util.Set;
import java.util.Stack;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LdapXPathTranslateHelper
implements XPathTranslateHelper {
    private LdapConfigManager ldapConfigMgr = null;
    private Set<String> entityTypes = null;
    private Stack<String> logOps = new Stack();
    private static final TraceComponent tc = Tr.register(LdapXPathTranslateHelper.class, (String)"ldapUtil", (String)"com.ibm.ws.security.wim.adapter.ldap.resources.LdapUtilMessages");
    static final long serialVersionUID = 4108825776165329562L;

    public LdapXPathTranslateHelper(Set<String> entityTypes, LdapConfigManager ldapCfgMgr) {
        this.entityTypes = entityTypes;
        this.ldapConfigMgr = ldapCfgMgr;
    }

    public void genSearchString(StringBuffer searchExpBuffer, XPathNode node) throws WIMException {
        switch (node.getNodeType()) {
            case 0: {
                this.genSearchString(searchExpBuffer, (PropertyNode)node);
                break;
            }
            case 2: {
                this.genSearchString(searchExpBuffer, (ParenthesisNode)node);
                break;
            }
            case 1: {
                this.genSearchString(searchExpBuffer, (LogicalNode)node);
                break;
            }
        }
    }

    private void genSearchString(StringBuffer searchExpBuffer, PropertyNode propNode) throws WIMException {
        String propName = propNode.getName();
        String ldapAttrName = null;
        String dataType = null;
        Set<String> attrs = this.ldapConfigMgr.getAttributeNames(this.entityTypes, propName);
        if (attrs.size() == 1) {
            ldapAttrName = (String)attrs.toArray()[0];
            Object value = null;
            for (String entityType : this.entityTypes) {
                Object entity = null;
                if (entityType != null) {
                    entity = entityType.equalsIgnoreCase("PersonAccount") || entityType.equalsIgnoreCase("LoginAccount") ? new PersonAccount() : (entityType.equalsIgnoreCase("Person") ? new Person() : (entityType.equalsIgnoreCase("Group") ? new Group() : new Entity()));
                    dataType = entity.getDataType(propName);
                }
                if (dataType != null) {
                    value = this.ldapConfigMgr.getLdapValue(propNode.getValue(), dataType, ldapAttrName);
                    continue;
                }
                throw new PropertyNotDefinedException("PROPERTY_NOT_DEFINED", Tr.formatMessage((TraceComponent)tc, (String)"PROPERTY_NOT_DEFINED", (Object[])WIMMessageHelper.generateMsgParms((Object)propName)));
            }
            short operator = this.ldapConfigMgr.getOperator(propNode.getOperator());
            value = this.ldapConfigMgr.escapeSpecialCharacters((String)value);
            Object[] arguments = new Object[]{ldapAttrName, value};
            String searchCondtion = this.ldapConfigMgr.CONDITION_FORMATS[operator].format(arguments);
            searchExpBuffer.append(searchCondtion);
        } else if (attrs.size() > 1) {
            searchExpBuffer.append("|");
            for (String entityType : this.entityTypes) {
                LdapEntity ldapEntity = this.ldapConfigMgr.getLdapEntity(entityType);
                ldapAttrName = this.ldapConfigMgr.getAttributeName(ldapEntity, propName);
                Object value = null;
                Object entity = null;
                if (entityType != null) {
                    entity = entityType.equalsIgnoreCase("PersonAccount") ? new PersonAccount() : (entityType.equalsIgnoreCase("Person") ? new Person() : (entityType.equalsIgnoreCase("Group") ? new Group() : new Entity()));
                    dataType = entity.getDataType(propName);
                }
                value = this.ldapConfigMgr.getLdapValue(propNode.getValue(), dataType, this.ldapConfigMgr.getSyntax(ldapAttrName));
                short operator = this.ldapConfigMgr.getOperator(propNode.getOperator());
                value = this.ldapConfigMgr.escapeSpecialCharacters((String)value);
                Object[] arguments = new Object[]{ldapAttrName, value};
                String searchCondtion = this.ldapConfigMgr.CONDITION_FORMATS[operator].format(arguments);
                searchExpBuffer.append("(");
                searchExpBuffer.append(searchCondtion);
                searchExpBuffer.append(")");
            }
        }
    }

    private void genSearchString(StringBuffer searchExpBuffer, LogicalNode logicalNode) throws WIMException {
        boolean write = false;
        if (this.logOps.isEmpty()) {
            write = true;
            this.logOps.push(logicalNode.getOperator());
        } else if (this.logOps.peek() != logicalNode.getOperator()) {
            write = true;
            this.logOps.push(logicalNode.getOperator());
        }
        if (write) {
            if (logicalNode.getOperator().equals("and")) {
                searchExpBuffer.append("(&");
            } else {
                searchExpBuffer.append("(|");
            }
        }
        this.genStringChild(searchExpBuffer, (XPathNode)logicalNode.getLeftChild());
        this.genStringChild(searchExpBuffer, (XPathNode)logicalNode.getRightChild());
        if (write) {
            searchExpBuffer.append(')');
            this.logOps.pop();
        }
    }

    private void genSearchString(StringBuffer searchExpBuffer, ParenthesisNode parenNode) throws WIMException {
        XPathNode child = (XPathNode)parenNode.getChild();
        this.genStringChild(searchExpBuffer, child);
    }

    private void genStringChild(StringBuffer searchExpBuffer, XPathNode child) throws WIMException {
        switch (child.getNodeType()) {
            case 0: {
                searchExpBuffer.append('(');
                this.genSearchString(searchExpBuffer, (PropertyNode)child);
                searchExpBuffer.append(')');
                break;
            }
            case 2: {
                this.genSearchString(searchExpBuffer, (ParenthesisNode)child);
                break;
            }
            case 1: {
                this.genSearchString(searchExpBuffer, (LogicalNode)child);
                break;
            }
        }
    }
}

