/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config13.sources;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.config.sources.DynamicConfigSource;
import com.ibm.ws.microprofile.config.sources.InternalConfigSource;
import com.ibm.ws.microprofile.config13.sources.OSGiConfigUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AppPropertyConfigSource
extends InternalConfigSource
implements DynamicConfigSource {
    private static final TraceComponent tc = Tr.register(AppPropertyConfigSource.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config13.resources.Config13");
    private BundleContext bundleContext;
    private String applicationName;
    private final ConfigAction configAction = new ConfigAction();
    static final long serialVersionUID = 979477667949199581L;

    public AppPropertyConfigSource() {
        super(600, Tr.formatMessage((TraceComponent)tc, (String)"server.xml.appproperties.config.source", (Object[])new Object[0]));
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        SortedSet<Configuration> osgiConfigs = null;
        osgiConfigs = System.getSecurityManager() == null ? this.getOSGiConfigurations() : AccessController.doPrivileged(this.configAction);
        if (osgiConfigs != null) {
            for (Configuration osgiConfig : osgiConfigs) {
                Dictionary dict = osgiConfig.getProperties();
                Enumeration keys = dict.keys();
                Object myKey = null;
                Object myValue = null;
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (key.equals("name")) {
                        myKey = dict.get(key);
                    }
                    if (key.equals("value")) {
                        myValue = dict.get(key);
                    }
                    if (myKey == null || myValue == null) continue;
                    props.put(myKey.toString(), myValue.toString());
                }
            }
        }
        return props;
    }

    private BundleContext getBundleContext() {
        if (this.bundleContext == null) {
            this.bundleContext = OSGiConfigUtils.getBundleContext(((Object)((Object)this)).getClass());
        }
        return this.bundleContext;
    }

    private String getApplicationName() {
        BundleContext bundleContext;
        if (this.applicationName == null && (bundleContext = this.getBundleContext()) != null) {
            this.applicationName = OSGiConfigUtils.getApplicationName(bundleContext);
        }
        return this.applicationName;
    }

    private SortedSet<Configuration> getOSGiConfigurations() {
        String applicationName;
        SortedSet<Configuration> osgiConfigs = null;
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext != null && (applicationName = this.getApplicationName()) != null) {
            osgiConfigs = OSGiConfigUtils.getConfigurations(bundleContext, applicationName);
        }
        return osgiConfigs;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class ConfigAction
    implements PrivilegedAction<SortedSet<Configuration>> {
        static final long serialVersionUID = 6353273727249235258L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ConfigAction() {
        }

        @Override
        public SortedSet<Configuration> run() {
            return AppPropertyConfigSource.this.getOSGiConfigurations();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.config13.sources.AppPropertyConfigSource$ConfigAction", ConfigAction.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config13.resources.Config13");
        }
    }
}

