/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.internal.ApplicationDependency;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.listeners.CompletionListener;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FutureCollectionCompletionListener
implements CompletionListener<Boolean> {
    private final CompletionListener<Boolean> completionListener;
    private final AtomicInteger completionCount;
    private final AtomicBoolean completionResult = new AtomicBoolean(true);
    static final long serialVersionUID = 511606809309418301L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static void newFutureCollectionCompletionListener(Collection<ApplicationDependency> futureConditions, CompletionListener<Boolean> newCL) {
        if (futureConditions.isEmpty()) {
            newCL.successfulCompletion(null, (Object)true);
        } else {
            FutureCollectionCompletionListener futureListener = new FutureCollectionCompletionListener(futureConditions.size(), newCL);
            futureListener.onCompletion(futureConditions);
        }
    }

    private FutureCollectionCompletionListener(int numDeps, CompletionListener<Boolean> completionListener) {
        assert (numDeps > 0);
        this.completionListener = completionListener;
        this.completionCount = new AtomicInteger(numDeps);
    }

    void onCompletion(Collection<ApplicationDependency> dependencies) {
        if (!dependencies.isEmpty()) {
            for (ApplicationDependency dependency : dependencies) {
                dependency.onCompletion(this);
            }
        }
    }

    public void successfulCompletion(Future<Boolean> future, Boolean result) {
        this.completionResult.compareAndSet(true, result);
        int count = this.completionCount.decrementAndGet();
        if (count == 0) {
            this.completionListener.successfulCompletion(null, (Object)this.completionResult.get());
        }
    }

    public void failedCompletion(Future<Boolean> future, Throwable t) {
        this.completionListener.failedCompletion(future, t);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(FutureCollectionCompletionListener.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.FutureCollectionCompletionListener");
    }
}

