/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import org.apache.yoko.orb.OB.CodeConverterBase;
import org.apache.yoko.orb.OB.CodeConverterImpl;
import org.apache.yoko.orb.OB.CodeConverterNone;
import org.apache.yoko.orb.OB.CodeSetInfo;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CORBA.CODESET_INCOMPATIBLE;

enum CodeSetDatabase {


    static CodeConverterBase getConverter(int to, int from) {
        CodeSetInfo toSet = CodeSetInfo.forRegistryId(to);
        CodeSetInfo fromSet = CodeSetInfo.forRegistryId(from);
        return CodeSetDatabase.getConverter(toSet, fromSet);
    }

    static CodeConverterBase getConverter(CodeSetInfo toSet, CodeSetInfo fromSet) {
        if (toSet != null && toSet == fromSet && toSet.max_bytes == 1) {
            return null;
        }
        CodeConverterBase converter = null;
        converter = fromSet == null || toSet == null ? new CodeConverterNone(fromSet, toSet) : new CodeConverterImpl(fromSet, toSet);
        return converter;
    }

    static int determineTCS(CodeSetComponent clientCS, CodeSetComponent serverCS, int fallback) {
        if (clientCS.native_code_set != 0 && serverCS.native_code_set != 0) {
            if (clientCS.native_code_set == serverCS.native_code_set) {
                return serverCS.native_code_set;
            }
            if (CodeSetDatabase.checkCodeSetId(clientCS, serverCS.native_code_set)) {
                return serverCS.native_code_set;
            }
            if (CodeSetDatabase.checkCodeSetId(serverCS, clientCS.native_code_set)) {
                return clientCS.native_code_set;
            }
        }
        for (int conversionCodeSet : serverCS.conversion_code_sets) {
            if (!CodeSetDatabase.checkCodeSetId(clientCS, conversionCodeSet)) continue;
            return conversionCodeSet;
        }
        if (clientCS.native_code_set != 0 && serverCS.native_code_set != 0 && CodeSetDatabase.isCompatible(clientCS.native_code_set, serverCS.native_code_set)) {
            return fallback;
        }
        throw new CODESET_INCOMPATIBLE();
    }

    private static boolean isCompatible(int id1, int id2) {
        CodeSetInfo cs1 = CodeSetInfo.forRegistryId(id1);
        if (cs1 == null) {
            return false;
        }
        CodeSetInfo cs2 = CodeSetInfo.forRegistryId(id2);
        return cs1.isCompatibleWith(cs2);
    }

    private static boolean checkCodeSetId(CodeSetComponent csc, int id) {
        for (int cs : csc.conversion_code_sets) {
            if (cs != id) continue;
            return true;
        }
        return false;
    }
}

