/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.OB.CodeConverterBase;
import org.apache.yoko.orb.OB.CodeConverters;
import org.apache.yoko.orb.OB.CodeSetDatabase;
import org.apache.yoko.orb.OB.CodeSetInfo;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CONV_FRAME.CodeSetComponentInfoHolder;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.CONV_FRAME.CodeSetContextHolder;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;

public final class CodeSetUtil {
    private static final List<CodeSetInfo> SUPPORTED_CHAR_CODESETS = Collections.unmodifiableList(CodeSetUtil.getSupportedCharCodeSets());
    private static final List<CodeSetInfo> SUPPORTED_WCHAR_CODESETS = Collections.unmodifiableList(Arrays.asList(CodeSetInfo.UTF_16));

    private static List<CodeSetInfo> getLocaleSpecificCodeSets() {
        String language;
        switch (language = Locale.getDefault().getLanguage()) {
            case "C": 
            case "POSIX": {
                return Arrays.asList(CodeSetInfo.ISO_LATIN_1);
            }
        }
        switch (language.substring(0, 2)) {
            case "de": 
            case "en": 
            case "fr": 
            case "nl": 
            case "pt": {
                return Arrays.asList(CodeSetInfo.ISO_LATIN_1);
            }
            case "da": 
            case "fi": 
            case "is": 
            case "no": 
            case "sv": {
                return Arrays.asList(CodeSetInfo.ISO_LATIN_4);
            }
            case "it": {
                return Arrays.asList(CodeSetInfo.ISO_LATIN_3);
            }
            case "cs": 
            case "hu": 
            case "pl": 
            case "sk": 
            case "sl": {
                return Arrays.asList(CodeSetInfo.ISO_LATIN_2);
            }
            case "el": {
                return Arrays.asList(CodeSetInfo.ISO_8859_7);
            }
            case "ru": {
                return Arrays.asList(CodeSetInfo.ISO_8859_5);
            }
            case "tr": {
                return Arrays.asList(CodeSetInfo.ISO_8859_9);
            }
        }
        return Collections.emptyList();
    }

    private static List<CodeSetInfo> getSupportedCharCodeSets() {
        ArrayList<CodeSetInfo> result = new ArrayList<CodeSetInfo>();
        result.addAll(CodeSetUtil.getLocaleSpecificCodeSets());
        result.add(CodeSetInfo.ISO_646_IRV);
        result.add(CodeSetInfo.UTF_8);
        return result;
    }

    static CodeSetComponent createCodeSetComponent(int id, boolean wChar) {
        CodeSetComponent codeSetComponent = new CodeSetComponent();
        codeSetComponent.native_code_set = id;
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (CodeSetInfo csi : wChar ? SUPPORTED_WCHAR_CODESETS : SUPPORTED_CHAR_CODESETS) {
            if (id == csi.id) continue;
            ids.add(csi.id);
        }
        codeSetComponent.conversion_code_sets = new int[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            codeSetComponent.conversion_code_sets[i] = (Integer)ids.get(i);
        }
        return codeSetComponent;
    }

    static boolean getCodeSetInfoFromComponents(ORBInstance orbInstance, ProfileInfo profileInfo, CodeSetComponentInfoHolder info) {
        if (profileInfo.major == 1 && profileInfo.minor > 0) {
            for (int i = 0; i < profileInfo.components.length; ++i) {
                if (!CodeSetUtil.checkForCodeSetInfo(profileInfo.components[i], info)) continue;
                return true;
            }
        } else if (orbInstance.extendedWchar()) {
            info.value = new CodeSetComponentInfo(new CodeSetComponent(CodeSetInfo.ISO_LATIN_1.id, new int[0]), new CodeSetComponent(CodeSetInfo.UCS_2.id, new int[0]));
            return true;
        }
        return false;
    }

    static CodeConverters getCodeConverters(ORBInstance orbInstance, ProfileInfo profileInfo) {
        CodeSetComponentInfoHolder serverInfo = new CodeSetComponentInfoHolder();
        serverInfo.value = new CodeSetComponentInfo();
        serverInfo.value.ForCharData = new CodeSetComponent();
        serverInfo.value.ForWcharData = new CodeSetComponent();
        serverInfo.value.ForCharData.native_code_set = CodeSetInfo.ISO_LATIN_1.id;
        serverInfo.value.ForCharData.conversion_code_sets = new int[0];
        serverInfo.value.ForWcharData.native_code_set = orbInstance.getDefaultWcs();
        serverInfo.value.ForWcharData.conversion_code_sets = new int[0];
        int nativeCs = orbInstance.getNativeCs();
        CodeSetComponent client_cs = CodeSetUtil.createCodeSetComponent(nativeCs, false);
        int tcs_c = CodeSetInfo.ISO_LATIN_1.id;
        int nativeWcs = orbInstance.getNativeWcs();
        CodeSetComponent client_wcs = CodeSetUtil.createCodeSetComponent(nativeWcs, true);
        int tcs_wc = orbInstance.getDefaultWcs();
        if (CodeSetUtil.getCodeSetInfoFromComponents(orbInstance, profileInfo, serverInfo)) {
            tcs_c = CodeSetDatabase.determineTCS(client_cs, serverInfo.value.ForCharData, CodeSetInfo.UTF_8.id);
            tcs_wc = CodeSetDatabase.determineTCS(client_wcs, serverInfo.value.ForWcharData, CodeSetInfo.UTF_16.id);
        }
        CodeConverterBase inputCharConverter = CodeSetDatabase.getConverter(nativeCs, tcs_c);
        CodeConverterBase outputCharConverter = CodeSetDatabase.getConverter(tcs_c, nativeCs);
        CodeConverterBase inputWcharConverter = CodeSetDatabase.getConverter(nativeWcs, tcs_wc);
        CodeConverterBase outputWcharConverter = CodeSetDatabase.getConverter(tcs_wc, nativeWcs);
        return new CodeConverters(inputCharConverter, outputCharConverter, inputWcharConverter, outputWcharConverter);
    }

    static boolean checkForCodeSetInfo(TaggedComponent comp, CodeSetComponentInfoHolder info) {
        if (comp.tag == 1) {
            InputStream in = new InputStream(comp.component_data);
            in._OB_readEndian();
            info.value = CodeSetComponentInfoHelper.read((org.omg.CORBA.portable.InputStream)in);
            return true;
        }
        return false;
    }

    static void extractCodeSetContext(ServiceContext context, CodeSetContextHolder ctx) {
        InputStream in = new InputStream(context.context_data);
        in._OB_readEndian();
        ctx.value = CodeSetContextHelper.read((org.omg.CORBA.portable.InputStream)in);
    }
}

