/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TAIUtil {
    private static final TraceComponent tc = Tr.register(TAIUtil.class, null, null);
    private boolean invokeBeforeSSO = false;
    private boolean invokeAfterSSO = false;
    private boolean addLtpaCookieToResponse = true;
    static final long serialVersionUID = 8892232367950365782L;

    public void processTAIUserFeatureProps(ConcurrentServiceReferenceMap<String, TrustAssociationInterceptor> interceptorServiceRef, String interceptorId) {
        this.invokeBeforeSSO = false;
        this.invokeAfterSSO = false;
        this.addLtpaCookieToResponse = true;
        ServiceReference taiServiceRef = interceptorServiceRef.getReference((Object)interceptorId);
        Object beforeSsoProp = taiServiceRef.getProperty("invokeBeforeSSO");
        Object afterSsoProp = taiServiceRef.getProperty("invokeAfterSSO");
        if (taiServiceRef.getProperty("addLTPACookieToResponse") != null) {
            this.addLtpaCookieToResponse = (Boolean)taiServiceRef.getProperty("addLTPACookieToResponse");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("user feature have properties,  beforeSsoProp=" + beforeSsoProp + " invokeAfterSSO=" + afterSsoProp + " addLtpaCookieToResponse=" + this.addLtpaCookieToResponse), (Object[])new Object[0]);
        }
        if (beforeSsoProp == null && afterSsoProp == null) {
            this.invokeAfterSSO = true;
        } else if (beforeSsoProp == null && afterSsoProp != null) {
            this.resolveOnlyInvokeAfterSSOSpecified(afterSsoProp);
        } else if (beforeSsoProp != null && afterSsoProp == null) {
            this.resolveOnlyInvokeBeforeSSOSpecified(beforeSsoProp);
        } else if (beforeSsoProp != null && afterSsoProp != null) {
            this.invokeBeforeSSO = (Boolean)beforeSsoProp;
            this.invokeAfterSSO = (Boolean)afterSsoProp;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("resolve user feature have,  invokeBeforeSSO=" + this.invokeBeforeSSO + " invokeAfterSSO=" + this.invokeAfterSSO + " addLtpaCookieToResponse=" + this.addLtpaCookieToResponse), (Object[])new Object[0]);
        }
    }

    protected void resolveOnlyInvokeBeforeSSOSpecified(Object beforeSSO) {
        this.invokeBeforeSSO = (Boolean)beforeSSO;
        if (!this.invokeBeforeSSO) {
            this.invokeAfterSSO = true;
        }
    }

    protected void resolveOnlyInvokeAfterSSOSpecified(Object afterSSO) {
        this.invokeAfterSSO = (Boolean)afterSSO;
        if (!this.invokeAfterSSO) {
            this.invokeBeforeSSO = true;
        }
    }

    public boolean isInvokeBeforeSSO() {
        return this.invokeBeforeSSO;
    }

    public boolean isInvokeAfterSSO() {
        return this.invokeAfterSSO;
    }

    public boolean addLtpaCookieToResponse() {
        return this.addLtpaCookieToResponse;
    }
}

