/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.jaxb.JAXBContextCache;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ModCountCopyOnWriteArrayList;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.databinding.AbstractDataBinding;
import org.apache.cxf.databinding.AbstractWrapperHelper;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.databinding.WrapperCapableDatabinding;
import org.apache.cxf.databinding.WrapperHelper;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxb.JAXBContextInitializer;
import org.apache.cxf.jaxb.JAXBSchemaInitializer;
import org.apache.cxf.jaxb.JAXBWrapperHelper;
import org.apache.cxf.jaxb.WrapperHelperCompiler;
import org.apache.cxf.jaxb.attachment.JAXBAttachmentSchemaValidationHack;
import org.apache.cxf.jaxb.io.DataReaderImpl;
import org.apache.cxf.jaxb.io.DataWriterImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.addressing.ObjectFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

@NoJSR250Annotations
@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class JAXBDataBinding
extends AbstractDataBinding
implements WrapperCapableDatabinding,
InterceptorProvider {
    public static final String SCHEMA_RESOURCE = "SCHEMRESOURCE";
    public static final String MTOM_THRESHOLD = "org.apache.cxf.jaxb.mtomThreshold";
    public static final String UNWRAP_JAXB_ELEMENT = "unwrap.jaxb.element";
    public static final String USE_JAXB_BRIDGE = "use.jaxb.bridge";
    private static final Logger LOG;
    private static final Class<?>[] SUPPORTED_READER_FORMATS;
    private static final Class<?>[] SUPPORTED_WRITER_FORMATS;
    private static final boolean ENABLE_MARSHALL_POOLING = true;
    private static final boolean ENABLE_UNMARSHALL_POOLING = true;
    private static final int MAX_LOAD_FACTOR = 50;
    private static final Map<String, DOMResult> BUILT_IN_SCHEMAS;
    Class<?>[] extraClass;
    JAXBContext context;
    Set<Class<?>> contextClasses;
    Collection<Object> typeRefs;
    Class<?> cls;
    private Map<String, Object> contextProperties;
    private Map<String, Object> marshallerProperties;
    private Map<String, Object> unmarshallerProperties;
    private Unmarshaller.Listener unmarshallerListener;
    private Marshaller.Listener marshallerListener;
    private ValidationEventHandler validationEventHandler;
    private boolean unwrapJAXBElement;
    private boolean qualifiedSchemas;
    private ModCountCopyOnWriteArrayList<Interceptor<? extends Message>> in;
    private ModCountCopyOnWriteArrayList<Interceptor<? extends Message>> out;
    private ModCountCopyOnWriteArrayList<Interceptor<? extends Message>> outFault;
    private ModCountCopyOnWriteArrayList<Interceptor<? extends Message>> inFault;
    private Deque<SoftReference<Marshaller>> marshallers;
    private Deque<SoftReference<Unmarshaller>> unmarshallers;
    static final long serialVersionUID = -4243786198142991399L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXBDataBinding() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "<init>", new Object[0]);
        }
        this.typeRefs = new ArrayList<Object>();
        this.contextProperties = Collections.emptyMap();
        this.marshallerProperties = Collections.emptyMap();
        this.unmarshallerProperties = Collections.emptyMap();
        this.unwrapJAXBElement = true;
        this.in = new ModCountCopyOnWriteArrayList();
        this.out = new ModCountCopyOnWriteArrayList();
        this.outFault = new ModCountCopyOnWriteArrayList();
        this.inFault = new ModCountCopyOnWriteArrayList();
        this.marshallers = new LinkedBlockingDeque<SoftReference<Marshaller>>(50);
        this.unmarshallers = new LinkedBlockingDeque<SoftReference<Unmarshaller>>(50);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXBDataBinding(boolean q) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "<init>", new Object[]{q});
        }
        this.typeRefs = new ArrayList<Object>();
        this.contextProperties = Collections.emptyMap();
        this.marshallerProperties = Collections.emptyMap();
        this.unmarshallerProperties = Collections.emptyMap();
        this.unwrapJAXBElement = true;
        this.in = new ModCountCopyOnWriteArrayList();
        this.out = new ModCountCopyOnWriteArrayList();
        this.outFault = new ModCountCopyOnWriteArrayList();
        this.inFault = new ModCountCopyOnWriteArrayList();
        this.marshallers = new LinkedBlockingDeque<SoftReference<Marshaller>>(50);
        this.unmarshallers = new LinkedBlockingDeque<SoftReference<Unmarshaller>>(50);
        this.qualifiedSchemas = q;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXBDataBinding(Class<?> ... classes) throws JAXBException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "<init>", new Object[]{classes});
        }
        this.typeRefs = new ArrayList<Object>();
        this.contextProperties = Collections.emptyMap();
        this.marshallerProperties = Collections.emptyMap();
        this.unmarshallerProperties = Collections.emptyMap();
        this.unwrapJAXBElement = true;
        this.in = new ModCountCopyOnWriteArrayList();
        this.out = new ModCountCopyOnWriteArrayList();
        this.outFault = new ModCountCopyOnWriteArrayList();
        this.inFault = new ModCountCopyOnWriteArrayList();
        this.marshallers = new LinkedBlockingDeque<SoftReference<Marshaller>>(50);
        this.unmarshallers = new LinkedBlockingDeque<SoftReference<Unmarshaller>>(50);
        this.contextClasses = new LinkedHashSet();
        this.contextClasses.addAll(Arrays.asList(classes));
        this.setContext(this.createJAXBContext(this.contextClasses));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXBDataBinding(ReflectionServiceFactoryBean b) throws JAXBException {
        this(b.isQualifyWrapperSchema());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "<init>", new Object[]{b});
        }
        Map props = b.getProperties();
        if (props != null && props.get("jaxb.additionalContextClasses") != null) {
            Object o = b.getProperties().get("jaxb.additionalContextClasses");
            if (o instanceof Class) {
                o = new Class[]{(Class)o};
            }
            this.extraClass = (Class[])o;
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXBDataBinding(JAXBContext context) {
        this();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "<init>", new Object[]{context});
        }
        this.setContext(context);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXBContext getContext() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getContext", new Object[0]);
        }
        JAXBContext jAXBContext = this.context;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            jAXBContext = jAXBContext;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getContext", jAXBContext);
        }
        return jAXBContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public final void setContext(JAXBContext ctx) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "setContext", new Object[]{ctx});
        }
        this.context = ctx;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "setContext");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> DataWriter<T> createWriter(Class<T> c) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "createWriter", new Object[]{c});
        }
        Integer mtomThresholdInt = new Integer(this.getMtomThreshold());
        if (c == XMLStreamWriter.class) {
            DataWriterImpl r = new DataWriterImpl(this);
            r.setMtomThreshold(mtomThresholdInt);
            DataWriterImpl dataWriterImpl = r;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                dataWriterImpl = dataWriterImpl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createWriter", dataWriterImpl);
            }
            return dataWriterImpl;
        }
        if (c == OutputStream.class) {
            DataWriterImpl r = new DataWriterImpl(this);
            r.setMtomThreshold(mtomThresholdInt);
            DataWriterImpl dataWriterImpl = r;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                dataWriterImpl = dataWriterImpl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createWriter", dataWriterImpl);
            }
            return dataWriterImpl;
        }
        if (c == XMLEventWriter.class) {
            DataWriterImpl r = new DataWriterImpl(this);
            r.setMtomThreshold(mtomThresholdInt);
            DataWriterImpl dataWriterImpl = r;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                dataWriterImpl = dataWriterImpl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createWriter", dataWriterImpl);
            }
            return dataWriterImpl;
        }
        if (c == Node.class) {
            DataWriterImpl r = new DataWriterImpl(this);
            r.setMtomThreshold(mtomThresholdInt);
            DataWriterImpl dataWriterImpl = r;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                dataWriterImpl = dataWriterImpl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createWriter", dataWriterImpl);
            }
            return dataWriterImpl;
        }
        DataWriter<T> dataWriter = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            dataWriter = dataWriter;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createWriter", dataWriter);
        }
        return dataWriter;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Class<?>[] getSupportedWriterFormats() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getSupportedWriterFormats", new Object[0]);
        }
        Class<?>[] classArray = SUPPORTED_WRITER_FORMATS;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            classArray = classArray;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getSupportedWriterFormats", classArray);
        }
        return classArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> DataReader<T> createReader(Class<T> c) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "createReader", new Object[]{c});
        }
        DataReaderImpl dr = null;
        if (c == XMLStreamReader.class) {
            dr = new DataReaderImpl(this, this.unwrapJAXBElement);
        } else if (c == XMLEventReader.class) {
            dr = new DataReaderImpl(this, this.unwrapJAXBElement);
        } else if (c == Node.class) {
            dr = new DataReaderImpl(this, this.unwrapJAXBElement);
        }
        DataReaderImpl dataReaderImpl = dr;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            dataReaderImpl = dataReaderImpl;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createReader", dataReaderImpl);
        }
        return dataReaderImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Class<?>[] getSupportedReaderFormats() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getSupportedReaderFormats", new Object[0]);
        }
        Class<?>[] classArray = SUPPORTED_READER_FORMATS;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            classArray = classArray;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getSupportedReaderFormats", classArray);
        }
        return classArray;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void initialize(Service service) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "initialize", new Object[]{service});
        }
        this.in.addIfAbsent((Object)JAXBAttachmentSchemaValidationHack.INSTANCE);
        this.inFault.addIfAbsent((Object)JAXBAttachmentSchemaValidationHack.INSTANCE);
        if (this.context != null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "initialize");
            }
            return;
        }
        this.contextClasses = new LinkedHashSet();
        for (ServiceInfo serviceInfo : service.getServiceInfos()) {
            JAXBContextInitializer initializer = new JAXBContextInitializer(serviceInfo, this.contextClasses, this.typeRefs);
            initializer.walk();
            if (serviceInfo.getProperty("extra.class") == null) continue;
            Set exClasses = (Set)serviceInfo.getProperty("extra.class", Set.class);
            this.contextClasses.addAll(exClasses);
        }
        String tns = this.getNamespaceToUse(service);
        JAXBContextCache.CachedContextAndSchemas cachedContextAndSchemas = null;
        JAXBContext ctx = null;
        try {
            cachedContextAndSchemas = this.createJAXBContextAndSchemas(this.contextClasses, tns);
        }
        catch (JAXBException e1) {
            throw new ServiceConstructionException((Throwable)e1);
        }
        ctx = cachedContextAndSchemas.getContext();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "CREATED_JAXB_CONTEXT", new Object[]{ctx, this.contextClasses});
        }
        this.setContext(ctx);
        for (ServiceInfo serviceInfo : service.getServiceInfos()) {
            void var12_14;
            SchemaCollection col = serviceInfo.getXmlSchemaCollection();
            if (col.getXmlSchemas().length > 1) continue;
            boolean schemasFromCache = false;
            Collection<DOMSource> schemas = this.getSchemas();
            if (schemas == null || schemas.size() == 0) {
                schemas = cachedContextAndSchemas.getSchemas();
                if (schemas != null) {
                    schemasFromCache = true;
                }
            } else {
                schemasFromCache = true;
            }
            LinkedHashSet<DOMSource> bi = new LinkedHashSet<DOMSource>();
            if (schemas == null) {
                schemas = new LinkedHashSet<DOMSource>();
                try {
                    for (DOMResult dOMResult : this.generateJaxbSchemas()) {
                        DOMSource src = new DOMSource(dOMResult.getNode(), dOMResult.getSystemId());
                        if (BUILT_IN_SCHEMAS.containsValue(dOMResult)) {
                            bi.add(src);
                            continue;
                        }
                        schemas.add(src);
                    }
                    schemas.addAll(bi);
                }
                catch (IOException e) {
                    throw new ServiceConstructionException("SCHEMA_GEN_EXC", LOG, (Throwable)e);
                }
            }
            HashSet<String> ids = new HashSet<String>();
            for (DOMSource r3 : schemas) {
                ids.add(r3.getSystemId());
            }
            for (DOMSource r : schemas) {
                String ns;
                if (bi.contains(r) && serviceInfo.getSchema(ns = ((Document)r.getNode()).getDocumentElement().getAttribute("targetNamespace")) != null) continue;
                this.addSchemaDocument(serviceInfo, col, (Document)r.getNode(), r.getSystemId());
            }
            if (this.context.getClass().getName().contains("com.sun.xml.")) {
                JAXBContext jAXBContext = this.context;
            } else {
                try {
                    JAXBContext jAXBContext = JAXBUtils.createRIContext((Class[])this.contextClasses.toArray(new Class[this.contextClasses.size()]), (String)tns);
                }
                catch (JAXBException e) {
                    throw new ServiceConstructionException((Throwable)e);
                }
            }
            JAXBSchemaInitializer schemaInit = new JAXBSchemaInitializer(serviceInfo, col, (JAXBContext)var12_14, this.qualifiedSchemas);
            schemaInit.walk();
            if (cachedContextAndSchemas == null || schemasFromCache) continue;
            cachedContextAndSchemas.setSchemas(schemas);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "initialize");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getNamespaceToUse(Service service) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getNamespaceToUse", new Object[]{service});
        }
        if ("true".equals(service.get((Object)"org.apache.cxf.databinding.namespace"))) {
            String string = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getNamespaceToUse", string);
            }
            return string;
        }
        String tns = null;
        tns = service.getServiceInfos().size() > 0 ? ((ServiceInfo)service.getServiceInfos().get(0)).getInterface().getName().getNamespaceURI() : service.getName().getNamespaceURI();
        String string = tns;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getNamespaceToUse", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setExtraClass(Class<?>[] userExtraClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "setExtraClass", new Object[]{userExtraClass});
        }
        this.extraClass = userExtraClass;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "setExtraClass");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Class<?>[] getExtraClass() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getExtraClass", new Object[0]);
        }
        Class<?>[] classArray = this.extraClass;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            classArray = classArray;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getExtraClass", classArray);
        }
        return classArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    List<DOMResult> generateJaxbSchemas() throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "generateJaxbSchemas", new Object[0]);
        }
        List list = JAXBUtils.generateJaxbSchemas((JAXBContext)this.context, BUILT_IN_SCHEMAS);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "generateJaxbSchemas", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXBContext createJAXBContext(Set<Class<?>> classes) throws JAXBException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "createJAXBContext", new Object[]{classes});
        }
        JAXBContext jAXBContext = this.createJAXBContext(classes, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            jAXBContext = jAXBContext;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createJAXBContext", jAXBContext);
        }
        return jAXBContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXBContext createJAXBContext(Set<Class<?>> classes, String defaultNs) throws JAXBException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "createJAXBContext", new Object[]{classes, defaultNs});
        }
        JAXBContext jAXBContext = this.createJAXBContextAndSchemas(classes, defaultNs).getContext();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            jAXBContext = jAXBContext;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createJAXBContext", jAXBContext);
        }
        return jAXBContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXBContextCache.CachedContextAndSchemas createJAXBContextAndSchemas(Set<Class<?>> classes, String defaultNs) throws JAXBException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "createJAXBContextAndSchemas", new Object[]{classes, defaultNs});
        }
        if (this.extraClass != null && this.extraClass.length > 0) {
            for (Class<?> clz : this.extraClass) {
                classes.add(clz);
            }
        }
        JAXBContextCache.scanPackages(classes);
        this.addWsAddressingTypes(classes);
        JAXBContextCache.CachedContextAndSchemas cachedContextAndSchemas = JAXBContextCache.getCachedContextAndSchemas(classes, (String)defaultNs, this.contextProperties, this.typeRefs, (boolean)true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            cachedContextAndSchemas = cachedContextAndSchemas;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createJAXBContextAndSchemas", cachedContextAndSchemas);
        }
        return cachedContextAndSchemas;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addWsAddressingTypes(Set<Class<?>> classes) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "addWsAddressingTypes", new Object[]{classes});
        }
        if (classes.contains(ObjectFactory.class)) {
            try {
                classes.add(Class.forName("org.apache.cxf.ws.addressing.wsdl.ObjectFactory"));
                classes.add(Class.forName("org.apache.cxf.ws.addressing.wsdl.AttributedQNameType"));
                classes.add(Class.forName("org.apache.cxf.ws.addressing.wsdl.ServiceNameType"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "addWsAddressingTypes");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<Class<?>> getContextClasses() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getContextClasses", new Object[0]);
        }
        Set<Class<?>> set = Collections.unmodifiableSet(this.contextClasses);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            set = set;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getContextClasses", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Object> getContextProperties() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getContextProperties", new Object[0]);
        }
        Map<String, Object> map = this.contextProperties;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            map = map;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getContextProperties", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setContextProperties(Map<String, Object> contextProperties) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "setContextProperties", new Object[]{contextProperties});
        }
        this.contextProperties = contextProperties;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "setContextProperties");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Object> getMarshallerProperties() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getMarshallerProperties", new Object[0]);
        }
        Map<String, Object> map = this.marshallerProperties;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            map = map;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getMarshallerProperties", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setMarshallerProperties(Map<String, Object> marshallerProperties) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "setMarshallerProperties", new Object[]{marshallerProperties});
        }
        this.marshallerProperties = marshallerProperties;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "setMarshallerProperties");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Object> getUnmarshallerProperties() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getUnmarshallerProperties", new Object[0]);
        }
        Map<String, Object> map = this.unmarshallerProperties;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            map = map;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getUnmarshallerProperties", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setUnmarshallerProperties(Map<String, Object> unmarshallerProperties) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "setUnmarshallerProperties", new Object[]{unmarshallerProperties});
        }
        this.unmarshallerProperties = unmarshallerProperties;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "setUnmarshallerProperties");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Unmarshaller.Listener getUnmarshallerListener() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getUnmarshallerListener", new Object[0]);
        }
        Unmarshaller.Listener listener = this.unmarshallerListener;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            listener = listener;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getUnmarshallerListener", listener);
        }
        return listener;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setUnmarshallerListener(Unmarshaller.Listener unmarshallerListener) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "setUnmarshallerListener", new Object[]{unmarshallerListener});
        }
        this.unmarshallerListener = unmarshallerListener;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "setUnmarshallerListener");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Marshaller.Listener getMarshallerListener() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getMarshallerListener", new Object[0]);
        }
        Marshaller.Listener listener = this.marshallerListener;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            listener = listener;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getMarshallerListener", listener);
        }
        return listener;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setMarshallerListener(Marshaller.Listener marshallerListener) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "setMarshallerListener", new Object[]{marshallerListener});
        }
        this.marshallerListener = marshallerListener;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "setMarshallerListener");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ValidationEventHandler getValidationEventHandler() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getValidationEventHandler", new Object[0]);
        }
        ValidationEventHandler validationEventHandler = this.validationEventHandler;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            validationEventHandler = validationEventHandler;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getValidationEventHandler", validationEventHandler);
        }
        return validationEventHandler;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "setValidationEventHandler", new Object[]{validationEventHandler});
        }
        this.validationEventHandler = validationEventHandler;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "setValidationEventHandler");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isUnwrapJAXBElement() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "isUnwrapJAXBElement", new Object[0]);
        }
        boolean bl = this.unwrapJAXBElement;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "isUnwrapJAXBElement", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setUnwrapJAXBElement(boolean unwrapJAXBElement) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "setUnwrapJAXBElement", new Object[]{unwrapJAXBElement});
        }
        this.unwrapJAXBElement = unwrapJAXBElement;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "setUnwrapJAXBElement");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WrapperHelper createWrapperHelper(Class<?> wrapperType, QName wrapperName, List<String> partNames, List<String> elTypeNames, List<Class<?>> partClasses) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "createWrapperHelper", new Object[]{wrapperType, wrapperName, partNames, elTypeNames, partClasses});
        }
        ArrayList<Method> getMethods = new ArrayList<Method>(partNames.size());
        ArrayList<Method> setMethods = new ArrayList<Method>(partNames.size());
        ArrayList<Method> jaxbMethods = new ArrayList<Method>(partNames.size());
        ArrayList<Field> fields = new ArrayList<Field>(partNames.size());
        Method[] allMethods = wrapperType.getMethods();
        String packageName = PackageUtils.getPackageName(wrapperType);
        if (wrapperType.getPackage() != null) {
            packageName = wrapperType.getPackage().getName();
        }
        String objectFactoryClassName = packageName + ".ObjectFactory";
        Object objectFactory = null;
        try {
            objectFactory = wrapperType.getClassLoader().loadClass(objectFactoryClassName).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Method[] allOFMethods = objectFactory != null ? objectFactory.getClass().getMethods() : new Method[]{};
        for (int x = 0; x < partNames.size(); ++x) {
            String partName = partNames.get(x);
            if (partName == null) {
                getMethods.add(null);
                setMethods.add(null);
                fields.add(null);
                jaxbMethods.add(null);
                continue;
            }
            String elementType = elTypeNames.get(x);
            String getAccessor = JAXBUtils.nameToIdentifier((String)partName, (JAXBUtils.IdentifierType)JAXBUtils.IdentifierType.GETTER);
            String setAccessor = JAXBUtils.nameToIdentifier((String)partName, (JAXBUtils.IdentifierType)JAXBUtils.IdentifierType.SETTER);
            Method getMethod = null;
            Method setMethod = null;
            Class<?> valueClass = wrapperType;
            try {
                getMethod = valueClass.getMethod(getAccessor, AbstractWrapperHelper.NO_CLASSES);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            Field elField = JAXBDataBinding.getElField(partName, valueClass);
            if (getMethod == null && elementType != null && "boolean".equals(elementType.toLowerCase()) && (elField == null || !Collection.class.isAssignableFrom(elField.getType()) && !elField.getType().isArray())) {
                try {
                    String newAcc = getAccessor.replaceFirst("get", "is");
                    getMethod = wrapperType.getMethod(newAcc, AbstractWrapperHelper.NO_CLASSES);
                }
                catch (NoSuchMethodException newAcc) {
                    // empty catch block
                }
            }
            if (getMethod == null && "return".equals(partName)) {
                try {
                    getMethod = valueClass.getMethod("get_return", AbstractWrapperHelper.NO_CLASSES);
                }
                catch (NoSuchMethodException ex) {
                    try {
                        getMethod = valueClass.getMethod("is_return", new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            if (getMethod == null && elField != null) {
                getAccessor = JAXBUtils.nameToIdentifier((String)elField.getName(), (JAXBUtils.IdentifierType)JAXBUtils.IdentifierType.GETTER);
                setAccessor = JAXBUtils.nameToIdentifier((String)elField.getName(), (JAXBUtils.IdentifierType)JAXBUtils.IdentifierType.SETTER);
                try {
                    getMethod = valueClass.getMethod(getAccessor, AbstractWrapperHelper.NO_CLASSES);
                }
                catch (NoSuchMethodException ex) {
                    // empty catch block
                }
            }
            String setAccessor2 = setAccessor;
            if ("return".equals(partName)) {
                setAccessor2 = "set_return";
            }
            for (Method method : allMethods) {
                if (method.getParameterTypes() == null || method.getParameterTypes().length != 1 || !setAccessor.equals(method.getName()) && !setAccessor2.equals(method.getName())) continue;
                setMethod = method;
                break;
            }
            getMethods.add(getMethod);
            setMethods.add(setMethod);
            if (setMethod != null && JAXBElement.class.isAssignableFrom(setMethod.getParameterTypes()[0])) {
                Type t = setMethod.getGenericParameterTypes()[0];
                Class pcls = null;
                if (t instanceof ParameterizedType) {
                    t = ((ParameterizedType)t).getActualTypeArguments()[0];
                }
                if (t instanceof Class) {
                    pcls = (Class)t;
                }
                String methodName = "create" + wrapperType.getSimpleName() + setMethod.getName().substring(3);
                for (Method m : allOFMethods) {
                    if (!m.getName().equals(methodName) || m.getParameterTypes().length != 1 || pcls != null && !pcls.equals(m.getParameterTypes()[0])) continue;
                    jaxbMethods.add(m);
                }
            } else {
                jaxbMethods.add(null);
            }
            if (elField != null) {
                XmlElement el = elField.getAnnotation(XmlElement.class);
                if (el != null && (partName.equals(el.name()) || "##default".equals(el.name()))) {
                    ReflectionUtil.setAccessible((AccessibleObject)elField);
                    fields.add(elField);
                    continue;
                }
                if (getMethod == null && setMethod == null) {
                    if (el != null) {
                        LOG.warning("Could not create accessor for property " + partName + " of type " + wrapperType.getName() + " as the @XmlElement defines the name as " + el.name());
                    } else {
                        LOG.warning("Could not create accessor for property " + partName + " of type " + wrapperType.getName());
                    }
                }
                fields.add(null);
                continue;
            }
            fields.add(null);
        }
        WrapperHelper wrapperHelper = JAXBDataBinding.createWrapperHelper(wrapperType, setMethods.toArray(new Method[setMethods.size()]), getMethods.toArray(new Method[getMethods.size()]), jaxbMethods.toArray(new Method[jaxbMethods.size()]), fields.toArray(new Field[fields.size()]), objectFactory);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            wrapperHelper = wrapperHelper;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createWrapperHelper", wrapperHelper);
        }
        return wrapperHelper;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Field getElField(String partName, Class<?> wrapperType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getElField", new Object[]{partName, wrapperType});
        }
        String fieldName = JAXBUtils.nameToIdentifier((String)partName, (JAXBUtils.IdentifierType)JAXBUtils.IdentifierType.VARIABLE);
        for (Field field : wrapperType.getDeclaredFields()) {
            XmlElement el = field.getAnnotation(XmlElement.class);
            if (el != null && partName.equals(el.name())) {
                Field field2 = field;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    field2 = field2;
                    LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getElField", field2);
                }
                return field2;
            }
            if (!field.getName().equals(fieldName)) continue;
            Field field3 = field;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                field3 = field3;
                LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getElField", field3);
            }
            return field3;
        }
        Field field = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            field = field;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getElField", field);
        }
        return field;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static WrapperHelper createWrapperHelper(Class<?> wrapperType, Method[] setMethods, Method[] getMethods, Method[] jaxbMethods, Field[] fields, Object objectFactory) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "createWrapperHelper", new Object[]{wrapperType, setMethods, getMethods, jaxbMethods, fields, objectFactory});
        }
        Object wh = JAXBDataBinding.compileWrapperHelper(wrapperType, setMethods, getMethods, jaxbMethods, fields, objectFactory);
        if (wh == null) {
            wh = new JAXBWrapperHelper(wrapperType, setMethods, getMethods, jaxbMethods, fields, objectFactory);
        }
        WrapperHelper wrapperHelper = wh;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            wrapperHelper = wrapperHelper;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "createWrapperHelper", wrapperHelper);
        }
        return wrapperHelper;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static WrapperHelper compileWrapperHelper(Class<?> wrapperType, Method[] setMethods, Method[] getMethods, Method[] jaxbMethods, Field[] fields, Object objectFactory) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "compileWrapperHelper", new Object[]{wrapperType, setMethods, getMethods, jaxbMethods, fields, objectFactory});
        }
        WrapperHelper wrapperHelper = WrapperHelperCompiler.compileWrapperHelper(wrapperType, setMethods, getMethods, jaxbMethods, fields, objectFactory);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            wrapperHelper = wrapperHelper;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "compileWrapperHelper", wrapperHelper);
        }
        return wrapperHelper;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Interceptor<? extends Message>> getOutFaultInterceptors() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getOutFaultInterceptors", new Object[0]);
        }
        ModCountCopyOnWriteArrayList<Interceptor<? extends Message>> modCountCopyOnWriteArrayList = this.outFault;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            modCountCopyOnWriteArrayList = modCountCopyOnWriteArrayList;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getOutFaultInterceptors", modCountCopyOnWriteArrayList);
        }
        return modCountCopyOnWriteArrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Interceptor<? extends Message>> getInFaultInterceptors() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getInFaultInterceptors", new Object[0]);
        }
        ModCountCopyOnWriteArrayList<Interceptor<? extends Message>> modCountCopyOnWriteArrayList = this.inFault;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            modCountCopyOnWriteArrayList = modCountCopyOnWriteArrayList;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getInFaultInterceptors", modCountCopyOnWriteArrayList);
        }
        return modCountCopyOnWriteArrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Interceptor<? extends Message>> getInInterceptors() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getInInterceptors", new Object[0]);
        }
        ModCountCopyOnWriteArrayList<Interceptor<? extends Message>> modCountCopyOnWriteArrayList = this.in;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            modCountCopyOnWriteArrayList = modCountCopyOnWriteArrayList;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getInInterceptors", modCountCopyOnWriteArrayList);
        }
        return modCountCopyOnWriteArrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Interceptor<? extends Message>> getOutInterceptors() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getOutInterceptors", new Object[0]);
        }
        ModCountCopyOnWriteArrayList<Interceptor<? extends Message>> modCountCopyOnWriteArrayList = this.out;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            modCountCopyOnWriteArrayList = modCountCopyOnWriteArrayList;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getOutInterceptors", modCountCopyOnWriteArrayList);
        }
        return modCountCopyOnWriteArrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void releaseJAXBMarshaller(Marshaller marshaller) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "releaseJAXBMarshaller", new Object[]{marshaller});
        }
        if (marshaller != null) {
            this.marshallers.offerFirst(new SoftReference<Marshaller>(marshaller));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "releaseJAXBMarshaller");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Marshaller getJAXBMarshaller() throws JAXBException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getJAXBMarshaller", new Object[0]);
        }
        Marshaller m = null;
        SoftReference<Marshaller> ref = this.marshallers.poll();
        while (ref != null && ref.get() == null) {
            ref = this.marshallers.poll();
        }
        if (ref != null) {
            m = ref.get();
        }
        if (m == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Marshaller created [not in pool]");
            }
            m = this.getContext().createMarshaller();
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Marshaller obtained [from  pool]");
        }
        Marshaller marshaller = m;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            marshaller = marshaller;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getJAXBMarshaller", marshaller);
        }
        return marshaller;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Unmarshaller getJAXBUnmarshaller() throws JAXBException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "getJAXBUnmarshaller", new Object[0]);
        }
        Unmarshaller unm = null;
        SoftReference<Unmarshaller> ref = this.unmarshallers.poll();
        while (ref != null && ref.get() == null) {
            ref = this.unmarshallers.poll();
        }
        if (ref != null) {
            unm = ref.get();
        }
        if (unm == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Unmarshaller created [not in pool]");
            }
            unm = this.getContext().createUnmarshaller();
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Unmarshaller obtained [from  pool]");
        }
        Unmarshaller unmarshaller = unm;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            unmarshaller = unmarshaller;
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "getJAXBUnmarshaller", unmarshaller);
        }
        return unmarshaller;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void releaseJAXBUnmarshaller(Unmarshaller unmarshaller) {
        block6: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxb.JAXBDataBinding", "releaseJAXBUnmarshaller", new Object[]{unmarshaller});
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Unmarshaller placed back into pool");
            }
            if (unmarshaller != null) {
                try {
                    this.unmarshallers.offerFirst(new SoftReference<Unmarshaller>(unmarshaller));
                }
                catch (Throwable t) {
                    if (!LOG.isLoggable(Level.FINE)) break block6;
                    LOG.fine("The following exception is ignored. Processing continues " + t);
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBDataBinding", "releaseJAXBUnmarshaller");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        DelayedDOMResult dr2;
        LOG = LogUtils.getLogger(JAXBDataBinding.class);
        SUPPORTED_READER_FORMATS = new Class[]{Node.class, XMLEventReader.class, XMLStreamReader.class};
        SUPPORTED_WRITER_FORMATS = new Class[]{OutputStream.class, Node.class, XMLEventWriter.class, XMLStreamWriter.class};
        BUILT_IN_SCHEMAS = new HashMap<String, DOMResult>();
        URIResolver resolver = new URIResolver();
        try {
            resolver.resolve("", "classpath:/schemas/wsdl/ws-addr-wsdl.xsd", JAXBDataBinding.class);
            if (resolver.isResolved()) {
                resolver.getInputStream().close();
                dr2 = new DelayedDOMResult(resolver.getURL(), "classpath:/schemas/wsdl/ws-addr-wsdl.xsd", "http://www.w3.org/2005/02/addressing/wsdl");
                BUILT_IN_SCHEMAS.put("http://www.w3.org/2005/02/addressing/wsdl", dr2);
                resolver.unresolve();
            }
        }
        catch (Exception dr2) {
            // empty catch block
        }
        try {
            resolver.resolve("", "classpath:/schemas/wsdl/ws-addr.xsd", JAXBDataBinding.class);
            if (resolver.isResolved()) {
                resolver.getInputStream().close();
                dr2 = new DelayedDOMResult(resolver.getURL(), "classpath:/schemas/wsdl/ws-addr.xsd", "http://www.w3.org/2005/08/addressing");
                BUILT_IN_SCHEMAS.put("http://www.w3.org/2005/08/addressing", dr2);
                resolver.unresolve();
            }
        }
        catch (Exception dr3) {
            // empty catch block
        }
        try {
            resolver.resolve("", "classpath:/schemas/wsdl/wsrm.xsd", JAXBDataBinding.class);
            if (resolver.isResolved()) {
                resolver.getInputStream().close();
                dr2 = new DelayedDOMResult(resolver.getURL(), "classpath:/schemas/wsdl/wsrm.xsd", "http://schemas.xmlsoap.org/ws/2005/02/rm");
                BUILT_IN_SCHEMAS.put("http://schemas.xmlsoap.org/ws/2005/02/rm", dr2);
                resolver.unresolve();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class DelayedDOMResult
    extends DOMResult {
        private final URL resource;
        private final String publicId;
        static final long serialVersionUID = 6111905522690593176L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public DelayedDOMResult(URL url, String sysId, String pId) {
            super(null, sysId);
            this.resource = url;
            this.publicId = pId;
        }

        @Override
        public synchronized Node getNode() {
            Node nd = super.getNode();
            if (nd == null) {
                try {
                    InputSource src = new InputSource(this.resource.openStream());
                    src.setSystemId(this.getSystemId());
                    src.setPublicId(this.publicId);
                    Document doc = StaxUtils.read((InputSource)src);
                    this.setNode(doc);
                    nd = super.getNode();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            return nd;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxb.JAXBDataBinding$DelayedDOMResult", DelayedDOMResult.class, null, null);
        }
    }
}

