/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.impl;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.impl.DatabaseHelper;
import com.ibm.ws.rsadapter.impl.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.resource.ResourceException;

public class PostgreSQLHelper
extends DatabaseHelper {
    private static final TraceComponent tc = com.ibm.websphere.ras.Tr.register(PostgreSQLHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final String PROP_DEFAULT_FETCH_SIZE = "DefaultFetchSize";
    private static final String PROP_PREPARE_THRESHOLD = "PrepareThreshold";
    private static final String PROP_AUTOSAVE = "AutoSave";
    private transient com.ibm.ejs.ras.TraceComponent jdbcTC = Tr.register((String)"com.ibm.ws.postgresql.logwriter", (String)"WAS.database", null);
    private transient PrintWriter jdbcTraceWriter;
    private Class<?> Autosave;
    private Class<?> LargeObjectManager;
    private Class<?> BaseConnection;

    PostgreSQLHelper(WSManagedConnectionFactoryImpl mcf) throws ClassNotFoundException {
        super(mcf);
    }

    @Override
    public Object getLargeObjectAPI(Connection con) throws SQLException {
        try {
            if (this.LargeObjectManager == null || this.BaseConnection == null) {
                this.LargeObjectManager = WSManagedConnectionFactoryImpl.priv.loadClass(this.mcf.jdbcDriverLoader, "org.postgresql.largeobject.LargeObjectManager");
                this.BaseConnection = WSManagedConnectionFactoryImpl.priv.loadClass(this.mcf.jdbcDriverLoader, "org.postgresql.core.BaseConnection");
            }
            Object selfProxy = con.unwrap(this.BaseConnection);
            return this.LargeObjectManager.getConstructor(this.BaseConnection).newInstance(selfProxy);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Map<String, Object> cacheVendorConnectionProps(Connection connImpl) throws SQLException {
        try {
            if (this.Autosave == null) {
                this.Autosave = WSManagedConnectionFactoryImpl.priv.loadClass(this.mcf.jdbcDriverLoader, "org.postgresql.jdbc.AutoSave");
            }
            Class<?> PGConnection = connImpl.getClass();
            HashMap<String, Object> defaultProps = new HashMap<String, Object>(2);
            defaultProps.put(PROP_DEFAULT_FETCH_SIZE, PGConnection.getMethod("getDefaultFetchSize", new Class[0]).invoke((Object)connImpl, new Object[0]));
            defaultProps.put(PROP_PREPARE_THRESHOLD, PGConnection.getMethod("getPrepareThreshold", new Class[0]).invoke((Object)connImpl, new Object[0]));
            defaultProps.put(PROP_AUTOSAVE, PGConnection.getMethod("getAutosave", new Class[0]).invoke((Object)connImpl, new Object[0]));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((TraceComponent)tc, (String)("Got initial PGConnection vendor-specific property defaults: " + defaultProps), (Object[])new Object[0]);
            }
            return defaultProps;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw AdapterUtil.toSQLException(x);
        }
    }

    @Override
    public boolean doConnectionVendorPropertyReset(Connection connImpl, Map<String, Object> props) throws SQLException {
        try {
            if (this.Autosave == null) {
                this.Autosave = WSManagedConnectionFactoryImpl.priv.loadClass(this.mcf.jdbcDriverLoader, "org.postgresql.jdbc.AutoSave");
            }
            Class<?> PGConnection = connImpl.getClass();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((TraceComponent)tc, (String)("Resetting PGConnection vendor-specific properties to defaults: " + props), (Object[])new Object[0]);
            }
            PGConnection.getMethod("setDefaultFetchSize", Integer.TYPE).invoke((Object)connImpl, props.get(PROP_DEFAULT_FETCH_SIZE));
            PGConnection.getMethod("setPrepareThreshold", Integer.TYPE).invoke((Object)connImpl, props.get(PROP_PREPARE_THRESHOLD));
            PGConnection.getMethod("setAutosave", this.Autosave).invoke((Object)connImpl, props.get(PROP_AUTOSAVE));
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw AdapterUtil.toSQLException(x);
        }
        return true;
    }

    @Override
    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.jdbcTraceWriter == null) {
            this.jdbcTraceWriter = new PrintWriter((Writer)new TraceWriter(this.jdbcTC), true);
        }
        return this.jdbcTraceWriter;
    }

    @Override
    public com.ibm.ejs.ras.TraceComponent getTracer() {
        return this.jdbcTC;
    }

    @Override
    public boolean shouldTraceBeEnabled(WSManagedConnectionFactoryImpl mcf) {
        return TraceComponent.isAnyTracingEnabled() && this.jdbcTC.isDebugEnabled() && !mcf.loggingEnabled;
    }

    @Override
    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl mc) {
        return TraceComponent.isAnyTracingEnabled() && !this.jdbcTC.isDebugEnabled() && mc.mcf.loggingEnabled;
    }
}

