/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebFault;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.FaultOutInterceptor;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class WebFaultOutInterceptor
extends FaultOutInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(WebFaultOutInterceptor.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(WebFaultOutInterceptor.class);
    static final long serialVersionUID = -1470409096317343386L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WebFaultOutInterceptor() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.WebFaultOutInterceptor", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.WebFaultOutInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private QName getFaultName(WebFault wf, Class<?> cls, OperationInfo op) {
        String name;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.WebFaultOutInterceptor", "getFaultName", new Object[]{wf, cls, op});
        }
        String ns = wf.targetNamespace();
        if (StringUtils.isEmpty((String)ns)) {
            ns = op.getName().getNamespaceURI();
        }
        if (StringUtils.isEmpty((String)(name = wf.name()))) {
            name = cls.getSimpleName();
        }
        QName qName = new QName(ns, name);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxws.interceptors.WebFaultOutInterceptor", "getFaultName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private WebFault getWebFaultAnnotation(Class<?> t) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.WebFaultOutInterceptor", "getWebFaultAnnotation", new Object[]{t});
        }
        WebFault fault = t.getAnnotation(WebFault.class);
        if (fault == null && t.getSuperclass() != null && Throwable.class.isAssignableFrom(t.getSuperclass())) {
            fault = this.getWebFaultAnnotation(t.getSuperclass());
        }
        WebFault webFault = fault;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            webFault = webFault;
            LOG.exiting("org.apache.cxf.jaxws.interceptors.WebFaultOutInterceptor", "getWebFaultAnnotation", webFault);
        }
        return webFault;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(Message message) throws Fault {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.WebFaultOutInterceptor", "handleMessage", new Object[]{message});
        }
        Fault f = (Fault)((Object)message.getContent(Exception.class));
        if (f == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxws.interceptors.WebFaultOutInterceptor", "handleMessage");
            }
            return;
        }
        try {
            if (f.getCause().getClass().equals(SOAPFaultException.class)) {
                SOAPFaultException sf = (SOAPFaultException)f.getCause();
                if (sf.getFault().getFaultSubcodes().hasNext() && ((Object)((Object)f)).getClass().equals(SoapFault.class)) {
                    String subcode = sf.getFault().getFaultSubcodes().next().toString();
                    String nameSpace = subcode.substring(subcode.indexOf("{") + 1, subcode.indexOf("}"));
                    String localPart = subcode.substring(subcode.indexOf("}") + 1);
                    QName subcodeQName = new QName(nameSpace, localPart);
                    ((SoapFault)f).setSubCode(subcodeQName);
                }
                if (sf.getFault().getFaultReasonLocales().hasNext()) {
                    Locale lang = (Locale)sf.getFault().getFaultReasonLocales().next();
                    String convertedLang = lang.getLanguage();
                    String country = lang.getCountry();
                    if (country.length() > 0) {
                        convertedLang = convertedLang + '-' + country;
                    }
                    f.setLang(convertedLang);
                }
                message.setContent(Exception.class, (Object)f);
            }
        }
        catch (Exception sf) {
            // empty catch block
        }
        Throwable cause = f.getCause();
        WebFault fault = null;
        if (cause != null) {
            fault = this.getWebFaultAnnotation(cause.getClass());
        }
        if (cause instanceof Exception && fault != null) {
            Exception ex = (Exception)cause;
            Object faultInfo = null;
            try {
                Method method = cause.getClass().getMethod("getFaultInfo", new Class[0]);
                faultInfo = method.invoke((Object)cause, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                faultInfo = this.createFaultInfoBean(fault, cause);
            }
            catch (InvocationTargetException e) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("INVOCATION_TARGET_EXC", BUNDLE, new Object[0]), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("COULD_NOT_INVOKE", BUNDLE, new Object[0]), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("COULD_NOT_INVOKE", BUNDLE, new Object[0]), (Throwable)e);
            }
            Service service = (Service)message.getExchange().get(Service.class);
            try {
                DataWriter writer = service.getDataBinding().createWriter(XMLStreamWriter.class);
                OperationInfo op = ((BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class)).getOperationInfo();
                QName faultName = this.getFaultName(fault, cause.getClass(), op);
                MessagePartInfo part = this.getFaultMessagePart(faultName, op);
                if (f.hasDetails()) {
                    writer.write(faultInfo, part, (Object)new W3CDOMStreamWriter(f.getDetail()));
                } else {
                    writer.write(faultInfo, part, (Object)new W3CDOMStreamWriter(f.getOrCreateDetail()));
                    if (!f.getDetail().hasChildNodes()) {
                        f.setDetail(null);
                    }
                }
                f.setMessage(ex.getMessage());
            }
            catch (Exception nex) {
                LOG.log(Level.WARNING, "EXCEPTION_WHILE_WRITING_FAULT", nex);
            }
        } else {
            FaultMode mode = (FaultMode)message.get(FaultMode.class);
            if (mode == FaultMode.CHECKED_APPLICATION_FAULT) {
                super.handleMessage(message);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.WebFaultOutInterceptor", "handleMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Object createFaultInfoBean(WebFault fault, Throwable cause) {
        block10: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxws.interceptors.WebFaultOutInterceptor", "createFaultInfoBean", new Object[]{fault, cause});
            }
            if (!StringUtils.isEmpty((String)fault.faultBean())) {
                Object t;
                block11: {
                    try {
                        Method[] meth;
                        Class cls = ClassLoaderUtils.loadClass((String)fault.faultBean(), cause.getClass());
                        if (cls == null) break block10;
                        Object ret = cls.newInstance();
                        for (Method m : meth = cause.getClass().getMethods()) {
                            if (m.getParameterTypes().length != 0 || !m.getName().startsWith("get") && !m.getName().startsWith("is")) continue;
                            try {
                                String name = m.getName().startsWith("get") ? "set" + m.getName().substring(3) : "set" + m.getName().substring(2);
                                Method m2 = cls.getMethod(name, m.getReturnType());
                                m2.invoke(ret, m.invoke((Object)cause, new Object[0]));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        t = ret;
                        if (LOG == null || !LOG.isLoggable(Level.FINER)) break block11;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                    t = t;
                    LOG.exiting("org.apache.cxf.jaxws.interceptors.WebFaultOutInterceptor", "createFaultInfoBean", t);
                }
                return t;
            }
        }
        LOG.fine("Using @WebFault annotated class " + cause.getClass().getName() + " as faultInfo since getFaultInfo() was not found");
        Throwable throwable = cause;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            throwable = throwable;
            LOG.exiting("org.apache.cxf.jaxws.interceptors.WebFaultOutInterceptor", "createFaultInfoBean", throwable);
        }
        return throwable;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private MessagePartInfo getFaultMessagePart(QName qname, OperationInfo op) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.WebFaultOutInterceptor", "getFaultMessagePart", new Object[]{qname, op});
        }
        for (FaultInfo faultInfo : op.getFaults()) {
            for (MessagePartInfo mpi : faultInfo.getMessageParts()) {
                String ns = null;
                ns = mpi.isElement() ? mpi.getElementQName().getNamespaceURI() : mpi.getTypeQName().getNamespaceURI();
                if (!qname.getLocalPart().equals(mpi.getConcreteName().getLocalPart()) || !qname.getNamespaceURI().equals(ns)) continue;
                MessagePartInfo messagePartInfo = mpi;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    messagePartInfo = messagePartInfo;
                    LOG.exiting("org.apache.cxf.jaxws.interceptors.WebFaultOutInterceptor", "getFaultMessagePart", messagePartInfo);
                }
                return messagePartInfo;
            }
        }
        MessagePartInfo messagePartInfo = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            messagePartInfo = messagePartInfo;
            LOG.exiting("org.apache.cxf.jaxws.interceptors.WebFaultOutInterceptor", "getFaultMessagePart", messagePartInfo);
        }
        return messagePartInfo;
    }
}

