/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.soap.wsdl.extensions.SoapBody;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.NSStack;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class RPCOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(RPCOutInterceptor.class);
    static final long serialVersionUID = 2050004076885997472L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RPCOutInterceptor() {
        super("marshal");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.RPCOutInterceptor", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.RPCOutInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(Message message) {
        MessageContentsList objs;
        boolean output;
        List parts;
        XMLStreamWriter xmlWriter;
        BindingOperationInfo operation;
        NSStack nsStack;
        block10: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.binding.soap.interceptor.RPCOutInterceptor", "handleMessage", new Object[]{message});
            }
            nsStack = new NSStack();
            nsStack.push();
            operation = (BindingOperationInfo)message.getExchange().get((Object)BindingOperationInfo.class.getName());
            assert (operation.getName() != null);
            xmlWriter = this.getXMLStreamWriter(message);
            parts = null;
            output = false;
            if (!this.isRequestor(message)) {
                parts = operation.getOutput().getMessageParts();
                output = true;
            } else {
                parts = operation.getInput().getMessageParts();
                output = false;
            }
            objs = MessageContentsList.getContentsList((Message)message);
            if (objs != null) break block10;
            this.addOperationNode(nsStack, message, xmlWriter, output, operation);
            xmlWriter.writeEndElement();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.binding.soap.interceptor.RPCOutInterceptor", "handleMessage");
            }
            return;
        }
        try {
            for (MessagePartInfo part : parts) {
                Object o;
                if (!objs.hasValue(part) || (o = objs.get(part)) != null) continue;
                throw new Fault(new org.apache.cxf.common.i18n.Message("BP_2211_RPCLIT_CANNOT_BE_NULL", LOG, new Object[]{part.getConcreteName()}));
            }
            this.addOperationNode(nsStack, message, xmlWriter, output, operation);
            this.writeParts(message, message.getExchange(), operation, objs, parts);
            xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new Fault((Throwable)e);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.RPCOutInterceptor", "handleMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String addOperationNode(NSStack nsStack, Message message, XMLStreamWriter xmlWriter, boolean output, BindingOperationInfo boi) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.RPCOutInterceptor", "addOperationNode", new Object[]{nsStack, message, xmlWriter, output, boi});
        }
        String responseSuffix = output ? "Response" : "";
        String ns = boi.getName().getNamespaceURI();
        SoapBody body = null;
        body = output ? (SoapBody)boi.getOutput().getExtensor(SoapBody.class) : (SoapBody)boi.getInput().getExtensor(SoapBody.class);
        if (body != null && !StringUtils.isEmpty((String)body.getNamespaceURI())) {
            ns = body.getNamespaceURI();
        }
        nsStack.add(ns);
        String prefix = nsStack.getPrefix(ns);
        StaxUtils.writeStartElement((XMLStreamWriter)xmlWriter, (String)prefix, (String)(boi.getName().getLocalPart() + responseSuffix), (String)ns);
        String string = ns;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.RPCOutInterceptor", "addOperationNode", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected XMLStreamWriter getXMLStreamWriter(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.RPCOutInterceptor", "getXMLStreamWriter", new Object[]{message});
        }
        XMLStreamWriter xMLStreamWriter = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            xMLStreamWriter = xMLStreamWriter;
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.RPCOutInterceptor", "getXMLStreamWriter", xMLStreamWriter);
        }
        return xMLStreamWriter;
    }
}

