/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.frames;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.h2internal.FrameReadProcessor;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2ConnectionSettings;
import com.ibm.ws.http.channel.h2internal.exceptions.FrameSizeException;
import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.utils;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;

public class FrameRstStream
extends Frame {
    private int errorCode;

    public FrameRstStream(int streamId, int payloadLength, byte flags, boolean reserveBit, Frame.FrameDirection direction) {
        super(streamId, payloadLength, flags, reserveBit, direction);
        this.frameType = FrameTypes.RST_STREAM;
    }

    public FrameRstStream(int streamId, int errorCode, boolean reserveBit) {
        super(streamId, 4, (byte)0, reserveBit, Frame.FrameDirection.WRITE);
        this.frameType = FrameTypes.RST_STREAM;
        this.errorCode = errorCode;
        this.writeFrameLength += this.payloadLength;
        this.setInitialized();
    }

    @Override
    public void processPayload(FrameReadProcessor frp) throws FrameSizeException {
        if (this.payloadLength != 4) {
            for (int i = 0; i < this.payloadLength; ++i) {
                frp.grabNextByte();
            }
            FrameSizeException e = new FrameSizeException("RST_STREAM frame payload must have a length of 4 octets");
            throw e;
        }
        this.errorCode = frp.grabNext32BitInt();
    }

    @Override
    public WsByteBuffer buildFrameForWrite() {
        WsByteBuffer buffer = super.buildFrameForWrite();
        byte[] frame = buffer.hasArray() ? buffer.array() : super.createFrameArray();
        this.setFrameHeaders(frame, (byte)3);
        int frameIndex = 9;
        utils.Move32BitstoByteArray(this.errorCode, frame, frameIndex);
        buffer.put(frame, 0, this.writeFrameLength);
        buffer.flip();
        return buffer;
    }

    @Override
    public void validate(H2ConnectionSettings settings) throws ProtocolException {
        if (this.streamId == 0) {
            throw new ProtocolException("RST_STREAM frame stream ID cannot be 0");
        }
    }

    @Override
    protected void setFlags() {
    }

    public void setErrorCode(int code) {
        this.errorCode = code;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FrameRstStream)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"equals: object is not a FrameRstStream", (Object[])new Object[0]);
            }
            return false;
        }
        FrameRstStream frameRstStreamToCompare = (FrameRstStream)object;
        if (!super.equals(frameRstStreamToCompare)) {
            return false;
        }
        if (this.getErrorCode() != frameRstStreamToCompare.getErrorCode()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("this.getErrorCode() = " + this.getErrorCode() + " frameRstStreamToCompare.getErrorCode() = " + frameRstStreamToCompare.getErrorCode()), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder frameToString = new StringBuilder();
        frameToString.append(super.toString());
        frameToString.append("ErrorCode: " + this.getErrorCode() + "\n");
        return frameToString.toString();
    }
}

