/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.internal;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.channelfw.osgi.ChannelFactoryProvider;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.http.internal.HttpChain;
import com.ibm.ws.http.internal.HttpEndpointList;
import com.ibm.ws.http.logging.internal.AccessLogger;
import com.ibm.ws.http.logging.internal.DisabledLogger;
import com.ibm.ws.kernel.launch.service.PauseableComponent;
import com.ibm.ws.kernel.launch.service.PauseableComponentException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.update.RuntimeUpdateListener;
import com.ibm.ws.runtime.update.RuntimeUpdateManager;
import com.ibm.ws.runtime.update.RuntimeUpdateNotification;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.ws.threading.listeners.CompletionListener;
import com.ibm.wsspi.channelfw.ChannelConfiguration;
import com.ibm.wsspi.channelfw.utils.HostNameUtils;
import com.ibm.wsspi.http.logging.AccessLog;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.event.EventAdmin;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.http"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, service={HttpEndpointImpl.class, RuntimeUpdateListener.class, PauseableComponent.class}, property={"service.vendor=IBM"})
public class HttpEndpointImpl
implements RuntimeUpdateListener,
PauseableComponent {
    private static final TraceComponent tc = Tr.register(HttpEndpointImpl.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final int DEACTIVATED = 1;
    private static final int ENABLED = 2;
    private static final int DISABLED = 4;
    private static String defaultHostName = "localhost";
    private static String resolvedDefaultHostName = "localhost";
    private final AtomicInteger endpointState = new AtomicInteger(4);
    private CHFWBundle chfw = null;
    private volatile ChannelConfiguration tcpOptions = null;
    private volatile ChannelConfiguration httpOptions = null;
    private final AtomicServiceReference<ExecutorService> executorService = new AtomicServiceReference("executorService");
    private final AtomicServiceReference<ChannelFactoryProvider> sslFactoryProvider = new AtomicServiceReference("sslSupport");
    private final AtomicServiceReference<ChannelConfiguration> sslOptions = new AtomicServiceReference("sslOptions");
    private final AtomicServiceReference<EventAdmin> eventService = new AtomicServiceReference("eventService");
    private volatile Map<String, Object> endpointConfig = null;
    private volatile ChannelConfiguration remoteIpConfig = null;
    private volatile boolean endpointStarted = false;
    private volatile String resolvedHostName = null;
    private volatile String host = "localhost";
    private volatile int httpPort = -1;
    private volatile int httpsPort = -1;
    private volatile String protocolVersion = null;
    private volatile String topicString = null;
    private volatile String name = null;
    private volatile String pid = null;
    private BundleContext bundleContext = null;
    protected volatile OnErrorUtil.OnError onError = OnErrorUtil.OnError.WARN;
    private final HttpChain httpChain = new HttpChain(this, false);
    private final HttpChain httpSecureChain = new HttpChain(this, true);
    private final AtomicReference<AccessLog> accessLogger = new AtomicReference<DisabledLogger>(DisabledLogger.getRef());
    private final Object actionLock = new Object(){
        static final long serialVersionUID = 2541559560371405029L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.HttpEndpointImpl$1", 1.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
        }
    };
    private final LinkedList<Runnable> actionQueue = new LinkedList();
    private Future<?> actionFuture = null;
    private final Runnable actionsRunner = new Runnable(){
        static final long serialVersionUID = -945172484208410211L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            while (true) {
                Runnable r;
                LinkedList linkedList = HttpEndpointImpl.this.actionQueue;
                synchronized (linkedList) {
                    r = (Runnable)HttpEndpointImpl.this.actionQueue.poll();
                    if (r == null) {
                        HttpEndpointImpl.this.actionFuture = null;
                        return;
                    }
                }
                r.run();
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.HttpEndpointImpl$2", 2.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
        }
    };
    private final Runnable stopAction = new Runnable(){
        static final long serialVersionUID = -8143644507476856755L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            Object object = HttpEndpointImpl.this.actionLock;
            synchronized (object) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("EndpointAction: stopping chains " + HttpEndpointImpl.this), (Object[])new Object[]{HttpEndpointImpl.this.httpChain, HttpEndpointImpl.this.httpSecureChain});
                }
                HttpEndpointImpl.this.httpChain.stop();
                HttpEndpointImpl.this.httpSecureChain.stop();
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.HttpEndpointImpl$3", 3.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
        }
    };
    private final Runnable stopHttpsOnlyAction = new Runnable(){
        static final long serialVersionUID = -6192468404261015095L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            Object object = HttpEndpointImpl.this.actionLock;
            synchronized (object) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("EndpointAction: stopping https chain " + HttpEndpointImpl.this), (Object[])new Object[]{HttpEndpointImpl.this.httpSecureChain});
                }
                HttpEndpointImpl.this.httpSecureChain.stop();
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.HttpEndpointImpl$4", 4.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
        }
    };
    private final Runnable updateAction = new Runnable(){
        static final long serialVersionUID = 2133926873913118835L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            Object object = HttpEndpointImpl.this.actionLock;
            synchronized (object) {
                if (HttpEndpointImpl.this.endpointStarted && HttpEndpointImpl.this.endpointState.get() == 2 && FrameworkState.isValid()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("EndpointAction: updating chains " + HttpEndpointImpl.this), (Object[])new Object[]{HttpEndpointImpl.this.httpChain, HttpEndpointImpl.this.httpSecureChain});
                    }
                    String resolvedHost = HttpEndpointImpl.this.resolvedHostName;
                    HttpEndpointImpl.this.httpChain.update(resolvedHost);
                    HttpEndpointImpl.this.httpSecureChain.update(resolvedHost);
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.HttpEndpointImpl$5", 5.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
        }
    };
    private Future<Boolean> configFuture = null;
    private volatile FutureMonitor _futureMonitor;
    static final long serialVersionUID = -4582620917074538073L;

    public static AtomicReference<AccessLog> getAccessLogger(String name) {
        HttpEndpointImpl h = HttpEndpointList.findEndpoint(name);
        if (h != null) {
            return h.accessLogger;
        }
        return null;
    }

    @Activate
    protected void activate(ComponentContext ctx, Map<String, Object> config) {
        Object cid = config.get("component.id");
        this.name = (String)config.get("id");
        this.pid = (String)config.get("service.pid");
        this.bundleContext = ctx.getBundleContext();
        if (this.name == null) {
            this.name = "httpEndpoint-" + cid;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("activate HttpEndpoint " + this), (Object[])new Object[0]);
        }
        HttpEndpointList.registerEndpoint(this);
        this.endpointStarted = true;
        this.executorService.activate(ctx);
        this.sslFactoryProvider.activate(ctx);
        this.sslOptions.activate(ctx);
        this.eventService.activate(ctx);
        this.httpChain.init(this.name, cid, this.chfw);
        this.httpSecureChain.init(this.name, cid, this.chfw);
        this.modified(config);
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx, int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("deactivate HttpEndpoint " + this + ", reason=" + reason), (Object[])new Object[0]);
        }
        this.endpointStarted = false;
        HttpEndpointList.unregisterEndpoint(this);
        this.endpointState.set(1);
        this.performAction(this.stopAction, false);
        this.executorService.deactivate(ctx);
        this.sslFactoryProvider.deactivate(ctx);
        this.sslOptions.deactivate(ctx);
        this.eventService.deactivate(ctx);
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        boolean endpointEnabled = MetatypeUtils.parseBoolean((Object)"httpEndpoint", (String)"enabled", (Object)config.get("enabled"), (boolean)true);
        this.onError = (OnErrorUtil.OnError)config.get("onError");
        this.host = ((String)config.get("host")).toLowerCase(Locale.ENGLISH);
        String cfgDefaultHost = ((String)config.get("_defaultHostName")).toLowerCase(Locale.ENGLISH);
        this.resolvedHostName = this.resolveHostName(this.host, cfgDefaultHost);
        if (this.resolvedHostName == null) {
            if ("*".equals(this.host)) {
                this.resolvedHostName = "localhost";
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("unresolved hostname right now: " + this.host + "setting resolvedHostName to this host for VIPA"), (Object[])new Object[0]);
                }
                this.resolvedHostName = this.host;
            }
        }
        this.protocolVersion = (String)config.get("protocolVersion");
        this.httpPort = MetatypeUtils.parseInteger((Object)"httpEndpoint", (String)"httpPort", (Object)config.get("httpPort"), (int)-1);
        this.httpsPort = MetatypeUtils.parseInteger((Object)"httpEndpoint", (String)"httpsPort", (Object)config.get("httpsPort"), (int)-1);
        String id = (String)config.get("id");
        Object cid = config.get("component.id");
        this.topicString = "com/ibm/ws/transport/http/endpoint/" + id + "/" + cid;
        if (this.httpPort < 0 && this.httpsPort < 0) {
            endpointEnabled = false;
            Tr.warning((TraceComponent)tc, (String)"missingPorts.endpointDisabled", (Object[])new Object[]{id});
        }
        this.endpointConfig = config;
        this.processHttpChainWork(endpointEnabled, false);
    }

    public void processHttpChainWork(boolean enableEndpoint, boolean isPause) {
        if (enableEndpoint) {
            this.endpointState.compareAndSet(4, 2);
            if (this.httpPort >= 0) {
                this.httpChain.enable();
            }
            if (this.httpsPort >= 0 && this.sslFactoryProvider.getService() != null) {
                this.httpSecureChain.enable();
            }
            if (!isPause) {
                this.performAction(this.updateAction);
            } else {
                this.updateAction.run();
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("endpoint disabled: " + (String)this.endpointConfig.get("id")), (Object[])new Object[0]);
            }
            this.endpointState.set(4);
            if (!isPause) {
                this.performAction(this.stopAction);
            } else {
                this.stopAction.run();
            }
        }
    }

    public String getEventTopic() {
        return this.topicString;
    }

    OnErrorUtil.OnError onError() {
        return this.onError;
    }

    @FFDCIgnore(value={Exception.class})
    final void shutdownFramework() {
        Tr.audit((TraceComponent)tc, (String)"httpChain.error.shutdown", (Object[])new Object[]{this.name});
        try {
            Bundle bundle = this.bundleContext.getBundle("System Bundle");
            if (bundle != null) {
                bundle.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Map<String, Object> getEndpointOptions() {
        return this.endpointConfig;
    }

    public String getHostName() {
        return this.host;
    }

    public String getResolvedHostName() {
        return this.resolvedHostName;
    }

    public int getListeningHttpPort() {
        return this.httpChain.getActivePort();
    }

    public int getListeningSecureHttpPort() {
        return this.httpSecureChain.getActivePort();
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    @Reference(name="sslSupport", service=ChannelFactoryProvider.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL, target="(type=SSLChannel)")
    protected void setSslSupport(ServiceReference<ChannelFactoryProvider> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("enable ssl support " + ref.getProperty("type")), (Object[])new Object[]{this});
        }
        this.sslFactoryProvider.setReference(ref);
        this.httpSecureChain.enable();
        if (this.endpointConfig != null) {
            this.performAction(this.updateAction);
        }
    }

    protected void unsetSslSupport(ServiceReference<ChannelFactoryProvider> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("disable ssl support " + ref.getProperty("type")), (Object[])new Object[]{this});
        }
        if (this.sslFactoryProvider.unsetReference(ref)) {
            this.httpSecureChain.disable();
        }
    }

    @Trivial
    @Reference(name="sslOptions", service=ChannelConfiguration.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setSslOptions(ServiceReference<ChannelConfiguration> service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("set ssl options " + service.getProperty("id")), (Object[])new Object[]{this});
        }
        this.sslOptions.setReference(service);
        if (this.endpointConfig != null) {
            this.performAction(this.updateAction);
        }
    }

    @Trivial
    protected void updatedSslOptions(ServiceReference<ChannelConfiguration> service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("update ssl options " + service.getProperty("id")), (Object[])new Object[]{this});
        }
        if (this.endpointConfig != null) {
            this.performAction(this.updateAction);
        }
    }

    @Trivial
    protected void unsetSslOptions(ServiceReference<ChannelConfiguration> service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("unset ssl options " + service.getProperty("id")), (Object[])new Object[]{this});
        }
        if (this.sslOptions.unsetReference(service)) {
            this.performAction(this.stopHttpsOnlyAction);
        }
    }

    public Map<String, Object> getSslOptions() {
        ChannelConfiguration c = (ChannelConfiguration)this.sslOptions.getService();
        return c == null ? null : c.getConfiguration();
    }

    @Trivial
    @Reference(name="tcpOptions", service=ChannelConfiguration.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MANDATORY)
    protected void setTcpOptions(ChannelConfiguration config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("set tcp options " + config.getProperty("id")), (Object[])new Object[]{this});
        }
        this.tcpOptions = config;
        if (this.endpointConfig != null) {
            this.performAction(this.updateAction);
        }
    }

    @Trivial
    protected void updatedTcpOptions(ChannelConfiguration config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("update tcp options " + config.getProperty("id")), (Object[])new Object[]{this});
        }
        if (this.endpointConfig != null) {
            this.performAction(this.updateAction);
        }
    }

    protected void unsetTcpOptions(ChannelConfiguration config) {
    }

    public Map<String, Object> getTcpOptions() {
        ChannelConfiguration c = this.tcpOptions;
        return c == null ? null : c.getConfiguration();
    }

    @Trivial
    @Reference(name="httpOptions", service=ChannelConfiguration.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MANDATORY)
    protected void setHttpOptions(ChannelConfiguration config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("set http options " + config.getProperty("id")), (Object[])new Object[]{this});
        }
        this.httpOptions = config;
        if (this.endpointConfig != null) {
            this.performAction(this.updateAction);
        }
    }

    @Trivial
    protected void updatedHttpOptions(ChannelConfiguration config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("update http options " + config.getProperty("id")), (Object[])new Object[]{this});
        }
        if (this.endpointConfig != null) {
            this.performAction(this.updateAction);
        }
    }

    protected void unsetHttpOptions(ChannelConfiguration config) {
    }

    public Map<String, Object> getHttpOptions() {
        ChannelConfiguration c = this.httpOptions;
        return c == null ? null : c.getConfiguration();
    }

    @Trivial
    @Reference(name="remoteIp", service=ChannelConfiguration.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MANDATORY)
    protected void setRemoteIp(ChannelConfiguration config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("set remote ip " + config.getProperty("id")), (Object[])new Object[]{this});
        }
        this.remoteIpConfig = config;
        if (this.remoteIpConfig != null) {
            this.performAction(this.updateAction);
        }
    }

    @Trivial
    protected void updatedRemoteIp(ChannelConfiguration config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("update remote ip " + config.getProperty("id")), (Object[])new Object[]{this});
        }
        if (this.remoteIpConfig != null) {
            this.performAction(this.updateAction);
        }
    }

    protected void unsetRemoteIp(ChannelConfiguration config) {
    }

    public Map<String, Object> getRemoteIpConfig() {
        ChannelConfiguration c = this.remoteIpConfig;
        return c == null ? null : c.getConfiguration();
    }

    @Reference(name="chfwBundle")
    protected void setChfwBundle(CHFWBundle bundle) {
        this.chfw = bundle;
    }

    protected void unsetChfwBundle(CHFWBundle bundle) {
    }

    protected CHFWBundle getChfwBundle() {
        return this.chfw;
    }

    @Reference(name="executorService", service=ExecutorService.class, policy=ReferencePolicy.DYNAMIC)
    protected void setExecutorService(ServiceReference<ExecutorService> executorService) {
        this.executorService.setReference(executorService);
    }

    protected void unsetExecutorService(ServiceReference<ExecutorService> executorService) {
        this.executorService.unsetReference(executorService);
    }

    @Trivial
    @Reference(name="accessLogging", service=AccessLogger.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setAccessLogging(AccessLogger alConfig) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("set access log " + alConfig), (Object[])new Object[0]);
        }
        this.accessLogger.set(alConfig);
    }

    protected void unsetAccessLogging(AccessLogger alConfig) {
        this.accessLogger.set(DisabledLogger.getRef());
    }

    @Reference(name="eventService", service=EventAdmin.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MANDATORY)
    protected void setEventAdmin(ServiceReference<EventAdmin> reference) {
        this.eventService.setReference(reference);
    }

    protected void unsetEventAdmin(ServiceReference<EventAdmin> reference) {
        this.eventService.unsetReference(reference);
    }

    public EventAdmin getEventAdmin() {
        return (EventAdmin)this.eventService.getService();
    }

    @Reference(name="httpDispatcher")
    protected void setHttpDispatcher(HttpDispatcher dispatcher) {
    }

    protected void unsetHttpDispatcher(HttpDispatcher dispatcher) {
    }

    @Trivial
    private void performAction(Runnable action) {
        this.performAction(action, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    private void performAction(Runnable action, boolean addToQueue) {
        ExecutorService exec = (ExecutorService)this.executorService.getService();
        if (exec == null) {
            action.run();
        } else if (addToQueue) {
            LinkedList<Runnable> linkedList = this.actionQueue;
            synchronized (linkedList) {
                this.actionQueue.add(action);
                if (this.actionFuture == null && this.configFuture == null) {
                    this.actionFuture = exec.submit(this.actionsRunner);
                }
            }
        } else {
            exec.submit(action);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[@" + System.identityHashCode(this) + ",name=" + this.name + ",host=" + this.host + ",http=" + this.httpPort + ",https=" + this.httpsPort + ",state=" + this.endpointState.get() + "]";
    }

    @Trivial
    public String getName() {
        return this.name;
    }

    @Trivial
    public String getPid() {
        return this.pid;
    }

    protected String resolveHostName(String cfgHost, String cfgDefaultHost) {
        if ("*".equals(cfgHost) && !"localhost".equals(cfgDefaultHost)) {
            return HttpEndpointImpl.resolveDefaultHostName(cfgDefaultHost);
        }
        return HostNameUtils.tryResolveHostName((String)cfgHost);
    }

    protected static synchronized String resolveDefaultHostName(String cfgDefaultHost) {
        if (resolvedDefaultHostName == null || !cfgDefaultHost.equals(defaultHostName)) {
            defaultHostName = cfgDefaultHost;
            if (HostNameUtils.validLocalHostName((String)defaultHostName)) {
                resolvedDefaultHostName = defaultHostName;
            } else {
                Tr.warning((TraceComponent)tc, (String)"unresolveableDefaultHost", (Object[])new Object[]{defaultHostName});
                resolvedDefaultHostName = "localhost";
            }
        }
        return resolvedDefaultHostName;
    }

    public void notificationCreated(RuntimeUpdateManager updateManager, RuntimeUpdateNotification notification) {
        if ("ConfigUpdatesDelivered".equals(notification.getName())) {
            this.configFuture = notification.getFuture();
            this._futureMonitor.onCompletion(notification.getFuture(), (CompletionListener)new CompletionListener<Boolean>(){
                static final long serialVersionUID = 2037642521032870026L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public void successfulCompletion(Future<Boolean> future, Boolean result) {
                    HttpEndpointImpl.this.configFuture = null;
                    this.submit();
                }

                public void failedCompletion(Future<Boolean> future, Throwable t) {
                    HttpEndpointImpl.this.configFuture = null;
                    this.submit();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void submit() {
                    LinkedList linkedList = HttpEndpointImpl.this.actionQueue;
                    synchronized (linkedList) {
                        HttpEndpointImpl.this.performAction(new Runnable(){
                            static final long serialVersionUID = -4231519400506360354L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            @Override
                            public void run() {
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.HttpEndpointImpl$6$1", 1.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
                            }
                        });
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.internal.HttpEndpointImpl$6", 6.class, (String)"HttpTransport", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
                }
            });
        }
    }

    @Reference(service=FutureMonitor.class)
    protected void setFutureMonitor(FutureMonitor futureMonitor) {
        this._futureMonitor = futureMonitor;
    }

    protected void unsetFutureMonitor(FutureMonitor futureMonitor) {
        this._futureMonitor = null;
    }

    /*
     * WARNING - void declaration
     */
    public void pause() throws PauseableComponentException {
        try {
            this.processHttpChainWork(false, true);
            if (this.httpChain.getChainState() == HttpChain.ChainState.STARTED.val || this.httpSecureChain.getChainState() == HttpChain.ChainState.STARTED.val) {
                throw new PauseableComponentException("The request to pause HTTP endpoint " + this.name + " did not complete successfully.");
            }
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.http.internal.HttpEndpointImpl", (String)"939", (Object)this, (Object[])new Object[0]);
            throw new PauseableComponentException((Throwable)t);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void resume() throws PauseableComponentException {
        try {
            this.processHttpChainWork(true, true);
            int httpChainState = this.httpChain.getChainState();
            int httpsChainState = this.httpSecureChain.getChainState();
            if (!(httpChainState == HttpChain.ChainState.STARTED.val && httpsChainState == HttpChain.ChainState.UNINITIALIZED.val || httpChainState == HttpChain.ChainState.UNINITIALIZED.val && httpsChainState == HttpChain.ChainState.STARTED.val || httpChainState == HttpChain.ChainState.STARTED.val && httpsChainState == HttpChain.ChainState.STARTED.val)) {
                throw new PauseableComponentException("The request to resume HTTP endpoint " + this.name + " did not complete successfully. HTTPChain: " + this.httpChain.toString() + ". HTTPSChain: " + this.httpSecureChain.toString());
            }
        }
        catch (Throwable httpChainState) {
            void t;
            FFDCFilter.processException((Throwable)httpChainState, (String)"com.ibm.ws.http.internal.HttpEndpointImpl", (String)"963", (Object)this, (Object[])new Object[0]);
            throw new PauseableComponentException((Throwable)t);
        }
    }

    public boolean isPaused() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("endpoint and chain data: " + this), (Object[])new Object[]{this.httpChain, this.httpSecureChain});
        }
        return this.httpChain.getChainState() != HttpChain.ChainState.STARTED.val && this.httpSecureChain.getChainState() != HttpChain.ChainState.STARTED.val;
    }

    public HashMap<String, String> getExtendedInfo() {
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        info.put("host", this.host);
        info.put("httpPort", String.valueOf(this.httpPort));
        info.put("httpsPort", String.valueOf(this.httpsPort));
        return info;
    }
}

