/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.indexes;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableSubscription;
import com.ibm.ws.sib.processor.utils.index.Index;
import com.ibm.ws.sib.processor.utils.index.IndexFilter;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;

public class SubscriptionIndex
extends Index {
    private static final TraceComponent tc = SibTr.register(SubscriptionIndex.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private int durableSubscriptions = 0;
    private int nonDurableSubscriptions = 0;

    public synchronized Index.Entry put(ControllableSubscription subscription) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{subscription});
        }
        SubscriptionType type = new SubscriptionType();
        type.durable = subscription.isDurable();
        type.local = subscription.isLocal();
        SubscriptionEntry entry = new SubscriptionEntry(subscription, type);
        this.add(entry);
        if (subscription.isDurable()) {
            ++this.durableSubscriptions;
        } else {
            ++this.nonDurableSubscriptions;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put", (Object)entry);
        }
        return entry;
    }

    public synchronized void remove(ControllableSubscription subscription) {
        ControllableSubscription sub;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)new Object[]{subscription});
        }
        if ((sub = (ControllableSubscription)this.remove(subscription.getSubscriptionUuid())) != null) {
            if (sub.isDurable()) {
                --this.durableSubscriptions;
            } else {
                --this.nonDurableSubscriptions;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    public synchronized ControllableSubscription findByUuid(SIBUuid12 uuid, IndexFilter filter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findByUuid", (Object)new Object[]{uuid, filter});
        }
        ControllableSubscription controllableSubscription = (ControllableSubscription)this.get(uuid, filter);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findByUuid", (Object)controllableSubscription);
        }
        return controllableSubscription;
    }

    public synchronized SubscriptionType getType(SIBUuid12 uuid) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getType", (Object)new Object[]{uuid});
        }
        SubscriptionType type = (SubscriptionType)super.getType(uuid).clone();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getType", (Object)type);
        }
        return type;
    }

    public synchronized int getDurableSubscriptions() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDurableSubscriptions");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDurableSubscriptions", (Object)new Integer(this.durableSubscriptions));
        }
        return this.durableSubscriptions;
    }

    public synchronized int getNonDurableSubscriptions() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNonDurableSubscriptions");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNonDurableSubscriptions", (Object)new Integer(this.nonDurableSubscriptions));
        }
        return this.nonDurableSubscriptions;
    }

    public synchronized int getTotalSubscriptions() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTotalSubscriptions");
        }
        int totalSubscriptions = this.durableSubscriptions + this.nonDurableSubscriptions;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTotalSubscriptions", (Object)new Integer(totalSubscriptions));
        }
        return totalSubscriptions;
    }

    protected static class SubscriptionEntry
    extends Index.Entry {
        SubscriptionEntry(ControllableSubscription subscription, SubscriptionType type) {
            super(subscription.getSubscriptionUuid(), subscription, type);
        }

        ControllableSubscription getControllableSubscription() {
            return (ControllableSubscription)this.data;
        }
    }

    public static class SubscriptionType
    extends Index.Type {
        public boolean local = true;
        public boolean durable = false;
    }
}

