/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.jms.internal.listener;

import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.exception.BatchIllegalIDPersistedException;
import com.ibm.jbatch.container.exception.BatchIllegalJobStatusTransitionException;
import com.ibm.jbatch.container.exception.PersistenceException;
import com.ibm.jbatch.container.ws.BatchInternalDispatcher;
import com.ibm.jbatch.container.ws.BatchStatusValidator;
import com.ibm.jbatch.container.ws.BatchSubmitInvalidParametersException;
import com.ibm.jbatch.container.ws.InstanceState;
import com.ibm.jbatch.container.ws.JobStoppedOnStartException;
import com.ibm.jbatch.container.ws.PartitionPlanConfig;
import com.ibm.jbatch.container.ws.PartitionReplyMsg;
import com.ibm.jbatch.container.ws.PartitionReplyQueue;
import com.ibm.jbatch.container.ws.RemotablePartitionState;
import com.ibm.jbatch.container.ws.WSJobExecution;
import com.ibm.jbatch.container.ws.WSJobInstance;
import com.ibm.jbatch.container.ws.WSJobOperator;
import com.ibm.jbatch.container.ws.WSJobRepository;
import com.ibm.jbatch.container.ws.events.BatchEventsPublisher;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jbatch.jms.internal.BatchJmsEnvHelper;
import com.ibm.ws.jbatch.jms.internal.BatchJmsMessage;
import com.ibm.ws.jbatch.jms.internal.BatchOperationGroup;
import com.ibm.ws.jbatch.jms.internal.dispatcher.PartitionReplyQueueJms;
import com.ibm.ws.jbatch.jms.internal.dispatcher.StartPartitionPayload;
import com.ibm.ws.jbatch.rest.bridge.BatchContainerAppNotFoundException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.ThreadContextDeserializer;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.batch.runtime.BatchStatus;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BatchJmsEndpointListener
implements MessageListener {
    private static final TraceComponent tc = Tr.register(BatchJmsEndpointListener.class, (String)"wsbatch", (String)"com.ibm.ws.jbatch.jms.internal.resources.BatchJmsMessages");
    private static final long NO_INSTANCE_ID = -1L;
    private static final long NO_EXECUTION_ID = -1L;
    private ConnectionFactory connectionFactory;
    private BatchOperationGroup batchOperationGroup;
    private WSJobRepository jobRepository;
    static final long serialVersionUID = -3659161429190174719L;

    public BatchJmsEndpointListener(ConnectionFactory cf, BatchOperationGroup batchOpGrp, WSJobRepository jobRepo) {
        this.batchOperationGroup = batchOpGrp;
        this.jobRepository = jobRepo;
        this.connectionFactory = cf;
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized BatchInternalDispatcher getInternalDispatcherInstance() {
        BundleContext bundleContext = FrameworkUtil.getBundle(BatchInternalDispatcher.class).getBundleContext();
        BatchInternalDispatcher retMe = null;
        try {
            Collection srs = bundleContext.getServiceReferences(BatchInternalDispatcher.class, null);
            if (srs.isEmpty()) {
                throw new BatchContainerRuntimeException("Unable to obtain BatchInternalDispatcher");
            }
            ServiceReference batchDispatcherSR = (ServiceReference)srs.iterator().next();
            retMe = (BatchInternalDispatcher)bundleContext.getService(batchDispatcherSR);
        }
        catch (InvalidSyntaxException srs) {
            void e;
            FFDCFilter.processException((Throwable)srs, (String)"com.ibm.ws.jbatch.jms.internal.listener.BatchJmsEndpointListener", (String)"134", (Object)this, (Object[])new Object[0]);
            throw new BatchContainerRuntimeException((Throwable)e);
        }
        return retMe;
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized WSContextService getWSContextServiceInstance() {
        BundleContext bundleContext = FrameworkUtil.getBundle(WSContextService.class).getBundleContext();
        WSContextService retMe = null;
        try {
            Collection srs = bundleContext.getServiceReferences(WSContextService.class, null);
            if (srs.isEmpty()) {
                throw new BatchContainerRuntimeException("Unable to obtain WSContextService");
            }
            ServiceReference wsContextServiceSR = (ServiceReference)srs.iterator().next();
            retMe = (WSContextService)bundleContext.getService(wsContextServiceSR);
        }
        catch (InvalidSyntaxException srs) {
            void e;
            FFDCFilter.processException((Throwable)srs, (String)"com.ibm.ws.jbatch.jms.internal.listener.BatchJmsEndpointListener", (String)"157", (Object)this, (Object[])new Object[0]);
            throw new BatchContainerRuntimeException((Throwable)e);
        }
        return retMe;
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized WSJobRepository getWSJobRepositoryInstance() {
        BundleContext bundleContext = FrameworkUtil.getBundle(WSJobRepository.class).getBundleContext();
        WSJobRepository retMe = null;
        try {
            Collection srs = bundleContext.getServiceReferences(WSJobRepository.class, null);
            if (srs.isEmpty()) {
                throw new BatchContainerRuntimeException("Unable to obtain WSJobRepository");
            }
            ServiceReference wsJobRepositorySR = (ServiceReference)srs.iterator().next();
            retMe = (WSJobRepository)bundleContext.getService(wsJobRepositorySR);
        }
        catch (InvalidSyntaxException srs) {
            void e;
            FFDCFilter.processException((Throwable)srs, (String)"com.ibm.ws.jbatch.jms.internal.listener.BatchJmsEndpointListener", (String)"181", (Object)this, (Object[])new Object[0]);
            throw new BatchContainerRuntimeException((Throwable)e);
        }
        return retMe;
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized WSJobOperator getWSJobOperatorInstance() {
        BundleContext bundleContext = FrameworkUtil.getBundle(WSJobOperator.class).getBundleContext();
        WSJobOperator retMe = null;
        try {
            Collection srs = bundleContext.getServiceReferences(WSJobOperator.class, null);
            if (srs.isEmpty()) {
                throw new BatchContainerRuntimeException("Unable to obtain WSJobOperator");
            }
            ServiceReference wsJobOperatorSR = (ServiceReference)srs.iterator().next();
            retMe = (WSJobOperator)bundleContext.getService(wsJobOperatorSR);
        }
        catch (InvalidSyntaxException srs) {
            void e;
            FFDCFilter.processException((Throwable)srs, (String)"com.ibm.ws.jbatch.jms.internal.listener.BatchJmsEndpointListener", (String)"205", (Object)this, (Object[])new Object[0]);
            throw new BatchContainerRuntimeException((Throwable)e);
        }
        return retMe;
    }

    protected synchronized BatchEventsPublisher getBatchEventsPublisher() {
        BundleContext bundleContext = FrameworkUtil.getBundle(BatchEventsPublisher.class).getBundleContext();
        BatchEventsPublisher retMe = null;
        try {
            Collection srs = bundleContext.getServiceReferences(BatchEventsPublisher.class, null);
            if (!srs.isEmpty()) {
                ServiceReference eventsPublisherSR = (ServiceReference)srs.iterator().next();
                retMe = (BatchEventsPublisher)bundleContext.getService(eventsPublisherSR);
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.jbatch.jms.internal.listener.BatchJmsEndpointListener", (String)"229", (Object)this, (Object[])new Object[0]);
        }
        return retMe;
    }

    public void onMessage(Message msg) {
        this.processMessage(new BatchJmsMessage(msg));
    }

    /*
     * WARNING - void declaration
     */
    private void processMessage(BatchJmsMessage msg) {
        block14: {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)(" received message from com.ibm.ws.jbatch.jms.listener.BatchJmsEndpointListener for applicationName: " + msg.getApplicationName()), (Object[])new Object[0]);
                }
                if (msg.getOperation().equalsIgnoreCase("Start")) {
                    if (BatchJmsEnvHelper.isTriggerEndpointJmsException() && BatchJmsEnvHelper.getExceptionCount() == 0) {
                        BatchJmsEnvHelper.incrementExceptionCount();
                        throw new JMSException("Throws Jms exception to simulate failure in retreiving data from jms message for instance id " + msg.getInstanceId());
                    }
                    long executionId = -1L;
                    if (msg.getMessage().getIntProperty("com_ibm_ws_batch_internal_minorVersion") > 1) {
                        executionId = msg.getExecutionId();
                    }
                    this.handleStartRequest(msg.getInstanceId(), executionId, msg.getSecurityContext(), msg.getJobParameters());
                } else if (msg.getOperation().equalsIgnoreCase("Restart")) {
                    long instanceId = -1L;
                    if (msg.getMessage().getIntProperty("com_ibm_ws_batch_internal_minorVersion") > 0) {
                        instanceId = msg.getInstanceId();
                    }
                    this.handleRestartRequest(instanceId, msg.getExecutionId(), msg.getSecurityContext(), msg.getJobParameters());
                } else if (msg.getOperation().equalsIgnoreCase("PartitionExecute")) {
                    this.handleStartPartitionRequest(msg);
                } else {
                    Tr.warning((TraceComponent)tc, (String)"warning.unsupported.operation", (Object[])new Object[]{msg.getOperation(), msg.toString()});
                }
            }
            catch (JMSException instanceId) {
                void e;
                FFDCFilter.processException((Throwable)instanceId, (String)"com.ibm.ws.jbatch.jms.internal.listener.BatchJmsEndpointListener", (String)"314", (Object)this, (Object[])new Object[]{msg});
                Exception ex = e.getLinkedException() != null ? e.getLinkedException() : e;
                Tr.error((TraceComponent)tc, (String)"error.endpoint.unable.process.message", (Object[])new Object[]{msg.toString(), ex});
                if (msg.getOperationUnchecked().equalsIgnoreCase("PartitionExecute") || msg.getInstanceIdUnchecked() < 0L) break block14;
                try {
                    WSJobRepository jobRepository = this.getWSJobRepositoryInstance();
                    jobRepository.updateJobInstanceWithInstanceStateAndBatchStatus(msg.getInstanceIdUnchecked(), InstanceState.FAILED, BatchStatus.FAILED);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jbatch.jms.internal.listener.BatchJmsEndpointListener", (String)"327", (Object)this, (Object[])new Object[]{msg});
                }
            }
        }
    }

    private Connection getJmsConnection() throws JMSException {
        if (this.connectionFactory == null) {
            throw new IllegalStateException("The replyConnectionFactoryRef reference cannot be located in the <batchJmsExecutor> element.");
        }
        return this.connectionFactory.createConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleStartPartitionRequest(BatchJmsMessage batchJmsMessage) {
        BatchInternalDispatcher dispatcherProxy;
        WSJobRepository jobRepositoryProxy;
        long jobExecutionId;
        PartitionPlanConfig config23333332;
        PartitionReplyQueueJms partitionReplyQueue;
        StartPartitionPayload payload;
        Object savedException;
        block19: {
            savedException = null;
            payload = null;
            partitionReplyQueue = null;
            payload = batchJmsMessage.getStartPartitionPayload();
            config23333332 = payload.getPartitionPlanConfig();
            jobExecutionId = config23333332.getTopLevelExecutionId();
            byte[] securityContext = payload.getSecurityContext();
            jobRepositoryProxy = this.createContextualProxy(securityContext, this.getWSJobRepositoryInstance(), WSJobRepository.class);
            dispatcherProxy = this.createContextualProxy(securityContext, this.getInternalDispatcherInstance(), BatchInternalDispatcher.class);
            if (this.isJobExecutionMostRecent(jobExecutionId)) break block19;
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Exiting since execution Id = " + jobExecutionId + " was not the newest."), (Object[])new Object[0]);
            }
            if (savedException == null) return;
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)(" received exception " + savedException.getClass() + ", sending FAILED status for this partition"), (Object[])new Object[0]);
                }
                partitionReplyQueue.add(new PartitionReplyMsg(PartitionReplyMsg.PartitionReplyMsgType.PARTITION_FINAL_STATUS).setBatchStatus(BatchStatus.FAILED).setExitStatus(BatchStatus.FAILED.toString()).setPartitionPlanConfig(payload.getPartitionPlanConfig()));
                partitionReplyQueue.close();
                return;
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jbatch.jms.internal.listener.BatchJmsEndpointListener", (String)"437", (Object)this, (Object[])new Object[]{batchJmsMessage});
                Tr.error((TraceComponent)tc, (String)"error.start.partition.request", (Object[])new Object[]{e});
            }
            return;
        }
        jobRepositoryProxy.updateRemotablePartitionInternalState(jobExecutionId, config23333332.getStepName(), config23333332.getPartitionNumber(), RemotablePartitionState.CONSUMED);
        partitionReplyQueue = new PartitionReplyQueueJms(this.getJmsConnection(), batchJmsMessage.getJmsReplyToQueue());
        Future futureWork = dispatcherProxy.startPartition(config23333332, payload.getStep(), (PartitionReplyQueue)partitionReplyQueue);
        this.waitTillWorkEnds(futureWork);
        if (savedException == null) return;
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)(" received exception " + savedException.getClass() + ", sending FAILED status for this partition"), (Object[])new Object[0]);
            }
            partitionReplyQueue.add(new PartitionReplyMsg(PartitionReplyMsg.PartitionReplyMsgType.PARTITION_FINAL_STATUS).setBatchStatus(BatchStatus.FAILED).setExitStatus(BatchStatus.FAILED.toString()).setPartitionPlanConfig(payload.getPartitionPlanConfig()));
            partitionReplyQueue.close();
            return;
        }
        catch (Exception config23333332) {
            void e;
            FFDCFilter.processException((Throwable)config23333332, (String)"com.ibm.ws.jbatch.jms.internal.listener.BatchJmsEndpointListener", (String)"437", (Object)this, (Object[])new Object[]{batchJmsMessage});
            Tr.error((TraceComponent)tc, (String)"error.start.partition.request", (Object[])new Object[]{e});
        }
        return;
        catch (Exception e) {
            try {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jbatch.jms.internal.listener.BatchJmsEndpointListener", (String)"412", (Object)this, (Object[])new Object[]{batchJmsMessage});
                if (!this.exceptionWillBeConsumed(e)) {
                    throw new BatchContainerRuntimeException(e.getCause() != null ? e.getCause() : e);
                }
                savedException = e;
                if (savedException == null) return;
            }
            catch (Throwable throwable) {
                if (savedException == null) throw throwable;
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)(" received exception " + savedException.getClass() + ", sending FAILED status for this partition"), (Object[])new Object[0]);
                    }
                    partitionReplyQueue.add(new PartitionReplyMsg(PartitionReplyMsg.PartitionReplyMsgType.PARTITION_FINAL_STATUS).setBatchStatus(BatchStatus.FAILED).setExitStatus(BatchStatus.FAILED.toString()).setPartitionPlanConfig(payload.getPartitionPlanConfig()));
                    partitionReplyQueue.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    void e2;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jbatch.jms.internal.listener.BatchJmsEndpointListener", (String)"437", (Object)this, (Object[])new Object[]{batchJmsMessage});
                    Tr.error((TraceComponent)tc, (String)"error.start.partition.request", (Object[])new Object[]{e2});
                }
                throw throwable;
            }
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)(" received exception " + savedException.getClass() + ", sending FAILED status for this partition"), (Object[])new Object[0]);
                }
                partitionReplyQueue.add(new PartitionReplyMsg(PartitionReplyMsg.PartitionReplyMsgType.PARTITION_FINAL_STATUS).setBatchStatus(BatchStatus.FAILED).setExitStatus(BatchStatus.FAILED.toString()).setPartitionPlanConfig(payload.getPartitionPlanConfig()));
                partitionReplyQueue.close();
                return;
            }
            catch (Exception e3) {
                FFDCFilter.processException((Throwable)e3, (String)"com.ibm.ws.jbatch.jms.internal.listener.BatchJmsEndpointListener", (String)"437", (Object)this, (Object[])new Object[]{batchJmsMessage});
                Tr.error((TraceComponent)tc, (String)"error.start.partition.request", (Object[])new Object[]{e3});
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleRestartRequest(long jobInstanceId, long executionId, byte[] securityContext, Properties restartParameters) {
        WSJobInstance jobInstance;
        BatchInternalDispatcher dispatcherProxy;
        WSJobRepository jobRepositoryProxy2;
        Throwable savedException;
        long jobExecutionId;
        long instanceId;
        String correlationId;
        block18: {
            block17: {
                WSJobRepository jobRepository = this.getWSJobRepositoryInstance();
                BatchInternalDispatcher batchDispatcher = this.getInternalDispatcherInstance();
                correlationId = this.getCorrelationId(restartParameters);
                instanceId = jobInstanceId;
                jobExecutionId = executionId;
                savedException = null;
                jobRepositoryProxy2 = this.createContextualProxy(securityContext, jobRepository, WSJobRepository.class);
                dispatcherProxy = this.createContextualProxy(securityContext, batchDispatcher, BatchInternalDispatcher.class);
                if (instanceId == -1L) {
                    instanceId = jobRepositoryProxy2.getJobInstanceFromExecution(executionId).getInstanceId();
                    jobExecutionId = -1L;
                }
                if (this.isJobExecutionMostRecent(jobExecutionId)) break block17;
                if (savedException == null) return;
                Tr.error((TraceComponent)tc, (String)"error.endpoint.unable.process.restart.request", (Object[])new Object[]{executionId, savedException.getCause() != null ? savedException.getCause() : savedException});
                this.markInstanceExecutionFailed(instanceId, executionId, correlationId);
                return;
            }
            jobInstance = jobRepositoryProxy2.updateJobInstanceStateOnConsumed(instanceId);
            if (jobInstance.getInstanceState() == InstanceState.JMS_CONSUMED) break block18;
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Exiting since instanceState isn't equal to JMS_CONSUMED, instead is: " + jobInstance.getInstanceState()), (Object[])new Object[0]);
            }
            if (savedException == null) return;
            Tr.error((TraceComponent)tc, (String)"error.endpoint.unable.process.restart.request", (Object[])new Object[]{executionId, savedException.getCause() != null ? savedException.getCause() : savedException});
            this.markInstanceExecutionFailed(instanceId, executionId, correlationId);
            return;
        }
        try {
            this.publishEvent(jobInstance, "batch/jobs/instance/jms_consumed", correlationId);
            if (this.batchOperationGroup != null) {
                int instanceTableVersion = jobRepositoryProxy2.getJobInstanceTableVersion();
                if (instanceTableVersion >= 3) {
                    if (jobInstance.getGroupNames() == null || jobInstance.getGroupNames().size() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"On restart, null/empty operation group mapping. Give it another chance.", (Object[])new Object[0]);
                        }
                        jobRepositoryProxy2.updateJobInstanceWithGroupNames(instanceId, this.batchOperationGroup.getGroupNames());
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"On restart, operation group mapping already performed, continuing without reassignment", (Object[])new Object[0]);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Skip group names update because job instance table version = " + instanceTableVersion), (Object[])new Object[0]);
                }
            }
            Future futureWork = dispatcherProxy.restartInstance(instanceId, restartParameters, jobExecutionId);
            this.waitTillWorkEnds(futureWork);
            if (savedException == null) return;
        }
        catch (Exception jobRepositoryProxy2) {
            try {
                void e;
                FFDCFilter.processException((Throwable)jobRepositoryProxy2, (String)"com.ibm.ws.jbatch.jms.internal.listener.BatchJmsEndpointListener", (String)"517", (Object)this, (Object[])new Object[]{jobInstanceId, executionId, securityContext, restartParameters});
                if (!this.exceptionWillBeConsumed((Exception)e)) {
                    throw new BatchContainerRuntimeException((Throwable)(e.getCause() != null ? e.getCause() : e));
                }
                savedException = e;
                if (savedException == null) return;
            }
            catch (Throwable throwable) {
                if (savedException == null) throw throwable;
                Tr.error((TraceComponent)tc, (String)"error.endpoint.unable.process.restart.request", (Object[])new Object[]{executionId, savedException.getCause() != null ? savedException.getCause() : savedException});
                this.markInstanceExecutionFailed(instanceId, executionId, correlationId);
                throw throwable;
            }
            Tr.error((TraceComponent)tc, (String)"error.endpoint.unable.process.restart.request", (Object[])new Object[]{executionId, savedException.getCause() != null ? savedException.getCause() : savedException});
            this.markInstanceExecutionFailed(instanceId, executionId, correlationId);
            return;
        }
        Tr.error((TraceComponent)tc, (String)"error.endpoint.unable.process.restart.request", (Object[])new Object[]{executionId, savedException.getCause() != null ? savedException.getCause() : savedException});
        this.markInstanceExecutionFailed(instanceId, executionId, correlationId);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @FFDCIgnore(value={JobStoppedOnStartException.class})
    private void handleStartRequest(long instanceId, long executionId, byte[] securityContext, Properties jobParameters) {
        WSJobInstance jobInstance;
        BatchInternalDispatcher dispatcherProxy;
        WSJobRepository jobRepositoryProxy;
        String correlationId;
        Throwable savedException;
        block17: {
            block16: {
                savedException = null;
                WSJobRepository jobRepository = this.getWSJobRepositoryInstance();
                BatchInternalDispatcher batchDispatcher = this.getInternalDispatcherInstance();
                correlationId = this.getCorrelationId(jobParameters);
                jobRepositoryProxy = this.createContextualProxy(securityContext, jobRepository, WSJobRepository.class);
                dispatcherProxy = this.createContextualProxy(securityContext, batchDispatcher, BatchInternalDispatcher.class);
                if (this.isJobExecutionMostRecent(executionId)) break block16;
                if (savedException == null) return;
                Tr.error((TraceComponent)tc, (String)"error.endpoint.unable.process.start.request", (Object[])new Object[]{instanceId, savedException.getCause() != null ? savedException.getCause() : savedException});
                this.markInstanceExecutionFailed(instanceId, executionId, correlationId);
                return;
            }
            jobInstance = jobRepositoryProxy.updateJobInstanceStateOnConsumed(instanceId);
            if (jobInstance.getInstanceState() == InstanceState.JMS_CONSUMED) break block17;
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Exiting since instanceState isn't equal to JMS_CONSUMED, instead is: " + jobInstance.getInstanceState()), (Object[])new Object[0]);
            }
            if (savedException == null) return;
            Tr.error((TraceComponent)tc, (String)"error.endpoint.unable.process.start.request", (Object[])new Object[]{instanceId, savedException.getCause() != null ? savedException.getCause() : savedException});
            this.markInstanceExecutionFailed(instanceId, executionId, correlationId);
            return;
        }
        try {
            this.publishEvent(jobInstance, "batch/jobs/instance/jms_consumed", correlationId);
            if (this.batchOperationGroup != null) {
                int instanceTableVersion = jobRepositoryProxy.getJobInstanceTableVersion();
                if (instanceTableVersion >= 3) {
                    jobRepositoryProxy.updateJobInstanceWithGroupNames(instanceId, this.batchOperationGroup.getGroupNames());
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Skip group names update because job instance table version = " + instanceTableVersion), (Object[])new Object[0]);
                }
            }
            if (BatchJmsEnvHelper.isTriggerEndpointDbException() && BatchJmsEnvHelper.getExceptionCount() == 0) {
                BatchJmsEnvHelper.incrementExceptionCount();
                throw new PersistenceException((Throwable)new BatchContainerRuntimeException("Throws persistence exception to simulate failure in db update"));
            }
            Future futureWork = dispatcherProxy.start(jobInstance, jobParameters, executionId);
            this.waitTillWorkEnds(futureWork);
            if (savedException == null) return;
        }
        catch (JobStoppedOnStartException js222222) {
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Stop operation was received prior to job being STARTED.", (Object[])new Object[0]);
            }
            if (savedException == null) return;
            Tr.error((TraceComponent)tc, (String)"error.endpoint.unable.process.start.request", (Object[])new Object[]{instanceId, savedException.getCause() != null ? savedException.getCause() : savedException});
            this.markInstanceExecutionFailed(instanceId, executionId, correlationId);
            return;
        }
        catch (Exception js222222) {
            void e;
            FFDCFilter.processException((Throwable)js222222, (String)"com.ibm.ws.jbatch.jms.internal.listener.BatchJmsEndpointListener", (String)"600", (Object)this, (Object[])new Object[]{instanceId, executionId, securityContext, jobParameters});
            if (!this.exceptionWillBeConsumed((Exception)e)) {
                throw new BatchContainerRuntimeException((Throwable)(e.getCause() != null ? e.getCause() : e));
            }
            savedException = e;
            if (savedException == null) return;
            {
                catch (Throwable throwable) {
                    if (savedException == null) throw throwable;
                    Tr.error((TraceComponent)tc, (String)"error.endpoint.unable.process.start.request", (Object[])new Object[]{instanceId, savedException.getCause() != null ? savedException.getCause() : savedException});
                    this.markInstanceExecutionFailed(instanceId, executionId, correlationId);
                    throw throwable;
                }
            }
            Tr.error((TraceComponent)tc, (String)"error.endpoint.unable.process.start.request", (Object[])new Object[]{instanceId, savedException.getCause() != null ? savedException.getCause() : savedException});
            this.markInstanceExecutionFailed(instanceId, executionId, correlationId);
            return;
        }
        Tr.error((TraceComponent)tc, (String)"error.endpoint.unable.process.start.request", (Object[])new Object[]{instanceId, savedException.getCause() != null ? savedException.getCause() : savedException});
        this.markInstanceExecutionFailed(instanceId, executionId, correlationId);
        return;
    }

    private void markInstanceExecutionFailed(long instanceId, long executionId, String correlationId) {
        try {
            this.getWSJobRepositoryInstance().updateJobInstanceAndExecutionWithInstanceStateAndBatchStatus(instanceId, executionId, InstanceState.FAILED, BatchStatus.FAILED);
            this.publishEvent(instanceId, "batch/jobs/instance/failed", correlationId);
            this.publishExecutionEvent(executionId, "batch/jobs/execution/failed", correlationId);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jbatch.jms.internal.listener.BatchJmsEndpointListener", (String)"633", (Object)this, (Object[])new Object[]{instanceId, executionId, correlationId});
        }
    }

    private String getCorrelationId(Properties jobParameters) {
        if (jobParameters != null) {
            return jobParameters.getProperty("com_ibm_ws_batch_events_correlationId", null);
        }
        return null;
    }

    private void waitTillWorkEnds(Future<?> futureWork) {
        try {
            futureWork.get();
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.jbatch.jms.internal.listener.BatchJmsEndpointListener", (String)"656", (Object)this, (Object[])new Object[]{futureWork});
        }
        catch (CancellationException cancellationException) {
            FFDCFilter.processException((Throwable)cancellationException, (String)"com.ibm.ws.jbatch.jms.internal.listener.BatchJmsEndpointListener", (String)"658", (Object)this, (Object[])new Object[]{futureWork});
        }
        catch (ExecutionException executionException) {
            FFDCFilter.processException((Throwable)executionException, (String)"com.ibm.ws.jbatch.jms.internal.listener.BatchJmsEndpointListener", (String)"660", (Object)this, (Object[])new Object[]{futureWork});
        }
    }

    private void publishEvent(WSJobInstance jobInstance, String topic, String correlationId) {
        BatchEventsPublisher publisher = this.getBatchEventsPublisher();
        if (publisher != null) {
            publisher.publishJobInstanceEvent(jobInstance, topic, correlationId);
        }
    }

    private void publishEvent(long instanceId, String event, String correlationId) {
        BatchEventsPublisher publisher = this.getBatchEventsPublisher();
        WSJobRepository jobRepository = this.getWSJobRepositoryInstance();
        if (publisher != null && jobRepository != null) {
            WSJobInstance jobInstance = jobRepository.getJobInstance(instanceId);
            publisher.publishJobInstanceEvent(jobInstance, event, correlationId);
        }
    }

    private void publishExecutionEvent(long executionId, String event, String correlationId) {
        BatchEventsPublisher publisher = this.getBatchEventsPublisher();
        WSJobRepository jobRepository = this.getWSJobRepositoryInstance();
        if (publisher != null && jobRepository != null) {
            WSJobExecution jobExecution = jobRepository.getJobExecution(executionId);
            publisher.publishJobExecutionEvent(jobExecution, event, correlationId);
        }
    }

    private boolean exceptionWillBeConsumed(Exception exception) {
        if (exception instanceof PersistenceException) {
            exception = this.unWrapException(exception);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)(" Unwrapped Exception: " + exception.toString()), (Object[])new Object[0]);
            }
        }
        return exception instanceof ClassCastException || exception instanceof ClassNotFoundException || exception instanceof IOException || exception instanceof NoSuchJobExecutionException || exception instanceof JobSecurityException || exception instanceof JobStartException || exception instanceof BatchContainerAppNotFoundException || exception instanceof JobExecutionNotMostRecentException || exception instanceof JobExecutionAlreadyCompleteException || exception instanceof NoSuchJobInstanceException || exception instanceof BatchSubmitInvalidParametersException || exception instanceof BatchIllegalIDPersistedException || exception instanceof BatchIllegalJobStatusTransitionException;
    }

    private Exception unWrapException(Exception e) {
        return e.getCause() != null ? this.unWrapException((Exception)e.getCause()) : e;
    }

    public <T> T createContextualProxy(byte[] serializedContext, T instance, Class<T> intf) throws IOException, ClassNotFoundException {
        HashMap<String, String> execProps = new HashMap<String, String>();
        execProps.put("javax.enterprise.concurrent.IDENTITY_NAME", "batch.job");
        execProps.put("com.ibm.ws.concurrent.TASK_OWNER", "batch.runtime");
        ThreadContextDescriptor tcDescriptor = ThreadContextDeserializer.deserialize((byte[])serializedContext, execProps);
        WSContextService contextService = this.getWSContextServiceInstance();
        if (contextService == null) {
            throw new RuntimeException("Unable to obtain WSContextService");
        }
        return (T)contextService.createContextualProxy(tcDescriptor, instance, intf);
    }

    public static String createPropertyFilter(String name, String value) {
        assert (name.matches("[^=><~()]+"));
        StringBuilder builder = new StringBuilder(name.length() + 3 + (value == null ? 0 : value.length() * 2));
        builder.append('(').append(name).append('=');
        int begin = 0;
        if (value != null) {
            for (int i = 0; i < value.length(); ++i) {
                if ("\\*()".indexOf(value.charAt(i)) == -1) continue;
                builder.append(value, begin, i).append('\\');
                begin = i;
            }
            return builder.append(value, begin, value.length()).append(')').toString();
        }
        return builder.append(')').toString();
    }

    private boolean isJobExecutionMostRecent(long jobExecutionId) {
        if (!BatchStatusValidator.isJobExecutionMostRecent((long)jobExecutionId)) {
            Tr.warning((TraceComponent)tc, (String)"warning.endpoint.listener.stale.message", (Object[])new Object[]{jobExecutionId});
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)(" discarding message with Top Level Execution Id = " + jobExecutionId + " since it was not the newest Execution"), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }
}

