/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.Location;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.staxutils.DepthExceededStaxException;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxSource;
import org.apache.cxf.staxutils.StreamWriterContentHandler;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public final class StaxUtils {
    private static final String INNER_ELEMENT_COUNT_SYSTEM_PROP = "org.apache.cxf.staxutils.innerElementCountThreshold";
    private static final String INNER_ELEMENT_LEVEL_SYSTEM_PROP = "org.apache.cxf.staxutils.innerElementLevelThreshold";
    private static final Logger LOG;
    private static final BlockingQueue<XMLInputFactory> NS_AWARE_INPUT_FACTORY_POOL;
    private static final XMLInputFactory SAFE_INPUT_FACTORY;
    private static final BlockingQueue<XMLOutputFactory> OUTPUT_FACTORY_POOL;
    private static final XMLOutputFactory SAFE_OUTPUT_FACTORY;
    private static final String XML_NS = "http://www.w3.org/2000/xmlns/";
    private static final String[] DEF_PREFIXES;
    private static int innerElementLevelThreshold;
    private static int innerElementCountThreshold;
    static final long serialVersionUID = 5791665669395279382L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private StaxUtils() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void setInnerElementLevelThreshold(int i) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "setInnerElementLevelThreshold", new Object[]{i});
        }
        innerElementLevelThreshold = i;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "setInnerElementLevelThreshold");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void setInnerElementCountThreshold(int i) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "setInnerElementCountThreshold", new Object[]{i});
        }
        innerElementCountThreshold = i;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "setInnerElementCountThreshold");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isWoodstox() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "isWoodstox", new Object[0]);
        }
        try {
            ClassLoaderUtils.loadClass("org.codehaus.stax2.XMLStreamReader2", StaxUtils.class);
        }
        catch (ClassNotFoundException e) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "isWoodstox", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "isWoodstox", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static XMLInputFactory getXMLInputFactory() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "getXMLInputFactory", new Object[0]);
        }
        if (SAFE_INPUT_FACTORY != null) {
            XMLInputFactory xMLInputFactory = SAFE_INPUT_FACTORY;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                xMLInputFactory = xMLInputFactory;
                LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "getXMLInputFactory", xMLInputFactory);
            }
            return xMLInputFactory;
        }
        XMLInputFactory f = (XMLInputFactory)NS_AWARE_INPUT_FACTORY_POOL.poll();
        if (f == null) {
            f = StaxUtils.createXMLInputFactory(true);
        }
        XMLInputFactory xMLInputFactory = f;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            xMLInputFactory = xMLInputFactory;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "getXMLInputFactory", xMLInputFactory);
        }
        return xMLInputFactory;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void returnXMLInputFactory(XMLInputFactory factory) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "returnXMLInputFactory", new Object[]{factory});
        }
        if (SAFE_INPUT_FACTORY != factory) {
            NS_AWARE_INPUT_FACTORY_POOL.offer(factory);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "returnXMLInputFactory");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static XMLOutputFactory getXMLOutputFactory() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "getXMLOutputFactory", new Object[0]);
        }
        if (SAFE_OUTPUT_FACTORY != null) {
            XMLOutputFactory xMLOutputFactory = SAFE_OUTPUT_FACTORY;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                xMLOutputFactory = xMLOutputFactory;
                LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "getXMLOutputFactory", xMLOutputFactory);
            }
            return xMLOutputFactory;
        }
        XMLOutputFactory f = (XMLOutputFactory)OUTPUT_FACTORY_POOL.poll();
        if (f == null) {
            f = XMLOutputFactory.newInstance();
        }
        XMLOutputFactory xMLOutputFactory = f;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            xMLOutputFactory = xMLOutputFactory;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "getXMLOutputFactory", xMLOutputFactory);
        }
        return xMLOutputFactory;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void returnXMLOutputFactory(XMLOutputFactory factory) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "returnXMLOutputFactory", new Object[]{factory});
        }
        if (SAFE_OUTPUT_FACTORY != factory) {
            OUTPUT_FACTORY_POOL.offer(factory);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "returnXMLOutputFactory");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static XMLInputFactory createXMLInputFactory(boolean nsAware) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "createXMLInputFactory", new Object[]{nsAware});
        }
        XMLInputFactory factory = XMLInputFactory.newInstance();
        StaxUtils.setProperty(factory, "javax.xml.stream.isNamespaceAware", nsAware);
        StaxUtils.setProperty(factory, "javax.xml.stream.supportDTD", Boolean.FALSE);
        StaxUtils.setProperty(factory, "javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        StaxUtils.setProperty(factory, "javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        factory.setXMLResolver(new XMLResolver(){
            static final long serialVersionUID = -4450809117102713233L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                throw new XMLStreamException("Reading external entities is disabled");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.staxutils.StaxUtils$1", 1.class, null, null);
            }
        });
        XMLInputFactory xMLInputFactory = factory;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            xMLInputFactory = xMLInputFactory;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "createXMLInputFactory", xMLInputFactory);
        }
        return xMLInputFactory;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void setProperty(XMLInputFactory f, String p, Object o) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "setProperty", new Object[]{f, p, o});
        }
        try {
            f.setProperty(p, o);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "setProperty");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static XMLStreamWriter createXMLStreamWriter(Writer out) {
        XMLStreamWriter xMLStreamWriter;
        block6: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamWriter", new Object[]{out});
            }
            XMLOutputFactory factory = StaxUtils.getXMLOutputFactory();
            try {
                XMLStreamWriter xMLStreamWriter2 = factory.createXMLStreamWriter(out);
                xMLStreamWriter = xMLStreamWriter2;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block6;
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Cant' create XMLStreamWriter", e);
            }
            finally {
                StaxUtils.returnXMLOutputFactory(factory);
            }
            xMLStreamWriter = xMLStreamWriter;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamWriter", xMLStreamWriter);
        }
        return xMLStreamWriter;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static XMLStreamWriter createXMLStreamWriter(OutputStream out) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamWriter", new Object[]{out});
        }
        XMLStreamWriter xMLStreamWriter = StaxUtils.createXMLStreamWriter(out, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            xMLStreamWriter = xMLStreamWriter;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamWriter", xMLStreamWriter);
        }
        return xMLStreamWriter;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static XMLStreamWriter createXMLStreamWriter(OutputStream out, String encoding) {
        XMLStreamWriter xMLStreamWriter;
        block7: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamWriter", new Object[]{out, encoding});
            }
            if (encoding == null) {
                encoding = "UTF-8";
            }
            XMLOutputFactory factory = StaxUtils.getXMLOutputFactory();
            try {
                XMLStreamWriter xMLStreamWriter2 = factory.createXMLStreamWriter(out, encoding);
                xMLStreamWriter = xMLStreamWriter2;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block7;
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Cant' create XMLStreamWriter", e);
            }
            finally {
                StaxUtils.returnXMLOutputFactory(factory);
            }
            xMLStreamWriter = xMLStreamWriter;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamWriter", xMLStreamWriter);
        }
        return xMLStreamWriter;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static XMLStreamWriter createXMLStreamWriter(Result r) {
        Object object;
        block13: {
            Object nd;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamWriter", new Object[]{r});
            }
            if (r instanceof DOMResult) {
                DOMResult dr = (DOMResult)r;
                nd = dr.getNode();
                if (nd instanceof Document) {
                    W3CDOMStreamWriter w3CDOMStreamWriter = new W3CDOMStreamWriter((Document)nd);
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        w3CDOMStreamWriter = w3CDOMStreamWriter;
                        LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamWriter", w3CDOMStreamWriter);
                    }
                    return w3CDOMStreamWriter;
                }
                if (nd instanceof Element) {
                    W3CDOMStreamWriter w3CDOMStreamWriter = new W3CDOMStreamWriter((Element)nd);
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        w3CDOMStreamWriter = w3CDOMStreamWriter;
                        LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamWriter", w3CDOMStreamWriter);
                    }
                    return w3CDOMStreamWriter;
                }
                if (nd instanceof DocumentFragment) {
                    W3CDOMStreamWriter w3CDOMStreamWriter = new W3CDOMStreamWriter((DocumentFragment)nd);
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        w3CDOMStreamWriter = w3CDOMStreamWriter;
                        LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamWriter", w3CDOMStreamWriter);
                    }
                    return w3CDOMStreamWriter;
                }
            }
            XMLOutputFactory factory = StaxUtils.getXMLOutputFactory();
            try {
                nd = factory.createXMLStreamWriter(r);
                object = nd;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block13;
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Cant' create XMLStreamWriter", e);
            }
            finally {
                StaxUtils.returnXMLOutputFactory(factory);
            }
            object = object;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamWriter", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static XMLStreamReader createFilteredReader(XMLStreamReader reader, StreamFilter filter) {
        XMLStreamReader xMLStreamReader;
        block6: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.staxutils.StaxUtils", "createFilteredReader", new Object[]{reader, filter});
            }
            XMLInputFactory factory = StaxUtils.getXMLInputFactory();
            try {
                XMLStreamReader xMLStreamReader2 = factory.createFilteredReader(reader, filter);
                xMLStreamReader = xMLStreamReader2;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block6;
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Cant' create XMLStreamReader", e);
            }
            finally {
                StaxUtils.returnXMLInputFactory(factory);
            }
            xMLStreamReader = xMLStreamReader;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "createFilteredReader", xMLStreamReader);
        }
        return xMLStreamReader;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void nextEvent(XMLStreamReader dr) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "nextEvent", new Object[]{dr});
        }
        try {
            dr.next();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "nextEvent");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean toNextText(DepthXMLStreamReader reader) {
        block10: {
            block8: {
                block9: {
                    if (StaxUtils.LOG != null && StaxUtils.LOG.isLoggable(Level.FINER)) {
                        StaxUtils.LOG.entering("org.apache.cxf.staxutils.StaxUtils", "toNextText", new Object[]{reader});
                    }
                    if (reader.getEventType() == 4) {
                        v0 = true;
                        if (StaxUtils.LOG != null && StaxUtils.LOG.isLoggable(Level.FINER)) {
                            v0 = v0;
                            StaxUtils.LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "toNextText", v0);
                        }
                        return v0;
                    }
                    try {
                        depth = reader.getDepth();
                        event = reader.getEventType();
lbl13:
                        // 2 sources

                        while (reader.getDepth() >= depth && reader.hasNext()) {
                            if (event == 4 && reader.getDepth() == depth + 1) {
                                v1 = true;
                                if (StaxUtils.LOG == null || !StaxUtils.LOG.isLoggable(Level.FINER)) break block8;
                                break block9;
                            }
                            ** GOTO lbl-1000
                        }
                        ** GOTO lbl29
                    }
                    catch (XMLStreamException e) {
                        throw new RuntimeException("Couldn't parse stream.", e);
                    }
                }
                v1 = v1;
                StaxUtils.LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "toNextText", v1);
            }
            return v1;
lbl-1000:
            // 1 sources

            {
                event = reader.next();
                ** GOTO lbl13
lbl29:
                // 1 sources

                v2 = false;
                if (StaxUtils.LOG == null || !StaxUtils.LOG.isLoggable(Level.FINER)) break block10;
            }
            v2 = v2;
            StaxUtils.LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "toNextText", v2);
        }
        return v2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean toNextTag(XMLStreamReader reader) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "toNextTag", new Object[]{reader});
        }
        try {
            int x = reader.getEventType();
            while (x != 1 && x != 2 && reader.hasNext()) {
                x = reader.next();
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "toNextTag", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean toNextTag(DepthXMLStreamReader reader, QName endTag) {
        block8: {
            block6: {
                block7: {
                    if (StaxUtils.LOG != null && StaxUtils.LOG.isLoggable(Level.FINER)) {
                        StaxUtils.LOG.entering("org.apache.cxf.staxutils.StaxUtils", "toNextTag", new Object[]{reader, endTag});
                    }
                    try {
                        depth = reader.getDepth();
                        event = reader.getEventType();
lbl7:
                        // 2 sources

                        while (reader.getDepth() >= depth && reader.hasNext()) {
                            if (event == 1 && reader.getName().equals(endTag) && reader.getDepth() == depth + 1) {
                                v0 = true;
                                if (StaxUtils.LOG == null || !StaxUtils.LOG.isLoggable(Level.FINER)) break block6;
                                break block7;
                            }
                            ** GOTO lbl-1000
                        }
                        ** GOTO lbl23
                    }
                    catch (XMLStreamException e) {
                        throw new RuntimeException("Couldn't parse stream.", e);
                    }
                }
                v0 = v0;
                StaxUtils.LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "toNextTag", v0);
            }
            return v0;
lbl-1000:
            // 1 sources

            {
                event = reader.next();
                ** GOTO lbl7
lbl23:
                // 1 sources

                v1 = false;
                if (StaxUtils.LOG == null || !StaxUtils.LOG.isLoggable(Level.FINER)) break block8;
            }
            v1 = v1;
            StaxUtils.LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "toNextTag", v1);
        }
        return v1;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void writeStartElement(XMLStreamWriter writer, String prefix, String name, String namespace) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "writeStartElement", new Object[]{writer, prefix, name, namespace});
        }
        if (prefix == null) {
            prefix = "";
        }
        if (namespace.length() > 0) {
            writer.writeStartElement(prefix, name, namespace);
            if (prefix.length() > 0) {
                writer.writeNamespace(prefix, namespace);
                writer.setPrefix(prefix, namespace);
            } else {
                writer.writeDefaultNamespace(namespace);
                writer.setDefaultNamespace(namespace);
            }
        } else {
            writer.writeStartElement(name);
            writer.writeDefaultNamespace("");
            writer.setDefaultNamespace("");
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "writeStartElement");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean skipToStartOfElement(XMLStreamReader in) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "skipToStartOfElement", new Object[]{in});
        }
        int code = in.getEventType();
        while (code != 8) {
            if (code == 1) {
                boolean bl = true;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "skipToStartOfElement", bl);
                }
                return bl;
            }
            code = in.next();
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "skipToStartOfElement", bl);
        }
        return bl;
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean toNextElement(DepthXMLStreamReader dr) {
        LOG.entering("StaxUtils", "toNextElement");
        if (dr.getEventType() == 1) {
            return true;
        }
        if (dr.getEventType() == 2) {
            return false;
        }
        try {
            int depth = dr.getDepth();
            int event = dr.getEventType();
            while (dr.getDepth() >= depth && dr.hasNext()) {
                if (event == 1 && dr.getDepth() == depth + 1) {
                    return true;
                }
                if (event == 2) {
                    --depth;
                }
                event = dr.next();
            }
            LOG.exiting("StaxUtils", "toNextElement");
            return false;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't parse stream.", e);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean skipToStartOfElement(DepthXMLStreamReader in) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "skipToStartOfElement", new Object[]{in});
        }
        int code = in.getEventType();
        while (code != 8) {
            if (code == 1) {
                boolean bl = true;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "skipToStartOfElement", bl);
                }
                return bl;
            }
            code = in.next();
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "skipToStartOfElement", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void copy(Source source, OutputStream os) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "copy", new Object[]{source, os});
        }
        XMLStreamWriter writer = StaxUtils.createXMLStreamWriter(os);
        try {
            StaxUtils.copy(source, writer);
        }
        finally {
            try {
                writer.flush();
            }
            catch (XMLStreamException xMLStreamException) {}
            StaxUtils.close(writer);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "copy");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void copy(Source source, XMLStreamWriter writer) throws XMLStreamException {
        block21: {
            Source ss2;
            block24: {
                block23: {
                    block22: {
                        if (LOG != null && LOG.isLoggable(Level.FINER)) {
                            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "copy", new Object[]{source, writer});
                        }
                        if (!(source instanceof StaxSource)) break block22;
                        ss2 = (StaxSource)source;
                        if (((StaxSource)ss2).getXMLStreamReader() == null) {
                            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                                LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "copy");
                            }
                            return;
                        }
                        break block21;
                    }
                    if (!"javax.xml.transform.stax.StAXSource".equals(source.getClass().getName())) break block23;
                    try {
                        if (source.getClass().getMethod("getXMLStreamReader", new Class[0]).invoke((Object)source, new Object[0]) == null) {
                            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                                LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "copy");
                            }
                            return;
                        }
                        break block21;
                    }
                    catch (Exception ss2) {}
                    break block21;
                }
                if (!(source instanceof SAXSource)) break block24;
                ss2 = (SAXSource)source;
                InputSource src = ((SAXSource)ss2).getInputSource();
                if (src == null || src.getSystemId() == null && src.getPublicId() == null) {
                    if (((SAXSource)ss2).getXMLReader() != null) {
                        StreamWriterContentHandler ch = new StreamWriterContentHandler(writer);
                        XMLReader reader = ((SAXSource)source).getXMLReader();
                        reader.setContentHandler(ch);
                        try {
                            try {
                                reader.setFeature("http://xml.org/sax/features/namespaces", true);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                reader.setProperty("http://xml.org/sax/properties/lexical-handler", ch);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            reader.parse(((SAXSource)source).getInputSource());
                            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                                LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "copy");
                            }
                            return;
                        }
                        catch (Exception e) {
                            throw new XMLStreamException(e);
                        }
                    }
                    if (((SAXSource)ss2).getInputSource() == null) {
                        if (LOG != null && LOG.isLoggable(Level.FINER)) {
                            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "copy");
                        }
                        return;
                    }
                }
                break block21;
            }
            if (source instanceof StreamSource && ((StreamSource)(ss2 = (StreamSource)source)).getInputStream() == null && ((StreamSource)ss2).getReader() == null && ((StreamSource)ss2).getSystemId() == null) {
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "copy");
                }
                return;
            }
        }
        XMLStreamReader reader = StaxUtils.createXMLStreamReader(source);
        StaxUtils.copy(reader, writer);
        reader.close();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "copy");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Document copy(Document doc) throws XMLStreamException, ParserConfigurationException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "copy", new Object[]{doc});
        }
        XMLStreamReader reader = StaxUtils.createXMLStreamReader(doc);
        W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
        StaxUtils.copy(reader, (XMLStreamWriter)writer);
        Document d = writer.getDocument();
        try {
            d.setDocumentURI(doc.getDocumentURI());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Document document = d;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            document = document;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "copy", document);
        }
        return document;
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void copy(Document doc, XMLStreamWriter writer) throws XMLStreamException {
        LOG.entering("StaxUtils", "copy");
        XMLStreamReader reader = StaxUtils.createXMLStreamReader(doc);
        StaxUtils.copy(reader, writer);
        LOG.exiting("StaxUtils", "copy");
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void copy(Element node, XMLStreamWriter writer) throws XMLStreamException {
        LOG.entering("StaxUtils", "copy");
        XMLStreamReader reader = StaxUtils.createXMLStreamReader(node);
        StaxUtils.copy(reader, writer);
        LOG.exiting("StaxUtils", "copy");
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void copy(XMLStreamReader reader, OutputStream os) throws XMLStreamException {
        LOG.entering("StaxUtils", "copy");
        XMLStreamWriter xsw = StaxUtils.createXMLStreamWriter(os);
        StaxUtils.copy(reader, xsw);
        xsw.close();
        LOG.exiting("StaxUtils", "copy");
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void copy(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        LOG.entering("StaxUtils", "copy");
        StaxUtils.copy(reader, writer, false);
        LOG.exiting("StaxUtils", "copy");
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void copy(XMLStreamReader reader, XMLStreamWriter writer, boolean fragment) throws XMLStreamException {
        LOG.entering("StaxUtils", "copy");
        int read = 0;
        int event = reader.getEventType();
        while (reader.hasNext()) {
            switch (event) {
                case 1: {
                    ++read;
                    StaxUtils.writeStartElement(reader, writer);
                    break;
                }
                case 2: {
                    writer.writeEndElement();
                    if (--read > 0 || fragment) break;
                    LOG.exiting("StaxUtils", "copy");
                    return;
                }
                case 4: {
                    String s = reader.getText();
                    if (s == null) break;
                    writer.writeCharacters(s);
                    break;
                }
                case 5: {
                    writer.writeComment(reader.getText());
                    break;
                }
                case 12: {
                    writer.writeCData(reader.getText());
                    break;
                }
                case 7: 
                case 8: 
                case 10: 
                case 13: {
                    break;
                }
            }
            event = reader.next();
        }
        LOG.exiting("StaxUtils", "copy");
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void writeStartElement(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        String nsPrefix;
        int i;
        LOG.entering("StaxUtils", "writeStartElement");
        String uri = reader.getNamespaceURI();
        String prefix = reader.getPrefix();
        String local = reader.getLocalName();
        if (prefix == null) {
            prefix = "";
        }
        boolean writeElementNS = false;
        if (uri != null) {
            writeElementNS = true;
            Iterator it = CastUtils.cast(writer.getNamespaceContext().getPrefixes(uri));
            while (it != null && it.hasNext()) {
                String s = (String)it.next();
                if (s == null) {
                    s = "";
                }
                if (!s.equals(prefix)) continue;
                writeElementNS = false;
            }
        }
        if (uri != null) {
            if (prefix.length() == 0 && StringUtils.isEmpty(uri)) {
                writer.writeStartElement(local);
            } else {
                writer.writeStartElement(prefix, local, uri);
            }
        } else {
            writer.writeStartElement(local);
        }
        for (i = 0; i < reader.getNamespaceCount(); ++i) {
            String nsURI = reader.getNamespaceURI(i);
            nsPrefix = reader.getNamespacePrefix(i);
            if (nsPrefix == null) {
                nsPrefix = "";
            }
            if (nsPrefix.length() == 0) {
                writer.writeDefaultNamespace(nsURI);
                writer.setDefaultNamespace(nsURI);
            } else {
                writer.writeNamespace(nsPrefix, nsURI);
                writer.setPrefix(nsPrefix, nsURI);
            }
            if (!nsURI.equals(uri) || !nsPrefix.equals(prefix)) continue;
            writeElementNS = false;
        }
        if (writeElementNS) {
            if (prefix.length() == 0) {
                writer.writeDefaultNamespace(uri);
                writer.setDefaultNamespace(uri);
            } else {
                writer.writeNamespace(prefix, uri);
                writer.setPrefix(prefix, uri);
            }
        }
        for (i = 0; i < reader.getAttributeCount(); ++i) {
            String ns = reader.getAttributeNamespace(i);
            nsPrefix = reader.getAttributePrefix(i);
            if (ns == null || ns.length() == 0) {
                writer.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            if (nsPrefix == null || nsPrefix.length() == 0) {
                writer.writeAttribute(reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            Iterator it = CastUtils.cast(writer.getNamespaceContext().getPrefixes(ns));
            boolean writeNs = true;
            while (it != null && it.hasNext()) {
                String s = (String)it.next();
                if (s == null) {
                    s = "";
                }
                if (!s.equals(nsPrefix)) continue;
                writeNs = false;
            }
            if (writeNs) {
                writer.writeNamespace(nsPrefix, ns);
                writer.setPrefix(nsPrefix, ns);
            }
            writer.writeAttribute(reader.getAttributePrefix(i), reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
        }
        LOG.exiting("StaxUtils", "writeStartElement");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void writeDocument(Document d, XMLStreamWriter writer, boolean repairing) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "writeDocument", new Object[]{d, writer, repairing});
        }
        StaxUtils.writeDocument(d, writer, true, repairing);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "writeDocument");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void writeDocument(Document d, XMLStreamWriter writer, boolean writeProlog, boolean repairing) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "writeDocument", new Object[]{d, writer, writeProlog, repairing});
        }
        if (writeProlog) {
            writer.writeStartDocument();
        }
        for (Node node = d.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!writeProlog && node.getNodeType() != 1) continue;
            StaxUtils.writeNode(node, writer, repairing);
        }
        if (writeProlog) {
            writer.writeEndDocument();
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "writeDocument");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void writeElement(Element e, XMLStreamWriter writer, boolean repairing) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "writeElement", new Object[]{e, writer, repairing});
        }
        StaxUtils.writeElement(e, writer, repairing, true);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "writeElement");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void writeElement(Element e, XMLStreamWriter writer, boolean repairing, boolean endElement) throws XMLStreamException {
        boolean declareNamespace;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "writeElement", new Object[]{e, writer, repairing, endElement});
        }
        String prefix = e.getPrefix();
        String ns = e.getNamespaceURI();
        String localName = e.getLocalName();
        if (prefix == null) {
            prefix = "";
        }
        if (localName == null && (localName = e.getNodeName()) == null) {
            throw new IllegalStateException("Element's local name cannot be null!");
        }
        String decUri = writer.getNamespaceContext().getNamespaceURI(prefix);
        boolean bl = declareNamespace = decUri == null || !decUri.equals(ns);
        if (ns == null || ns.length() == 0) {
            writer.writeStartElement(localName);
            if (StringUtils.isEmpty(decUri)) {
                declareNamespace = false;
            }
        } else {
            writer.writeStartElement(prefix, localName, ns);
        }
        for (Node attr : StaxUtils.sortElementAttributes(e.getAttributes())) {
            String name = attr.getLocalName();
            String attrPrefix = attr.getPrefix();
            if (attrPrefix == null) {
                attrPrefix = "";
            }
            if (name == null) {
                name = attr.getNodeName();
            }
            if ("xmlns".equals(attrPrefix)) {
                writer.writeNamespace(name, attr.getNodeValue());
                writer.setPrefix(name, attr.getNodeValue());
                if (!name.equals(prefix) || !attr.getNodeValue().equals(ns)) continue;
                declareNamespace = false;
                continue;
            }
            if ("xmlns".equals(name) && "".equals(attrPrefix)) {
                writer.writeDefaultNamespace(attr.getNodeValue());
                writer.setDefaultNamespace(attr.getNodeValue());
                if (attr.getNodeValue().equals(ns)) {
                    declareNamespace = false;
                    continue;
                }
                if (!StringUtils.isEmpty(attr.getNodeValue()) || !StringUtils.isEmpty(ns)) continue;
                declareNamespace = false;
                continue;
            }
            String attns = attr.getNamespaceURI();
            String value = attr.getNodeValue();
            if (attns == null || attns.length() == 0) {
                writer.writeAttribute(name, value);
                continue;
            }
            if (attrPrefix.length() == 0) {
                writer.writeAttribute(attns, name, value);
                continue;
            }
            if (repairing && writer.getNamespaceContext().getNamespaceURI(attrPrefix) == null) {
                writer.writeNamespace(attrPrefix, attns);
            }
            writer.writeAttribute(attrPrefix, attns, name, value);
        }
        if (declareNamespace && repairing) {
            if (ns == null) {
                writer.writeNamespace(prefix, "");
                writer.setPrefix(prefix, "");
            } else {
                writer.writeNamespace(prefix, ns);
                writer.setPrefix(prefix, ns);
            }
        }
        for (Node nd = e.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            StaxUtils.writeNode(nd, writer, repairing);
        }
        if (endElement) {
            writer.writeEndElement();
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "writeElement");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static List<Node> sortElementAttributes(NamedNodeMap attrs) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "sortElementAttributes", new Object[]{attrs});
        }
        if (attrs.getLength() == 0) {
            List<Node> list = Collections.emptyList();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                list = list;
                LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "sortElementAttributes", list);
            }
            return list;
        }
        LinkedList<Node> sortedAttrs = new LinkedList<Node>();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getLocalName();
            if (name == null) {
                name = attr.getNodeName();
            }
            if ("xmlns".equals(attr.getPrefix()) || "xmlns".equals(name)) {
                sortedAttrs.add(0, attr);
                continue;
            }
            sortedAttrs.add(attr);
        }
        LinkedList<Node> linkedList = sortedAttrs;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            linkedList = linkedList;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "sortElementAttributes", linkedList);
        }
        return linkedList;
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void writeNode(Node n, XMLStreamWriter writer, boolean repairing) throws XMLStreamException {
        LOG.entering("StaxUtils", "writeNode");
        switch (n.getNodeType()) {
            case 1: {
                StaxUtils.writeElement((Element)n, writer, repairing);
                break;
            }
            case 3: {
                writer.writeCharacters(((Text)n).getNodeValue());
                break;
            }
            case 8: {
                writer.writeComment(((Comment)n).getData());
                break;
            }
            case 4: {
                writer.writeCData(((CDATASection)n).getData());
                break;
            }
            case 5: {
                writer.writeEntityRef(((org.w3c.dom.EntityReference)n).getNodeValue());
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)n;
                writer.writeProcessingInstruction(pi.getTarget(), pi.getData());
                break;
            }
            case 9: {
                StaxUtils.writeDocument((Document)n, writer, repairing);
                break;
            }
            case 11: {
                DocumentFragment frag = (DocumentFragment)n;
                for (Node child = frag.getFirstChild(); child != null; child = child.getNextSibling()) {
                    StaxUtils.writeNode(child, writer, repairing);
                }
                break;
            }
            case 10: {
                try {
                    if (((DocumentType)n).getTextContent() == null) break;
                    writer.writeDTD(((DocumentType)n).getTextContent());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
                break;
            }
            default: {
                throw new IllegalStateException("Found type: " + n.getClass().getName());
            }
        }
        LOG.exiting("StaxUtils", "writeNode");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Document read(Source s) throws XMLStreamException {
        Document document;
        XMLStreamReader reader;
        block8: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.staxutils.StaxUtils", "read", new Object[]{s});
            }
            reader = StaxUtils.createXMLStreamReader(s);
            Document document2 = StaxUtils.read(reader);
            document = document2;
            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block8;
            document = document;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "read", document);
        }
        return document;
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Document read(InputStream s) throws XMLStreamException {
        Document document;
        XMLStreamReader reader;
        block8: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.staxutils.StaxUtils", "read", new Object[]{s});
            }
            reader = StaxUtils.createXMLStreamReader(s);
            Document document2 = StaxUtils.read(reader);
            document = document2;
            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block8;
            document = document;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "read", document);
        }
        return document;
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Document read(InputSource s) throws XMLStreamException {
        Document document;
        XMLStreamReader reader;
        block8: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.staxutils.StaxUtils", "read", new Object[]{s});
            }
            reader = StaxUtils.createXMLStreamReader(s);
            Document document2 = StaxUtils.read(reader);
            document = document2;
            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block8;
            document = document;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "read", document);
        }
        return document;
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Document read(XMLStreamReader reader) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "read", new Object[]{reader});
        }
        Document document = StaxUtils.read(reader, false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            document = document;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "read", document);
        }
        return document;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Document read(XMLStreamReader reader, boolean recordLoc) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "read", new Object[]{reader, recordLoc});
        }
        Document doc = DOMUtils.createDocument();
        if (reader.getLocation().getSystemId() != null) {
            try {
                doc.setDocumentURI(new String(reader.getLocation().getSystemId()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        StaxUtils.readDocElements(doc, doc, reader, true, recordLoc);
        Document document = doc;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            document = document;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "read", document);
        }
        return document;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Document read(DocumentBuilder builder, XMLStreamReader reader, boolean repairing) throws XMLStreamException {
        Document doc;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "read", new Object[]{builder, reader, repairing});
        }
        Document document = doc = builder == null ? DOMUtils.createDocument() : builder.newDocument();
        if (reader.getLocation().getSystemId() != null) {
            try {
                doc.setDocumentURI(new String(reader.getLocation().getSystemId()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        StaxUtils.readDocElements(doc, reader, repairing);
        Document document2 = doc;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            document2 = document2;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "read", document2);
        }
        return document2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Document getDocument(Node parent) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "getDocument", new Object[]{parent});
        }
        Document document = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            document = document;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "getDocument", document);
        }
        return document;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean isDeclared(Element e, String namespaceURI, String prefix) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "isDeclared", new Object[]{e, namespaceURI, prefix});
        }
        while (e != null) {
            Attr att = prefix != null && prefix.length() > 0 ? e.getAttributeNodeNS(XML_NS, prefix) : e.getAttributeNode("xmlns");
            if (att != null && att.getNodeValue().equals(namespaceURI)) {
                boolean bl = true;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "isDeclared", bl);
                }
                return bl;
            }
            if (e.getParentNode() instanceof Element) {
                e = (Element)e.getParentNode();
                continue;
            }
            if (StringUtils.isEmpty(prefix) && StringUtils.isEmpty(namespaceURI)) {
                boolean bl = true;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "isDeclared", bl);
                }
                return bl;
            }
            e = null;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "isDeclared", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void readDocElements(Node parent, XMLStreamReader reader, boolean repairing) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "readDocElements", new Object[]{parent, reader, repairing});
        }
        Document doc = StaxUtils.getDocument(parent);
        StaxUtils.readDocElements(doc, parent, reader, repairing, false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "readDocElements");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void readDocElements(Node parent, XMLStreamReader reader, boolean repairing, boolean isThreshold) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "readDocElements", new Object[]{parent, reader, repairing, isThreshold});
        }
        Document doc = StaxUtils.getDocument(parent);
        StaxUtils.readDocElements(doc, parent, reader, repairing, false, isThreshold);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "readDocElements");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void readDocElements(Document doc, Node parent, XMLStreamReader reader, boolean repairing, boolean recordLoc) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "readDocElements", new Object[]{doc, parent, reader, repairing, recordLoc});
        }
        StaxUtils.readDocElements(doc, parent, reader, repairing, recordLoc, false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "readDocElements");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void readDocElements(Document doc, Node parent, XMLStreamReader reader, boolean repairing, boolean recordLoc, boolean isThreshold) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "readDocElements", new Object[]{doc, parent, reader, repairing, recordLoc, isThreshold});
        }
        Stack<Node> stack = new Stack<Node>();
        int event = reader.getEventType();
        int elementCount = 0;
        while (reader.hasNext()) {
            switch (event) {
                case 1: {
                    String prefix;
                    ++elementCount;
                    Element e = !StringUtils.isEmpty(reader.getPrefix()) ? doc.createElementNS(reader.getNamespaceURI(), reader.getPrefix() + ":" + reader.getLocalName()) : doc.createElementNS(reader.getNamespaceURI(), reader.getLocalName());
                    e = (Element)parent.appendChild(e);
                    recordLoc = StaxUtils.addLocation(doc, (Node)e, reader, recordLoc);
                    for (int ns = 0; ns < reader.getNamespaceCount(); ++ns) {
                        String uri = reader.getNamespaceURI(ns);
                        prefix = reader.getNamespacePrefix(ns);
                        StaxUtils.declare(e, uri, prefix);
                    }
                    for (int att = 0; att < reader.getAttributeCount(); ++att) {
                        String name = reader.getAttributeLocalName(att);
                        prefix = reader.getAttributePrefix(att);
                        if (prefix != null && prefix.length() > 0) {
                            name = prefix + ":" + name;
                        }
                        Attr attr = doc.createAttributeNS(reader.getAttributeNamespace(att), name);
                        attr.setValue(reader.getAttributeValue(att));
                        e.setAttributeNode(attr);
                    }
                    if (repairing && !StaxUtils.isDeclared(e, reader.getNamespaceURI(), reader.getPrefix())) {
                        StaxUtils.declare(e, reader.getNamespaceURI(), reader.getPrefix());
                    }
                    stack.push(parent);
                    if (isThreshold && innerElementLevelThreshold != -1 && stack.size() >= innerElementLevelThreshold) {
                        throw new DepthExceededStaxException("reach the innerElementLevelThreshold:" + innerElementLevelThreshold);
                    }
                    if (isThreshold && innerElementCountThreshold != -1 && elementCount >= innerElementCountThreshold) {
                        throw new DepthExceededStaxException("reach the innerElementCountThreshold:" + innerElementCountThreshold);
                    }
                    parent = e;
                    break;
                }
                case 2: {
                    if (stack.isEmpty()) {
                        if (LOG != null && LOG.isLoggable(Level.FINER)) {
                            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "readDocElements");
                        }
                        return;
                    }
                    parent = (Node)stack.pop();
                    if (!(parent instanceof Document)) break;
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "readDocElements");
                    }
                    return;
                }
                case 13: {
                    break;
                }
                case 10: {
                    break;
                }
                case 4: {
                    if (parent == null) break;
                    recordLoc = StaxUtils.addLocation(doc, parent.appendChild(doc.createTextNode(reader.getText())), reader, recordLoc);
                    break;
                }
                case 5: {
                    if (parent == null) break;
                    parent.appendChild(doc.createComment(reader.getText()));
                    break;
                }
                case 12: {
                    recordLoc = StaxUtils.addLocation(doc, parent.appendChild(doc.createCDATASection(reader.getText())), reader, recordLoc);
                    break;
                }
                case 3: {
                    parent.appendChild(doc.createProcessingInstruction(reader.getPITarget(), reader.getPIData()));
                    break;
                }
                case 9: {
                    parent.appendChild(doc.createProcessingInstruction(reader.getPITarget(), reader.getPIData()));
                    break;
                }
            }
            if (!reader.hasNext()) continue;
            event = reader.next();
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "readDocElements");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void readDocElements(Document doc, Node parent, XMLStreamReader reader, StreamToDOMContext context) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "readDocElements", new Object[]{doc, parent, reader, context});
        }
        int event = reader.getEventType();
        while (reader.hasNext()) {
            switch (event) {
                case 1: {
                    String prefix;
                    context.incrementCount();
                    Element e = !StringUtils.isEmpty(reader.getPrefix()) ? doc.createElementNS(reader.getNamespaceURI(), reader.getPrefix() + ":" + reader.getLocalName()) : doc.createElementNS(reader.getNamespaceURI(), reader.getLocalName());
                    e = (Element)parent.appendChild(e);
                    if (context.isRecordLoc()) {
                        context.setRecordLoc(StaxUtils.addLocation(doc, (Node)e, reader.getLocation(), context.isRecordLoc()));
                    }
                    for (int ns = 0; ns < reader.getNamespaceCount(); ++ns) {
                        String uri = reader.getNamespaceURI(ns);
                        prefix = reader.getNamespacePrefix(ns);
                        StaxUtils.declare(e, uri, prefix);
                    }
                    for (int att = 0; att < reader.getAttributeCount(); ++att) {
                        String name = reader.getAttributeLocalName(att);
                        prefix = reader.getAttributePrefix(att);
                        if (prefix != null && prefix.length() > 0) {
                            name = prefix + ":" + name;
                        }
                        Attr attr = doc.createAttributeNS(reader.getAttributeNamespace(att), name);
                        attr.setValue(reader.getAttributeValue(att));
                        e.setAttributeNode(attr);
                    }
                    if (context.isRepairing() && !StaxUtils.isDeclared(e, reader.getNamespaceURI(), reader.getPrefix())) {
                        StaxUtils.declare(e, reader.getNamespaceURI(), reader.getPrefix());
                    }
                    context.pushToStack(parent);
                    if (context.isThreshold() && innerElementLevelThreshold != -1 && context.getStackSize() >= innerElementLevelThreshold) {
                        throw new DepthExceededStaxException("reach the innerElementLevelThreshold:" + innerElementLevelThreshold);
                    }
                    if (context.isThreshold() && innerElementCountThreshold != -1 && context.getCount() >= innerElementCountThreshold) {
                        throw new DepthExceededStaxException("reach the innerElementCountThreshold:" + innerElementCountThreshold);
                    }
                    parent = e;
                    break;
                }
                case 2: {
                    if (context.isStackEmpty()) {
                        if (LOG != null && LOG.isLoggable(Level.FINER)) {
                            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "readDocElements");
                        }
                        return;
                    }
                    parent = context.popFromStack();
                    if (!(parent instanceof Document)) break;
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "readDocElements");
                    }
                    return;
                }
                case 13: {
                    break;
                }
                case 10: {
                    break;
                }
                case 4: {
                    if (parent == null) break;
                    context.setRecordLoc(StaxUtils.addLocation(doc, parent.appendChild(doc.createTextNode(reader.getText())), reader.getLocation(), context.isRecordLoc()));
                    break;
                }
                case 5: {
                    if (parent == null) break;
                    parent.appendChild(doc.createComment(reader.getText()));
                    break;
                }
                case 12: {
                    context.setRecordLoc(StaxUtils.addLocation(doc, parent.appendChild(doc.createCDATASection(reader.getText())), reader.getLocation(), context.isRecordLoc()));
                    break;
                }
                case 3: {
                    parent.appendChild(doc.createProcessingInstruction(reader.getPITarget(), reader.getPIData()));
                    break;
                }
                case 9: {
                    parent.appendChild(doc.createProcessingInstruction(reader.getPITarget(), reader.getPIData()));
                    break;
                }
            }
            if (!reader.hasNext()) continue;
            event = reader.next();
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "readDocElements");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Node readDocElement(Document doc, Node parent, XMLEvent ev, StreamToDOMContext context) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "readDocElement", new Object[]{doc, parent, ev, context});
        }
        switch (ev.getEventType()) {
            case 1: {
                context.incrementCount();
                StartElement startElem = ev.asStartElement();
                QName name = startElem.getName();
                Element e = !StringUtils.isEmpty(name.getPrefix()) ? doc.createElementNS(name.getNamespaceURI(), name.getPrefix() + ":" + name.getLocalPart()) : doc.createElementNS(name.getNamespaceURI(), name.getLocalPart());
                e = (Element)parent.appendChild(e);
                if (context.isRecordLoc()) {
                    context.setRecordLoc(StaxUtils.addLocation(doc, (Node)e, startElem.getLocation(), context.isRecordLoc()));
                }
                if (context.isRepairing() && !StaxUtils.isDeclared(e, name.getNamespaceURI(), name.getPrefix())) {
                    StaxUtils.declare(e, name.getNamespaceURI(), name.getPrefix());
                }
                context.pushToStack(parent);
                if (context.isThreshold() && innerElementLevelThreshold != -1 && context.getStackSize() >= innerElementLevelThreshold) {
                    throw new DepthExceededStaxException("reach the innerElementLevelThreshold:" + innerElementLevelThreshold);
                }
                if (context.isThreshold() && innerElementCountThreshold != -1 && context.getCount() >= innerElementCountThreshold) {
                    throw new DepthExceededStaxException("reach the innerElementCountThreshold:" + innerElementCountThreshold);
                }
                parent = e;
                break;
            }
            case 2: {
                if (context.isStackEmpty()) {
                    Node node = parent;
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        node = node;
                        LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "readDocElement", node);
                    }
                    return node;
                }
                parent = context.popFromStack();
                if (!(parent instanceof Document)) break;
                Node node = parent;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    node = node;
                    LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "readDocElement", node);
                }
                return node;
            }
            case 13: {
                Namespace ns = (Namespace)ev;
                StaxUtils.declare((Element)parent, ns.getNamespaceURI(), ns.getPrefix());
                break;
            }
            case 10: {
                Attribute at = (Attribute)ev;
                QName qname = at.getName();
                String attName = qname.getLocalPart();
                String attPrefix = qname.getPrefix();
                if (attPrefix != null && attPrefix.length() > 0) {
                    attName = attPrefix + ":" + attName;
                }
                Attr attr = doc.createAttributeNS(qname.getNamespaceURI(), attName);
                attr.setValue(at.getValue());
                ((Element)parent).setAttributeNode(attr);
                break;
            }
            case 4: {
                if (parent == null) break;
                Characters characters = ev.asCharacters();
                context.setRecordLoc(StaxUtils.addLocation(doc, parent.appendChild(doc.createTextNode(characters.getData())), characters.getLocation(), context.isRecordLoc()));
                break;
            }
            case 5: {
                if (parent == null) break;
                parent.appendChild(doc.createComment(((javax.xml.stream.events.Comment)ev).getText()));
                break;
            }
            case 12: {
                Characters characters = ev.asCharacters();
                context.setRecordLoc(StaxUtils.addLocation(doc, parent.appendChild(doc.createCDATASection(characters.getData())), characters.getLocation(), context.isRecordLoc()));
                break;
            }
            case 3: {
                parent.appendChild(doc.createProcessingInstruction(((ProcessingInstruction)((Object)ev)).getTarget(), ((ProcessingInstruction)((Object)ev)).getData()));
                break;
            }
            case 9: {
                EntityReference er = (EntityReference)ev;
                parent.appendChild(doc.createEntityReference(er.getName()));
                break;
            }
        }
        Node node = parent;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            node = node;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "readDocElement", node);
        }
        return node;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean addLocation(Document doc, Node node, Location loc, boolean recordLoc) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "addLocation", new Object[]{doc, node, loc, recordLoc});
        }
        if (recordLoc && loc != null && (loc.getColumnNumber() != 0 || loc.getLineNumber() != 0)) {
            try {
                final int charOffset = loc.getCharacterOffset();
                final int colNum = loc.getColumnNumber();
                final int linNum = loc.getLineNumber();
                final String pubId = loc.getPublicId() == null ? doc.getDocumentURI() : loc.getPublicId();
                final String sysId = loc.getSystemId() == null ? doc.getDocumentURI() : loc.getSystemId();
                Location loc2 = new Location(){
                    static final long serialVersionUID = -2711350019233244270L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public int getCharacterOffset() {
                        return charOffset;
                    }

                    @Override
                    public int getColumnNumber() {
                        return colNum;
                    }

                    @Override
                    public int getLineNumber() {
                        return linNum;
                    }

                    @Override
                    public String getPublicId() {
                        return pubId;
                    }

                    @Override
                    public String getSystemId() {
                        return sysId;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"org.apache.cxf.staxutils.StaxUtils$2", 2.class, null, null);
                    }
                };
                node.setUserData("location", loc2, LocationUserDataHandler.INSTANCE);
            }
            catch (Throwable ex) {
                boolean bl = false;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "addLocation", bl);
                }
                return bl;
            }
        }
        boolean bl = recordLoc;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "addLocation", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean addLocation(Document doc, Node node, XMLStreamReader reader, boolean recordLoc) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "addLocation", new Object[]{doc, node, reader, recordLoc});
        }
        boolean bl = StaxUtils.addLocation(doc, node, reader.getLocation(), recordLoc);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "addLocation", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void declare(Element node, String uri, String prefix) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "declare", new Object[]{node, uri, prefix});
        }
        String qualname = prefix != null && prefix.length() > 0 ? "xmlns:" + prefix : "xmlns";
        Attr attr = node.getOwnerDocument().createAttributeNS(XML_NS, qualname);
        attr.setValue(uri);
        node.setAttributeNodeNS(attr);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "declare");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static XMLStreamReader createXMLStreamReader(InputSource src) {
        XMLStreamReader xMLStreamReader;
        block9: {
            String pubId;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamReader", new Object[]{src});
            }
            String sysId = src.getSystemId() == null ? null : new String(src.getSystemId());
            String string = pubId = src.getPublicId() == null ? null : new String(src.getPublicId());
            if (src.getByteStream() != null) {
                if (src.getEncoding() == null) {
                    StreamSource ss = new StreamSource(src.getByteStream(), sysId);
                    ss.setPublicId(pubId);
                    XMLStreamReader xMLStreamReader2 = StaxUtils.createXMLStreamReader(ss);
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        xMLStreamReader2 = xMLStreamReader2;
                        LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamReader", xMLStreamReader2);
                    }
                    return xMLStreamReader2;
                }
                XMLStreamReader xMLStreamReader3 = StaxUtils.createXMLStreamReader(src.getByteStream(), src.getEncoding());
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    xMLStreamReader3 = xMLStreamReader3;
                    LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamReader", xMLStreamReader3);
                }
                return xMLStreamReader3;
            }
            if (src.getCharacterStream() != null) {
                StreamSource ss = new StreamSource(src.getCharacterStream(), sysId);
                ss.setPublicId(pubId);
                XMLStreamReader xMLStreamReader4 = StaxUtils.createXMLStreamReader(ss);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    xMLStreamReader4 = xMLStreamReader4;
                    LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamReader", xMLStreamReader4);
                }
                return xMLStreamReader4;
            }
            try {
                URL url = new URL(sysId);
                StreamSource ss = new StreamSource(url.openStream(), sysId);
                ss.setPublicId(pubId);
                xMLStreamReader = StaxUtils.createXMLStreamReader(ss);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block9;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("InputSource must have a ByteStream or CharacterStream");
            }
            xMLStreamReader = xMLStreamReader;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamReader", xMLStreamReader);
        }
        return xMLStreamReader;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static XMLStreamReader createXMLStreamReader(InputStream in, String encoding) {
        XMLStreamReader xMLStreamReader;
        block7: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamReader", new Object[]{in, encoding});
            }
            if (encoding == null) {
                encoding = "UTF-8";
            }
            XMLInputFactory factory = StaxUtils.getXMLInputFactory();
            try {
                XMLStreamReader xMLStreamReader2 = factory.createXMLStreamReader(in, encoding);
                xMLStreamReader = xMLStreamReader2;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block7;
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Couldn't parse stream.", e);
            }
            finally {
                StaxUtils.returnXMLInputFactory(factory);
            }
            xMLStreamReader = xMLStreamReader;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamReader", xMLStreamReader);
        }
        return xMLStreamReader;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static XMLStreamReader createXMLStreamReader(InputStream in) {
        XMLStreamReader xMLStreamReader;
        block6: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamReader", new Object[]{in});
            }
            XMLInputFactory factory = StaxUtils.getXMLInputFactory();
            try {
                XMLStreamReader xMLStreamReader2 = factory.createXMLStreamReader(in);
                xMLStreamReader = xMLStreamReader2;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block6;
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Couldn't parse stream.", e);
            }
            finally {
                StaxUtils.returnXMLInputFactory(factory);
            }
            xMLStreamReader = xMLStreamReader;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamReader", xMLStreamReader);
        }
        return xMLStreamReader;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static XMLStreamReader createXMLStreamReader(String systemId, InputStream in) {
        XMLStreamReader xMLStreamReader;
        block6: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamReader", new Object[]{systemId, in});
            }
            XMLInputFactory factory = StaxUtils.getXMLInputFactory();
            try {
                XMLStreamReader xMLStreamReader2 = factory.createXMLStreamReader(systemId, in);
                xMLStreamReader = xMLStreamReader2;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block6;
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Couldn't parse stream.", e);
            }
            finally {
                StaxUtils.returnXMLInputFactory(factory);
            }
            xMLStreamReader = xMLStreamReader;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamReader", xMLStreamReader);
        }
        return xMLStreamReader;
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static XMLStreamReader createXMLStreamReader(Element el) {
        LOG.entering("StaxUtils", "createXMLStreamReader");
        LOG.exiting("StaxUtils", "createXMLStreamReader");
        return new W3CDOMStreamReader(el);
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static XMLStreamReader createXMLStreamReader(Document doc) {
        LOG.entering("StaxUtils", "createXMLStreamReader");
        LOG.exiting("StaxUtils", "createXMLStreamReader");
        return new W3CDOMStreamReader(doc.getDocumentElement());
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static XMLStreamReader createXMLStreamReader(Element el, String sysId) {
        LOG.entering("StaxUtils", "createXMLStreamReader");
        LOG.exiting("StaxUtils", "createXMLStreamReader");
        return new W3CDOMStreamReader(el, sysId);
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static XMLStreamReader createXMLStreamReader(Document doc, String sysId) {
        LOG.entering("StaxUtils", "createXMLStreamReader");
        LOG.exiting("StaxUtils", "createXMLStreamReader");
        return new W3CDOMStreamReader(doc.getDocumentElement(), sysId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static XMLStreamReader createXMLStreamReader(Source source) {
        XMLStreamReader xMLStreamReader;
        LOG.entering("StaxUtils", "createXMLStreamReader");
        if (source instanceof DOMSource) {
            DOMSource ds = (DOMSource)source;
            Node nd = ds.getNode();
            Element el = null;
            if (nd instanceof Document) {
                el = ((Document)nd).getDocumentElement();
            } else if (nd instanceof Element) {
                el = (Element)nd;
            }
            if (null != el) {
                LOG.exiting("StaxUtils", "createXMLStreamReader");
                return new W3CDOMStreamReader(el, source.getSystemId());
            }
        } else if ("javax.xml.transform.stax.StAXSource".equals(source.getClass().getName())) {
            try {
                return (XMLStreamReader)source.getClass().getMethod("getXMLStreamReader", new Class[0]).invoke((Object)source, new Object[0]);
            }
            catch (Exception ds) {
            }
        } else {
            if (source instanceof StaxSource) {
                return ((StaxSource)source).getXMLStreamReader();
            }
            if (source instanceof SAXSource) {
                LOG.exiting("StaxUtils", "createXMLStreamReader");
                return StaxUtils.createXMLStreamReader(((SAXSource)source).getInputSource());
            }
        }
        XMLInputFactory factory = StaxUtils.getXMLInputFactory();
        try {
            XMLStreamReader reader = null;
            try {
                reader = factory.createXMLStreamReader(source);
            }
            catch (UnsupportedOperationException el) {
                // empty catch block
            }
            if (reader == null && source instanceof StreamSource) {
                StreamSource ss = (StreamSource)source;
                reader = ss.getInputStream() != null ? factory.createXMLStreamReader(ss.getSystemId(), ss.getInputStream()) : factory.createXMLStreamReader(ss.getSystemId(), ss.getReader());
            }
            LOG.exiting("StaxUtils", "createXMLStreamReader");
            xMLStreamReader = reader;
        }
        catch (Throwable throwable) {
            try {
                StaxUtils.returnXMLInputFactory(factory);
                throw throwable;
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Couldn't parse stream.", e);
            }
        }
        StaxUtils.returnXMLInputFactory(factory);
        return xMLStreamReader;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static XMLStreamReader createXMLStreamReader(Reader reader) {
        XMLStreamReader xMLStreamReader;
        block6: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamReader", new Object[]{reader});
            }
            XMLInputFactory factory = StaxUtils.getXMLInputFactory();
            try {
                XMLStreamReader xMLStreamReader2 = factory.createXMLStreamReader(reader);
                xMLStreamReader = xMLStreamReader2;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block6;
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Couldn't parse stream.", e);
            }
            finally {
                StaxUtils.returnXMLInputFactory(factory);
            }
            xMLStreamReader = xMLStreamReader;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "createXMLStreamReader", xMLStreamReader);
        }
        return xMLStreamReader;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static QName readQName(XMLStreamReader reader) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "readQName", new Object[]{reader});
        }
        String value = reader.getElementText();
        if (value == null) {
            QName qName = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "readQName", qName);
            }
            return qName;
        }
        int index = value.indexOf(":");
        if (index == -1) {
            QName qName = new QName(value);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "readQName", qName);
            }
            return qName;
        }
        String prefix = value.substring(0, index);
        String localName = value.substring(index + 1);
        String ns = reader.getNamespaceURI(prefix);
        if (!StringUtils.isEmpty(prefix) && ns == null || localName == null) {
            throw new RuntimeException("Invalid QName in mapping: " + value);
        }
        if (ns == null) {
            QName qName = new QName(localName);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                qName = qName;
                LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "readQName", qName);
            }
            return qName;
        }
        QName qName = new QName(ns, localName, prefix);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "readQName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getUniquePrefix(XMLStreamWriter writer, String namespaceURI, boolean declare) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "getUniquePrefix", new Object[]{writer, namespaceURI, declare});
        }
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = StaxUtils.getUniquePrefix(writer);
            if (declare) {
                writer.setPrefix(prefix, namespaceURI);
                writer.writeNamespace(prefix, namespaceURI);
            }
        }
        String string = prefix;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "getUniquePrefix", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getUniquePrefix(XMLStreamWriter writer, String namespaceURI) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "getUniquePrefix", new Object[]{writer, namespaceURI});
        }
        String string = StaxUtils.getUniquePrefix(writer, namespaceURI, false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "getUniquePrefix", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getUniquePrefix(XMLStreamWriter writer) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "getUniquePrefix", new Object[]{writer});
        }
        NamespaceContext nc = writer.getNamespaceContext();
        if (nc == null) {
            String string = DEF_PREFIXES[0];
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "getUniquePrefix", string);
            }
            return string;
        }
        for (String t : DEF_PREFIXES) {
            String uri = nc.getNamespaceURI(t);
            if (!StringUtils.isEmpty(uri)) continue;
            String string = t;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "getUniquePrefix", string);
            }
            return string;
        }
        int n = 10;
        while (true) {
            String nsPrefix;
            String uri;
            if (StringUtils.isEmpty(uri = nc.getNamespaceURI(nsPrefix = "ns" + n))) {
                String string = nsPrefix;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    string = string;
                    LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "getUniquePrefix", string);
                }
                return string;
            }
            ++n;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void printXmlFragment(XMLStreamReader reader) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "printXmlFragment", new Object[]{reader});
        }
        try {
            LOG.info(XMLUtils.toString(StaxUtils.read(reader), 4));
        }
        catch (XMLStreamException e) {
            LOG.severe(e.getMessage());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "printXmlFragment");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void writeStartElementEvent(XMLEvent event, XMLStreamWriter writer) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "writeStartElementEvent", new Object[]{event, writer});
        }
        StartElement start = event.asStartElement();
        QName name = start.getName();
        String nsURI = name.getNamespaceURI();
        String localName = name.getLocalPart();
        String prefix = name.getPrefix();
        if (prefix != null) {
            writer.writeStartElement(prefix, localName, nsURI);
        } else if (nsURI != null) {
            writer.writeStartElement(localName, nsURI);
        } else {
            writer.writeStartElement(localName);
        }
        Iterator it = CastUtils.cast(start.getNamespaces());
        while (it != null && it.hasNext()) {
            StaxUtils.writeEvent((XMLEvent)it.next(), writer);
        }
        it = CastUtils.cast(start.getAttributes());
        while (it != null && it.hasNext()) {
            StaxUtils.writeAttributeEvent((XMLEvent)it.next(), writer);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "writeStartElementEvent");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void writeAttributeEvent(XMLEvent event, XMLStreamWriter writer) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "writeAttributeEvent", new Object[]{event, writer});
        }
        Attribute attr = (Attribute)event;
        QName name = attr.getName();
        String nsURI = name.getNamespaceURI();
        String localName = name.getLocalPart();
        String prefix = name.getPrefix();
        String value = attr.getValue();
        if (prefix != null) {
            writer.writeAttribute(prefix, nsURI, localName, value);
        } else if (nsURI != null) {
            writer.writeAttribute(nsURI, localName, value);
        } else {
            writer.writeAttribute(localName, value);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "writeAttributeEvent");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void writeEvent(XMLEvent event, XMLStreamWriter writer) throws XMLStreamException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.staxutils.StaxUtils", "writeEvent", new Object[]{event, writer});
        }
        switch (event.getEventType()) {
            case 1: {
                StaxUtils.writeStartElementEvent(event, writer);
                break;
            }
            case 2: {
                writer.writeEndElement();
                break;
            }
            case 10: {
                StaxUtils.writeAttributeEvent(event, writer);
                break;
            }
            case 9: {
                writer.writeEntityRef(((EntityReference)event).getName());
                break;
            }
            case 11: {
                writer.writeDTD(((DTD)event).getDocumentTypeDeclaration());
                break;
            }
            case 3: {
                if (((javax.xml.stream.events.ProcessingInstruction)event).getData() != null) {
                    writer.writeProcessingInstruction(((javax.xml.stream.events.ProcessingInstruction)event).getTarget(), ((javax.xml.stream.events.ProcessingInstruction)event).getData());
                    break;
                }
                writer.writeProcessingInstruction(((javax.xml.stream.events.ProcessingInstruction)event).getTarget());
                break;
            }
            case 13: {
                if (((Namespace)event).isDefaultNamespaceDeclaration()) {
                    writer.writeDefaultNamespace(((Namespace)event).getNamespaceURI());
                    writer.setDefaultNamespace(((Namespace)event).getNamespaceURI());
                    break;
                }
                writer.writeNamespace(((Namespace)event).getPrefix(), ((Namespace)event).getNamespaceURI());
                writer.setPrefix(((Namespace)event).getPrefix(), ((Namespace)event).getNamespaceURI());
                break;
            }
            case 5: {
                writer.writeComment(((javax.xml.stream.events.Comment)event).getText());
                break;
            }
            case 4: 
            case 6: {
                writer.writeCharacters(event.asCharacters().getData());
                break;
            }
            case 12: {
                writer.writeCData(event.asCharacters().getData());
                break;
            }
            case 7: {
                if (((StartDocument)event).encodingSet()) {
                    writer.writeStartDocument(((StartDocument)event).getCharacterEncodingScheme(), ((StartDocument)event).getVersion());
                    break;
                }
                writer.writeStartDocument(((StartDocument)event).getVersion());
                break;
            }
            case 8: {
                writer.writeEndDocument();
                break;
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.staxutils.StaxUtils", "writeEvent");
        }
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String toString(Document doc) throws XMLStreamException {
        LOG.entering("StaxUtils", "toString");
        StringWriter sw = new StringWriter(1024);
        XMLStreamWriter writer = null;
        try {
            writer = StaxUtils.createXMLStreamWriter(sw);
            StaxUtils.copy(doc, writer);
            writer.flush();
        }
        finally {
            StaxUtils.close(writer);
        }
        LOG.exiting("StaxUtils", "toString");
        return sw.toString();
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String toString(Element el) throws XMLStreamException {
        LOG.entering("StaxUtils", "toString");
        StringWriter sw = new StringWriter(1024);
        XMLStreamWriter writer = null;
        try {
            writer = StaxUtils.createXMLStreamWriter(sw);
            StaxUtils.copy(el, writer);
            writer.flush();
        }
        finally {
            StaxUtils.close(writer);
        }
        LOG.exiting("StaxUtils", "toString");
        return sw.toString();
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void close(XMLStreamReader reader) {
        LOG.entering("StaxUtils", "close");
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LOG.entering("StaxUtils", "close");
    }

    @Trivial
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void close(XMLStreamWriter writer) {
        LOG.entering("StaxUtils", "close");
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LOG.exiting("StaxUtils", "close");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static {
        XMLInputFactory xif;
        String xifClassName;
        String s;
        LOG = LogUtils.getL7dLogger(StaxUtils.class);
        DEF_PREFIXES = new String[]{"ns1".intern(), "ns2".intern(), "ns3".intern(), "ns4".intern(), "ns5".intern(), "ns6".intern(), "ns7".intern(), "ns8".intern(), "ns9".intern()};
        innerElementLevelThreshold = -1;
        innerElementCountThreshold = -1;
        int i = 20;
        try {
            s = SystemPropertyAction.getProperty("org.apache.cxf.staxutils.pool-size", "-1");
            i = Integer.parseInt(s);
        }
        catch (Throwable t) {
            i = 20;
        }
        if (i <= 0) {
            i = 20;
        }
        NS_AWARE_INPUT_FACTORY_POOL = new ArrayBlockingQueue<XMLInputFactory>(i);
        OUTPUT_FACTORY_POOL = new ArrayBlockingQueue<XMLOutputFactory>(i);
        try {
            s = SystemPropertyAction.getProperty(INNER_ELEMENT_LEVEL_SYSTEM_PROP, "-1");
            innerElementLevelThreshold = Integer.parseInt(s);
        }
        catch (Throwable t) {
            innerElementLevelThreshold = -1;
        }
        if (innerElementLevelThreshold <= 0) {
            innerElementLevelThreshold = -1;
        }
        try {
            s = SystemPropertyAction.getProperty(INNER_ELEMENT_COUNT_SYSTEM_PROP, "-1");
            innerElementCountThreshold = Integer.parseInt(s);
        }
        catch (Throwable t) {
            innerElementCountThreshold = -1;
        }
        if (innerElementCountThreshold <= 0) {
            innerElementCountThreshold = -1;
        }
        SAFE_INPUT_FACTORY = (xifClassName = (xif = StaxUtils.createXMLInputFactory(true)).getClass().getName()).contains("ctc.wstx") || xifClassName.contains("xml.xlxp") || xifClassName.contains("xml.xlxp2") || xifClassName.contains("bea.core") ? xif : null;
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        String xofClassName = xof.getClass().getName();
        SAFE_OUTPUT_FACTORY = xofClassName.contains("ctc.wstx") || xofClassName.contains("xml.xlxp") || xofClassName.contains("xml.xlxp2") || xofClassName.contains("bea.core") ? xof : null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    public static class StreamToDOMContext {
        private Stack<Node> stack = new Stack();
        private int elementCount;
        private boolean repairing;
        private boolean recordLoc;
        private boolean threshold;
        static final long serialVersionUID = -1069626803748489982L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public StreamToDOMContext(boolean repairing, boolean recordLoc, boolean threshold) {
            this.repairing = repairing;
            this.recordLoc = recordLoc;
            this.threshold = threshold;
        }

        public void setRecordLoc(boolean recordLoc) {
            this.recordLoc = recordLoc;
        }

        public boolean isRecordLoc() {
            return this.recordLoc;
        }

        public boolean isRepairing() {
            return this.repairing;
        }

        public boolean isThreshold() {
            return this.threshold;
        }

        public int incrementCount() {
            return ++this.elementCount;
        }

        public int decreaseCount() {
            return --this.elementCount;
        }

        public int getCount() {
            return this.elementCount;
        }

        public Node pushToStack(Node node) {
            return this.stack.push(node);
        }

        public Node popFromStack() {
            return this.stack.pop();
        }

        public int getStackSize() {
            return this.stack.size();
        }

        public boolean isStackEmpty() {
            return this.stack.isEmpty();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.staxutils.StaxUtils$StreamToDOMContext", StreamToDOMContext.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class LocationUserDataHandler
    implements UserDataHandler {
        public static final LocationUserDataHandler INSTANCE;
        static final long serialVersionUID = -6816237332860245958L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private LocationUserDataHandler() {
        }

        @Override
        public void handle(short operation, String key, Object data, Node src, Node dst) {
            if (operation == 1) {
                dst.setUserData(key, data, this);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.staxutils.StaxUtils$LocationUserDataHandler", LocationUserDataHandler.class, null, null);
            INSTANCE = new LocationUserDataHandler();
        }
    }
}

