/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.wsdl.WSDLLibrary;
import org.apache.cxf.wsdl.http.AddressType;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public final class BaseUrlHelper {
    static final long serialVersionUID = 7033165286112573707L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private BaseUrlHelper() {
    }

    public static String getBaseURL(HttpServletRequest request) {
        String reqPrefix = request.getRequestURL().toString();
        String pathInfo = request.getPathInfo();
        if (!"/".equals(pathInfo) || reqPrefix.contains(";")) {
            String servletPath;
            StringBuilder sb = new StringBuilder();
            URI uri = URI.create(reqPrefix);
            sb.append(uri.getScheme()).append("://").append(uri.getRawAuthority());
            String contextPath = request.getContextPath();
            if (contextPath != null) {
                sb.append(contextPath);
            }
            if ((servletPath = request.getServletPath()) != null) {
                sb.append(servletPath);
            }
            reqPrefix = sb.toString();
        }
        return reqPrefix;
    }

    public static void setAddress(AbstractDestination dest, String absAddress) {
        dest.getEndpointInfo().setAddress(absAddress);
        if (WSDLLibrary.isAvailable() && dest.getEndpointInfo().getExtensor(AddressType.class) != null) {
            ((AddressType)dest.getEndpointInfo().getExtensor(AddressType.class)).setLocation(absAddress);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.servlet.BaseUrlHelper", BaseUrlHelper.class, null, null);
    }
}

