/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.URIMappingInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.security.cache.ReplayCacheFactory;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor;
import org.apache.cxf.ws.security.wss4j.DelegatingCallbackHandler;
import org.apache.cxf.ws.security.wss4j.SAMLUtils;
import org.apache.cxf.ws.security.wss4j.WSS4JTokenConverter;
import org.apache.ws.security.CustomTokenPrincipal;
import org.apache.ws.security.WSDerivedKeyTokenPrincipal;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.cache.ReplayCache;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.ws.security.validate.NoOpValidator;
import org.apache.ws.security.validate.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class WSS4JInInterceptor
extends AbstractWSS4JInterceptor {
    public static final String SAML_ROLE_ATTRIBUTENAME_DEFAULT = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role";
    public static final String TIMESTAMP_RESULT = "wss4j.timestamp.result";
    public static final String SIGNATURE_RESULT = "wss4j.signature.result";
    public static final String PRINCIPAL_RESULT = "wss4j.principal.result";
    public static final String PROCESSOR_MAP = "wss4j.processor.map";
    public static final String VALIDATOR_MAP = "wss4j.validator.map";
    public static final String SAML_ONE_TIME_USE_CACHE_INSTANCE = "ws-security.saml.cache.instance";
    public static final String ENABLE_SAML_ONE_TIME_USE_CACHE = "ws-security.enable.saml.cache";
    public static final String SECURITY_PROCESSED = WSS4JInInterceptor.class.getName() + ".DONE";
    private static final Logger LOG = LogUtils.getL7dLogger(WSS4JInInterceptor.class);
    private static final Logger TIME_LOG = LogUtils.getL7dLogger(WSS4JInInterceptor.class, null, (String)(WSS4JInInterceptor.class.getName() + "-Time"));
    private boolean ignoreActions;
    private WSSecurityEngine secEngineOverride;
    static final long serialVersionUID = 1137084206853060173L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSS4JInInterceptor() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "<init>", new Object[0]);
        }
        this.setPhase("pre-protocol");
        this.getAfter().add(SAAJInInterceptor.class.getName());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSS4JInInterceptor(boolean ignore) {
        this();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "<init>", new Object[]{ignore});
        }
        this.ignoreActions = ignore;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSS4JInInterceptor(Map<String, Object> properties) {
        this();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "<init>", new Object[]{properties});
        }
        this.setProperties(properties);
        Map processorMap = CastUtils.cast((Map)((Map)properties.get(PROCESSOR_MAP)));
        Map validatorMap = CastUtils.cast((Map)((Map)properties.get(VALIDATOR_MAP)));
        if (processorMap != null) {
            if (validatorMap != null) {
                processorMap.putAll(validatorMap);
            }
            this.secEngineOverride = WSS4JInInterceptor.createSecurityEngine(processorMap);
        } else if (validatorMap != null) {
            this.secEngineOverride = WSS4JInInterceptor.createSecurityEngine(validatorMap);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "<init>", (Object)this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getAdditionalInterceptors", new Object[0]);
        }
        ArrayList<PhaseInterceptor<? extends Message>> extras = new ArrayList<PhaseInterceptor<? extends Message>>(1);
        extras.add((PhaseInterceptor<? extends Message>)SAAJInInterceptor.SAAJPreInInterceptor.INSTANCE);
        ArrayList<PhaseInterceptor<? extends Message>> arrayList = extras;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getAdditionalInterceptors", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setIgnoreActions(boolean i) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "setIgnoreActions", new Object[]{i});
        }
        this.ignoreActions = i;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "setIgnoreActions");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private SOAPMessage getSOAPMessage(SoapMessage msg) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getSOAPMessage", new Object[]{msg});
        }
        SAAJInInterceptor.INSTANCE.handleMessage(msg);
        SOAPMessage sOAPMessage = (SOAPMessage)msg.getContent(SOAPMessage.class);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            sOAPMessage = sOAPMessage;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getSOAPMessage", sOAPMessage);
        }
        return sOAPMessage;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object getProperty(Object msgContext, String key) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getProperty", new Object[]{msgContext, key});
        }
        Object result = super.getProperty(msgContext, key);
        if (result == null && "_sendSignatureValues_".equals(key) && this.isRequestor((SoapMessage)msgContext)) {
            result = ((SoapMessage)msgContext).getExchange().getOutMessage().get((Object)key);
        }
        Object object = result;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getProperty", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public final boolean isGET(SoapMessage message) {
        boolean isGet;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "isGET", new Object[]{message});
        }
        String method = (String)message.get((Object)"org.apache.cxf.request.method");
        boolean bl = isGet = "GET".equals(method) && message.getContent(XMLStreamReader.class) == null;
        if (isGet) {
            message.put(URIMappingInterceptor.URIMAPPING_SKIP, (Object)Boolean.TRUE);
        }
        boolean bl2 = isGet;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl2 = bl2;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "isGET", bl2);
        }
        return bl2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(SoapMessage msg) throws Fault {
        WSSecurityEngine engine;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "handleMessage", new Object[]{msg});
        }
        if (msg.containsKey((Object)SECURITY_PROCESSED) || this.isGET(msg)) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "handleMessage");
            }
            return;
        }
        msg.put(SECURITY_PROCESSED, (Object)Boolean.TRUE);
        boolean utWithCallbacks = MessageUtils.getContextualBoolean((Message)msg, (String)"ws-security.validate.token", (boolean)true);
        this.translateProperties(msg);
        CXFRequestData reqData = new CXFRequestData();
        WSSConfig config = (WSSConfig)msg.getContextualProperty(WSSConfig.class.getName());
        if (config != null) {
            engine = new WSSecurityEngine();
            engine.setWssConfig(config);
        } else {
            engine = this.getSecurityEngine(utWithCallbacks);
            if (engine == null) {
                engine = new WSSecurityEngine();
            }
            config = engine.getWssConfig();
        }
        this.handleMessage(msg, utWithCallbacks, reqData, config, engine);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "handleMessage");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(SoapMessage msg, boolean utWithCallbacks, RequestData reqData, WSSConfig config, WSSecurityEngine engine) throws Fault {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "handleMessage", new Object[]{msg, utWithCallbacks, reqData, config, engine});
        }
        reqData.setWssConfig(config);
        SOAPMessage doc = this.getSOAPMessage(msg);
        boolean doDebug = LOG.isLoggable(Level.FINE);
        boolean doTimeLog = TIME_LOG.isLoggable(Level.FINE);
        SoapVersion version = msg.getVersion();
        if (doDebug) {
            LOG.fine("WSS4JInInterceptor: enter handleMessage()");
        }
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        if (doTimeLog) {
            t0 = System.currentTimeMillis();
        }
        try {
            reqData.setMsgContext((Object)msg);
            this.computeAction(msg, reqData);
            ArrayList<Integer> actions = new ArrayList<Integer>();
            String action = this.getAction(msg, version);
            int doAction = WSSecurityUtil.decodeAction((String)action, actions);
            String actor = (String)this.getOption("actor");
            reqData.setCallbackHandler(this.getCallback(reqData, doAction, utWithCallbacks));
            String passwordTypeStrict = (String)this.getOption("passwordTypeStrict");
            if (passwordTypeStrict == null) {
                this.setProperty("passwordTypeStrict", "true");
            }
            ReplayCache nonceCache = this.getReplayCache(msg, "ws-security.enable.nonce.cache", "ws-security.nonce.cache.instance");
            reqData.setNonceReplayCache(nonceCache);
            ReplayCache timestampCache = this.getReplayCache(msg, "ws-security.enable.timestamp.cache", "ws-security.timestamp.cache.instance");
            reqData.setTimestampReplayCache(timestampCache);
            this.isSamlCacheRequired(doAction, msg, reqData);
            this.doReceiverAction(doAction, reqData);
            boolean enableRevocation = reqData.isRevocationEnabled() || MessageUtils.isTrue((Object)msg.getContextualProperty("ws-security.enableRevocation"));
            reqData.setEnableRevocation(enableRevocation);
            if (doTimeLog) {
                t1 = System.currentTimeMillis();
            }
            Element elem = WSSecurityUtil.getSecurityHeader((Document)doc.getSOAPPart(), (String)actor);
            elem = (Element)DOMUtils.getDomElement((Node)elem);
            Node originalNode = null;
            if (elem != null) {
                originalNode = elem.cloneNode(true);
            }
            ArrayList<WSSecurityEngineResult> wsResult = engine.processSecurityHeader(elem, reqData);
            this.importNewDomToSAAJ(doc, elem, originalNode);
            Object header = SAAJUtils.getHeader((SOAPMessage)doc);
            Object body = SAAJUtils.getBody((SOAPMessage)doc);
            header = (Element)DOMUtils.getDomElement((Node)header);
            body = (Element)DOMUtils.getDomElement((Node)body);
            if (doTimeLog) {
                t2 = System.currentTimeMillis();
            }
            if (wsResult != null && !wsResult.isEmpty()) {
                if (reqData.getWssConfig().isEnableSignatureConfirmation()) {
                    this.checkSignatureConfirmation(reqData, wsResult);
                }
                this.storeSignature(msg, reqData, wsResult);
                this.storeTimestamp(msg, reqData, wsResult);
                this.checkActions(msg, reqData, wsResult, actions);
                this.doResults(msg, actor, (Element)header, (Element)body, wsResult, utWithCallbacks);
            } else {
                wsResult = new ArrayList<WSSecurityEngineResult>();
                if (doc.getSOAPPart().getEnvelope().getBody().hasFault()) {
                    LOG.warning("Request does not contain Security header, but it's a fault.");
                    this.doResults(msg, actor, (Element)header, (Element)body, wsResult);
                } else {
                    this.checkActions(msg, reqData, wsResult, actions);
                    this.doResults(msg, actor, (Element)header, (Element)body, wsResult);
                }
            }
            if (SAAJUtils.getBody((SOAPMessage)doc) != null) {
                this.advanceBody(msg, (Node)body);
            }
            SAAJInInterceptor.replaceHeaders((SOAPMessage)doc, (SoapMessage)msg);
            if (doTimeLog) {
                t3 = System.currentTimeMillis();
                TIME_LOG.fine("Receive request: total= " + (t3 - t0) + " request preparation= " + (t1 - t0) + " request processing= " + (t2 - t1) + " header, cert verify, timestamp= " + (t3 - t2) + "\n");
            }
            if (doDebug) {
                LOG.fine("WSS4JInInterceptor: exit handleMessage()");
            }
        }
        catch (WSSecurityException actions) {
            void e;
            FFDCFilter.processException((Throwable)actions, (String)"org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", (String)"381", (Object)((Object)this), (Object[])new Object[]{msg, utWithCallbacks, reqData, config, engine});
            LOG.log(Level.WARNING, "", (Throwable)e);
            SoapFault fault = this.createSoapFault(version, (WSSecurityException)e);
            throw fault;
        }
        catch (XMLStreamException e) {
            FFDCFilter.processException((Throwable)e, (String)"org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", (String)"385", (Object)((Object)this), (Object[])new Object[]{msg, utWithCallbacks, reqData, config, engine});
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("STAX_EX", LOG, new Object[0]), (Throwable)e, version.getSender());
        }
        catch (SOAPException e) {
            FFDCFilter.processException((Throwable)e, (String)"org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", (String)"387", (Object)((Object)this), (Object[])new Object[]{msg, utWithCallbacks, reqData, config, engine});
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("SAAJ_EX", LOG, new Object[0]), (Throwable)e, version.getSender());
        }
        finally {
            reqData.clear();
            reqData = null;
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "handleMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void importNewDomToSAAJ(SOAPMessage doc, Element elem, Node originalNode) throws SOAPException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "importNewDomToSAAJ", new Object[]{doc, elem, originalNode});
        }
        if (DOMUtils.isJava9SAAJ() && originalNode != null && !originalNode.isEqualNode(elem)) {
            Node node = null;
            Document document = null;
            SOAPBody body = SAAJUtils.getBody((SOAPMessage)doc);
            if (body != null) {
                document = body.getOwnerDocument();
            }
            if (elem != null && elem.getOwnerDocument() != null && elem.getOwnerDocument().getDocumentElement() != null) {
                node = elem.getOwnerDocument().getDocumentElement().getFirstChild().getNextSibling().getFirstChild();
            }
            if (document != null && node != null) {
                Node newNode = null;
                try {
                    newNode = document.importNode(node, true);
                    if (newNode != null) {
                        try {
                            Method method = newNode.getClass().getMethod("getDomElement", new Class[0]);
                            newNode = (Element)method.invoke((Object)newNode, new Object[0]);
                        }
                        catch (NoSuchMethodException method) {
                            FFDCFilter.processException((Throwable)method, (String)"org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", (String)"418", (Object)((Object)this), (Object[])new Object[]{doc, elem, originalNode});
                        }
                    }
                    elem.getOwnerDocument().getDocumentElement().getFirstChild().getNextSibling().replaceChild(newNode, node);
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", (String)"424", (Object)((Object)this), (Object[])new Object[]{doc, elem, originalNode});
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "importNewDomToSAAJ");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isSamlCacheRequired(int doAction, SoapMessage msg, RequestData reqData) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "isSamlCacheRequired", new Object[]{doAction, msg, reqData});
        }
        if ((doAction & 8) == 8 || (doAction & 0x10) == 16) {
            ReplayCache samlCache = this.getReplayCache(msg, ENABLE_SAML_ONE_TIME_USE_CACHE, SAML_ONE_TIME_USE_CACHE_INSTANCE);
            reqData.setSamlOneTimeUseReplayCache(samlCache);
            boolean doDebug = LOG.isLoggable(Level.FINE);
            if (doDebug) {
                LOG.fine("WSS4JInInterceptor: saml cache is required");
            }
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "isSamlCacheRequired", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "isSamlCacheRequired", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void checkActions(SoapMessage msg, RequestData reqData, List<WSSecurityEngineResult> wsResult, List<Integer> actions) throws WSSecurityException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "checkActions", new Object[]{msg, reqData, wsResult, actions});
        }
        if (this.ignoreActions) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "checkActions");
            }
            return;
        }
        if (!this.checkReceiverResultsAnyOrder(wsResult, actions)) {
            LOG.warning("Security processing failed (actions mismatch)");
            throw new WSSecurityException(3);
        }
        String signatureParts = (String)this.getProperty(msg, "signatureParts");
        if (signatureParts != null) {
            String warning = "To enforce that particular elements were signed you must either use WS-SecurityPolicy, or else use the CryptoCoverageChecker or SignatureCoverageChecker";
            LOG.warning(warning);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "checkActions");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void storeSignature(SoapMessage msg, RequestData reqData, List<WSSecurityEngineResult> wsResult) throws WSSecurityException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "storeSignature", new Object[]{msg, reqData, wsResult});
        }
        List signatureResults = new ArrayList();
        signatureResults = WSSecurityUtil.fetchAllActionResults(wsResult, (int)2, signatureResults);
        if (!signatureResults.isEmpty()) {
            msg.put(SIGNATURE_RESULT, signatureResults.get(signatureResults.size() - 1));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "storeSignature");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void storeTimestamp(SoapMessage msg, RequestData reqData, List<WSSecurityEngineResult> wsResult) throws WSSecurityException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "storeTimestamp", new Object[]{msg, reqData, wsResult});
        }
        List timestampResults = new ArrayList();
        timestampResults = WSSecurityUtil.fetchAllActionResults(wsResult, (int)32, timestampResults);
        if (!timestampResults.isEmpty()) {
            msg.put(TIMESTAMP_RESULT, timestampResults.get(timestampResults.size() - 1));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "storeTimestamp");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void computeAction(SoapMessage msg, RequestData reqData) {
        Crypto sigCrypto;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "computeAction", new Object[]{msg, reqData});
        }
        Crypto encCrypto = (Crypto)msg.getContextualProperty("ws-security.encryption.crypto");
        if (encCrypto != null) {
            reqData.setEncCrypto(encCrypto);
            reqData.setDecCrypto(encCrypto);
        }
        if ((sigCrypto = (Crypto)msg.getContextualProperty("ws-security.signature.crypto")) != null) {
            reqData.setSigCrypto(sigCrypto);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "computeAction");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void doResults(SoapMessage msg, String actor, Element soapHeader, Element soapBody, List<WSSecurityEngineResult> wsResult) throws SOAPException, XMLStreamException, WSSecurityException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "doResults", new Object[]{msg, actor, soapHeader, soapBody, wsResult});
        }
        this.doResults(msg, actor, soapHeader, soapBody, wsResult, false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "doResults");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void doResults(SoapMessage msg, String actor, Element soapHeader, Element soapBody, List<WSSecurityEngineResult> wsResult, boolean utWithCallbacks) throws SOAPException, XMLStreamException, WSSecurityException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "doResults", new Object[]{msg, actor, soapHeader, soapBody, wsResult, utWithCallbacks});
        }
        ArrayList<WSHandlerResult> results = CastUtils.cast((List)((List)msg.get((Object)"RECV_RESULTS")));
        if (results == null) {
            results = new ArrayList<WSHandlerResult>();
            msg.put("RECV_RESULTS", results);
        }
        WSHandlerResult rResult = new WSHandlerResult(actor, wsResult);
        results.add(0, rResult);
        for (WSSecurityEngineResult o : wsResult) {
            Principal p = (Principal)o.get((Object)"principal");
            if (p == null || !this.isSecurityContextPrincipal(p, wsResult)) continue;
            msg.put(PRINCIPAL_RESULT, (Object)p);
            if (!utWithCallbacks) {
                WSS4JTokenConverter.convertToken((Message)msg, p);
            }
            Object receivedAssertion = null;
            List<String> roles = null;
            if (o.get((Object)"saml-assertion") != null) {
                String roleAttributeName = (String)msg.getContextualProperty("ws-security.saml-role-attributename");
                if (roleAttributeName == null || roleAttributeName.length() == 0) {
                    roleAttributeName = SAML_ROLE_ATTRIBUTENAME_DEFAULT;
                }
                receivedAssertion = o.get((Object)"saml-assertion");
                roles = SAMLUtils.parseRolesInAssertion(receivedAssertion, roleAttributeName);
                msg.put(SecurityContext.class, (Object)this.createSecurityContext(p, roles));
                continue;
            }
            msg.put(SecurityContext.class, (Object)this.createSecurityContext(p));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "doResults");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isSecurityContextPrincipal(Principal p, List<WSSecurityEngineResult> wsResult) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "isSecurityContextPrincipal", new Object[]{p, wsResult});
        }
        boolean derivedKeyPrincipal = p instanceof WSDerivedKeyTokenPrincipal;
        if (derivedKeyPrincipal || p instanceof CustomTokenPrincipal) {
            boolean bl = wsResult.size() <= 1;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "isSecurityContextPrincipal", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "isSecurityContextPrincipal", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void advanceBody(SoapMessage msg, Node body) throws SOAPException, XMLStreamException, WSSecurityException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "advanceBody", new Object[]{msg, body});
        }
        XMLStreamReader reader = StaxUtils.createXMLStreamReader((Source)new DOMSource(body));
        int evt = reader.next();
        for (int i = 0; reader.hasNext() && i < 1 && (evt != 2 || evt != 1); ++i) {
            reader.next();
        }
        msg.setContent(XMLStreamReader.class, (Object)reader);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "advanceBody");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected SecurityContext createSecurityContext(Principal p) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "createSecurityContext", new Object[]{p});
        }
        SecurityContext securityContext = this.createSecurityContext(p, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            securityContext = securityContext;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "createSecurityContext", securityContext);
        }
        return securityContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected SecurityContext createSecurityContext(final Principal p, final List<String> roles) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "createSecurityContext", new Object[]{p, roles});
        }
        SecurityContext securityContext = new SecurityContext(){

            public Principal getUserPrincipal() {
                return p;
            }

            public boolean isUserInRole(String role) {
                if (roles == null) {
                    return false;
                }
                return roles.contains(role);
            }
        };
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            securityContext = securityContext;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "createSecurityContext", securityContext);
        }
        return securityContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getAction(SoapMessage msg, SoapVersion version) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getAction", new Object[]{msg, version});
        }
        String action = (String)this.getOption("action");
        if (action == null) {
            action = (String)msg.get((Object)"action");
        }
        if (action == null) {
            LOG.warning("No security action was defined!");
            throw new SoapFault("No security action was defined!", version.getReceiver());
        }
        String string = action;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getAction", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected CallbackHandler getCallback(RequestData reqData, int doAction, boolean utWithCallbacks) throws WSSecurityException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getCallback", new Object[]{reqData, doAction, utWithCallbacks});
        }
        if (!(utWithCallbacks || (doAction & 1) == 0 && (doAction & 0x2000) == 0)) {
            CallbackHandler pwdCallback = null;
            try {
                pwdCallback = this.getCallback(reqData, doAction);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", (String)"698", (Object)((Object)this), (Object[])new Object[]{reqData, doAction, utWithCallbacks});
            }
            DelegatingCallbackHandler delegatingCallbackHandler = new DelegatingCallbackHandler(pwdCallback);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                delegatingCallbackHandler = delegatingCallbackHandler;
                LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getCallback", delegatingCallbackHandler);
            }
            return delegatingCallbackHandler;
        }
        CallbackHandler callbackHandler = this.getCallback(reqData, doAction);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            callbackHandler = callbackHandler;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getCallback", callbackHandler);
        }
        return callbackHandler;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected CallbackHandler getCallback(RequestData reqData, int doAction) throws WSSecurityException {
        TokenStore store;
        Endpoint ep;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getCallback", new Object[]{reqData, doAction});
        }
        CallbackHandler cbHandler = null;
        if ((doAction & 5) != 0) {
            Object o = ((SoapMessage)reqData.getMsgContext()).getContextualProperty("ws-security.callback-handler");
            if (o instanceof String) {
                try {
                    o = ClassLoaderUtils.loadClass((String)((String)o), ((Object)((Object)this)).getClass()).newInstance();
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", (String)"719", (Object)((Object)this), (Object[])new Object[]{reqData, doAction});
                    throw new WSSecurityException(e.getMessage(), (Throwable)e);
                }
            }
            if (o instanceof CallbackHandler) {
                cbHandler = (CallbackHandler)o;
            }
            if (cbHandler == null) {
                try {
                    cbHandler = this.getPasswordCallbackHandler(reqData);
                }
                catch (WSSecurityException e) {
                    void sec;
                    TokenStore store2;
                    FFDCFilter.processException((Throwable)e, (String)"org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", (String)"729", (Object)((Object)this), (Object[])new Object[]{reqData, doAction});
                    Endpoint ep2 = (Endpoint)((SoapMessage)reqData.getMsgContext()).getExchange().get(Endpoint.class);
                    if (ep2 != null && ep2.getEndpointInfo() != null && (store2 = (TokenStore)ep2.getEndpointInfo().getProperty(TokenStore.class.getName())) != null) {
                        TokenStoreCallbackHandler tokenStoreCallbackHandler = new TokenStoreCallbackHandler(null, store2);
                        if (LOG != null && LOG.isLoggable(Level.FINER)) {
                            tokenStoreCallbackHandler = tokenStoreCallbackHandler;
                            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getCallback", tokenStoreCallbackHandler);
                        }
                        return tokenStoreCallbackHandler;
                    }
                    throw sec;
                }
            }
        }
        if ((ep = (Endpoint)((SoapMessage)reqData.getMsgContext()).getExchange().get(Endpoint.class)) != null && ep.getEndpointInfo() != null && (store = (TokenStore)ep.getEndpointInfo().getProperty(TokenStore.class.getName())) != null) {
            TokenStoreCallbackHandler tokenStoreCallbackHandler = new TokenStoreCallbackHandler(cbHandler, store);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                tokenStoreCallbackHandler = tokenStoreCallbackHandler;
                LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getCallback", tokenStoreCallbackHandler);
            }
            return tokenStoreCallbackHandler;
        }
        CallbackHandler callbackHandler = cbHandler;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            callbackHandler = callbackHandler;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getCallback", callbackHandler);
        }
        return callbackHandler;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected WSSecurityEngine getSecurityEngine(boolean utWithCallbacks) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getSecurityEngine", new Object[]{utWithCallbacks});
        }
        if (this.secEngineOverride != null) {
            WSSecurityEngine wSSecurityEngine = this.secEngineOverride;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                wSSecurityEngine = wSSecurityEngine;
                LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getSecurityEngine", wSSecurityEngine);
            }
            return wSSecurityEngine;
        }
        if (!utWithCallbacks) {
            HashMap<QName, Object> profiles = new HashMap<QName, Object>(1);
            NoOpValidator validator = new NoOpValidator();
            profiles.put(WSSecurityEngine.USERNAME_TOKEN, validator);
            WSSecurityEngine wSSecurityEngine = WSS4JInInterceptor.createSecurityEngine(profiles);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                wSSecurityEngine = wSSecurityEngine;
                LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getSecurityEngine", wSSecurityEngine);
            }
            return wSSecurityEngine;
        }
        WSSecurityEngine wSSecurityEngine = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            wSSecurityEngine = wSSecurityEngine;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getSecurityEngine", wSSecurityEngine);
        }
        return wSSecurityEngine;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static WSSecurityEngine createSecurityEngine(Map<QName, Object> map) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "createSecurityEngine", new Object[]{map});
        }
        assert (map != null);
        WSSConfig config = WSSConfig.getNewInstance();
        for (Map.Entry<QName, Object> entry : map.entrySet()) {
            QName key = entry.getKey();
            Object val = entry.getValue();
            if (val instanceof Class) {
                config.setProcessor(key, (Class)val);
                continue;
            }
            if (val instanceof Processor) {
                config.setProcessor(key, (Processor)val);
                continue;
            }
            if (val instanceof Validator) {
                config.setValidator(key, (Validator)val);
                continue;
            }
            if (val != null) continue;
            config.setProcessor(key, (Class)null);
        }
        WSSecurityEngine ret = new WSSecurityEngine();
        ret.setWssConfig(config);
        WSSecurityEngine wSSecurityEngine = ret;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            wSSecurityEngine = wSSecurityEngine;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "createSecurityEngine", wSSecurityEngine);
        }
        return wSSecurityEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ReplayCache getReplayCache(SoapMessage message, String booleanKey, String instanceKey) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getReplayCache", new Object[]{message, booleanKey, instanceKey});
        }
        boolean specified = false;
        Object o = message.getContextualProperty(booleanKey);
        if (o != null) {
            if (!MessageUtils.isTrue((Object)o)) {
                ReplayCache replayCache = null;
                if (LOG == null) return replayCache;
                if (!LOG.isLoggable(Level.FINER)) return replayCache;
                replayCache = replayCache;
                LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getReplayCache", replayCache);
                return replayCache;
            }
            specified = true;
        }
        if (!specified && MessageUtils.isRequestor((Message)message)) {
            ReplayCache replayCache = null;
            if (LOG == null) return replayCache;
            if (!LOG.isLoggable(Level.FINER)) return replayCache;
            replayCache = replayCache;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getReplayCache", replayCache);
            return replayCache;
        }
        Endpoint ep = (Endpoint)message.getExchange().get(Endpoint.class);
        if (ep != null && ep.getEndpointInfo() != null) {
            EndpointInfo info;
            EndpointInfo endpointInfo = info = ep.getEndpointInfo();
            // MONITORENTER : endpointInfo
            ReplayCache replayCache2 = (ReplayCache)message.getContextualProperty(instanceKey);
            if (replayCache2 == null) {
                replayCache2 = (ReplayCache)info.getProperty(instanceKey);
            }
            if (replayCache2 == null) {
                ReplayCacheFactory replayCacheFactory = ReplayCacheFactory.newInstance();
                String cacheKey = instanceKey;
                if (info.getName() != null) {
                    cacheKey = cacheKey + "-" + info.getName().toString().hashCode();
                }
                replayCache2 = replayCacheFactory.newReplayCache(cacheKey, (Message)message);
                info.setProperty(instanceKey, (Object)replayCache2);
            }
            ReplayCache replayCache = replayCache2;
            // MONITOREXIT : endpointInfo
            if (LOG == null) return replayCache;
            if (!LOG.isLoggable(Level.FINER)) return replayCache;
            replayCache = replayCache;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getReplayCache", replayCache);
            return replayCache;
        }
        ReplayCache replayCache = null;
        if (LOG == null) return replayCache;
        if (!LOG.isLoggable(Level.FINER)) return replayCache;
        replayCache = replayCache;
        LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "getReplayCache", replayCache);
        return replayCache;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private SoapFault createSoapFault(SoapVersion version, WSSecurityException e) {
        SoapFault fault;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "createSoapFault", new Object[]{version, e});
        }
        QName faultCode = e.getFaultCode();
        if (version.getVersion() == 1.1 && faultCode != null) {
            fault = new SoapFault(e.getMessage(), (Throwable)e, faultCode);
        } else {
            fault = new SoapFault(e.getMessage(), (Throwable)e, version.getSender());
            if (version.getVersion() != 1.1 && faultCode != null) {
                fault.setSubCode(faultCode);
            }
        }
        SoapFault soapFault = fault;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            soapFault = soapFault;
            LOG.exiting("org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor", "createSoapFault", soapFault);
        }
        return soapFault;
    }

    static class CXFRequestData
    extends RequestData {
        public Validator getValidator(QName qName) throws WSSecurityException {
            String key = null;
            if (WSSecurityEngine.SAML_TOKEN.equals(qName)) {
                key = "ws-security.saml1.validator";
            } else if (WSSecurityEngine.SAML2_TOKEN.equals(qName)) {
                key = "ws-security.saml2.validator";
            } else if (WSSecurityEngine.USERNAME_TOKEN.equals(qName)) {
                key = "ws-security.ut.validator";
            } else if (WSSecurityEngine.SIGNATURE.equals(qName)) {
                key = "ws-security.signature.validator";
            } else if (WSSecurityEngine.TIMESTAMP.equals(qName)) {
                key = "ws-security.timestamp.validator";
            } else if (WSSecurityEngine.BINARY_TOKEN.equals(qName)) {
                key = "ws-security.bst.validator";
            } else if (WSSecurityEngine.SECURITY_CONTEXT_TOKEN_05_02.equals(qName) || WSSecurityEngine.SECURITY_CONTEXT_TOKEN_05_12.equals(qName)) {
                key = "ws-security.sct.validator";
            }
            if (key != null) {
                Object o = ((SoapMessage)this.getMsgContext()).getContextualProperty(key);
                try {
                    if (o instanceof Validator) {
                        return (Validator)o;
                    }
                    if (o instanceof Class) {
                        return (Validator)((Class)o).newInstance();
                    }
                    if (o instanceof String) {
                        return (Validator)ClassLoaderUtils.loadClass((String)o.toString(), WSS4JInInterceptor.class).newInstance();
                    }
                }
                catch (RuntimeException t) {
                    throw t;
                }
                catch (Throwable t) {
                    throw new WSSecurityException(t.getMessage(), t);
                }
            }
            return super.getValidator(qName);
        }
    }

    private class TokenStoreCallbackHandler
    implements CallbackHandler {
        private final CallbackHandler internal;
        private final TokenStore store;

        public TokenStoreCallbackHandler(CallbackHandler in, TokenStore st) {
            this.internal = in;
            this.store = st;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                String id = pc.getIdentifier();
                if ("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1".equals(pc.getType()) || "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1".equals(pc.getType())) {
                    for (String tokenId : this.store.getTokenIdentifiers()) {
                        SecurityToken token = this.store.getToken(tokenId);
                        if (token == null || !id.equals(token.getSHA1())) continue;
                        pc.setKey(token.getSecret());
                        return;
                    }
                    continue;
                }
                SecurityToken tok = this.store.getToken(id);
                if (tok == null) continue;
                pc.setKey(tok.getSecret());
                pc.setCustomToken(tok.getToken());
                return;
            }
            if (this.internal != null) {
                this.internal.handle(callbacks);
            }
        }
    }
}

