/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.http.HttpUtils;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.Oauth2LoginConfigImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import javax.net.ssl.SSLSocketFactory;
import org.jose4j.lang.JoseException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OpenShiftUserApiUtils {
    public static final TraceComponent tc = Tr.register(OpenShiftUserApiUtils.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    Oauth2LoginConfigImpl config = null;
    HttpUtils httpUtils = new HttpUtils();
    static final long serialVersionUID = -5457929305381545358L;

    public OpenShiftUserApiUtils(Oauth2LoginConfigImpl config) {
        this.config = config;
    }

    /*
     * WARNING - void declaration
     */
    public String getUserApiResponse(@Sensitive String accessToken, SSLSocketFactory sslSocketFactory) throws SocialLoginException {
        String response = null;
        try {
            HttpURLConnection connection = this.sendUserApiRequest(accessToken, sslSocketFactory);
            response = this.readUserApiResponse(connection);
        }
        catch (Exception connection) {
            void e;
            Object[] objectArray = new Object[2];
            objectArray[0] = "<sensitive java.lang.String>";
            objectArray[1] = sslSocketFactory;
            FFDCFilter.processException((Throwable)connection, (String)"com.ibm.ws.security.social.internal.utils.OpenShiftUserApiUtils", (String)"60", (Object)this, (Object[])objectArray);
            throw new SocialLoginException("OPENSHIFT_ERROR_GETTING_USER_INFO", (Exception)e, new Object[]{e});
        }
        return response;
    }

    HttpURLConnection sendUserApiRequest(@Sensitive String accessToken, SSLSocketFactory sslSocketFactory) throws IOException, SocialLoginException {
        HttpURLConnection connection = this.httpUtils.createConnection(HttpUtils.RequestMethod.POST, this.config.getUserApi(), sslSocketFactory);
        connection = this.httpUtils.setHeaders(connection, this.getUserApiRequestHeaders());
        connection.setDoOutput(true);
        OutputStream outputStream = connection.getOutputStream();
        OutputStreamWriter streamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        String bodyString = this.createUserApiRequestBody(accessToken);
        streamWriter.write(bodyString);
        streamWriter.close();
        outputStream.close();
        connection.connect();
        return connection;
    }

    @Sensitive
    Map<String, String> getUserApiRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.config.getUserApiToken());
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return headers;
    }

    String createUserApiRequestBody(@Sensitive String accessToken) throws SocialLoginException {
        if (accessToken == null) {
            throw new SocialLoginException("OPENSHIFT_ACCESS_TOKEN_MISSING", null, null);
        }
        JsonObjectBuilder bodyBuilder = Json.createObjectBuilder();
        bodyBuilder.add("kind", "TokenReview");
        bodyBuilder.add("apiVersion", "authentication.k8s.io/v1");
        bodyBuilder.add("spec", Json.createObjectBuilder().add("token", accessToken));
        return bodyBuilder.build().toString();
    }

    String readUserApiResponse(HttpURLConnection connection) throws IOException, SocialLoginException, JoseException {
        int responseCode = connection.getResponseCode();
        String response = this.httpUtils.readConnectionResponse(connection);
        if (responseCode != 201) {
            throw new SocialLoginException("OPENSHIFT_USER_API_BAD_STATUS", null, new Object[]{responseCode, response});
        }
        return this.modifyExistingResponseToJSON(response);
    }

    /*
     * WARNING - void declaration
     */
    String modifyExistingResponseToJSON(String response) throws JoseException, SocialLoginException {
        JsonObject userInnerMap;
        JsonObject jsonResponse;
        if (response == null || response.isEmpty()) {
            throw new SocialLoginException("OPENSHIFT_USER_API_BAD_RESPONSE", null, null);
        }
        try {
            jsonResponse = Json.createReader((Reader)new StringReader(response)).readObject();
        }
        catch (JsonParsingException jsonParsingException) {
            void e;
            FFDCFilter.processException((Throwable)jsonParsingException, (String)"com.ibm.ws.security.social.internal.utils.OpenShiftUserApiUtils", (String)"120", (Object)this, (Object[])new Object[]{response});
            throw new SocialLoginException("OPENSHIFT_USER_API_BAD_RESPONSE", null, new Object[]{response, e});
        }
        JsonObjectBuilder modifiedResponse = Json.createObjectBuilder();
        if (jsonResponse.containsKey((Object)"status")) {
            JsonValue statusValue = (JsonValue)jsonResponse.get((Object)"status");
            if (JsonValue.ValueType.STRING == statusValue.getValueType() && jsonResponse.getString("status").equals("Failure")) {
                throw new SocialLoginException(jsonResponse.getString("message"), null, null);
            }
        } else {
            throw new SocialLoginException("OPENSHIFT_USER_API_RESPONSE_MISSING_KEY", null, new Object[]{"status", jsonResponse});
        }
        JsonObject statusInnerMap = jsonResponse.getJsonObject("status");
        if (statusInnerMap.containsKey((Object)"user")) {
            userInnerMap = statusInnerMap.getJsonObject("user");
            if (!userInnerMap.containsKey((Object)this.config.getUserNameAttribute())) {
                throw new SocialLoginException("OPENSHIFT_USER_API_RESPONSE_MISSING_KEY", null, new Object[]{"user", jsonResponse});
            }
        } else {
            throw new SocialLoginException("OPENSHIFT_USER_API_RESPONSE_MISSING_KEY", null, new Object[]{"user", jsonResponse});
        }
        modifiedResponse.add("username", userInnerMap.getString(this.config.getUserNameAttribute()));
        if (statusInnerMap.containsKey((Object)"error")) {
            throw new SocialLoginException("OPENSHIFT_USER_API_RESPONSE_ERROR", null, new Object[]{jsonResponse});
        }
        if (userInnerMap.containsKey((Object)"groups")) {
            JsonValue groupsValue = (JsonValue)userInnerMap.get((Object)"groups");
            if (groupsValue.getValueType() != JsonValue.ValueType.ARRAY) {
                throw new SocialLoginException("OPENSHIFT_USER_API_RESPONSE_MISCONFIGURED_KEY", null, null);
            }
            modifiedResponse.add("groups", (JsonValue)userInnerMap.getJsonArray("groups"));
        }
        return modifiedResponse.build().toString();
    }
}

