/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal.commands;

import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.Debug;
import com.ibm.ws.kernel.boot.archive.Archive;
import com.ibm.ws.kernel.boot.archive.ArchiveEntryConfig;
import com.ibm.ws.kernel.boot.archive.ArchiveFactory;
import com.ibm.ws.kernel.boot.archive.DirEntryConfig;
import com.ibm.ws.kernel.boot.archive.DirPattern;
import com.ibm.ws.kernel.boot.archive.FileEntryConfig;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.FileUtils;
import com.ibm.ws.kernel.boot.internal.XMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ProcessorUtils {
    public static Set<File> getLooseConfigFiles(BootstrapConfig bootProps) {
        File shared;
        File apps;
        HashSet<File> files = new HashSet<File>();
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        patterns.add(Pattern.compile(".*(\\.xml)$"));
        File dropins = ProcessorUtils.getFileFromDirectory(new File(bootProps.get("server.config.dir")), "dropins");
        if (dropins.exists()) {
            files.addAll(Arrays.asList(FileUtils.listFiles(dropins, patterns, true)));
        }
        if ((apps = ProcessorUtils.getFileFromDirectory(new File(bootProps.get("server.config.dir")), "apps")).exists()) {
            files.addAll(Arrays.asList(FileUtils.listFiles(apps, patterns, true)));
        }
        if ((shared = new File(bootProps.get("shared.app.dir"))).exists()) {
            files.addAll(Arrays.asList(FileUtils.listFiles(shared, patterns, true)));
        }
        return files;
    }

    public static LooseConfig convertToLooseConfig(File looseFile) throws Exception {
        if (looseFile.exists() && looseFile.isFile() && looseFile.canRead() && looseFile.getName().toLowerCase().endsWith(".xml")) {
            LooseConfig root = new LooseConfig(LooseType.ARCHIVE);
            XMLStreamReader reader = null;
            try {
                LooseConfig cEntry = root;
                Stack<LooseConfig> stack = new Stack<LooseConfig>();
                stack.push(cEntry);
                reader = XMLInputFactory.newInstance().createXMLStreamReader(new FileInputStream(looseFile));
                while (reader.hasNext() && cEntry != null) {
                    int result = reader.next();
                    if (result == 1) {
                        if ("archive".equals(reader.getLocalName())) {
                            String targetLocation = XMLUtils.getAttribute(reader, "targetInArchive");
                            if (targetLocation == null) continue;
                            LooseConfig pEntry = cEntry;
                            cEntry = new LooseConfig(LooseType.ARCHIVE);
                            cEntry.targetInArchive = targetLocation;
                            pEntry.children.add(cEntry);
                            stack.push(cEntry);
                            continue;
                        }
                        if ("dir".equals(reader.getLocalName())) {
                            cEntry.children.add(ProcessorUtils.createElement(reader, LooseType.DIR));
                            continue;
                        }
                        if (!"file".equals(reader.getLocalName())) continue;
                        cEntry.children.add(ProcessorUtils.createElement(reader, LooseType.FILE));
                        continue;
                    }
                    if (result != 2 || !"archive".equals(reader.getLocalName())) continue;
                    stack.pop();
                    if (!stack.empty()) {
                        cEntry = (LooseConfig)stack.peek();
                        continue;
                    }
                    cEntry = null;
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (XMLStreamException e) {
                throw e;
            }
            catch (FactoryConfigurationError e) {
                throw e;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                        reader = null;
                    }
                    catch (XMLStreamException e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
            return root;
        }
        return null;
    }

    private static LooseConfig createElement(XMLStreamReader reader, LooseType type) {
        LooseConfig lEntry = null;
        HashSet<String> attrNames = new HashSet<String>();
        attrNames.add("targetInArchive");
        attrNames.add("sourceOnDisk");
        if (LooseType.DIR == type) {
            attrNames.add("excludes");
        }
        lEntry = XMLUtils.createInstanceByElement(reader, LooseConfig.class, attrNames);
        lEntry.type = type;
        return lEntry;
    }

    public static List<ArchiveEntryConfig> createLooseExpandedArchiveEntryConfigs(LooseConfig looseConfig, File looseFile, BootstrapConfig bootProps, String archiveEntryPrefix, boolean isUsr) throws IOException {
        ArrayList<ArchiveEntryConfig> entryConfigs = new ArrayList<ArchiveEntryConfig>();
        String entryPath = ProcessorUtils.generateBaseEntryPath(looseFile, bootProps, archiveEntryPrefix, isUsr);
        File archiveFile = ProcessorUtils.processArchive(looseConfig, looseFile.getName(), bootProps);
        entryConfigs.add(new FileEntryConfig(entryPath, archiveFile));
        int lastSlash = entryPath.lastIndexOf("/") + 1;
        if (lastSlash != 0) {
            entryPath = entryPath.substring(0, lastSlash) + "expanded/" + entryPath.substring(lastSlash);
        }
        Iterator<LooseConfig> configIter = looseConfig.iteration();
        while (configIter.hasNext()) {
            LooseConfig config = configIter.next();
            try {
                entryConfigs.add(ProcessorUtils.processLooseConfig(entryPath, config, bootProps));
            }
            catch (FileNotFoundException | IllegalArgumentException ex) {}
        }
        return entryConfigs;
    }

    public static ArchiveEntryConfig processLooseConfig(String entryPath, LooseConfig config, BootstrapConfig bootProps) throws IllegalArgumentException, IOException {
        if (LooseType.ARCHIVE.equals((Object)config.type)) {
            File archiveFile = ProcessorUtils.processArchive(config, null, bootProps);
            return new FileEntryConfig(ProcessorUtils.createLooseConfigEntryPath(config, entryPath), archiveFile);
        }
        if (LooseType.DIR.equals((Object)config.type)) {
            DirEntryConfig dirConfig;
            try {
                File dir = FileUtils.convertPathToFile(config.sourceOnDisk, bootProps);
                dirConfig = new DirEntryConfig(ProcessorUtils.createLooseConfigEntryPath(config, entryPath), dir, true, DirPattern.PatternStrategy.ExcludePreference);
            }
            catch (FileNotFoundException | IllegalArgumentException ex) {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("warning.unableToPackageLooseConfigFileCannotResolveLocSymbol"), config.sourceOnDisk));
                throw ex;
            }
            if (config.excludes != null) {
                dirConfig.exclude(ProcessorUtils.convertToRegex(config.excludes));
            }
            return dirConfig;
        }
        return new FileEntryConfig(ProcessorUtils.createLooseConfigEntryPath(config, entryPath), FileUtils.convertPathToFile(config.sourceOnDisk, bootProps));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File processArchive(LooseConfig looseConfig, String LooseFileName, BootstrapConfig bootProps) throws IOException {
        File file;
        Archive thisArchive = null;
        File archiveFile = null;
        try {
            if (LooseFileName != null) {
                archiveFile = FileUtils.createTempFile(LooseFileName, null, bootProps.get("server.tmp.dir"));
            } else {
                int index;
                String fileName = looseConfig.targetInArchive.replace("\\", "/");
                if (fileName.endsWith("/")) {
                    fileName = fileName.substring(0, fileName.length() - 1);
                }
                if ((index = fileName.lastIndexOf("/")) != -1) {
                    fileName = fileName.substring(index + 1);
                }
                archiveFile = FileUtils.createTempFile(fileName, null, bootProps.get("server.tmp.dir"));
            }
            thisArchive = ArchiveFactory.create(archiveFile);
            Iterator<LooseConfig> configIter = looseConfig.iteration();
            while (configIter.hasNext()) {
                LooseConfig config = configIter.next();
                try {
                    thisArchive.addEntryConfig(ProcessorUtils.processLooseConfig("", config, bootProps));
                }
                catch (FileNotFoundException | IllegalArgumentException ex) {}
            }
            thisArchive.create();
            file = archiveFile;
        }
        catch (Throwable throwable) {
            Utils.tryToClose(thisArchive);
            throw throwable;
        }
        Utils.tryToClose(thisArchive);
        return file;
    }

    private static String generateBaseEntryPath(File looseFile, BootstrapConfig bootProps, String archiveEntryPrefix, boolean isUsr) {
        File usrRoot = bootProps.getUserRoot();
        int len = usrRoot.getAbsolutePath().length();
        String entryPath = null;
        entryPath = archiveEntryPrefix.equalsIgnoreCase("wlp/") || !isUsr ? archiveEntryPrefix + "usr" + looseFile.getAbsolutePath().substring(len) : archiveEntryPrefix + looseFile.getAbsolutePath().substring(len);
        return entryPath.replace("\\", "/").replaceAll("/(?=/)|.xml$", "");
    }

    public static String createLooseConfigEntryPath(LooseConfig looseConfig, String entryPath) {
        entryPath = looseConfig.targetInArchive.startsWith("/") || entryPath == "" ? entryPath + looseConfig.targetInArchive : entryPath + "/" + looseConfig.targetInArchive;
        return entryPath;
    }

    public static Pattern convertToRegex(String excludeStr) {
        if (excludeStr.contains(".")) {
            excludeStr = excludeStr.replace(".", "\\.");
        }
        if (excludeStr.endsWith("/")) {
            excludeStr = excludeStr.substring(0, excludeStr.length() - 1);
        }
        if (excludeStr.contains("**")) {
            excludeStr = excludeStr.replace("**", ".*");
        }
        if (excludeStr.contains("/*")) {
            excludeStr = excludeStr.replace("/*", "/.*");
        }
        if (excludeStr.contains("/")) {
            excludeStr = excludeStr.replace("/", "\\/");
        }
        if (excludeStr.contains("**")) {
            excludeStr = excludeStr.replace("**", "*");
        }
        if (excludeStr.startsWith("*")) {
            excludeStr = "." + excludeStr;
        }
        if (excludeStr.contains("[")) {
            excludeStr = excludeStr.replace("[", "\\[");
        }
        if (excludeStr.contains("]")) {
            excludeStr = excludeStr.replace("]", "\\]");
        }
        if (excludeStr.contains("-")) {
            excludeStr = excludeStr.replace("-", "\\-");
        }
        return Pattern.compile(excludeStr);
    }

    public static File getFileFromDirectory(File dir, String path) {
        StringBuilder sBuilder = new StringBuilder(dir.getAbsolutePath());
        for (String p : path.split("/")) {
            sBuilder.append(File.separator).append(p);
        }
        return new File(sBuilder.toString());
    }

    private static enum LooseType {
        DIR,
        FILE,
        ARCHIVE;

    }

    protected static class LooseConfig {
        protected String targetInArchive;
        protected String sourceOnDisk;
        protected String excludes;
        protected LooseType type;
        protected List<LooseConfig> children = new ArrayList<LooseConfig>();

        public Iterator<LooseConfig> iteration() {
            return this.children.iterator();
        }

        public LooseConfig() {
        }

        public LooseConfig(LooseType type) {
            this.type = type;
        }
    }
}

