/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jpa.diagnostics.AbstractIntrospection;
import com.ibm.ws.jpa.diagnostics.JPAORMDiagnostics;
import com.ibm.ws.jpa.diagnostics.OpenJPAIntrospection;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ClassInfoType;
import com.ibm.ws.jpa.diagnostics.puscanner.PersistenceUnitScannerResults;
import com.ibm.ws.jpa.management.JPAApplInfo;
import com.ibm.ws.jpa.management.JPAPUnitInfo;
import com.ibm.ws.jpa.management.JPAPxmlInfo;
import com.ibm.ws.jpa.management.JPAScopeInfo;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.persistence.spi.PersistenceUnitInfo;

public class JPAIntrospection {
    private static final TraceComponent tc = Tr.register(JPAIntrospection.class, (String)"JPAORM", (String)"com.ibm.ws.jpa.jpa");
    private static final ThreadLocal<JPAIntrospection> threadLocal = new ThreadLocal<JPAIntrospection>(){

        @Override
        protected JPAIntrospection initialValue() {
            return new JPAIntrospection();
        }
    };
    private boolean validIntrospector = false;
    private final HashMap<String, JPAApplInfoIntrospect> jpaApplInfoMap = new HashMap();
    private final List<JPAPUnitInfo> allJPAPUnitInfoList = new ArrayList<JPAPUnitInfo>();
    private JPAApplInfoIntrospect currentAppl = null;
    private JPAScopeInfoIntrospect currentScopeInfo = null;
    private JPAPxmlInfoIntrospect currentPxmlInfo = null;
    private final HashMap<JPAApplInfoIntrospect, Set<String>> applicationArchivesMap = new HashMap();
    private static final String[] openJPAEntityManagerFactoryImplClasses = new String[]{"org.apache.openjpa.persistence.EntityManagerFactoryImpl", "com.ibm.ws.persistence.EntityManagerFactoryImpl"};
    private static final String[] eclipselinkEntityManagerFactoryImplClasses = new String[]{"org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl"};

    public static final void beginJPAIntrospection() {
        JPAIntrospection jpaIntrospector = threadLocal.get();
        jpaIntrospector.validIntrospector = true;
    }

    public static final void endJPAIntrospection() {
        threadLocal.remove();
    }

    public static final void beginApplicationVisit(String appname, JPAApplInfo appl) {
        JPAIntrospection jpaIntrospector = JPAIntrospection.getJPAIntrospection();
        if (jpaIntrospector != null) {
            try {
                jpaIntrospector.doBeginApplicationVisit(appname, appl);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(JPAIntrospection.class.getName() + ".beginApplicationVisit"), (String)"66");
            }
        }
    }

    public static final void endApplicationVisit() {
        JPAIntrospection jpaIntrospector = JPAIntrospection.getJPAIntrospection();
        if (jpaIntrospector != null) {
            jpaIntrospector.doEndApplicationVisit();
        }
    }

    public static final void registerArchiveSet(Set<String> archivesSet) {
        if (archivesSet == null || archivesSet.isEmpty()) {
            return;
        }
        JPAIntrospection jpaIntrospector = JPAIntrospection.getJPAIntrospection();
        if (jpaIntrospector != null) {
            try {
                jpaIntrospector.doRegisterArchiveSet(archivesSet);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(JPAIntrospection.class.getName() + ".registerArchiveSet"), (String)"92");
            }
        }
    }

    public static final void beginPUScopeVisit(JPAScopeInfo scopeInfo) {
        JPAIntrospection jpaIntrospector = JPAIntrospection.getJPAIntrospection();
        if (jpaIntrospector != null) {
            try {
                jpaIntrospector.doBeginPUScopeVisit(scopeInfo);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(JPAIntrospection.class.getName() + ".beginPUScopeVisit"), (String)"84");
            }
        }
    }

    public static final void endPUScopeVisit() {
        JPAIntrospection jpaIntrospector = JPAIntrospection.getJPAIntrospection();
        if (jpaIntrospector != null) {
            jpaIntrospector.doEndPUScopeVisit();
        }
    }

    public static final void beginPXmlInfoVisit(JPAPxmlInfo pxmlInfo) {
        JPAIntrospection jpaIntrospector = JPAIntrospection.getJPAIntrospection();
        if (jpaIntrospector != null) {
            try {
                jpaIntrospector.doBeginPXmlInfoVisit(pxmlInfo);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(JPAIntrospection.class.getName() + ".beginPXmlInfoVisit"), (String)"103");
            }
        }
    }

    public static final void endPXmlInfoVisit() {
        JPAIntrospection jpaIntrospector = JPAIntrospection.getJPAIntrospection();
        if (jpaIntrospector != null) {
            jpaIntrospector.doEndPXmlInfoVisit();
        }
    }

    public static final void visitJPAPUnitInfo(String puName, JPAPUnitInfo jpaPuInfo) {
        JPAIntrospection jpaIntrospector = JPAIntrospection.getJPAIntrospection();
        if (jpaIntrospector != null) {
            try {
                jpaIntrospector.doVisitJPAPUnitInfo(puName, jpaPuInfo);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(JPAIntrospection.class.getName() + ".visitJPAPUnitInfo"), (String)"121");
            }
        }
    }

    public static final void executeIntrospectionAnalysis(PrintWriter dout) {
        JPAIntrospection jpaIntrospector = JPAIntrospection.getJPAIntrospection();
        if (jpaIntrospector != null) {
            try {
                jpaIntrospector.doExecuteIntrospectionAnalysis(dout);
                dout.println();
                jpaIntrospector.doDumpJPARuntimeStates(dout);
                dout.println();
                jpaIntrospector.doDumpOpenJPAPCRegistry(dout);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(JPAIntrospection.class.getName() + ".executeIntrospectionAnalysis"), (String)"132");
            }
        }
    }

    public static final void executeTraceAnalysis() {
        JPAIntrospection jpaIntrospector = JPAIntrospection.getJPAIntrospection();
        if (jpaIntrospector != null) {
            try {
                jpaIntrospector.doExecuteTraceAnalysis();
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(JPAIntrospection.class.getName() + ".executeTraceAnalysis"), (String)"143");
            }
        }
    }

    private static final JPAIntrospection getJPAIntrospection() {
        JPAIntrospection jpaIntrospector = threadLocal.get();
        if (!jpaIntrospector.validIntrospector) {
            threadLocal.remove();
            return null;
        }
        return jpaIntrospector;
    }

    public final Map<String, JPAApplInfoIntrospect> getJPAApplInfoIntrospectMap() {
        return Collections.unmodifiableMap(this.jpaApplInfoMap);
    }

    private void doBeginApplicationVisit(String appname, JPAApplInfo appl) {
        this.currentAppl = new JPAApplInfoIntrospect(appname, appl);
        this.jpaApplInfoMap.put(appname, this.currentAppl);
    }

    private void doEndApplicationVisit() {
        this.currentAppl = null;
    }

    private void doRegisterArchiveSet(Set<String> archivesSet) {
        if (this.currentAppl != null) {
            Set<String> applicationArchives = this.applicationArchivesMap.get(this.currentAppl);
            if (applicationArchives == null) {
                applicationArchives = new TreeSet<String>(new Comparator<String>(){

                    @Override
                    public int compare(String s1, String s2) {
                        return s1.compareTo(s2);
                    }
                });
                this.applicationArchivesMap.put(this.currentAppl, applicationArchives);
            }
            applicationArchives.addAll(archivesSet);
        }
    }

    private void doBeginPUScopeVisit(JPAScopeInfo scopeInfo) {
        if (this.currentAppl == null) {
            return;
        }
        this.currentScopeInfo = new JPAScopeInfoIntrospect(scopeInfo);
        this.currentAppl.scopeInfoList.add(this.currentScopeInfo);
    }

    private void doEndPUScopeVisit() {
        this.currentScopeInfo = null;
    }

    private void doBeginPXmlInfoVisit(JPAPxmlInfo pxmlInfo) {
        if (this.currentAppl == null || this.currentScopeInfo == null) {
            return;
        }
        this.currentPxmlInfo = new JPAPxmlInfoIntrospect(pxmlInfo);
        this.currentScopeInfo.pxmlInfoList.add(this.currentPxmlInfo);
    }

    private void doEndPXmlInfoVisit() {
        this.currentPxmlInfo = null;
    }

    private void doVisitJPAPUnitInfo(String puName, JPAPUnitInfo jpaPuInfo) {
        if (this.currentAppl == null || this.currentScopeInfo == null || this.currentPxmlInfo == null) {
            return;
        }
        this.currentPxmlInfo.jpaPuInfoList.add(new JPAPUnitInfoIntrospect(puName, jpaPuInfo));
        this.currentAppl.puCount++;
        this.currentPxmlInfo.puCount++;
        this.allJPAPUnitInfoList.add(jpaPuInfo);
    }

    private Map<String, JPAAnalysisResult> executeDiagnostics(boolean isIntrospectorDump) {
        HashMap<String, JPAAnalysisResult> analysisResultMap = new HashMap<String, JPAAnalysisResult>();
        for (Map.Entry<String, JPAApplInfoIntrospect> entry : this.jpaApplInfoMap.entrySet()) {
            String appName = entry.getKey();
            JPAApplInfoIntrospect jpaAppl = entry.getValue();
            JPAApplInfo appl = jpaAppl.getJPAApplInfo();
            JPAAnalysisResult analysisResult = new JPAAnalysisResult(appName, jpaAppl);
            analysisResultMap.put(appName, analysisResult);
            PrintWriter out = analysisResult.getPw();
            ArrayList<JPAPUnitInfo> puInfoList = new ArrayList<JPAPUnitInfo>();
            HashMap<URL, ArrayList<JPAPUnitInfo>> puRootURL_PUInfo_Map = new HashMap<URL, ArrayList<JPAPUnitInfo>>();
            HashMap<URL, String> puRootURL_pxml_Map = new HashMap<URL, String>();
            List<JPAScopeInfoIntrospect> scopeInfoList = jpaAppl.getScopeInfoList();
            for (JPAScopeInfoIntrospect jPAScopeInfoIntrospect : scopeInfoList) {
                JPAScopeInfo scopeInfo = jPAScopeInfoIntrospect.getJPAScopeInfo();
                List<JPAPxmlInfoIntrospect> pxmlList = jPAScopeInfoIntrospect.getPxmlInfoList();
                for (JPAPxmlInfoIntrospect pxml : pxmlList) {
                    JPAPxmlInfo pxmlInfo = pxml.getJPAPxmlInfo();
                    List<JPAPUnitInfoIntrospect> jpaPuInfoList = pxml.getJPAPUnitInfoList();
                    for (JPAPUnitInfoIntrospect puInfoIntro : jpaPuInfoList) {
                        JPAPUnitInfo jpaPuInfo = puInfoIntro.getJpaPuInfo();
                        URL puRootURL = jpaPuInfo.getPersistenceUnitRootUrl();
                        puInfoList.add(jpaPuInfo);
                        analysisResult.registerJPAPUInfo(puInfoIntro);
                        ArrayList<JPAPUnitInfo> list = (ArrayList<JPAPUnitInfo>)puRootURL_PUInfo_Map.get(puRootURL);
                        if (list == null) {
                            list = new ArrayList<JPAPUnitInfo>();
                            puRootURL_PUInfo_Map.put(puRootURL, list);
                        }
                        list.add(jpaPuInfo);
                    }
                }
            }
            for (URL uRL : puRootURL_PUInfo_Map.keySet()) {
                String pxml = this.resolvePersistenceXML(uRL);
                puRootURL_pxml_Map.put(uRL, pxml);
            }
            if (isIntrospectorDump) {
                for (Map.Entry entry2 : puRootURL_pxml_Map.entrySet()) {
                    out.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
                    out.println("Contents of persistence.xml at Peristence Unit Root:\n" + entry2.getKey());
                    out.println();
                    out.println((String)entry2.getValue());
                    out.println();
                    List puInfo_List = (List)puRootURL_PUInfo_Map.get(entry2.getKey());
                    for (JPAPUnitInfo puInfo : puInfo_List) {
                        out.println(puInfo.dump());
                        out.println("************************************************************");
                    }
                }
                jpaAppl.results = JPAORMDiagnostics.performJPAORMDiagnosticsForIntrospector(new ArrayList<PersistenceUnitInfo>(puInfoList), puRootURL_pxml_Map, out);
                continue;
            }
            jpaAppl.results = JPAORMDiagnostics.performJPAORMDiagnosticsForTrace(new ArrayList<PersistenceUnitInfo>(puInfoList), puRootURL_pxml_Map);
        }
        return analysisResultMap;
    }

    private void doExecuteTraceAnalysis() {
        if (!tc.isAnyTracingEnabled() || !tc.isDebugEnabled()) {
            return;
        }
        try {
            Map<String, JPAAnalysisResult> analysisResultMap = this.executeDiagnostics(false);
            for (Map.Entry<String, JPAAnalysisResult> entry : analysisResultMap.entrySet()) {
                JPAAnalysisResult result = entry.getValue();
                JPAApplInfoIntrospect applInfoIntro = result.getAppl();
                PersistenceUnitScannerResults results = applInfoIntro.results;
                if (results == null) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                results.generateORMDump(new PrintWriter(baos));
                StringBuilder sb = new StringBuilder();
                sb.append("\nJPA Diagnostic Dump for Application " + entry.getKey() + " : \n");
                sb.append(baos.toString());
                Tr.debug((TraceComponent)tc, (String)"JPAORMDiagnostics Dump", (Object[])new Object[]{sb.toString()});
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(JPAIntrospection.class.getName() + ".executeTraceAnalysis"), (String)"185");
        }
    }

    private void doExecuteIntrospectionAnalysis(PrintWriter dout) {
        Map<String, JPAAnalysisResult> analysisResultMap = this.executeDiagnostics(true);
        dout.println("Applications: ");
        dout.println();
        for (Map.Entry<String, JPAAnalysisResult> entry : analysisResultMap.entrySet()) {
            dout.println(entry.getKey() + " (" + entry.getValue().getAppl().getPersistenceUnitCount() + " persistence units, " + entry.getValue().getLineCount() + " lines) :");
            dout.println("   Persistence Unit Roots:");
            Map<URL, List<JPAPUnitInfoIntrospect>> urlPUInfoMap = entry.getValue().getURL_JPAPuInfoMap();
            if (urlPUInfoMap.size() == 0) {
                dout.println("      None");
                continue;
            }
            for (Map.Entry<URL, List<JPAPUnitInfoIntrospect>> e2 : urlPUInfoMap.entrySet()) {
                dout.println("      " + JPAIntrospection.getShortenedURLPath(e2.getKey()) + " (" + e2.getValue().size() + " persistence units)");
            }
        }
        dout.println();
        for (Map.Entry<String, JPAAnalysisResult> entry : analysisResultMap.entrySet()) {
            JPAAnalysisResult result = entry.getValue();
            PersistenceUnitScannerResults scannerResults = result.getAppl().results;
            dout.println();
            dout.println("################################################################################");
            dout.println("Application \"" + entry.getKey() + "\":");
            if (scannerResults == null) {
                dout.println("   No JPA Materials to Analyze.");
                continue;
            }
            dout.println("   Total ORM Files: " + scannerResults.getAllEntityMappingsDefinitions().size());
            Map<URL, Set<ClassInfoType>> urlCitMap = scannerResults.getAllScannedClasses();
            int count = 0;
            for (Set<ClassInfoType> citSet : urlCitMap.values()) {
                count += citSet.size();
            }
            dout.println("   Total JPA Involved Classes: " + count);
            Map<URL, List<JPAPUnitInfoIntrospect>> urlPUInfoMap = entry.getValue().getURL_JPAPuInfoMap();
            if (urlPUInfoMap.size() == 0) {
                dout.println("   Persistence Unit Roots:");
                dout.println("      None");
            } else {
                dout.println("   Persistence Unit Roots:");
                for (Map.Entry<URL, List<JPAPUnitInfoIntrospect>> e2 : urlPUInfoMap.entrySet()) {
                    dout.println("      " + JPAIntrospection.getShortenedURLPath(e2.getKey()) + " (" + e2.getValue().size() + " persistence units)");
                }
                dout.println("   Persistence Units:");
                for (Map.Entry<URL, List<JPAPUnitInfoIntrospect>> e2 : urlPUInfoMap.entrySet()) {
                    dout.println("      At Persistence Unit Root: " + JPAIntrospection.getShortenedURLPath(e2.getKey()));
                    ArrayList ispecList = new ArrayList(e2.getValue());
                    Collections.sort(ispecList, new Comparator<JPAPUnitInfoIntrospect>(){

                        @Override
                        public int compare(JPAPUnitInfoIntrospect o1, JPAPUnitInfoIntrospect o2) {
                            if (o1 == null || o2 == null || o1.puName == null || o2.puName == null) {
                                return 0;
                            }
                            return o1.puName.compareTo(o2.puName);
                        }
                    });
                    for (JPAPUnitInfoIntrospect puIspec : ispecList) {
                        dout.println("         " + puIspec.getPuName());
                    }
                }
            }
            dout.println();
            dout.println("   Application Modules and Archives:");
            Set<String> applicationArchives = this.applicationArchivesMap.get(result.getAppl());
            if (applicationArchives == null || applicationArchives.isEmpty()) {
                dout.println("      -- None were located.");
            } else {
                for (String archiveName : applicationArchives) {
                    dout.println("     " + archiveName);
                }
            }
            dout.println();
            dout.println(result.getBaos().toString());
        }
    }

    private static String getShortenedURLPath(URL url) {
        String urlStr = url.toString().replace("%21", "!");
        String ptcols = urlStr.substring(0, urlStr.indexOf("/"));
        String path = urlStr.substring(urlStr.indexOf("/"));
        if (path.contains(".cache")) {
            path = path.substring(path.lastIndexOf(".cache") + 6);
        }
        int index = path.length();
        int temp = path.lastIndexOf(".jar");
        if (temp > 0) {
            index = temp;
        }
        if ((temp = path.lastIndexOf(".war", index)) > 0) {
            index = temp;
        }
        if ((temp = path.lastIndexOf(".ear", index)) > 0) {
            index = temp;
        }
        if (index > 0) {
            index = path.lastIndexOf("/", index);
            path = path.substring(index);
        }
        return ptcols + "..." + path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String resolvePersistenceXML(URL puRootURL) {
        String pxmlPath = "META-INF/persistence.xml";
        String urlPtcol = puRootURL.getProtocol();
        if (urlPtcol.toLowerCase().contains("wsjpa")) {
            try (ZipInputStream zis = new ZipInputStream(puRootURL.openStream());){
                ZipEntry ze = null;
                do {
                    if ((ze = zis.getNextEntry()) == null) return null;
                } while (!ze.getName().equals("META-INF/persistence.xml"));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                int bytesRead = -1;
                while ((bytesRead = zis.read(buffer)) >= 0) {
                    baos.write(buffer, 0, bytesRead);
                }
                String string = baos.toString();
                return string;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(JPAIntrospection.class.getName() + ".resolvePersistenceXML"), (String)"wsjpa");
                return null;
            }
        }
        if (!urlPtcol.toLowerCase().contains("jar")) {
            if (!urlPtcol.toLowerCase().contains("file")) return null;
            return null;
        }
        try {
            String urlStr = puRootURL.toString();
            URL pxmlURL = urlStr.endsWith("/") ? new URL(urlStr + "META-INF/persistence.xml") : new URL(urlStr + "/" + "META-INF/persistence.xml");
            return this.readData(pxmlURL);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(JPAIntrospection.class.getName() + ".resolvePersistenceXML"), (String)"jar");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readData(URL url) {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(url.openStream()));
            String in = null;
            while ((in = br.readLine()) != null) {
                sb.append(in);
            }
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)(JPAIntrospection.class.getName() + ".readData"), (String)"readData");
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return sb.toString();
    }

    private void doDumpJPARuntimeStates(PrintWriter out) {
        out.println();
        out.println("################################################################################");
        out.println("################################################################################");
        out.println("################################################################################");
        out.println();
        out.println("Dumping JPA Runtime States:");
        out.println();
        for (JPAPUnitInfo puinfo : this.allJPAPUnitInfoList) {
            this.doDumpJPARuntimeState(puinfo, out);
        }
    }

    private void doDumpJPARuntimeState(JPAPUnitInfo jpaPuInfo, PrintWriter out) {
        out.println();
        out.println("JPA Runtime State Analysis for JPAPUnitInfo: ");
        out.println(jpaPuInfo.dump());
        out.println();
        Object ivEMFactory = null;
        try {
            ivEMFactory = JPAIntrospection.reflectObjValue(jpaPuInfo, "ivEMFactory");
        }
        catch (Throwable t) {
            out.println("*** Unable to access ivEMFactory due to Exception ***");
        }
        Map ivEMFMap = null;
        try {
            ivEMFMap = (Map)JPAIntrospection.reflectObjValue(jpaPuInfo, "ivEMFMap");
        }
        catch (Throwable t) {
            out.println("*** Unable to access ivEMFactory due to Exception ***");
        }
        if (ivEMFactory == null && (ivEMFMap == null || ivEMFMap.isEmpty())) {
            out.println("No EntityManagerFactory available for introspection with persistence unit " + jpaPuInfo.getPersistenceUnitName());
            return;
        }
        Class<?> emfClass = null;
        if (ivEMFactory != null) {
            emfClass = ivEMFactory.getClass();
        } else if (ivEMFMap != null && ivEMFMap.size() > 0) {
            emfClass = ivEMFMap.values().toArray()[0].getClass();
        } else {
            out.println("Encountered a problem acquiring an EntityManagerFactory from JPAPUnitInfo");
            return;
        }
        if (!AbstractIntrospection.isSupportedPlatform(emfClass)) {
            out.println("Introspector doesn't support EntityManagerFactory impl type " + emfClass.getName());
            return;
        }
        if (ivEMFactory != null && (ivEMFMap == null || ivEMFMap.size() == 0)) {
            out.println("EntityManagerFactory state for ivEMFactory:");
            AbstractIntrospection.getPlatformIntrospection(emfClass).dumpJPAEntityManagerFactoryState(ivEMFactory, out);
        }
        if (ivEMFMap != null && ivEMFMap.size() > 0) {
            for (Map.Entry entry : ivEMFMap.entrySet()) {
                out.println();
                out.println("EntityManagerFactory state for java:comp/env EMF: " + entry.getKey());
                AbstractIntrospection.getPlatformIntrospection(emfClass).dumpJPAEntityManagerFactoryState(entry.getValue(), out);
            }
        }
    }

    private void doDumpOpenJPAPCRegistry(PrintWriter out) {
        ArrayList<ClassLoader> tclList = new ArrayList<ClassLoader>();
        for (JPAPUnitInfo puinfo : this.allJPAPUnitInfoList) {
            tclList.add(puinfo.getNewTempClassLoader());
        }
        OpenJPAIntrospection.dumpOpenJPAPCRegistry(tclList, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object reflectObjValue(Object o, String field) throws Exception {
        Class<?> c = o.getClass();
        Field f = JPAIntrospection.findField(c, field);
        if (f == null) {
            return null;
        }
        boolean accessible = f.isAccessible();
        try {
            f.setAccessible(true);
            Object object = f.get(o);
            return object;
        }
        finally {
            f.setAccessible(accessible);
        }
    }

    private static Field findField(Class<?> c, String field) {
        if (c == null) {
            return null;
        }
        try {
            return c.getDeclaredField(field);
        }
        catch (Exception exception) {
            if (Object.class.equals(c)) {
                return null;
            }
            return JPAIntrospection.findField(c.getSuperclass(), field);
        }
    }

    public class JPAAnalysisResult {
        private final String appName;
        private final JPAApplInfoIntrospect appl;
        private final ByteArrayOutputStream baos;
        private final PrintWriter pw;
        private final HashMap<URL, List<JPAPUnitInfoIntrospect>> puRootURL_JPAPuInfoMap = new HashMap();

        public JPAAnalysisResult(String appName, JPAApplInfoIntrospect appl) {
            this.appName = appName;
            this.appl = appl;
            this.baos = new ByteArrayOutputStream();
            this.pw = new PrintWriter(this.baos);
        }

        public String getAppName() {
            return this.appName;
        }

        public JPAApplInfoIntrospect getAppl() {
            return this.appl;
        }

        public ByteArrayOutputStream getBaos() {
            return this.baos;
        }

        public PrintWriter getPw() {
            return this.pw;
        }

        public Map<URL, List<JPAPUnitInfoIntrospect>> getURL_JPAPuInfoMap() {
            return this.puRootURL_JPAPuInfoMap;
        }

        public void registerJPAPUInfo(JPAPUnitInfoIntrospect puInfoIntrospect) {
            URL puRootURL = puInfoIntrospect.getJpaPuInfo().getPersistenceUnitRootUrl();
            List<JPAPUnitInfoIntrospect> introList = this.puRootURL_JPAPuInfoMap.get(puRootURL);
            if (introList == null) {
                introList = new ArrayList<JPAPUnitInfoIntrospect>();
                this.puRootURL_JPAPuInfoMap.put(puRootURL, introList);
            }
            introList.add(puInfoIntrospect);
        }

        public long getLineCount() {
            int newline = 10;
            long count = 0L;
            for (byte b : this.baos.toByteArray()) {
                if (10 != b) continue;
                ++count;
            }
            return count;
        }
    }

    public class JPAPUnitInfoIntrospect {
        private final String puName;
        private final JPAPUnitInfo jpaPuInfo;

        public JPAPUnitInfoIntrospect(String puName, JPAPUnitInfo jpaPuInfo) {
            this.puName = puName;
            this.jpaPuInfo = jpaPuInfo;
        }

        public String getPuName() {
            return this.puName;
        }

        public JPAPUnitInfo getJpaPuInfo() {
            return this.jpaPuInfo;
        }
    }

    public class JPAPxmlInfoIntrospect {
        private final JPAPxmlInfo pxmlInfo;
        private final ArrayList<JPAPUnitInfoIntrospect> jpaPuInfoList = new ArrayList();
        private int puCount = 0;

        public JPAPxmlInfoIntrospect(JPAPxmlInfo pxmlInfo) {
            this.pxmlInfo = pxmlInfo;
        }

        public JPAPxmlInfo getJPAPxmlInfo() {
            return this.pxmlInfo;
        }

        public List<JPAPUnitInfoIntrospect> getJPAPUnitInfoList() {
            return Collections.unmodifiableList(this.jpaPuInfoList);
        }

        public int getPersistenceUnitCount() {
            return this.puCount;
        }
    }

    public class JPAScopeInfoIntrospect {
        private final JPAScopeInfo scopeInfo;
        private final ArrayList<JPAPxmlInfoIntrospect> pxmlInfoList = new ArrayList();

        public JPAScopeInfoIntrospect(JPAScopeInfo scopeInfo) {
            this.scopeInfo = scopeInfo;
        }

        public JPAScopeInfo getJPAScopeInfo() {
            return this.scopeInfo;
        }

        public List<JPAPxmlInfoIntrospect> getPxmlInfoList() {
            return Collections.unmodifiableList(this.pxmlInfoList);
        }
    }

    public class JPAApplInfoIntrospect {
        private final String appname;
        private final JPAApplInfo appl;
        private final ArrayList<JPAScopeInfoIntrospect> scopeInfoList = new ArrayList();
        private int puCount = 0;
        private PersistenceUnitScannerResults results;

        public JPAApplInfoIntrospect(String appname, JPAApplInfo appl) {
            this.appname = appname;
            this.appl = appl;
        }

        public JPAApplInfo getJPAApplInfo() {
            return this.appl;
        }

        public List<JPAScopeInfoIntrospect> getScopeInfoList() {
            return Collections.unmodifiableList(this.scopeInfoList);
        }

        public int getPersistenceUnitCount() {
            return this.puCount;
        }
    }
}

